/*************************************************************************
 *
 *  $RCSfile: fudgrlin.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: bm $ $Date: 2000/09/21 12:03:10 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFX_OBJSH_HXX //autogen
#include <sfx2/objsh.hxx>
#endif

#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif


#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif

#include <svx/svxids.hrc>

#include "viewshel.hxx"
#include "schresid.hxx"
#include "datarow.hxx"
#include "schview.hxx"
#include "attrib.hxx"
#include "strings.hrc"
#include "chwindow.hxx"
#include "objid.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "app.hrc"
#include "chtmodel.hxx"
#include "fudgrlin.hxx"
#include "undgrlin.hxx"

#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuLine::SchFuLine(SchViewShell* pViewSh, SchWindow* pWin, SchView* pView,
					 ChartModel* pDoc, SfxRequest& rReq, Point &rMDPos)
	: SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	aMDPos       = rMDPos;

	if (pView->GetMarkList().GetMarkCount() == 1)
	{
		SdrObject* pObj = pView->GetMarkList().GetMark(0)->GetObj();
		SchObjectId* pObjId = GetObjectId(*pObj);

		if (pObjId)
		{
			SchDataRow* pDataRow = NULL;

			switch (pObjId->GetObjId())
			{
				case CHOBJID_DIAGRAM_STATISTICS_GROUP :
				case CHOBJID_DIAGRAM_AVERAGEVALUE :
				case CHOBJID_DIAGRAM_REGRESSION :
					pDataRow = GetDataRow(*pObj);
					break;
				case CHOBJID_DIAGRAM_STOCKLINE_GROUP:
					break;

				default :
					return;
			}
			const SfxItemSet* pArgs = rReq.GetArgs();
			long nId=rReq.GetSlot();

			long nRow =0;
			if(pDataRow)
				nRow=pDataRow->GetRow();

			if (pDataRow || nId==SID_DIAGRAM_STOCK_LINE)
			{
				SfxItemSet *pRowAttr;

				if (!pArgs)
				{
					switch (nId)
					{
						case SID_DIAGRAM_ERROR :
							pRowAttr = (SfxItemSet *) &pDoc->GetErrorAttr(nRow);
							break;

						case SID_DIAGRAM_AVERAGEVALUE :
							pRowAttr = (SfxItemSet *) &pDoc->GetAverageAttr(nRow);
							break;

						case SID_DIAGRAM_REGRESSION :
							pRowAttr = (SfxItemSet *) &pDoc->GetRegressAttr(nRow);
							break;
						case SID_DIAGRAM_STOCK_LINE:
							pRowAttr = (SfxItemSet *) &pDoc->GetAttr(CHOBJID_DIAGRAM_STOCKLINE_GROUP);
							break;

						default :
							return;
					}

//      FG: Mit dieser Zeile erhaelt man keinen modalen Dialog => Absturz falls ein Resize im Chart
//      stattfindet waehrend dieser Dialog geoeffnet ist.
//	                SchAttribTabDlg *pDlg =	new SchAttribTabDlg(&pViewSh->GetViewFrame()->GetWindow(), ATTR_LINE,
//                                                                pRowAttr, pDoc->GetObjectShell(),
//                                                                pDoc, 0, pDoc->ChartStyle());
					SchAttribTabDlg *pDlg =	new SchAttribTabDlg(NULL, ATTR_LINE,
																pRowAttr, pDoc->GetObjectShell(),
																pDoc, 0, pDoc->ChartStyle());
					if (pDlg->Execute() == RET_OK)
					{
						rReq.Done(*(pDlg->GetOutputItemSet()));
						pArgs = rReq.GetArgs();
						delete pDlg;
					}
					else
					{
						delete pDlg;
						return;
					}
				}

				if( pViewSh )
					pViewSh->GetViewFrame()->GetDispatcher()->Execute(
						SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON );

				switch (rReq.GetSlot ())
				{
					case SID_DIAGRAM_ERROR :
						pDoc->ChangeErrorAttr(*pArgs, nRow);
						break;

					case SID_DIAGRAM_AVERAGEVALUE :
						pDoc->ChangeAverageAttr(*pArgs, nRow);
						break;

					case SID_DIAGRAM_REGRESSION :
						pDoc->ChangeRegressAttr(*pArgs, nRow);
						break;

					case SID_DIAGRAM_STOCK_LINE:
						pDoc->ChangeAttr(*pArgs,CHOBJID_DIAGRAM_STOCKLINE_GROUP);
						break;

				}

				SchUndoDiagramLine* pUndo =	new SchUndoDiagramLine(*pDoc, *pRowAttr, *pArgs, nRow,
																   rReq.GetSlot ());
				pUndo->SetComment(String(SchResId(STR_UNDO_DIAGRAM_LINE)));
				pViewSh->GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
			}
		}
	}

	RemarkObject ();
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchFuLine::~SchFuLine()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuLine::Activate()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuLine::Deactivate()
{
}


