/*************************************************************************
 *
 *  $RCSfile: modview.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:07:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef __MODVIEW_HXX
#define __MODVIEW_HXX

#ifndef _SVTABBX_HXX //autogen
#include <svtools/svtabbx.hxx>
#endif

class SiModule;
class SiFile;

class SiModuleView : public SvTabListBox
{
	USHORT 				m_nLanguage;
	BOOL 				m_bOnceWarn;
	BOOL				m_bTopLevelMode;
	SvLBoxButtonData*	m_pButtons;

	SiModule*			m_pTopClicked;
	Link				m_aWarnLink;

	Window* m_pParent;
	bool m_bHighContrastMode;
	bool isHighContrast(Window* pParent);
	void DataChanged( const DataChangedEvent& rDCEvt );
	void CommonConstruct();

	DECL_LINK(DblClickHdl, void*);
protected:
	virtual void		InitEntry(SvLBoxEntry*, const String&,const Image&, const Image&);
	virtual void		CheckButtonHdl(); // derived

	void				List(SiModule* pModule, SvLBoxEntry* pParent, ULONG lClusterSize,
							 BOOL bWorkstation, BOOL bDisplayLevel, BOOL bModulesOnly);
	void				List(SiFile const* pFile, SvLBoxEntry* pParent);

	SiModule*			IsMaxSelected(SiModule* pModule);
	void				MySelect(SvLBoxEntry *, BOOL bForInstall);

	enum TriState { STATE_NON, STATE_ALL, STATE_SOME };

	void				UpdateAllTriStates();
	TriState			UpdateTriStates(SvLBoxEntry *);

public:
		SiModuleView(Window* pParent, WinBits nWinStyle, USHORT nLanguage, BOOL bTop = FALSE);
		SiModuleView(Window* pParent, const ResId& rResId, USHORT nLanguage, BOOL bTop = FALSE);
		~SiModuleView();

	virtual void		KeyInput( const KeyEvent &rKeyEvent );
	void				SetWarnHdl(const Link& rHdl) { m_aWarnLink = rHdl; }

	void				List(SiModule* pModule, ULONG lClusterSize, BOOL bWorkstation,
							 BOOL bDisplayRoot = FALSE, BOOL bModulesOnly = TRUE);

	enum Selection { ALL, NO, MINIMAL, DEFAULT };
	void 				Select(Selection);
};

#endif // __MODVIEW_HXX
