/*************************************************************************
 *
 *  $RCSfile: service.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: ok $ $Date: 2001/11/06 08:41:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SERVICE_HXX
#define _SERVICE_HXX

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#ifndef _COM_SUN_STAR_SETUP_XSETUP_HPP_
#include <com/sun/star/setup/XSetup.hpp>
#endif

#ifndef _COM_SUN_STAR_SETUP_MODULEINFO_HPP_
#include <com/sun/star/setup/ModuleInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_SETUP_MODULESTATE_HPP_
#include <com/sun/star/setup/ModuleState.hpp>
#endif

#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif

#ifndef _DATETIME_HXX
#include <tools/datetime.hxx>
#endif

using namespace osl;
using namespace rtl;

using namespace com::sun::star::setup;
using namespace com::sun::star::uno;

class SiCompiledScript;

DECLARE_LIST(MirrorList, UniString*)

class CachedConfiguration
{
public:
		CachedConfiguration();
		~CachedConfiguration();

	VersionIdentifier	aIdentifier;

	DateTime 			aLastValidation;

	ByteString 			aNativeLocation;
	ByteString 			aScriptLocation;
	ByteString 			aHiddenModules;
	ByteString 			aVisibleModules;
	SiCompiledScript*	pCS;
	MirrorList			aMirrorList;
};

DECLARE_LIST(ConfigurationCache, CachedConfiguration*)

class Config;

class SetupServiceImpl : public ::cppu::WeakImplHelper1< XSetup >
{
private:
	Mutex					m_ScriptCacheMutex;
	ConfigurationCache		m_ConfigCache;
	ByteString				m_aAppPath;

	CachedConfiguration* 			SAL_CALL getCachedConfig( const VersionIdentifier& aVerIdentifier );
	void 							SAL_CALL readOSConfiguration( OSType eType );

protected:
	Mutex					m_mutex;

public:
	void							SAL_CALL readAllOSConfiguration();
	void							SAL_CALL SetAppPath( const ByteString& r ) { m_aAppPath =r; }
	// XServiceInfo
    virtual OUString				SAL_CALL getImplementationName()
												throw(RuntimeException);
	virtual sal_Bool				SAL_CALL supportsService( const OUString& ServiceName )
												throw(RuntimeException);
	virtual Sequence< OUString >	SAL_CALL getSupportedServiceNames()
												throw(RuntimeException);
	static Sequence< OUString > 	SAL_CALL getSupportedServiceNames_Static();

	// XSetup
    virtual sal_Bool 				SAL_CALL	isVersionSupported( const VersionIdentifier& aVerIdentifier ) throw (::com::sun::star::uno::RuntimeException);
	virtual Sequence< sal_Int16 >	SAL_CALL	getAvailableLanguages( const VersionIdentifier& aVerIdentifier ) throw (::com::sun::star::uno::RuntimeException);

	virtual OUString 				SAL_CALL	getReadmeText( const VersionIdentifier& aVerIdentifier ) throw (::com::sun::star::uno::RuntimeException);
    virtual OUString 				SAL_CALL	getLicenseText( const VersionIdentifier& aVerIdentifier ) throw (::com::sun::star::uno::RuntimeException);

	virtual OUString				SAL_CALL	getProductname( const VersionIdentifier& aVerIdentifier ) throw (::com::sun::star::uno::RuntimeException);
	virtual OUString				SAL_CALL	getVendorname( const VersionIdentifier& aVerIdentifier ) throw (::com::sun::star::uno::RuntimeException);
    virtual OUString 				SAL_CALL	getDefaultDestinationPath( const VersionIdentifier& aVerIdentifier ) throw (::com::sun::star::uno::RuntimeException);
    virtual SizeInfo				SAL_CALL	getStandardSizeValues( const VersionIdentifier& aVerIdentifier,
													const Sequence< sal_Int16 >& seqLanguages ) throw (::com::sun::star::uno::RuntimeException);

	virtual OUString				SAL_CALL	getHelpText( const VersionIdentifier& aVerIdentifier, const OUString& strPagename ) throw (::com::sun::star::uno::RuntimeException);

    virtual OUString				SAL_CALL	getNativeLocation( const VersionIdentifier& aVerIdentifier ) throw (::com::sun::star::uno::RuntimeException);
	virtual ModuleInfo				SAL_CALL	getRootModule( const VersionIdentifier& aVerIdentifier ) throw (::com::sun::star::uno::RuntimeException);
    virtual Sequence< Any >			SAL_CALL	getMirrorList( const VersionIdentifier& aVerIdentifier ) throw (::com::sun::star::uno::RuntimeException);
    virtual void 					SAL_CALL	setHiddenModule( const VersionIdentifier& aVerIdentifier,
													const OUString& strModuleID, sal_Bool bHidden ) throw (::com::sun::star::uno::RuntimeException);

    virtual UpdateType 				SAL_CALL	isUpdateAvailable( const VersionIdentifier& aVerIdentifier,
													VersionIdentifier& aNewVerIdentifier ) throw (::com::sun::star::uno::RuntimeException);

	virtual sal_Bool 				SAL_CALL	isModuleAvailable( const VersionIdentifier& aVerIdentifier,
													const OUString& strModuleID ) throw (::com::sun::star::uno::RuntimeException);

	virtual Sequence< Any >			SAL_CALL	getActionListForInstall(
													const VersionIdentifier& aVerIdentifier,
													const VersionIdentifier& aOldVerIdentifier,
													const InstallEnvironment& aEnvironment,
													InstallResponse& aResponse ) throw (::com::sun::star::uno::RuntimeException);
};

#endif
