/*************************************************************************
 *
 *  $RCSfile: service.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: dv $ $Date: 2001/09/24 15:16:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef _REGISTRY_REGISTRY_HXX_
#include <registry/registry.hxx>
#endif
#ifndef _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif
#ifndef _VOS_PROCESS_HXX_
#include <vos/process.hxx>
#endif
#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#include <com/sun/star/registry/XSimpleRegistry.hpp>

#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#include <com/sun/star/lang/XServiceInfo.hpp>
#include <com/sun/star/lang/XSingleServiceFactory.hpp>

#include <osl/thread.h>
#include <tools/string.hxx>
#include <uno/environment.h>

#include "service.hxx"
#include "sifsys.hxx"

//=============================================================================

using namespace vos;
using namespace cppu;
using namespace com::sun::star::registry;
using namespace com::sun::star::lang;

#define SERVICENAME "com.sun.star.setup.Setup"
#define IMPLNAME	"com.sun.star.comp.setup.Setup"

static Reference<XInterface> static_xRef;

//=============================================================================

OUString SAL_CALL SetupServiceImpl::getImplementationName()
	throw(RuntimeException)
{
	Guard< Mutex > aGuard( m_mutex );
	return OUString( RTL_CONSTASCII_USTRINGPARAM(IMPLNAME) );
}

sal_Bool SAL_CALL SetupServiceImpl::supportsService( const OUString& ServiceName )
	throw(RuntimeException)
{
	Guard< Mutex > aGuard( m_mutex );
	Sequence< OUString > aSNL = getSupportedServiceNames();
	const OUString * pArray = aSNL.getArray();
	for( sal_Int32 i = 0; i < aSNL.getLength(); i++ )
		if( pArray[i] == ServiceName )
			return sal_True;
	return sal_False;
}

Sequence<OUString> SAL_CALL SetupServiceImpl::getSupportedServiceNames()
	throw(RuntimeException)
{
	Guard< Mutex > aGuard( m_mutex );
	return getSupportedServiceNames_Static();
}

Sequence<OUString> SAL_CALL SetupServiceImpl::getSupportedServiceNames_Static()
{
	OUString aName( RTL_CONSTASCII_USTRINGPARAM(SERVICENAME) );
	return Sequence< OUString >( &aName, 1 );
}

//=============================================================================
//=============================================================================
//=============================================================================
#if SUPD > 583
Reference<XInterface> SAL_CALL SetupService_CreateInstance( const Reference<XMultiServiceFactory>& rSMgr )
#else
Reference<XInterface> SetupService_CreateInstance( const Reference<XMultiServiceFactory>& rSMgr )
#endif
{
	Reference<XInterface>	xRet;
	RegistryLoader 			aLoader;

	if ( aLoader.isLoaded() )
	{
		if( static_xRef.is() )
			xRet = static_xRef;
		else
		{
			XSetup* pSetup = (XSetup*) new SetupServiceImpl();
			if( pSetup )
			{
				OUString aExeFileName;
				OUString aNativeFileName;
				OStartupInfo aStartInfo;

				aStartInfo.getExecutableFile( aExeFileName );

				FileBase::getSystemPathFromFileURL(aExeFileName, aNativeFileName);
				
				UniString aTmpUniStr(aNativeFileName);
				SiDirEntry aAppPath( ByteString(aTmpUniStr, osl_getThreadTextEncoding()) );
				aAppPath.ToAbs();
				((SetupServiceImpl*)pSetup)->SetAppPath( ((SiDirEntry&)aAppPath.GetPath()).GetFull() );

				((SetupServiceImpl*)pSetup)->readAllOSConfiguration();
				xRet = pSetup;
				static_xRef = xRet;
			}
		}
	}
	return xRet;
}

extern "C"
{
void SAL_CALL component_getImplementationEnvironment(
	const sal_Char ** ppEnvTypeName, uno_Environment ** ppEnv )
{
	*ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}


sal_Bool SAL_CALL component_writeInfo(
	void * pServiceManager, void * pRegistryKey )
{
	if (pRegistryKey)
	{
		try
		{
			Reference< XRegistryKey > xNewKey(
				reinterpret_cast< XRegistryKey * >( pRegistryKey )->createKey(
					OUString( RTL_CONSTASCII_USTRINGPARAM("/" IMPLNAME "/UNO/SERVICES") ) ) );

			const Sequence< OUString > & rSNL =
				SetupServiceImpl::getSupportedServiceNames_Static();
			const OUString * pArray = rSNL.getConstArray();
			for ( sal_Int32 nPos = rSNL.getLength(); nPos--; )
				xNewKey->createKey( pArray[nPos] );

			return sal_True;
		}
		catch (InvalidRegistryException &)
		{
			OSL_ENSURE( sal_False, "### InvalidRegistryException!" );
		}
	}
	return sal_False;
}


void * SAL_CALL component_getFactory(
	const sal_Char * pImplName, void * pServiceManager, void * pRegistryKey )
{
	void * pRet = 0;

	if (rtl_str_compare( pImplName, IMPLNAME ) == 0)
	{
		Reference< XSingleServiceFactory > xFactory( createSingleFactory(
			reinterpret_cast< XMultiServiceFactory * >( pServiceManager ),
			OUString( RTL_CONSTASCII_USTRINGPARAM(IMPLNAME) ),
			SetupService_CreateInstance,
			SetupServiceImpl::getSupportedServiceNames_Static() ) );

		if (xFactory.is())
		{
			xFactory->acquire();
			pRet = xFactory.get();
		}
	}

	return pRet;
}
}

