/*************************************************************************
 *
 *  $RCSfile: reinst.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ok $ $Date: 2001/09/05 13:15:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#include "reinst.hxx"

#include "event.hxx"
#pragma hdrstop

#include "dialog.hrc"
#include "reinst.hrc"

// class SetupReinstallModeDialog ----------------------------------------

SetupReinstallModeDialog::SetupReinstallModeDialog
(
	Window* pParent,
	ByteString const& aProgramName,
	SiInstallMode eInstallMode,
	ByteString const& anInstalledPath,
	BOOL		  bNoModules
)
: ModelessDialog		(pParent, ResId( RID_REINST_DLG))
, m_aInfoText1          ( this, ResId( FT_INFO1 ) )
, m_aPathInfo           ( this, ResId( FT_PATHINFO ) )
, m_aInfoText2          ( this, ResId( FT_INFO2 ) )
, m_aInfoText3          ( this, ResId( FT_INFO3 ) )
, m_aChangeButton       ( this, ResId( BTN_UPDATE ) )
, m_aChangeText         ( this, ResId( FT_UPDATE ) )
, m_aChangeInfoText1    ( this, ResId( FT_UPDATE_INFO1 ) )
, m_aChangeInfoText2    ( this, ResId( FT_UPDATE_INFO2 ) )
, m_aUpgradeButton      ( this, ResId( BTN_UPGRADE ) )
, m_aUpgradeText        ( this, ResId( FT_UPGRADE ) )
, m_aUpgradeInfoText1   ( this, ResId( FT_UPGRADE_INFO1 ) )
, m_aUpgradeInfoText2   ( this, ResId( FT_UPGRADE_INFO2 ) )
, m_aDeinstallButton    ( this, ResId( BTN_DEINST ) )
, m_aDeinstText         ( this, ResId( FT_DEINST ) )
, m_aDeinstInfoText1    ( this, ResId( FT_DEINST_INFO1 ) )
, m_aDeinstInfoText2    ( this, ResId( FT_DEINST_INFO2 ) )
, m_aRecoverButton      ( this, ResId( BTN_RECOVER ) )
, m_aRecoverText        ( this, ResId( FT_RECOVER ) )
, m_aRecoverInfoText1   ( this, ResId( FT_RECOVER_INFO1 ) )
, m_aRecoverInfoText2   ( this, ResId( FT_RECOVER_INFO2 ) )
{
	Size aButtonSize = m_aChangeButton.GetImage().GetSizePixel();
	aButtonSize.Width() += 8;
	aButtonSize.Height() += 8;
	m_aChangeButton.SetOutputSizePixel( aButtonSize );
	m_aUpgradeButton.SetOutputSizePixel( aButtonSize );
	m_aDeinstallButton.SetOutputSizePixel( aButtonSize );
	m_aRecoverButton.SetOutputSizePixel( aButtonSize );

	FreeResource();

	m_aChangeButton.SetClickHdl(
		LINK( this, SetupReinstallModeDialog, ChangeHdl ) );
	m_aUpgradeButton.SetClickHdl(
		LINK( this, SetupReinstallModeDialog, UpgradeHdl ) );
	m_aDeinstallButton.SetClickHdl(
		LINK( this, SetupReinstallModeDialog, DeinstallHdl ) );
	m_aRecoverButton.SetClickHdl(
		LINK( this, SetupReinstallModeDialog, RecoverHdl ) );

	if (bNoModules)
	{
		m_aChangeButton.Disable();
	}

	if (eInstallMode == IM_WORKSTATION)
	{
		m_aInfoText2.Hide();
		m_aInfoText3.Hide();
		// m_aChangeButton.Disable();
		m_aUpgradeButton.Disable();
	}

	ByteString sTmp = m_aPathInfo.GetText();

	#ifndef MAC
		sTmp.SearchAndReplace( "%1", anInstalledPath);
	#else
		ByteString sStr = anInstalledPath;
		USHORT nCnt = sStr.GetTokenCount( ':' );
		sTmp.SearchAndReplace( "%2", sStr.GetToken( 0, ':' ) );
		ByteString sFolder;

		if ( nCnt < 4 )
			sFolder = sStr.GetToken( nCnt - 1, ':' );
		else
		{
			sFolder = sStr.GetToken( nCnt - 2, ':' );
			sFolder += ':';
			sFolder += sStr.GetToken( nCnt - 1, ':' );
		}
		sTmp.SearchAndReplace( "%1", sFolder );
	#endif

	m_aPathInfo.SetText( sTmp );
	ByteString aText(aProgramName);
	aText += ByteString( ResId( STR_DLG_TITLE ) );
	SetText( aText );

	/** UI - Hack FixedTexte zusammenfassen **/
	m_aInfoText3.Hide();
	ByteString aStr = m_aInfoText2.GetText();
	aStr += " ";
	aStr += m_aInfoText3.GetText();
	m_aInfoText2.SetText(aStr);

	m_aChangeInfoText2.Hide();
	aStr = m_aChangeInfoText1.GetText();
	aStr += " ";
	aStr += m_aChangeInfoText2.GetText();
	m_aChangeInfoText1.SetText(aStr);

	m_aUpgradeInfoText2.Hide();
	aStr = m_aUpgradeInfoText1.GetText();
	aStr += " ";
	aStr += m_aUpgradeInfoText2.GetText();
	m_aUpgradeInfoText1.SetText(aStr);
	/** Ende UI - Hack **/
}

void SetupReinstallModeDialog::DisableRecover()
{
	m_aRecoverButton.Enable( FALSE );
}

// -----------------------------------------------------------------------

IMPL_LINK_INLINE_START( SetupReinstallModeDialog, ChangeHdl, Button *, EMPTYARG )
{
	Application::PostUserEvent(SETUP_EVENT_CHANGE);
	return 0;
}
IMPL_LINK_INLINE_END( SetupReinstallModeDialog, ChangeHdl, Button *, EMPTYARG )

// -----------------------------------------------------------------------

IMPL_LINK_INLINE_START( SetupReinstallModeDialog, UpgradeHdl, Button *, EMPTYARG )
{
	Application::PostUserEvent(SETUP_EVENT_UPGRADE);
	return 0;
}
IMPL_LINK_INLINE_END( SetupReinstallModeDialog, UpgradeHdl, Button *, EMPTYARG )

// -----------------------------------------------------------------------

IMPL_LINK_INLINE_START( SetupReinstallModeDialog, DeinstallHdl, Button *, EMPTYARG )
{
	Application::PostUserEvent(SETUP_EVENT_DEINSTALL);
	return 0;
}
IMPL_LINK_INLINE_END( SetupReinstallModeDialog, DeinstallHdl, Button *, EMPTYARG )

// -----------------------------------------------------------------------

IMPL_LINK_INLINE_START( SetupReinstallModeDialog, RecoverHdl, Button *, EMPTYARG )
{
	Application::PostUserEvent(SETUP_EVENT_RECOVER);
	return 0;
}
IMPL_LINK_INLINE_END( SetupReinstallModeDialog, RecoverHdl, Button *, EMPTYARG )

// -----------------------------------------------------------------------

BOOL SetupReinstallModeDialog::Close()
{
	// Application::PostUserEvent( EVENT_START, 0 );
	Application::PostUserEvent(SETUP_EVENT_END);
	return TRUE;
}

// -----------------------------------------------------------------------

void SetupReinstallModeDialog::KeyInput( const KeyEvent& rKEvt )
{
	const KeyCode& rKeyCode = rKEvt.GetKeyCode();
	USHORT nCode = rKeyCode.GetCode();

	if ( ( KEY_ESCAPE == nCode && rKeyCode.GetModifier() == 0 )
	||	 ( KEY_POINT == nCode  && rKeyCode.IsMod1() ) )
		Close();
	else
		ModelessDialog::KeyInput( rKEvt );
}
