/*************************************************************************
 *
 *  $RCSfile: appwin.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 14:33:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXAPPWIN_HXX
#define _SFXAPPWIN_HXX

#ifndef _WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif

class SfxWorkWindow;
//====================================================================
class SfxApplicationWindow
{
friend class SfxApplicationWindow_Impl;

    static SfxApplicationWindow*    pAppWin;

    Rectangle                       aClientArea;
    SfxApplicationWindow_Impl*      pImpData;
    SfxWorkWindow*                  pWorkWin;

							SfxApplicationWindow();
							SfxApplicationWindow( const SfxApplicationWindow& );
							~SfxApplicationWindow();

	void            		operator=( const SfxApplicationWindow& );

	void    				Activate();
	void    				Deactivate();
	void    				Resize();
	void    				Move();
	void    				Paint( const Rectangle& );
	void    				GetFocus();
	long					Notify( NotifyEvent& rEvt );
	BOOL    				Drop( const DropEvent& rEvt );
	BOOL    				QueryDrop( DropEvent& rEvt );
	void					KeyInput( const KeyEvent &rKeyEvent );
	XubString				GetText() const;

public:
	static
	SfxApplicationWindow*	Get();
	static
	void					Release();

	void					Appear( FASTBOOL bKeepMinimized = FALSE );
	BOOL    				Close();

	const Rectangle&		GetClientAreaPixel() const { return aClientArea; }

	void					SetPresentationMode ( BOOL, WorkWindow* );
	void					SetFullScreenView( BOOL bSet );
	BOOL					IsFullScreenView() const;
	void					InvalidateTitle();
	BOOL					IsInModalMode();
    BOOL                    IsInPresentationMode();

#if _SOLAR__PRIVATE
							// Compatibilit"ats-Hack, GetClientAreaPixel InLine ist
	void            		LockResize_Impl( BOOL bLock = TRUE );
	void 					SetClientAreaPixel_Impl( const Rectangle& rRect ) { aClientArea = rRect; }

	SfxWorkWindow*  		GetWorkWindow_Impl();
	void					DeleteControllers_Impl();
	void            		SetTitle_Impl(BOOL bIBM = FALSE);
	DECL_LINK( 				AliveHandler_Impl, void * );

	void					DoActivate_Impl() { Activate(); }

	void					LoadConfig_Impl();
	void					SwitchMode_Impl();
	void 					StorePosSize_Impl();

	String					GetTitle() const;

private:
	void					Construct_Impl();
	DECL_LINK( 				IdleHandler_Impl, void * );
#endif
};

//--------------------------------------------------------------------

#define SFX_APPWINDOW ( SfxApplicationWindow::Get() )

#endif // #ifndef _SFXAPPWIN_HXX


