/*************************************************************************
 *
 *  $RCSfile: scriptcont.cxx,v $
 *
 *  $Revision: 1.20 $
 *
 *  last change: $Author: hr $ $Date: 2003/04/04 17:34:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XPARSER_HPP_
#include <com/sun/star/xml/sax/XParser.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_INPUTSOURCE_HPP_
#include <com/sun/star/xml/sax/InputSource.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XSIMPLEFILEACCESS_HPP_
#include <com/sun/star/ucb/XSimpleFileAccess.hpp>
#endif

#include <com/sun/star/script/XStarBasicAccess.hpp>
#include <com/sun/star/script/XStarBasicModuleInfo.hpp>
#include <com/sun/star/script/XStarBasicLibraryInfo.hpp>


#include "scriptcont.hxx"

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _UTL_STREAM_WRAPPER_HXX_
#include <unotools/streamwrap.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _RTL_DIGEST_H_
#include <rtl/digest.h>
#endif

// For password functionality
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif


#include <svtools/pathoptions.hxx>
#include <svtools/sfxecode.hxx>
#include <svtools/ehdl.hxx>
#include <basic/basmgr.hxx>
#include <basic/sbmod.hxx>
#include <xmlscript/xmlmod_imexp.hxx>
#include <app.hxx>


using namespace com::sun::star::container;
using namespace com::sun::star::io;
using namespace com::sun::star::uno;
using namespace com::sun::star::ucb;
using namespace com::sun::star::lang;
using namespace com::sun::star::script;
using namespace com::sun::star::xml::sax;
using namespace com::sun::star;
using namespace cppu;
using namespace rtl;
using namespace osl;


//============================================================================
// Implementation class SfxScriptLibraryContainer

sal_Bool SfxScriptLibraryContainer::init
( const ::rtl::OUString& aInitialisationParam,
  const ::rtl::OUString& aScriptLanguage,
  BasicManager* pBasMgr, SotStorage* pStor )
{
    maScriptLanguage = aScriptLanguage;
    mpBasMgr = pBasMgr;
    return SfxLibraryContainer_Impl::init( 
        aInitialisationParam,
		OUString ( RTL_CONSTASCII_USTRINGPARAM("script") ),
		OUString ( RTL_CONSTASCII_USTRINGPARAM("script") ),
		OUString ( RTL_CONSTASCII_USTRINGPARAM("xba") ),
		OUString ( RTL_CONSTASCII_USTRINGPARAM("Basic") ),
        pStor );
}

// OldBasicPassword interface
void SfxScriptLibraryContainer::setLibraryPassword
    ( const String& rLibraryName, const String& rPassword )
{
    try
    {
        SfxLibrary_Impl* pImplLib = getImplLib( rLibraryName );
        if( rPassword.Len() )
        {
	        pImplLib->mbDoc50Password = sal_True;
            pImplLib->mbPasswordProtected = sal_True;
            pImplLib->maPassword = rPassword;
        }
    }
    catch( NoSuchElementException& ) {}
}

String SfxScriptLibraryContainer::getLibraryPassword( const String& rLibraryName )
{
    SfxLibrary_Impl* pImplLib = getImplLib( rLibraryName );
    String aPassword;
    if( pImplLib->mbPasswordVerified )
        aPassword = pImplLib->maPassword;
    return aPassword;
}

void SfxScriptLibraryContainer::clearLibraryPassword( const String& rLibraryName )
{
    try
    {
        SfxLibrary_Impl* pImplLib = getImplLib( rLibraryName );
	    pImplLib->mbDoc50Password = sal_False;
        pImplLib->mbPasswordProtected = sal_False;
        pImplLib->maPassword = OUString();
    }
    catch( NoSuchElementException& ) {}
}

sal_Bool SfxScriptLibraryContainer::hasLibraryPassword( const String& rLibraryName )
{
    SfxLibrary_Impl* pImplLib = getImplLib( rLibraryName );
    return pImplLib->mbPasswordProtected;
}


// Ctor for service
SfxScriptLibraryContainer::SfxScriptLibraryContainer( void )
{
    // all initialisation has to be done
    // by calling XInitialization::initialize
}

SfxScriptLibraryContainer::	SfxScriptLibraryContainer
	( const ::rtl::OUString& aScriptLanguage, BasicManager* pBasMgr, SotStorage* pStor )
{
    OUString aInitialisationParam;
    init( aInitialisationParam, aScriptLanguage, pBasMgr, pStor );
}

// Methods to get library instances of the correct type
SfxLibrary_Impl* SfxScriptLibraryContainer::implCreateLibrary( void )
{
	SfxLibrary_Impl* pRet = (SfxLibrary_Impl*) new SfxScriptLibrary( mxMSF, mxSFI );
	return pRet;
}

SfxLibrary_Impl* SfxScriptLibraryContainer::implCreateLibraryLink
	( const OUString& aLibInfoFileURL, const OUString& StorageURL, sal_Bool ReadOnly )
{
	SfxLibrary_Impl* pRet = 
		(SfxLibrary_Impl*) new SfxScriptLibrary
            ( mxMSF, mxSFI, aLibInfoFileURL, StorageURL, ReadOnly );
	return pRet;
}

Any SAL_CALL SfxScriptLibraryContainer::createEmptyLibraryElement( void )
{
	OUString aMod;
	Any aRetAny;
	aRetAny <<= aMod;
	return aRetAny;
}

sal_Bool SAL_CALL SfxScriptLibraryContainer::isLibraryElementValid( Any aElement )
{
	OUString aMod;
	aElement >>= aMod;
	sal_Bool bRet = (aMod.getLength() > 0);
	return bRet;
}

void SAL_CALL SfxScriptLibraryContainer::writeLibraryElement
( 
	Any aElement,
	const OUString& aElementName, 
	Reference< XOutputStream > xOutput 
)
	throw(Exception)
{
	// Create sax writer
	Reference< XExtendedDocumentHandler > xHandler(
		mxMSF->createInstance(
			OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.xml.sax.Writer") ) ), UNO_QUERY );
	if( !xHandler.is() )
	{
		OSL_ENSURE( 0, "### couln't create sax-writer component\n" );
		return;
	}

	Reference< XActiveDataSource > xSource( xHandler, UNO_QUERY );
	xSource->setOutputStream( xOutput );

	xmlscript::ModuleDescriptor aMod;
	aMod.aName = aElementName;
	aMod.aLanguage = maScriptLanguage;
	aElement >>= aMod.aCode;
	xmlscript::exportScriptModule( xHandler, aMod );
}


Any SAL_CALL SfxScriptLibraryContainer::importLibraryElement
	( const OUString& aFile, SotStorageStreamRef xElementStream )
{
	Any aRetAny;

	Reference< XParser > xParser( mxMSF->createInstance(
		OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.xml.sax.Parser") ) ), UNO_QUERY );
	if( !xParser.is() )
	{
		OSL_ENSURE( 0, "### couln't create sax parser component\n" );
		return aRetAny;
	}


	// Read from storage?
	sal_Bool bStorage = xElementStream.Is();
	Reference< XInputStream > xInput;

	if( bStorage )
	{
		xInput = new utl::OInputStreamWrapper( *xElementStream );
	}
	else
	{
		try
		{
			xInput = mxSFI->openFileRead( aFile );
		}
		catch( Exception& )
		//catch( Exception& e )
		{
			// TODO:
			//throw WrappedTargetException( e );
		}
	}
	if( !xInput.is() )
		return aRetAny;

	InputSource source;
	source.aInputStream = xInput;
	source.sSystemId 	= aFile;
	
	// start parsing 
	xmlscript::ModuleDescriptor aMod;

    try
    {
    	xParser->setDocumentHandler( ::xmlscript::importScriptModule( aMod ) );
	    xParser->parseStream( source );
    }
    catch( Exception& )
    {
		SfxErrorContext aEc( ERRCTX_SFX_LOADBASIC, aFile );
        ULONG nErrorCode = ERRCODE_IO_GENERAL;
        ErrorHandler::HandleError( nErrorCode );
    }

	aRetAny <<= aMod.aCode;

	// TODO: Check language
	// aMod.aLanguage
	// aMod.aName ignored

	return aRetAny;
}

SfxLibraryContainer_Impl* SfxScriptLibraryContainer::createInstanceImpl( void )
{
    return new SfxScriptLibraryContainer();
}

void SAL_CALL SfxScriptLibraryContainer::importFromOldStorage( const ::rtl::OUString& aFile )
{
    SotStorageRef xStorage = new SotStorage( sal_False, aFile );
	if( xStorage.Is() && xStorage->GetError() == ERRCODE_NONE )
    {
        // We need a BasicManager to avoid problems
        // StarBASIC* pBas = new StarBASIC();
        BasicManager* pBasicManager = new BasicManager( *(SotStorage*)xStorage );

        // Set info
        Reference< XLibraryContainer > xBasicCont = 
            static_cast< XLibraryContainer* >( this );
        Reference< XLibraryContainer > xDialogCont;
	    LibraryContainerInfo* pInfo = new LibraryContainerInfo
            ( xBasicCont, xDialogCont, static_cast< OldBasicPassword* >( this ) );
	    pBasicManager->SetLibraryContainerInfo( pInfo );

        // Now the libraries should be copied to this SfxScriptLibraryContainer
        delete pBasicManager;
    }
}


// Storing with password encryption

// Methods XLibraryContainerPassword
sal_Bool SAL_CALL SfxScriptLibraryContainer::isLibraryPasswordProtected( const OUString& Name ) 
    throw (NoSuchElementException, RuntimeException)
{
    SfxLibrary_Impl* pImplLib = getImplLib( Name );
	sal_Bool bRet = pImplLib->mbPasswordProtected;
	return bRet;
}

sal_Bool SAL_CALL SfxScriptLibraryContainer::isLibraryPasswordVerified( const OUString& Name ) 
    throw (IllegalArgumentException, NoSuchElementException, RuntimeException)
{
    SfxLibrary_Impl* pImplLib = getImplLib( Name );
	if( !pImplLib->mbPasswordProtected )
		throw IllegalArgumentException();
	sal_Bool bRet = pImplLib->mbPasswordVerified;
	return bRet;
}

sal_Bool SAL_CALL SfxScriptLibraryContainer::verifyLibraryPassword
    ( const OUString& Name, const OUString& Password ) 
        throw (IllegalArgumentException, NoSuchElementException, RuntimeException)
{
    SfxLibrary_Impl* pImplLib = getImplLib( Name );
	if( !pImplLib->mbPasswordProtected || pImplLib->mbPasswordVerified )
		throw IllegalArgumentException();

    // Test password
    sal_Bool bSuccess = sal_False;
    if( pImplLib->mbDoc50Password )
    {
        bSuccess = ( Password == pImplLib->maPassword );
        if( bSuccess )
            pImplLib->mbPasswordVerified = sal_True;
    }
    else
    {
        pImplLib->maPassword = Password;
        bSuccess = implLoadPasswordLibrary( pImplLib, Name, sal_True );
        if( bSuccess )
        {
            // The library gets modified by verifiying the password, because other-
            // wise for saving the storage would be copied and that doesn't work 
            // with mtg's storages when the password is verified
            pImplLib->mbModified = sal_True;
            pImplLib->mbPasswordVerified = sal_True;

            // Reload library to get source
            if( pImplLib->mbLoaded )
                implLoadPasswordLibrary( pImplLib, Name );
        }
    }
	return bSuccess;
}

void SAL_CALL SfxScriptLibraryContainer::changeLibraryPassword( const OUString& Name, 
    const OUString& OldPassword, const OUString& NewPassword ) 
        throw (IllegalArgumentException, NoSuchElementException, RuntimeException)
{
    SfxLibrary_Impl* pImplLib = getImplLib( Name );
    if( OldPassword == NewPassword )
        return;

    sal_Bool bOldPassword = ( OldPassword.getLength() > 0 );
    sal_Bool bNewPassword = ( NewPassword.getLength() > 0 );
	sal_Bool bStorage = mxStorage.Is() && !pImplLib->mbLink;

    if( pImplLib->mbReadOnly || (bOldPassword && !pImplLib->mbPasswordProtected) )
		throw IllegalArgumentException();

    // Library must be loaded
	loadLibrary( Name );

    sal_Bool bKillCryptedFiles = sal_False;
    sal_Bool bKillUncryptedFiles = sal_False;

    // Remove or change password?
    if( bOldPassword )
    {
        if( isLibraryPasswordVerified( Name ) )
        {
            if( pImplLib->maPassword != OldPassword )
       		    throw IllegalArgumentException();
        }
        else
        {
            if( !verifyLibraryPassword( Name, OldPassword ) )
       		    throw IllegalArgumentException();

            // Reload library to get source
            // Should be done in verifyLibraryPassword loadLibrary( Name );
        }

        if( !bNewPassword )
        {
            pImplLib->mbPasswordProtected = sal_False;
            pImplLib->mbPasswordVerified = sal_False;
            pImplLib->maPassword = OUString();

		    mbModified = sal_True;
            pImplLib->mbModified = sal_True;

            if( !bStorage && !pImplLib->mbDoc50Password )
            {
                // Store application basic uncrypted
                SotStorageRef xStorage;
                storeLibraries_Impl( xStorage, sal_False );
                bKillCryptedFiles = sal_True;
            }
        }
    }

    // Set new password?
    if( bNewPassword )
    {
        pImplLib->mbPasswordProtected = sal_True;
        pImplLib->mbPasswordVerified = sal_True;
        pImplLib->maPassword = NewPassword;

		mbModified = sal_True;
        pImplLib->mbModified = sal_True;

        if( !bStorage && !pImplLib->mbDoc50Password )
        {
            // Store applictaion basic crypted
            SotStorageRef xStorage;
            storeLibraries_Impl( xStorage, sal_False );
            bKillUncryptedFiles = sal_True;
        }
    }

    if( bKillCryptedFiles || bKillUncryptedFiles )
    {
	    Sequence< OUString > aElementNames = pImplLib->getElementNames();
	    sal_Int32 nNameCount = aElementNames.getLength();
	    const OUString* pNames = aElementNames.getConstArray();
        OUString aLibDirPath = createAppLibraryFolder( pImplLib, Name );
		try
		{
			for( sal_Int32 i = 0 ; i < nNameCount ; i++ )
			{
				OUString aElementName = pNames[ i ];

				INetURLObject aElementInetObj( aLibDirPath );
				aElementInetObj.insertName( aElementName, sal_False,
					INetURLObject::LAST_SEGMENT, sal_True, INetURLObject::ENCODE_ALL );
                if( bKillUncryptedFiles )
				    aElementInetObj.setExtension( maLibElementFileExtension );
                else
				    aElementInetObj.setExtension( OUString( RTL_CONSTASCII_USTRINGPARAM("pba") ) );
				String aElementPath( aElementInetObj.GetMainURL( INetURLObject::NO_DECODE ) );

				if( mxSFI->exists( aElementPath ) )
					mxSFI->kill( aElementPath );
			}
		}
        catch( Exception& ) {}
    }
}


void setStreamKey( SotStorageStreamRef xStream, const ByteString& rKey )
{
    ByteString aKey( rKey );
    sal_uInt8 aBuffer[RTL_DIGEST_LENGTH_SHA1];
    rtlDigestError nError = rtl_digest_SHA1( aKey.GetBuffer(), aKey.Len(), aBuffer, RTL_DIGEST_LENGTH_SHA1 );
    if ( nError == rtl_Digest_E_None )
    {
        sal_uInt8* pBuffer = aBuffer;
        ::com::sun::star::uno::Sequence < sal_Int8 > aSequ( (sal_Int8*) pBuffer, RTL_DIGEST_LENGTH_SHA1 );
        ::com::sun::star::uno::Any aAny;
        aAny <<= aSequ;
        xStream->SetProperty( ::rtl::OUString::createFromAscii("EncryptionKey"), aAny );
    }
}


// Impl methods
sal_Bool SfxScriptLibraryContainer::implStorePasswordLibrary( SfxLibrary_Impl* pLib, 
    const ::rtl::OUString& aName, SotStorageRef xStorage )
{
    BasicManager* pBasicMgr = getBasicManager();
    StarBASIC* pBasicLib = pBasicMgr->GetLib( aName );
    if( !pBasicLib )
	    return sal_False;

	Sequence< OUString > aElementNames = pLib->getElementNames();
	sal_Int32 nNameCount = aElementNames.getLength();
	const OUString* pNames = aElementNames.getConstArray();

	sal_Bool bLink = pLib->mbLink;
	sal_Bool bStorage = xStorage.Is() && !bLink;
	if( bStorage )
	{
		for( sal_Int32 i = 0 ; i < nNameCount ; i++ )
		{
			OUString aElementName = pNames[ i ];

            // Write binary image stream
	        SbModule* pMod = pBasicLib->FindModule( aElementName );
	        if( pMod )
            {
		        //OUString aCodeStreamName( RTL_CONSTASCII_USTRINGPARAM("code.bin") );
	            OUString aCodeStreamName = aElementName;
		        aCodeStreamName += String( RTL_CONSTASCII_USTRINGPARAM(".bin") );

                SotStorageStreamRef xCodeStream = xStorage->OpenSotStream
                    ( aCodeStreamName, STREAM_WRITE | STREAM_SHARE_DENYWRITE | STREAM_TRUNC );

		        if( xCodeStream->GetError() == ERRCODE_NONE )
		        {
                    SvMemoryStream aMemStream;
                    BOOL bStore = pMod->StoreBinaryData( aMemStream );

                    // TODO? Store Id to check password?

                    sal_Int32 nSize = (sal_Int32)aMemStream.Tell();
                    Sequence< sal_Int8 > aBinSeq( nSize );
                    sal_Int8* pData = aBinSeq.getArray();
	                ::rtl_copyMemory( pData, aMemStream.GetData(), nSize );

                    Reference< XOutputStream > xOut = new utl::OOutputStreamWrapper( *xCodeStream );
                    xOut->writeBytes( aBinSeq );
    				xOut->closeOutput();
                }
		    }


        	if( pLib->mbPasswordVerified || pLib->mbDoc50Password )
            {
			    Any aElement = pLib->getByName( aElementName );
			    if( isLibraryElementValid( aElement ) )
			    {
	                OUString aSourceStreamName = aElementName;
		            aSourceStreamName += String( RTL_CONSTASCII_USTRINGPARAM(".xml") );
				    SotStorageStreamRef xSourceStream = xStorage->OpenSotStream
					    ( aSourceStreamName, STREAM_WRITE | STREAM_SHARE_DENYWRITE );

				    if( xSourceStream->GetError() == ERRCODE_NONE )
				    {
					    String aPropName( String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM("MediaType") ) );
					    OUString aMime( RTL_CONSTASCII_USTRINGPARAM("text/xml") );
					    Any aAny;
					    aAny <<= aMime;
					    xSourceStream->SetProperty( aPropName, aAny );

                        // Set encryption key
					    ByteString aByteKey( OUStringToOString( pLib->maPassword, RTL_TEXTENCODING_ASCII_US ) );
                        setStreamKey( xSourceStream, aByteKey );

                        // #87671 Allow encryption
					    aPropName = String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM("Encrypted") );
					    aAny <<= sal_True;
					    xSourceStream->SetProperty( aPropName, aAny );

					    Reference< XOutputStream > xOutput =
						    new utl::OOutputStreamWrapper( *xSourceStream );
					    writeLibraryElement( aElement, aElementName, xOutput );
					    xOutput->closeOutput();

					    xSourceStream->Commit();
				    }
			    }
            }
            else    // !mbPasswordVerified
            {
                // TODO
                // What to do if not verified?! In any case it's already loaded here
            }
		}

	}
    // Application libraries have only to be saved if the password 
    // is verified because otherwise they can't be modified
	else if( pLib->mbPasswordVerified )
	{
		try
		{
            OUString aLibDirPath = createAppLibraryFolder( pLib, aName );

			for( sal_Int32 i = 0 ; i < nNameCount ; i++ )
			{
				OUString aElementName = pNames[ i ];

				INetURLObject aElementInetObj( aLibDirPath );
				aElementInetObj.insertName( aElementName, sal_False,
					INetURLObject::LAST_SEGMENT, sal_True, INetURLObject::ENCODE_ALL );
				aElementInetObj.setExtension( OUString( RTL_CONSTASCII_USTRINGPARAM("pba") ) );
				String aElementPath = aElementInetObj.GetMainURL( INetURLObject::NO_DECODE );

				Any aElement = pLib->getByName( aElementName );
				if( isLibraryElementValid( aElement ) )
				{
                    SotStorageRef xElementRootStorage = new SotStorage( sal_True, aElementPath );

                    // Write binary image stream
	                SbModule* pMod = pBasicLib->FindModule( aElementName );
	                if( pMod )
                    {
		                OUString aCodeStreamName( RTL_CONSTASCII_USTRINGPARAM("code.bin") );

                	    SotStorageStreamRef xCodeStream = xElementRootStorage->OpenSotStream
                            ( aCodeStreamName, STREAM_WRITE | STREAM_SHARE_DENYWRITE | STREAM_TRUNC );

		                if( xCodeStream->GetError() == ERRCODE_NONE )
		                {
                            SvMemoryStream aMemStream;
                            BOOL bStore = pMod->StoreBinaryData( aMemStream );

                            // TODO? Store Id to check password?

                            sal_Int32 nSize = (sal_Int32)aMemStream.Tell();
                            Sequence< sal_Int8 > aBinSeq( nSize );
                            sal_Int8* pData = aBinSeq.getArray();
	                        ::rtl_copyMemory( pData, aMemStream.GetData(), nSize );

                    	    Reference< XOutputStream > xOut = new utl::OOutputStreamWrapper( *xCodeStream );
                            xOut->writeBytes( aBinSeq );
    					    xOut->closeOutput();
                        }
		            }

                    // Set encryption key
					ByteString aByteKey( OUStringToOString( pLib->maPassword, RTL_TEXTENCODING_ASCII_US ) );
                    xElementRootStorage->SetKey( aByteKey );

                    // Write encrypted source stream
		            OUString aSourceStreamName( RTL_CONSTASCII_USTRINGPARAM("source.xml") );
                	SotStorageStreamRef xSourceStream = xElementRootStorage->OpenSotStream
                        ( aSourceStreamName, STREAM_WRITE | STREAM_SHARE_DENYWRITE | STREAM_TRUNC );

		            if( xSourceStream->GetError() == ERRCODE_NONE )
		            {
			            String aPropName( String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM("MediaType") ) );
			            OUString aMime( RTL_CONSTASCII_USTRINGPARAM("text/xml") );
			            Any aAny;
			            aAny <<= aMime;
			            xSourceStream->SetProperty( aPropName, aAny );

                        // #87671 Allow encryption
			            aPropName = String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM("Encrypted") );
			            aAny <<= sal_True;
			            xSourceStream->SetProperty( aPropName, aAny );

                    	Reference< XOutputStream > xOut = new utl::OOutputStreamWrapper( *xSourceStream );
    					writeLibraryElement( aElement, aElementName, xOut );
    					xOut->closeOutput();
		            }


                    // Storage Dtor commits too, that makes problems
                    // xElementRootStorage->Commit();
				}

			}
		}
		catch( Exception& )
		{
			//throw e;
		}
	}
    return sal_True;
}

sal_Bool SfxScriptLibraryContainer::implLoadPasswordLibrary
    ( SfxLibrary_Impl* pLib, const OUString& Name, sal_Bool bVerifyPasswordOnly )
        throw(WrappedTargetException, RuntimeException)
{
	sal_Bool bLink = pLib->mbLink;
	sal_Bool bStorage = mxStorage.Is() && !bLink;

    // Already loaded? Then only verifiedPassword can change something
	SfxScriptLibrary* pScriptLib = static_cast< SfxScriptLibrary* >( pLib );
    if( pScriptLib->mbLoaded )
    {
        if( pScriptLib->mbLoadedBinary && !bVerifyPasswordOnly && 
            (pScriptLib->mbLoadedSource || !pLib->mbPasswordVerified) )
                return sal_False;
    }

    StarBASIC* pBasicLib = NULL;
    sal_Bool bLoadBinary = sal_False;
    if( !pScriptLib->mbLoadedBinary && !bVerifyPasswordOnly && !pLib->mbPasswordVerified )
    {
        BasicManager* pBasicMgr = getBasicManager();
        sal_Bool bLoaded = pScriptLib->mbLoaded;
        pScriptLib->mbLoaded = sal_True;        // Necessary to get lib
        pBasicLib = pBasicMgr->GetLib( Name );
        pScriptLib->mbLoaded = bLoaded;    // Restore flag
        if( !pBasicLib )
	        return sal_False;

        bLoadBinary = sal_True;
        pScriptLib->mbLoadedBinary = sal_True;
    }

    sal_Bool bLoadSource = sal_False;
    if( !pScriptLib->mbLoadedSource && pLib->mbPasswordVerified && !bVerifyPasswordOnly )
    {
        bLoadSource = sal_True;
        pScriptLib->mbLoadedSource = sal_True;
    }

	Sequence< OUString > aElementNames = pLib->getElementNames();
	sal_Int32 nNameCount = aElementNames.getLength();
	const OUString* pNames = aElementNames.getConstArray();

	if( bStorage )
    {
		SotStorageRef xLibrariesStor;
		SotStorageRef xLibraryStor;
		if( bStorage )
		{
            xLibrariesStor = mxStorage->OpenSotStorage( maLibrariesDir, STREAM_READ | STREAM_NOCREATE );
			if( xLibrariesStor.Is() && xLibrariesStor->GetError() == ERRCODE_NONE )
			{
                xLibraryStor = xLibrariesStor->OpenSotStorage( Name, STREAM_READ | STREAM_NOCREATE );
			}
			if( !xLibraryStor.Is() || xLibraryStor->GetError() != ERRCODE_NONE )
			{
				OSL_ENSURE( 0, "### couln't open sub storage for library\n" );
				return sal_False;
			}
		}

		for( sal_Int32 i = 0 ; i < nNameCount ; i++ )
		{
			OUString aElementName = pNames[ i ];

            // Load binary
            if( bLoadBinary )
            {
	            SbModule* pMod = pBasicLib->FindModule( aElementName );
                if( !pMod )
                {
			        pMod = pBasicLib->MakeModule( aElementName, String() );
			        pBasicLib->SetModified( FALSE );
                }

		        //OUString aCodeStreamName( RTL_CONSTASCII_USTRINGPARAM("code.bin") );
	            OUString aCodeStreamName= aElementName;
		        aCodeStreamName += String( RTL_CONSTASCII_USTRINGPARAM(".bin") );
                SotStorageStreamRef xCodeStream = xLibraryStor->OpenSotStream
                    ( aCodeStreamName, STREAM_READ );

		        if( xCodeStream->GetError() == ERRCODE_NONE )
		        {
                    BOOL bRet = pMod->LoadBinaryData( *static_cast< SvStream* >( xCodeStream ) );
                    // TODO: Check return value
                }
            }

            // Load source
            if( bLoadSource || bVerifyPasswordOnly )
            {
                // Access encrypted source stream
	            OUString aSourceStreamName = aElementName;
		        aSourceStreamName += String( RTL_CONSTASCII_USTRINGPARAM(".xml") );
				ByteString aByteKey( OUStringToOString( pLib->maPassword, RTL_TEXTENCODING_ASCII_US ) );
				SotStorageStreamRef xSourceStream = xLibraryStor->OpenEncryptedSotStream
					( aSourceStreamName, aByteKey, STREAM_READ );

                // TODO: helper function to be used together with application basic
		        if( xSourceStream->GetError() == ERRCODE_NONE )
                {
                    if( bVerifyPasswordOnly )
                    {
                        // Check start of xml file
                        // TODO: Use password check functionality when available
                        char pTest[] = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
                        sal_Int32 nLen = strlen( pTest );
                        char* pBuf = new char[ nLen + 1 ];
                        pBuf[nLen] = 0;
                        sal_Int32 nRead = xSourceStream->Read( pBuf, nLen );
                        sal_Bool bRet = sal_True;
                        if( nRead != nLen || strcmp( pBuf, pTest ) != 0 )
                            bRet = sal_False;
                        delete pBuf;
                        return bRet;
                    }
                    else
                    {
			            Any aAny = importLibraryElement( aSourceStreamName, xSourceStream );
			            if( pLib->hasByName( aElementName ) )
                        {
                            if( aAny.hasValue() )
				                pLib->maNameContainer.replaceByName( aElementName, aAny );
                        }
			            else
                        {
				            pLib->maNameContainer.insertByName( aElementName, aAny );
                        }
                    }
                }
            }
		}
    }
    else
    {
		try
		{
            OUString aLibDirPath = createAppLibraryFolder( pLib, Name );

			for( sal_Int32 i = 0 ; i < nNameCount ; i++ )
			{
				OUString aElementName = pNames[ i ];

				INetURLObject aElementInetObj( aLibDirPath );
				aElementInetObj.insertName( aElementName, sal_False,
					INetURLObject::LAST_SEGMENT, sal_True, INetURLObject::ENCODE_ALL );
				aElementInetObj.setExtension( OUString( RTL_CONSTASCII_USTRINGPARAM("pba") ) );
				String aElementPath = aElementInetObj.GetMainURL( INetURLObject::NO_DECODE );

                SotStorageRef xElementRootStorage = new SotStorage( sal_True, aElementPath );
			    if( xElementRootStorage->GetError() == ERRCODE_NONE )
			    {
                    // Load binary
                    if( bLoadBinary )
                    {
	                    SbModule* pMod = pBasicLib->FindModule( aElementName );
                        if( !pMod )
                        {
			                pMod = pBasicLib->MakeModule( aElementName, String() );
			                pBasicLib->SetModified( FALSE );
                        }

		                OUString aCodeStreamName( RTL_CONSTASCII_USTRINGPARAM("code.bin") );
                	    SotStorageStreamRef xCodeStream = xElementRootStorage->OpenSotStream
                            ( aCodeStreamName, STREAM_READ );

		                if( xCodeStream->GetError() == ERRCODE_NONE )
		                {
                            BOOL bRet = pMod->LoadBinaryData( *static_cast< SvStream* >( xCodeStream ) );
                            // TODO: Check return value
                        }
                    }

                    // Load source
                    if( bLoadSource || bVerifyPasswordOnly )
                    {
                        // Set encrytion key
				        ByteString aByteKey( OUStringToOString( pLib->maPassword, RTL_TEXTENCODING_ASCII_US ) );
                        xElementRootStorage->SetKey( aByteKey );

                        // Access encrypted source stream
		                OUString aSourceStreamName( RTL_CONSTASCII_USTRINGPARAM("source.xml") );
                        SotStorageStreamRef xSourceStream = 
                            xElementRootStorage->OpenSotStream( aSourceStreamName, STREAM_READ );

                        // TODO: helper function to be used together with application basic
		                if( xSourceStream->GetError() == ERRCODE_NONE )
                        {
                            if( bVerifyPasswordOnly )
                            {
                                // Check start of xml file
                                // TODO: Use password check functionality when available
                                char pTest[] = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
                                sal_Int32 nLen = strlen( pTest );
                                char* pBuf = new char[ nLen + 1 ];
                                pBuf[nLen] = 0;
                                sal_Int32 nRead = xSourceStream->Read( pBuf, nLen );
                                sal_Bool bRet = sal_True;
                                if( nRead != nLen || strcmp( pBuf, pTest ) != 0 )
                                    bRet = sal_False;
                                delete pBuf;
                                return bRet;
                            }
                            else
                            {
			                    Any aAny = importLibraryElement( aSourceStreamName, xSourceStream );
			                    if( pLib->hasByName( aElementName ) )
                                {
                                    if( aAny.hasValue() )
				                        pLib->maNameContainer.replaceByName( aElementName, aAny );
                                }
			                    else
                                {
				                    pLib->maNameContainer.insertByName( aElementName, aAny );
                                }
                            }
                        }
                    }
                }
			}

		}
		catch( Exception& )
		{
			// TODO
			//throw e;
		}
    }

    // If the password is verified the library must remain modified, because 
    // otherwise for saving the storage would be copied and that doesn't work 
    // with mtg's storages when the password is verified
    if( !pLib->mbPasswordVerified )
        pLib->mbModified = sal_False;
    return sal_True;
}


//============================================================================
// Methods XInitialization
void SAL_CALL SfxScriptLibraryContainer::initialize( const Sequence< Any >& aArguments ) 
    throw (::com::sun::star::uno::Exception, 
           ::com::sun::star::uno::RuntimeException)
{
	sal_Int32 nArgCount = aArguments.getLength();
	OSL_ENSURE( nArgCount, "SfxDialogLibraryContainer::initialize() called with no arguments\n" );

    OUString aInitialisationParam;
    OUString aScriptLanguage;
    if( nArgCount )
    {
        const Any* pArgs = aArguments.getConstArray();
        pArgs[0] >>= aInitialisationParam;
    	OSL_ENSURE( aInitialisationParam.getLength(), 
            "SfxDialogLibraryContainer::initialize() called with empty url\n" );

        if( nArgCount > 1 )
            pArgs[1] >>= aInitialisationParam;
        else
            aScriptLanguage = OUString::createFromAscii( "StarBasic" );
    }

    init( aInitialisationParam, aScriptLanguage );
}


//============================================================================
// Service
SFX_IMPL_SINGLEFACTORY( SfxScriptLibraryContainer )

Sequence< OUString > SfxScriptLibraryContainer::impl_getStaticSupportedServiceNames()
{
    static Sequence< OUString > seqServiceNames( 1 );
    static sal_Bool bNeedsInit = sal_True;

	MutexGuard aGuard( Mutex::getGlobalMutex() );
    if( bNeedsInit )
    {
        OUString* pSeq = seqServiceNames.getArray();
        pSeq[0] = OUString::createFromAscii( "com.sun.star.script.ScriptLibraryContainer" );
        bNeedsInit = sal_False;
    }
    return seqServiceNames;
}

OUString SfxScriptLibraryContainer::impl_getStaticImplementationName()
{
    static OUString aImplName;
    static sal_Bool bNeedsInit = sal_True;

	MutexGuard aGuard( Mutex::getGlobalMutex() );
    if( bNeedsInit )
    {
        aImplName = OUString::createFromAscii( "com.sun.star.comp.sfx2.ScriptLibraryContainer" );
        bNeedsInit = sal_False;
    }
    return aImplName;
}

Reference< XInterface > SAL_CALL SfxScriptLibraryContainer::impl_createInstance
    ( const Reference< XMultiServiceFactory >& xServiceManager ) 
        throw( Exception )
{
    Reference< XInterface > xRet = 
        static_cast< XInterface* >( static_cast< OWeakObject* >(new SfxScriptLibraryContainer()) );
    return xRet;
}

//============================================================================
// Service for application library container
SFX_IMPL_ONEINSTANCEFACTORY( SfxApplicationScriptLibraryContainer )

Sequence< OUString > SfxApplicationScriptLibraryContainer::impl_getStaticSupportedServiceNames()
{
    static Sequence< OUString > seqServiceNames( 1 );
    static sal_Bool bNeedsInit = sal_True;

	MutexGuard aGuard( Mutex::getGlobalMutex() );
    if( bNeedsInit )
    {
        OUString* pSeq = seqServiceNames.getArray();
        pSeq[0] = OUString::createFromAscii( "com.sun.star.script.ApplicationScriptLibraryContainer" );
        bNeedsInit = sal_False;
    }
    return seqServiceNames;
}

OUString SfxApplicationScriptLibraryContainer::impl_getStaticImplementationName()
{
    static OUString aImplName;
    static sal_Bool bNeedsInit = sal_True;

	MutexGuard aGuard( Mutex::getGlobalMutex() );
    if( bNeedsInit )
    {
        aImplName = OUString::createFromAscii( "com.sun.star.comp.sfx2.ApplicationScriptLibraryContainer" );
        bNeedsInit = sal_False;
    }
    return aImplName;
}

Reference< XInterface > SAL_CALL SfxApplicationScriptLibraryContainer::impl_createInstance
    ( const Reference< XMultiServiceFactory >& xServiceManager ) 
        throw( Exception )
{
	SFX_APP()->GetBasicManager();
    Reference< XInterface > xRet = 
        Reference< XInterface >( SFX_APP()->GetBasicContainer(), UNO_QUERY );
    return xRet;
}


//============================================================================

void SAL_CALL SfxScriptLibraryContainer::storeLibraries( sal_Bool bComplete )
{
	SfxLibraryContainer_Impl::storeLibraries( bComplete );
}

void SAL_CALL SfxScriptLibraryContainer::storeLibrariesToStorage( SotStorageRef xStorage )
{
	SfxLibraryContainer_Impl::storeLibrariesToStorage( xStorage );
}


//============================================================================
// Implementation class SfxScriptLibrary

// Ctor
SfxScriptLibrary::SfxScriptLibrary( Reference< XMultiServiceFactory > xMSF, 
                                    Reference< XSimpleFileAccess > xSFI )
	: SfxLibrary_Impl( getCppuType( (const OUString *)0 ), xMSF, xSFI )
    , mbLoadedSource( sal_False )
    , mbLoadedBinary( sal_False )
{
}

SfxScriptLibrary::SfxScriptLibrary( Reference< XMultiServiceFactory > xMSF, 
                                    Reference< XSimpleFileAccess > xSFI,
                                    const OUString& aLibInfoFileURL, 
                                    const OUString& aStorageURL, 
                                    sal_Bool ReadOnly )
	: SfxLibrary_Impl( getCppuType( (const OUString *)0 ), xMSF, xSFI,
						aLibInfoFileURL, aStorageURL, ReadOnly)
    , mbLoadedSource( sal_False )
    , mbLoadedBinary( sal_False )
{
}

//============================================================================
