/*************************************************************************
 *
 *  $RCSfile: mailwindow.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: dg $ $Date: 2001/06/21 13:26:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef INCLUDED_SFX_MAILWINDOW_HXX
#define INCLUDED_SFX_MAILWINDOW_HXX

#include <vcl/button.hxx>	// PushButton
#include <vcl/fixed.hxx>	// FixedText
#include <vcl/edit.hxx>		// Edit
#include <vcl/lstbox.hxx>	// ListBox

// class AddressEdit_Impl ------------------------------------------------

class MailWindow_Impl;

class AddressEdit_Impl : public Edit
{
private:
	MailWindow_Impl*	mpWindow;

public:
	AddressEdit_Impl( MailWindow_Impl* pWin, const ResId& rResId );

	virtual void		KeyInput( const KeyEvent& rKEvt );
};

class AddressListBox_Impl : public ListBox
{
private:
	MailWindow_Impl*	mpWindow;

public:
	AddressListBox_Impl( MailWindow_Impl* pWin, const ResId& rResId );

	virtual long		Notify( NotifyEvent& rNEvt );
};

// class MailWindow_Impl -------------------------------------------------

class MailListener_Impl;
class SfxMailModel_Impl;
class SfxBindings;

class MailWindow_Impl : public Window
{
private:
	PushButton			aSendBtn;
	PushButton			aCloseBtn;
	ListBox				aRoleLB;
	AddressEdit_Impl	aRoleEdit;
	AddressListBox_Impl	aAddressLB;
	FixedText			aSubjectFT;
	Edit				aSubjectEdit;
	FixedText			aFromFT;
	Edit				aFromEdit;
	FixedText			aPrioFT;
	ListBox				aPrioLB;

	Image				aSendImage;
	Image				aCloseImage;
	Timer				aCloseTimer;
	Timer				aInitTimer;

	sal_Bool			bSend;

	long				n6Size;
	long				nMinWidth;

	SfxBindings*		pBindings;

	void				FillModel( SfxMailModel_Impl& rModel );

	DECL_LINK( SendHdl, PushButton* );
	DECL_LINK( CloseHdl, void* );
	DECL_LINK( ModifyHdl, Edit* );
	DECL_LINK( InitHdl, Timer* );
	DECL_LINK( ChangeHdl, MailListener_Impl* );

public:
	MailWindow_Impl( Window* pParent, SfxBindings* pBinds, const ResId& rResId );
	~MailWindow_Impl();

	virtual void		Resize();

	sal_Bool			CanSend() const;
	void				Send();
	sal_Bool			HasSend() const { return bSend; }
	void				ReceiveAddress();
	void				ClearAddress();
	void				DeleteAddress();
};

#endif // INCLUDED_SFX_MAILWINDOW_HXX


