/*************************************************************************
 *
 *  $RCSfile: Console.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:54:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package stardiv.controller;

import java.awt.Button;
import java.awt.Frame;
import java.awt.Dialog;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.BorderLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import java.io.OutputStream;
import java.io.PrintStream;
//import java.io.IOException;

/**
 * Class Console creates a Java Console for GUI based Java Applications. Once
 * created, a Console component receives all the data directed to the standard
 * output (System.out) and error (System.err) streams.
 * <p>
 * For example, once a Java Console is created for an application, data passed
 * on to any methods of System.out (e.g., System.out.println(" ")) and
 * System.err (e.g., stack trace in case of uncought exceptions) will be
 * received by the Console.
 * <p>
 * Note that a Java Console can not be created for Applets to run on any
 * browsers due to security violations. Browsers will not let standard output
 * and error streams be redicted (for obvious reasons).
 *
 * @author Subrahmanyam Allamaraju (sallamar@cvimail.cv.com)
 */
public class Console {
	static String	aOutput = getVersion();

    static DebugDialog		pDialog;
    static Frame 			pFrame;
	static ConsoleStream	pErrStm;
	static ConsoleStream	pOutStm;

    static PrintStream		pSystemErr;
    static PrintStream		pSystemOut;

    static boolean 			redirected = false;
    static String			titel = "Java Console";

	public Console() {
		showConsole(true);
	}

    /**
     * Creates a Java Console.
     */
    static synchronized public void installConsole() {
    	if (!redirected) {
		    pSystemErr = System.err;
		    pSystemOut = System.out;

			pErrStm = new ConsoleStream();
		    System.setErr( new PrintStream( pErrStm ) );
			pOutStm = new ConsoleStream();
		    System.setOut( new PrintStream( pOutStm ) );
		    redirected = true;
		}
	}

	static String getVersion() {
		String version = new String();
		try {
			version += System.getProperty("java.vendor");
		} catch (SecurityException e) {
		}
		version += " (";
		
		try {
			version += System.getProperty("java.vendor.url");
		} catch (SecurityException e) {	
		}

		version += ") -- JDK ";
			
		try {
			version += System.getProperty("java.version") + "\n";
		} catch (SecurityException e) {
		}
		
		version += "\n";
		
		return version;
	}

	static void loadLibrary(String name) {
		System.loadLibrary(name);

//  		System.err.println("#### Console.loadLibrary:" + System.getProperty("java.class.path"));
//  		Class xClass = null;
//  		Object o = null;
//  		try {
//  			xClass = Class.forName("com.sun.star.comp.jawt.peer.Toolkit");
//  			o = xClass.newInstance();
//  		}
//  		catch(Exception exception) {
//  		}

//  		System.err.println("#### Console.loadLibrary:" + xClass + " " + o);
			
//  		java.awt.Toolkit.getDefaultToolkit();
	}

	static void printDebugPassword(String password) {

	    if (password != null) {
	    	titel = "Java Console [ password: " + password + " ]";
			//System.out.println("debug agent password: "+ password);
	    } else { // kein Debug Agent gefunden
	    	titel = "Java Console [ !! no debug agent found !! ]";
			//System.out.println("no debug agent found!");
	    }
	}

    static synchronized public void showConsole(boolean bShow) {
		if( bShow ) {
			if( pDialog == null ) {
				if (pFrame == null) {
					pFrame = new Frame();
				}
				pDialog = new DebugDialog(pFrame, titel);
			}
			pDialog.show();
			pDialog.setText( aOutput );
		} else {
			if ( pDialog != null ) {
    			pDialog.setVisible( false ); // Es wird nicht in das
    										// TextArea geschrieben wenn sie nicht sichtbar ist
				//pFrame.dispose();
				//pDialog = null;
			}
		}
    }

    public static void main( String [] args ) {
        installConsole();
        showConsole( true );
    }

}

class DebugDialog extends java.awt.Dialog {
    private TextArea aTextArea;
    private Frame pFrame;
    private PropertyEditor propertyEditor;
    private ThreadDialog threadDialog;
    private boolean instractionTracing 	= false;
    private boolean methodTracing		= false;

	public DebugDialog(Frame frame) {
		this(frame, "Java Console");
	}

	public DebugDialog(Frame frame, String title) {
		super( frame, title );
		pFrame = frame;
	    addWindowListener(new WindowAdapter()
			      {
				  public void windowClosing(WindowEvent e) {
					  Console.showConsole(false);
				      }
			      });

	    aTextArea = new TextArea();
	    aTextArea.setEditable(false);

	    Button clear = new Button("Clear");
	    Button close = new Button("Close");
	    Button performGC = new Button("Perform GC");
	    Button memory = new Button("Show Memory");
	    Button showPpropertyEditor = new Button("Property Editor");
	    Button showThreads = new Button("Threads");
	    
		ActionListener listener = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				String action = e.getActionCommand();
				if (action.equals("Clear")) {
					clear();
				} else 
				if(action.equals("Close")) {
					Console.showConsole(false);
				} else 
				if (action.equals("Perform GC")) {
					Runtime runtime = Runtime.getRuntime();
					long freeMemBefore = runtime.freeMemory();
					System.out.println();
					System.out.println("performing garbage collection ...");
					System.gc();
					long freeMemAfter = runtime.freeMemory();
					long freedMem = (freeMemAfter - freeMemBefore) / 1024;
					System.out.println("... "+freedMem +" KByte freed");
				} else 
				if (action.equals("Show Memory")) {
					Runtime runtime = Runtime.getRuntime();
					System.out.println();
					System.out.println(runtime. totalMemory() / 1024 + " kBytes total amount of memory in the Java Virtual Machine");
					System.out.println(runtime. freeMemory() / 1024 + " kBytes amount of free memory in the system");					
				} else 
				if (action.equals("Property Editor")) {
					if (propertyEditor == null) {
						Frame f = new Frame();
			        	propertyEditor = new PropertyEditor(f);
			        }
			        if (!propertyEditor.isVisible()) {
			        	propertyEditor.setVisible(true);
			        } else {
			        	propertyEditor.toFront();
			        }
				} else if (action.equals("Threads")) {
					if (threadDialog == null) {
						Frame f = new Frame();
						threadDialog = new ThreadDialog(f);
					}
			        if (!threadDialog.isVisible()) {
			        	threadDialog.setVisible(true);
			        } else {
			        	threadDialog.toFront();
			        }
				} else {
					System.err.println("unknown command : "+ action);
				}
						
			}
		};

	    clear.addActionListener(listener);
	    close.addActionListener(listener);
	    performGC.addActionListener(listener);
	    memory.addActionListener(listener);
	    showPpropertyEditor.addActionListener(listener);
	    showThreads.addActionListener(listener);

	    Panel buttonPanel = new Panel();
	    buttonPanel.setLayout(new GridLayout(2, 0));
	    buttonPanel.add(performGC);
	    buttonPanel.add(memory);
	    buttonPanel.add(showPpropertyEditor);
	    buttonPanel.add(showThreads);
	    buttonPanel.add(clear);
	    buttonPanel.add(close);
	    

	    setLayout(new BorderLayout());
	    add("Center", aTextArea);
	    add("South", buttonPanel);
	    pack();
	}

	public void clear()	{
		aTextArea.setText("");
		Console.aOutput = "";
	}

	public void append(String text) {
		if (isVisible()) {
			aTextArea.append(text);
		}
	}

	public void setText(String text) {
		if (isVisible()) {
			aTextArea.setText(text);
			aTextArea.select(text.length(), text.length());
		}
	}
}

/*
class ConsoleEvent extends java.awt.AWTEvent 
        implements  java.awt.peer.ActiveEvent, 
                    java.awt.ActiveEvent 
{
	byte b[];
	int off;
	int len;
	ConsoleStream consoleStream;

	ConsoleEvent(ConsoleStream consoleStream, byte[] b, int off, int len ) {
		super(b, off);

		this.consoleStream = consoleStream;
		this.b = b;
		this.off = off;
		this.len = len;
	}

	public void dispatch() {
    	String aAppend;
    	boolean bAppend = true;

		synchronized( Console.class ) {
			bAppend = true;

		    if ( Console.pErrStm == consoleStream ) {
		        Console.pSystemErr.write( b, off, len );
		    } else
		    if ( Console.pOutStm == consoleStream ) {
		        Console.pSystemOut.write( b, off, len );
		    }

		    aAppend = new String( b, off, len );

			int nOutputLen = Console.aOutput.length();

            if ( nOutputLen + len > 5000 ) {
            	bAppend = false;
				int nCutPos = nOutputLen - (4000 - len);
				//nach line feed suchen
				int nLFPos = Console.aOutput.indexOf('\n', nCutPos);
				//nach carriage return suchen
				int nCRPos = Console.aOutput.indexOf('\r', nCutPos);

				if ((nLFPos > -1) && (nCRPos == -1)) {
					// line feed gefunden; kein carriage return
					nCutPos = nLFPos;
				} else if ((nLFPos == -1) && (nCRPos > -1)) {
					// carriage return gefunden; kein line feed
					nCutPos = nCRPos;
				} else if ((nLFPos > -1) && (nCRPos > -1)) {
					// carriage return & line feed gefunden
					nCutPos = (nLFPos < nCRPos)? nLFPos: nCRPos;
				} else {
					// kein carriage return; kein line feed gefunden
					// ermittelte Cut-Position (4000 Zeichen beibehalten
				}

				if ( nCutPos > 0 ) {
					Console.aOutput = Console.aOutput.substring( nCutPos );
				} else {
					Console.aOutput = new String();
				}
			}
			Console.aOutput = Console.aOutput + aAppend;
		}
		if (Console.pDialog != null) {
			if (bAppend) {
				Console.pDialog.append(aAppend);
			} else {
				Console.pDialog.setText(Console.aOutput);
			}
		}

	}
}
*/

class ConsoleStream extends OutputStream
{
    synchronized public void write( int value )	{
	    byte [] aTmp = new byte[1];
	    aTmp[0] = (byte)value;
	    write( aTmp, 0, 1 );
	}

    public void write( byte[] b, int off, int len ) {
		// byte bytes[] = new byte[b.length];
		// System.arraycopy(b, 0, bytes, 0, bytes.length);
		// java.awt.Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new ConsoleEvent(this, bytes, off, len));
		
		String aAppend;
    	boolean bAppend = true;

		synchronized( Console.class ) {
			bAppend = true;

		    if ( Console.pErrStm == this ) {
		        Console.pSystemErr.write( b, off, len );
		    } else
		    if ( Console.pOutStm == this ) {
		        Console.pSystemOut.write( b, off, len );
		    }

		    aAppend = new String( b, off, len );

			int nOutputLen = Console.aOutput.length();

            if ( nOutputLen + len > 5000 ) {
            	bAppend = false;
				int nCutPos = nOutputLen - (4000 - len);
				//nach line feed suchen
				int nLFPos = Console.aOutput.indexOf('\n', nCutPos);
				//nach carriage return suchen
				int nCRPos = Console.aOutput.indexOf('\r', nCutPos);

				if ((nLFPos > -1) && (nCRPos == -1)) {
					// line feed gefunden; kein carriage return
					nCutPos = nLFPos;
				} else if ((nLFPos == -1) && (nCRPos > -1)) {
					// carriage return gefunden; kein line feed
					nCutPos = nCRPos;
				} else if ((nLFPos > -1) && (nCRPos > -1)) {
					// carriage return & line feed gefunden
					nCutPos = (nLFPos < nCRPos)? nLFPos: nCRPos;
				} else {
					// kein carriage return; kein line feed gefunden
					// ermittelte Cut-Position (4000 Zeichen beibehalten
				}

				if ( nCutPos > 0 ) {
					Console.aOutput = Console.aOutput.substring( nCutPos );
				} else {
					Console.aOutput = new String();
				}
			}
			Console.aOutput = Console.aOutput + aAppend;
		}
		
		if (Console.pDialog != null) {
			if (bAppend) {
				Console.pDialog.append(aAppend);
			} else {
				Console.pDialog.setText(Console.aOutput);
			}
		}
	}
}

class ThreadDialog extends java.awt.Dialog {
	private java.awt.List list;
	private Thread threadList[];
	private int selectedItem = -1;
	private	Button killBtn;
	private	Button suspendBtn;
	private	Button resumeBtn;
	private	Button closeBtn;
	private UpdaterThread updaterThread; 
	
	class UpdaterThread extends Thread {
	
		public UpdaterThread() {
			super("Thread Updater");
			setPriority(MIN_PRIORITY);
		}
	
		public void run() {
			while(true) {
				update();
				try {
					sleep(2000);
				} catch(InterruptedException e) {}
			}
		}
	
	}
	
	public ThreadDialog(Frame frame) {
		super(frame, "Threads");
		
		list = new java.awt.List(10);
		java.awt.Font font = new java.awt.Font("Courier", java.awt.Font.PLAIN, 10);
		list.setFont(font);
		
		java.awt.Label label = new java.awt.Label(" No.    Thread Name                     Thread Group              Is Alive Priority");
		label.setFont(font);
		label.setBackground(java.awt.Color.lightGray);
		
	    addWindowListener(new WindowAdapter()
			      {
				  public void windowClosing(WindowEvent e) {
					  		setVisible(false);
				      }
			      });
		
		killBtn = new Button("Kill");
		suspendBtn = new Button("Suspend");
		resumeBtn = new Button("Resume");
		closeBtn = new Button("Close");

		list.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent event) {
				selectedItem = list.getSelectedIndex();
				enableButtons(selectedItem > -1);
			}
		});
		
		ActionListener listener = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if (selectedItem > -1) {
					String action = e.getActionCommand();
					if (action.equals("Kill")) {
						threadList[selectedItem].stop();
					} else 
					if (action.equals("Suspend")) {
						threadList[selectedItem].suspend();
					} else 
					if (action.equals("Resume")) {
						threadList[selectedItem].resume();
					} else 
					if (action.equals("Close")) {
							setVisible(false);
					}
				}
			}
		};

		killBtn.addActionListener(listener);
		suspendBtn.addActionListener(listener);
		resumeBtn.addActionListener(listener);
		closeBtn.addActionListener(listener);
		
		Panel buttonPanel = new Panel(new GridLayout(2, 2));
		buttonPanel.add(suspendBtn);
		buttonPanel.add(resumeBtn);
		buttonPanel.add(killBtn);
		buttonPanel.add(closeBtn);
		
		setLayout(new BorderLayout());
		add("North", label);
		add("Center", list);
		add("South", buttonPanel);
		
		setSize(700, 500);
	}
	
	public void setVisible(boolean visible) {
		try {
			if (visible) {
				updaterThread = new UpdaterThread();
				updaterThread.start();			
			} else {
				updaterThread.stop();
				updaterThread = null;
			}
			super.setVisible(visible);
		} catch (NullPointerException e1) {}
	}
	
	private void update() {
		int count = Thread.activeCount();
		threadList = new Thread[count];
		
		count = Thread.enumerate(threadList);
		list.clear();
		
		for(int i=0; i< count; i++) {
			Thread t = threadList[i];
			
			String listItem = " "+i+". ";
			while (listItem.length()< 8) listItem += " "; 
			listItem += t.getName()+ " ";
			while (listItem.length()< 40) listItem += " "; 
			listItem += t.getThreadGroup().getName()+ " ";
			while (listItem.length()< 66) listItem += " "; 
			listItem += t.isAlive()+ " ";
			while (listItem.length()< 75) listItem += " "; 
			listItem += t.getPriority();
			
			list.add(listItem);
		}
		if((selectedItem ==-1) && (count>0)) {
			selectedItem = 0;
		}
		list.select(selectedItem);
	}
	
	private void enableButtons(boolean enable) {
		killBtn.setEnabled(enable);
		suspendBtn.setEnabled(enable);
		resumeBtn.setEnabled(enable);
	}
}


