// dlfcn.h
// dlopen() API
// requires dlcompat library (libdl.dylib)

#ifdef __cplusplus
extern "C" {
#endif

extern void	*dlopen( char *path, int mode );
extern int	dlclose( void *handle );
extern void	*dlsym( void *handle, char *symbol );
extern char	*dlerror( void );

#define RTLD_LAZY		0x0001		/* deferred function binding */
#define RTLD_NOW		0x0002		/* immediate function binding */
#define RTLD_LOCAL		0x0004		/* don't load object */
#define RTLD_GLOBAL		0x0008
#define RTLD_NOLOAD		0x0010
#define RTLD_SHARED		0x0020		/* not used, the default */
#define RTLD_UNSHARED	0x0040
#define RTLD_NODELETE	0x0080
#define RTLD_LAZY_UNDEF	0x0100

#ifdef __cplusplus
}
#endif
