/*************************************************************************
 *
 *  $RCSfile: itemprop.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: cl $ $Date: 2001/11/22 13:30:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFX_ITEMPROP_HXX
#define _SFX_ITEMPROP_HXX

#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _SFXITEMSET_HXX
#include <itemset.hxx>
#endif
//#include <uno/lbnames.h>			// CPPU_CURRENT_LANGUAGE_BINDING_NAME macro, which specify the environment type
#include <cppuhelper/implbase1.hxx>
//#include <com/sun/star/uno/Type.hxx>	// helper for implementations
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HPP_
#include <com/sun/star/beans/XPropertySetInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYSTATE_HPP_
#include <com/sun/star/beans/PropertyState.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_ILLEGALARGUMENTEXCEPTION_HPP_
#include <com/sun/star/lang/IllegalArgumentException.hpp>
#endif

/* -----------------------------21.02.00 11:03--------------------------------
	UNO III - Implementation
 ---------------------------------------------------------------------------*/
#define MAP_CHAR_LEN(cchar) cchar, sizeof(cchar) - 1
struct SfxItemPropertyMap
{
	const char* 						pName;
	USHORT 								nNameLen;
	USHORT								nWID;
	const com::sun::star::uno::Type*	pType;
	long								nFlags;
	BYTE								nMemberId;

	static const SfxItemPropertyMap*	GetByName( const SfxItemPropertyMap *pMap,
			const ::rtl::OUString &rName );
};
/* -----------------------------21.02.00 11:19--------------------------------

 ---------------------------------------------------------------------------*/
class SfxItemPropertySet
{
	const SfxItemPropertyMap* 	_pMap;
protected:
	virtual BOOL			FillItem(SfxItemSet& rSet, USHORT nWhich, BOOL bGetProperty) const;

public:
							SfxItemPropertySet( const SfxItemPropertyMap *pMap ) :
								_pMap(pMap) {}


	void getPropertyValue( const SfxItemPropertyMap& rMap,
											const SfxItemSet& rSet,
											com::sun::star::uno::Any& rAny) const
											throw(::com::sun::star::uno::RuntimeException);
	com::sun::star::uno::Any
		getPropertyValue( const SfxItemPropertyMap& rMap,
											const SfxItemSet& rSet ) const
											throw(::com::sun::star::uno::RuntimeException);
	void getPropertyValue( const ::rtl::OUString &rName,
											const SfxItemSet& rSet,
											com::sun::star::uno::Any& rAny) const
											throw(::com::sun::star::uno::RuntimeException,
													::com::sun::star::beans::UnknownPropertyException);
	com::sun::star::uno::Any
		getPropertyValue( const ::rtl::OUString &rName,
											const SfxItemSet& rSet ) const
											throw(::com::sun::star::uno::RuntimeException,
													::com::sun::star::beans::UnknownPropertyException);
	void					setPropertyValue( const SfxItemPropertyMap& rMap,
#if SUPD>633
											const com::sun::star::uno::Any& aVal,
#else
											const com::sun::star::uno::Any aVal,
#endif
											SfxItemSet& rSet ) const
											throw(::com::sun::star::uno::RuntimeException,
													com::sun::star::lang::IllegalArgumentException);
	void					setPropertyValue( const ::rtl::OUString& rPropertyName,
#if SUPD>633
											const com::sun::star::uno::Any& aVal,
#else
											const com::sun::star::uno::Any aVal,
#endif
											SfxItemSet& rSet ) const
											throw(::com::sun::star::uno::RuntimeException,
													com::sun::star::lang::IllegalArgumentException,
													::com::sun::star::beans::UnknownPropertyException);

	com::sun::star::beans::PropertyState
		getPropertyState(const ::rtl::OUString& rName, const SfxItemSet& rSet)
									throw(com::sun::star::beans::UnknownPropertyException);
    com::sun::star::beans::PropertyState
        getPropertyState(const SfxItemPropertyMap& rMap, const SfxItemSet& rSet)
                                    throw();

	com::sun::star::uno::Reference<com::sun::star::beans::XPropertySetInfo>
		getPropertySetInfo() const;
	const SfxItemPropertyMap*
		getPropertyMap() const {return _pMap;}

};
/* -----------------------------21.02.00 11:09--------------------------------

 ---------------------------------------------------------------------------*/
class SfxItemPropertySetInfo : public
	cppu::WeakImplHelper1<com::sun::star::beans::XPropertySetInfo>
{
	const SfxItemPropertyMap* 	_pMap;

public:
	SfxItemPropertySetInfo(const SfxItemPropertyMap *pMap ) :
								_pMap(pMap) {}

    virtual ::com::sun::star::uno::Sequence< ::com::sun::star::beans::Property > SAL_CALL
		getProperties(  )
			throw(::com::sun::star::uno::RuntimeException);

	virtual ::com::sun::star::beans::Property SAL_CALL
		getPropertyByName( const ::rtl::OUString& aName )
			throw(::com::sun::star::beans::UnknownPropertyException,
					::com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL
		hasPropertyByName( const ::rtl::OUString& Name )
			throw(::com::sun::star::uno::RuntimeException);

	const SfxItemPropertyMap* getMap() const { return _pMap; }
};
/* -----------------------------21.02.00 12:01--------------------------------

 ---------------------------------------------------------------------------*/
class SfxExtItemPropertySetInfo: public cppu::WeakImplHelper1<com::sun::star::beans::XPropertySetInfo >
{
	const SfxItemPropertyMap* 											_pExtMap;
	com::sun::star::uno::Sequence<com::sun::star::beans::Property>		aPropertySeq;
public:
							SfxExtItemPropertySetInfo(
								const SfxItemPropertyMap *pMap,
								const com::sun::star::uno::Sequence<com::sun::star::beans::Property>& rPropSeq );

    virtual ::com::sun::star::uno::Sequence< ::com::sun::star::beans::Property > SAL_CALL
		getProperties(  )
			throw(::com::sun::star::uno::RuntimeException);

	virtual ::com::sun::star::beans::Property SAL_CALL
		getPropertyByName( const ::rtl::OUString& aName )
			throw(::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL
		hasPropertyByName( const ::rtl::OUString& Name )
			throw(::com::sun::star::uno::RuntimeException);
};

#endif
