/*************************************************************************
 *
 *  $RCSfile: args.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: er $ $Date: 2001/05/13 03:25:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <sbx.hxx>
#include "args.hxx"

// STATIC DATA -----------------------------------------------------------

//------------------------------------------------------------------------

SfxArguments::SfxArguments( BOOL bCreateArray ):
	aArrayRef(bCreateArray ? new SbxArray : 0 ),
	nFrom(0), nCount(0)
{
}

//------------------------------------------------------------------------

SfxArguments::SfxArguments( SbxArray *pArray, USHORT nFromIdx, USHORT nIdxCount ):
	aArrayRef(pArray),
	nFrom(nFromIdx), nCount(nIdxCount)
{
}

//------------------------------------------------------------------------

SfxArguments::~SfxArguments()
{
}

//------------------------------------------------------------------------

void SfxArguments::Append( SbxVariable* pArg )
{
	DBG_ASSERT( aArrayRef.Is(), "SfxArguments::Append() not overloaded" );

	if ( pArg->ISA(SbxObject) )
	{
		// Objekte indirekt reinsetzen
		SbxVariableRef xVar = new SbxVariable;
		xVar->PutObject( pArg );
		aArrayRef->Put( xVar, aArrayRef->Count() );
	}
	else
		// alles andere direkt reinsetzen
		aArrayRef->Put( pArg, aArrayRef->Count() );

	++nCount;
}

//------------------------------------------------------------------------


void SfxArguments::AppendEmpty( )
{
	SbxVariableRef pVar = new SbxVariable;
	Append( pVar );
}

//------------------------------------------------------------------------

void SfxArguments::AppendInteger( INT16 nArg )
{
	SbxVariableRef pVar = new SbxVariable;
	pVar->PutInteger( nArg );
	Append( pVar );
}

//------------------------------------------------------------------------

void SfxArguments::AppendLong( INT32 nArg )
{
	SbxVariableRef pVar = new SbxVariable;
	pVar->PutLong( nArg );
	Append( pVar );
}

//------------------------------------------------------------------------

void SfxArguments::AppendSingle( float nArg )
{
	SbxVariableRef pVar = new SbxVariable;
	pVar->PutSingle( nArg );
	Append( pVar );
}

//------------------------------------------------------------------------

void SfxArguments::AppendDouble( double nArg )
{
	SbxVariableRef pVar = new SbxVariable;
	pVar->PutDouble( nArg );
	Append( pVar );
}

//------------------------------------------------------------------------

void SfxArguments::AppendBool( BOOL nArg )
{
	SbxVariableRef pVar = new SbxVariable;
	pVar->PutBool( nArg );
	Append( pVar );
}

//------------------------------------------------------------------------

void SfxArguments::AppendString( const String& rArg )
{
	SbxVariableRef pVar = new SbxVariable;
	pVar->PutString( rArg );
	Append( pVar );
}

//------------------------------------------------------------------------

void SfxArguments::AppendEnum( INT16 nVal )
{
	AppendInteger( nVal );
}

//------------------------------------------------------------------------

USHORT SfxArguments::Count() const
{
	if ( nFrom >= aArrayRef->Count() )
		return 0;
	return Min( nCount, (USHORT)(aArrayRef->Count() - nFrom) );
}

//------------------------------------------------------------------------

const SbxVariable& SfxArguments::Get
(
	USHORT nNo	// Nummer des Parameters beginnend mit 0
) 	const

/*	[Beschreibung]

	Liefert den Parameter an der Position 'nNo', wobei die Numerierung
	mit 0 beginnt. Zugriff auf nicht verf"ugbare Parameter ist nicht
	definiert.
*/

{
	DBG_ASSERT( nNo < Count(), "argument index overflow" );
	return *aArrayRef->Get( nFrom + nNo );
}

