/*************************************************************************
 *
 *  $RCSfile: svtoxstr.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2001/10/12 15:50:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
// 

#ifndef _SMART_COM_SUN_STAR_IO_XCONNECTABLE_HXX_
#include <smart/com/sun/star/io/XConnectable.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XOUTPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XOutputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XDATAOUTPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XDataOutputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XACTIVEDATACONTROL_HXX_
#include <smart/com/sun/star/io/XActiveDataControl.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XDATAINPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XDataInputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XMARKABLESTREAM_HXX_
#include <smart/com/sun/star/io/XMarkableStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XINPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XInputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XSTREAMLISTENER_HXX_
#include <smart/com/sun/star/io/XStreamListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XACTIVEDATASINK_HXX_
#include <smart/com/sun/star/io/XActiveDataSink.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XACTIVEDATASOURCE_HXX_
#include <smart/com/sun/star/io/XActiveDataSource.hxx>
#endif

#ifndef _STREAM_HXX //autogen wg. SvStream
#include <tools/stream.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX //autogen wg. DBG_ASSERT
#include <tools/debug.hxx>
#endif

#include <svtoxstr.hxx>

#include <algorithm>

#define QUERYIFACE( x ) 						\
if( aUik == x::getSmartUik() ) 					\
{												\
	rOut = (x*)this;							\
	return TRUE;								\
}

#define QUERYIFACEDONE() return UsrObject::queryInterface( aUik, rOut )
// -------------------------------- XInputStream --------------------------------

// -----------------------------------------------------------------------------
INT32 SvToXInputStream::readBytes(Sequence< BYTE >& aData, INT32 nBytesToRead) THROWS( (NotConnectedException, BufferSizeExceededException, UsrSystemException) )
{
	// POST: Read nBytes
	DBG_ASSERT(nBytesToRead >= 0, "nBytesToRead must be gt -1");
	INT32 nAvailable = available();
	if (nAvailable == 0) return 0;

	INT32 nCount = std::min(nBytesToRead, nAvailable);
	if (nCount != aData.getLen())
		aData.realloc(nCount);

	BYTE *pBuffer = (BYTE*)aData.getArray();
	return _aStream.Read(pBuffer, nCount);
}
// -----------------------------------------------------------------------------
INT32 SvToXInputStream::readSomeBytes(Sequence< BYTE >& aData, INT32 nMaxBytesToRead) THROWS( (NotConnectedException, BufferSizeExceededException, UsrSystemException) )
{
	// POST: read at least 1 Byte
	return readBytes(aData, nMaxBytesToRead);
}
// -----------------------------------------------------------------------------
void  SvToXInputStream::skipBytes(INT32 nBytesToSkip) THROWS( (NotConnectedException, BufferSizeExceededException, UsrSystemException) )              
{
	// POST: skip nBytes
	Sequence<BYTE> aTmp(nBytesToSkip);
	_aStream.Read(&aTmp, nBytesToSkip);
}
// -----------------------------------------------------------------------------
INT32 SvToXInputStream::available(void) THROWS( (NotConnectedException, UsrSystemException) )
{
	// POST: how many bytes can read/skip without blocking
	INT32 nPos = _aStream.Tell();
	_aStream.Seek(STREAM_SEEK_TO_END);
	INT32 nBytesToRead = _aStream.Tell() - nPos;
	_aStream.Seek(nPos);
	return nBytesToRead;
}
// -----------------------------------------------------------------------------
void  SvToXInputStream::closeInput(void) THROWS( (NotConnectedException, UsrSystemException) )
{
	// POST: close Stream
	//_aStream.Close();
}
// -----------------------------------------------------------------------------
// -------------------------------- UNO Geraffel --------------------------------
BOOL SvToXInputStream::queryInterface( UsrUik aUik, XInterfaceRef& rOut )
{
	QUERYIFACE( XInputStream );
	QUERYIFACEDONE();
}
// -----------------------------------------------------------------------------
const XIdlClassRef& SvToXInputStream::staticGetIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		"SvToXInputStream", UsrObject::getUsrObjectIdlClass(), 1,
		XInputStream_getReflection());
	return xClass;
}

// ------------------------------- XOutputStream -------------------------------

// -----------------------------------------------------------------------------
void SvToXOutputStream::flush(void) THROWS( (NotConnectedException, BufferSizeExceededException, UsrSystemException) )
{
	_aStream.Flush();
}

// -----------------------------------------------------------------------------
void SvToXOutputStream::writeBytes(const Sequence< BYTE >& aData) THROWS( (NotConnectedException, BufferSizeExceededException, UsrSystemException) )
{
	Sequence<BYTE> *pData = (Sequence<BYTE>*)&aData;
	BYTE* pBuffer = (BYTE *)pData->getArray();
	INT32 nLen = aData.getLen();
	_aStream.Write(pBuffer, nLen);
}

// -----------------------------------------------------------------------------
void SvToXOutputStream::closeOutput(void) THROWS( (NotConnectedException, BufferSizeExceededException, UsrSystemException) )
{
	//_aStream.Close();
}
// -----------------------------------------------------------------------------
BOOL SvToXOutputStream::queryInterface( UsrUik aUik, XInterfaceRef& rOut )
{
	QUERYIFACE( XInputStream );
	QUERYIFACEDONE();
}
// -----------------------------------------------------------------------------
const XIdlClassRef& SvToXOutputStream::staticGetIdlClass()
{
	static XIdlClassRef xClass = createStandardClass(
		"SvToXOutputStream", UsrObject::getUsrObjectIdlClass(), 1,
		XInputStream_getReflection());
	return xClass;
}
#undef QUERYIFACE
#undef QUERYIFACEDONE

