/*************************************************************************
 *
 *  $RCSfile: numfmtsh.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: dr $ $Date: 2002/07/23 10:47:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_NUMFMTSH_HXX
#define _SVX_NUMFMTSH_HXX

// include ---------------------------------------------------------------

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _LANG_HXX //autogen
#include <tools/lang.hxx>
#endif

#ifndef	_SVSTDARR_ULONGS
#define _SVSTDARR_ULONGS
#endif
#ifndef	_SVSTDARR_USHORTS
#define _SVSTDARR_USHORTS
#endif
#ifndef	_SVSTDARR_STRINGS
#define _SVSTDARR_STRINGS
#endif

#include <svtools/svstdarr.hxx>

// forward ---------------------------------------------------------------

class Color;
class SvNumberFormatter;
class SvNumberFormatTable;
class SvStrings;
class SvStringsDtor;
class NfCurrencyEntry;
// enum ------------------------------------------------------------------

enum SvxNumberValueType
{
	SVX_VALUE_TYPE_UNDEFINED = 0,
	SVX_VALUE_TYPE_NUMBER,
	SVX_VALUE_TYPE_STRING
};

// define ----------------------------------------------------------------

#define CAT_ALL				0	// Reihenfolge der Kategorie-
#define CAT_USERDEFINED		1	// ListBox-Eintraege in der TabPage
#define CAT_NUMBER			2
#define CAT_PERCENT			3
#define CAT_CURRENCY		4
#define CAT_DATE			5
#define CAT_TIME			6
#define CAT_SCIENTIFIC		7
#define CAT_FRACTION		8
#define CAT_BOOLEAN			9
#define CAT_TEXT			10

#define SELPOS_NONE			-1

#define NUMBERFORMAT_ENTRY_NEW_CURRENCY		NUMBERFORMAT_ENTRY_NOT_FOUND-1

typedef NfCurrencyEntry* NfShCurrencyEntryPtr;
SV_DECL_PTRARR( NfShCurrencyEntries, NfShCurrencyEntryPtr, 8, 1 );


class SvxDelStrgs: public SvStrings
{

public:
		~SvxDelStrgs() { DeleteAndDestroy(0,Count());}

};

// class SvxNumberFormatShell --------------------------------------------

class SvxNumberFormatShell
{
public:
						SvxNumberFormatShell( SvNumberFormatter* pNumFormatter,
											  ULONG              nFormatKey,
											  SvxNumberValueType eNumValType,
											  const String&		 rNumStr );

						SvxNumberFormatShell( SvNumberFormatter* pNumFormatter,
											  ULONG				 nFormatKey,
											  SvxNumberValueType eNumValType,
											  double			 nNumVal,
											  const String*		 pNumStr = NULL );

						~SvxNumberFormatShell();


	static SvxNumberFormatShell*	Create( SvNumberFormatter* pNumFormatter,
											  ULONG              nFormatKey,
											  SvxNumberValueType eNumValType,
											  const String&		 rNumStr );

	static SvxNumberFormatShell*	Create( SvNumberFormatter* pNumFormatter,
											  ULONG				 nFormatKey,
											  SvxNumberValueType eNumValType,
											  double			 nNumVal,
											  const String*		 pNumStr = NULL );


	void				GetInitSettings( USHORT&       nCatLbPos,
										LanguageType& rLangType,
										 USHORT&       nFmtLbSelPos,
										 SvStrings&    rFmtEntries,
										 String&	   rPrevString,
                                         Color*&       rpPrevColor );

	void				CategoryChanged( USHORT     nCatLbPos,
										short&     rFmtSelPos,
										 SvStrings& rFmtEntries );

	void				LanguageChanged( LanguageType eLangType,
										 short&       rFmtSelPos,
										 SvStrings&   rFmtEntries );

	void				FormatChanged( USHORT  nFmtLbPos,
									   String& rPreviewStr,
                                       Color*& rpFontColor );

	BOOL				AddFormat( String&    rFormat,
								   ULONG&     rErrPos,
								   USHORT&    rCatLbSelPos,
								   short&     rFmtSelPos,
								   SvStrings& rFmtEntries );

	BOOL				RemoveFormat( const String&	rFormat,
									  USHORT&       rCatLbSelPos,
									  short&        rFmtSelPos,
									  SvStrings&    rFmtEntries );

	void				MakeFormat( String& rFormat,
									BOOL    bThousand,
									BOOL    bNegRed,
									USHORT  nPrecision,
									USHORT  nLeadingZeroes,
									USHORT  nCurrencyEntryPos);

	void				GetOptions( const String& rFormat,
									BOOL&         rThousand,
									BOOL&         rNegRed,
									USHORT&       rPrecision,
									USHORT&       rLeadingZeroes,
									USHORT&       rCatLbPos );

	void				MakePreviewString( const String& rFormatStr,
										   String&       rPreviewStr,
                                           Color*&       rpFontColor );

	void				MakePrevStringFromVal( const String& rFormatStr,		//@ 19.09.97
												String&	rPreviewStr,
                                                Color*& rpFontColor,
												double	nValue);

	BOOL				IsUserDefined( const String& rFmtString );
	BOOL				IsTmpCurrencyFormat( const String& rFmtString );
	BOOL				FindEntry( const String& rFmtString, ULONG* pAt = NULL );

	void				ValidateNewEntries( BOOL bValidate = TRUE ) { bUndoAddList = !bValidate; }
	ULONG				GetUpdateDataCount() const;
	void				GetUpdateData( ULONG* pDelArray, const ULONG nSize );

	void				SetCurNumFmtKey( ULONG nNew )		{ nCurFormatKey = nNew; }
	void				SetCurLanguage( LanguageType eNew ) { eCurLanguage = eNew; }
	ULONG				GetCurNumFmtKey() const				{ return nCurFormatKey; }
	LanguageType		GetCurLanguage() const				{ return eCurLanguage; }

	String				GetComment4Entry(short nEntry);
	short				GetCategory4Entry(short nEntry);
	BOOL				GetUserDefined4Entry(short nEntry);
	String				GetFormat4Entry(short nEntry);
	void				SetComment4Entry(short nEntry,String aCommentString);

	BOOL				IsBankingSymbol(USHORT nPos);
	void				SetCurrencySymbol(USHORT nPos);
	ULONG				GetCurrencySymbol();
	USHORT				FindCurrencyFormat( const String& rFmtString );
	USHORT				FindCurrencyFormat(const NfCurrencyEntry* pTmpCurrencyEntry,BOOL bTmpBanking);
	NfCurrencyEntry*	GetCurCurrencyEntry();
	void				SetCurCurrencyEntry(NfCurrencyEntry*);
	short				GetListPos4Entry(ULONG nIdx);
	short				GetListPos4Entry( const String& rFmtString );

	void				GetCurrencySymbols(SvStringsDtor& rList,const XubString& rStrEurope,USHORT* pPos);
	void				GetCurrencySymbols(SvStringsDtor& rList,const XubString& rStrEurope, BOOL bFlag);

	USHORT				FindCurrencyTableEntry( const String& rFmtString, BOOL &bTestBanking );
	BOOL				IsInTable(USHORT nPos,BOOL bTmpBanking,const String &rFmtString);

	void				GetCurrencyFormats(SvStrings& rList);

private:
	static const double 	DEFAULT_NUMVALUE;	// 123456789

	SvNumberFormatter*		pFormatter;
	SvNumberFormatTable*	pCurFmtTable;
	SvxNumberValueType		eValType;
	String					aValStr;
	double					nValNum;
	BOOL					bUndoAddList;
	SvULongs				aAddList;
	SvULongs				aDelList;
	SvULongs				aCurEntryList;
	ULONG					nInitFormatKey;
	ULONG					nCurFormatKey;
	short					nCurCategory;
	LanguageType			eCurLanguage;
	SvUShorts				aCurCurrencyList;
	NfCurrencyEntry*		pCurCurrencyEntry;
	BOOL					bBankingSymbol;
	USHORT					nCurCurrencyEntryPos;
	SvStrings				aCurrencyFormatList;

#ifdef _SVX_NUMFMTSH_CXX
	short					FillEntryList_Impl( SvStrings& rList );
	void					FillEListWithStd_Impl( SvStrings& rList,USHORT aPrivCat, short &Pos);
	short					FillEListWithFormats_Impl( SvStrings& rList,short nSelPos,
													   NfIndexTableOffset eOffsetStart,
													   NfIndexTableOffset eOffsetEnd);

	short					FillEListWithDateTime_Impl( SvStrings& rList,short nSelPos);

	short					FillEListWithCurrency_Impl( SvStrings& rList,short nSelPos);
	short					FillEListWithSysCurrencys( SvStrings& rList,short nSelPos);
	short					FillEListWithUserCurrencys( SvStrings& rList,short nSelPos);

	short					FillEListWithUsD_Impl( SvStrings& rList, sal_uInt16 nPrivCat, short Pos );
	BOOL					IsRemoved_Impl( ULONG nKey );
	BOOL					IsAdded_Impl( ULONG nKey );
	void					GetPreviewString_Impl( String& rString,
                                                   Color*& rpColor );
	void					PosToCategory_Impl( USHORT nPos, short& rCategory );
	void					CategoryToPos_Impl( short nCategory, USHORT& rPos );
#endif
};


#endif

