/*************************************************************************
 *
 *  $RCSfile: svdio.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: sj $ $Date: 2001/05/22 10:12:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <tools/debug.hxx>

#include "svdio.hxx"
#include "svdobj.hxx"

////////////////////////////////////////////////////////////////////////////////////////////////////


SdrIOHeader::SdrIOHeader(SvStream& rNewStream, UINT16 nNewMode, const char cID[2], 
	BOOL bAutoOpen)
:	rStream(rNewStream)
{
	nFilePos = 0;
	nMode = nNewMode;
	bOpen = FALSE;
	bClosed = FALSE;
	bLookAhead = FALSE;
	SetID(cID);
	nVersion = nAktSdrFileVersion;
	nBlkSize = 0;
	SetMagic();

	if(bAutoOpen) 
	{
		OpenRecord();
	}
}

SdrIOHeader::~SdrIOHeader()
{
	if(bOpen && !bClosed && !bLookAhead) 
		CloseRecord();
}

void SdrIOHeader::OpenRecord()
{
	if(rStream.GetError()) 
		return;
	
	DBG_ASSERT(!bClosed,"SdrIOHeader::OpenRecord(): Record ist bereits geschlossen.");
	DBG_ASSERT(!bOpen,"SdrIOHeader::OpenRecord(): Record ist bereits geoeffnet.");
	
	// Fileposition des Records merken
	nFilePos = rStream.Tell(); 

	if(nMode==STREAM_READ) 
	{
		// RecordHeader lesen
		Read(); 
	} 
	else if(nMode == STREAM_WRITE) 
	{
		// Platz fuer RecordHeader schaffen
		Write();   
	} 
	else 
		DBG_ERROR("SdrIOHeader::OpenRecord(): Falscher StreamMode angegeben.");
	
	bOpen = TRUE;
	
	// Endemarke wird sofort geschlossen.
	if(IsEnde() && !bLookAhead) 
		CloseRecord(); 

	if(bLookAhead) 
		rStream.Seek(nFilePos);
}

void SdrIOHeader::CloseRecord()
{
	if(rStream.GetError()) 
		return;

	if(bLookAhead) 
	{
		rStream.Seek(nFilePos);
		DBG_ERROR("SdrIOHeader::CloseRecord(): CloseRecord im Modus LookAhead.");
		return;
	}
	
	DBG_ASSERT(!bClosed,"SdrIOHeader::CloseRecord(): Record ist bereits geschlossen.");
	DBG_ASSERT(bOpen || bClosed,"SdrIOHeader::CloseRecord(): Record ist noch nicht geoeffnet.");
	
	UINT32 nAktPos(rStream.Tell());
	
	if(nMode == STREAM_READ) 
	{
		UINT32 nReadAnz(nAktPos - nFilePos);

#ifdef DBG_UTIL
		ImpCheckRecordIntegrity();
#endif

		if(nReadAnz != nBlkSize) 
		{
			// FilePos korregieren
			rStream.Seek(nFilePos + nBlkSize); 
		}
	} 
	else if(nMode == STREAM_WRITE) 
	{
		// Groesse dieses Records (inkl. der Header)
		nBlkSize = nAktPos - nFilePos;     
		// an den Anfang des Records
		rStream.Seek(nFilePos);        
		// Header rausschreiben.
		Write();                       
		// und die FilePos restaurieren.
		rStream.Seek(nAktPos);         

#ifdef DBG_UTIL
		ImpCheckRecordIntegrity();
#endif
	} 
	else 
		DBG_ERROR("SdrIOHeader::CloseRecord(): Falscher StreamMode angegeben.");
	
	bOpen = FALSE;
	bClosed = TRUE;
}

void SdrIOHeader::Write()
{
#ifdef __BIGENDIAN
	nVersion=SWAPSHORT(nVersion);
	nBlkSize=SWAPLONG (nBlkSize);
#endif

	rStream.Write(cMagic, 4);

	if(!IsEnde()) 
	{
		rStream.Write((char*)&nVersion, 2);
		rStream.Write((char*)&nBlkSize, 4);
	}

#ifdef __BIGENDIAN
	nVersion=SWAPSHORT(nVersion);
	nBlkSize=SWAPLONG (nBlkSize);
#endif
}


void SdrIOHeader::Read()
{
	rStream.Read(cMagic, 4);

	if(!IsEnde()) 
	{
		rStream.Read((char*)&nVersion, 2);
		rStream.Read((char*)&nBlkSize, 4);

#ifdef __BIGENDIAN
		nVersion=SWAPSHORT(nVersion);
		nBlkSize=SWAPLONG (nBlkSize);
#endif
	} 
	else 
	{
		nBlkSize = 4;
	}
}

UINT32 SdrIOHeader::GetBytesLeft() const
{
	if(nMode == STREAM_READ) 
	{
		UINT32 nAktPos(rStream.Tell());
		UINT32 nReadAnz(nAktPos - nFilePos);
		
		if(nReadAnz <= nBlkSize) 
			return nBlkSize - nReadAnz;
		else 
			// Fehler, zuviel gelesen!
			return 0; 
	} 
	else 
		return 0;
}

#ifdef DBG_UTIL

void SdrIOHeader::ImpGetRecordName(ByteString& rStr, INT32 nSubRecCount, 
	INT32 nSubRecReadCount) const
{
	rStr = "CheckRecordIntegrity (ID=";
	rStr += cMagic[0];
	rStr += cMagic[1];
	rStr += cHdrID[0];
	rStr += cHdrID[1];
	rStr += ')';
	
	if(nSubRecCount != -1) 
	{
		rStr += " (";
		
		if(nSubRecReadCount != -1) 
		{
			rStr += ByteString::CreateFromInt32( nSubRecReadCount );
			rStr += " von ";
			rStr += ByteString::CreateFromInt32( nSubRecCount );
			rStr += " Records gelesen)";
		} 
		else 
		{
			rStr += ByteString::CreateFromInt32( nSubRecCount );
			rStr += " Records)";
		}
	}
}

BOOL SdrIOHeader::ImpHasSubRecords() const
{
	// nicht jeder Record hat SubRecords
	return IsID(SdrIOModlID) || 
		   IsID(SdrIOPageID) ||
		   IsID(SdrIOMaPgID) ||
		   IsID(SdrIODObjID);
}

// Testet die Integritaet eines Records. Innerhalb eines Records
// muessen alle Daten in Subrecords (SdrDownCompat) untergebracht sein.

void SdrIOHeader::ImpCheckRecordIntegrity()
{
	UINT32 nFilePos0(rStream.Tell());
	
	if(IsMagic() && ImpHasSubRecords()) 
	{ 
		// nicht jeder Record hat SubRecords
		// Seek an den Recordanfang
		rStream.Seek(nFilePos); 
		Read();

		// Anzahl der vorhandenen SubRecords
		UINT32 nHasSubRecCount(0);  
		// Anzahl der SubRecords bis nFilePos0
		UINT32 nReadSubRecCount(0); 
		UINT32 nAktFilePos(rStream.Tell());
		BOOL bFilePos0Hit(nAktFilePos == nFilePos0);
		
		while(!rStream.GetError() && !rStream.IsEof() && nAktFilePos < nFilePos + nBlkSize) 
		{
			UINT32 nSubRecSiz;

			nHasSubRecCount++;
			rStream >> nSubRecSiz;
			nAktFilePos += nSubRecSiz;
			rStream.Seek(nAktFilePos);

			if(nAktFilePos <= nFilePos0) 
				nReadSubRecCount++;

			if(nAktFilePos == nFilePos0) 
				// Aha, nFilePos0 ist ok.
				bFilePos0Hit = TRUE; 
		}
	
		ByteString aStr;
		
		if(nAktFilePos != nFilePos+nBlkSize) 
			aStr += "- SubRecord-Strukturfehler.\n";

		if(nFilePos0 > nAktFilePos) 
		{
			UINT32 nToMuch(nFilePos0 - nAktFilePos);

			aStr += "- ";

			if(nToMuch == 1) 
				aStr += "1 Byte";
			else 
			{
				aStr += ByteString::CreateFromInt32( nToMuch );
				aStr += " Bytes";
			}

			aStr += " zuviel gelesen.\n";
		}

		if(!bFilePos0Hit) 
			aStr += "- Aktuelle Fileposition liegt nicht am Ende eines SubRecords.\n";

		if(aStr.Len()) 
		{
			ByteString aStr2;

			aStr.Insert(":\n", 0);
			ImpGetRecordName(aStr2, nHasSubRecCount, nReadSubRecCount);
			aStr.Insert(aStr2, 0);
			DBG_ERROR(aStr.GetBuffer());
		}
	} 
	else 
	{ 
		// keine SubRecords vorhanden, also nur FilePos pruefen
		if(nFilePos0 > nFilePos + nBlkSize) 
		{
			ByteString aStr;
			UINT32 nToMuch(nFilePos0 - nFilePos+nBlkSize);
			
			ImpGetRecordName(aStr);
			aStr += ":\nAus dem Record wurde";
			
			if(nToMuch == 1) 
				aStr += "1 Byte";
			else 
			{
				aStr += "n ";
				aStr += ByteString::CreateFromInt32( nToMuch );
				aStr += " Bytes";
			}

			aStr += " zuviel gelesen. FilePos wird korregiert";

			DBG_ERROR(aStr.GetBuffer());
		}
	}

	// Fileposition restaurieren
	rStream.Seek(nFilePos0); 
}
#endif

SdrIOHeaderLookAhead::SdrIOHeaderLookAhead(SvStream& rNewStream, BOOL bAutoOpen)
:	SdrIOHeader(rNewStream, STREAM_READ, SdrIOEndeID, FALSE)
{
	bLookAhead = TRUE;
	
	if(bAutoOpen) 
	{
		OpenRecord();
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

SdrObjIOHeader::SdrObjIOHeader(SvStream& rNewStream, UINT16 nNewMode, 
	const SdrObject* pNewObj, BOOL bAutoOpen)
:	SdrIOHeader(rNewStream, nNewMode, SdrIODObjID, FALSE), 
	pObj(pNewObj)
{
	if(pNewObj) 
	{
		nInventor = pNewObj->GetObjInventor();
		nIdentifier = pNewObj->GetObjIdentifier();
	} 
	else 
	{
		nInventor = 0;
		nIdentifier = 0;
	}

	if(bAutoOpen) 
	{
		OpenRecord();
	}
}

SdrObjIOHeader::~SdrObjIOHeader()
{
	if(bOpen && !bClosed && !bLookAhead) 
		CloseRecord();
}

void SdrObjIOHeader::Write()
{
	SdrIOHeader::Write();

	if(!IsEnde()) 
	{
#ifdef __BIGENDIAN
		nInventor = SWAPLONG(nInventor);
		nIdentifier = SWAPSHORT(nIdentifier);
#endif
		rStream.Write((char*)&nInventor, 4);
		rStream.Write((char*)&nIdentifier, 2);
#ifdef __BIGENDIAN
		nInventor = SWAPLONG(nInventor);
		nIdentifier = SWAPSHORT(nIdentifier);
#endif
	}
}

void SdrObjIOHeader::Read()
{
	SdrIOHeader::Read();

	if(!IsEnde()) 
	{
		rStream.Read((char*)&nInventor, 4);
		rStream.Read((char*)&nIdentifier, 2);
#ifdef __BIGENDIAN
		nInventor = SWAPLONG(nInventor);
		nIdentifier = SWAPSHORT(nIdentifier);
#endif
	}
}

SdrObjIOHeaderLookAhead::SdrObjIOHeaderLookAhead(SvStream& rNewStream, 
	BOOL bAutoOpen)
:	SdrObjIOHeader(rNewStream, STREAM_READ, NULL, FALSE)
{
	bLookAhead = TRUE;

	if(bAutoOpen) 
	{
		OpenRecord();
	}
}

////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////

SdrDownCompat::SdrDownCompat(SvStream& rNewStream, UINT16 nNewMode, BOOL bAutoOpen)
:	rStream(rNewStream), 
	nSubRecSiz(0), 
	nSubRecPos(0), 
	nMode(nNewMode),
	bOpen(FALSE), 
	bClosed(FALSE), 
	pRecId(NULL)
{
	if(bAutoOpen) 
		OpenSubRecord();
}

SdrDownCompat::~SdrDownCompat()
{
	if(!bClosed)
		CloseSubRecord();
}

void SdrDownCompat::Read()
{
	// Subrecordgroesse auslesen
	rStream >> nSubRecSiz;   
}

void SdrDownCompat::Write()
{
	// Platz fuer Groessenangabe schaffen
	rStream << nSubRecSiz;   
}

void SdrDownCompat::OpenSubRecord()
{
	if(rStream.GetError()) 
		return;

	DBG_ASSERT(!bClosed,"SdrDownCompat::OpenSubRecord(): Record ist bereits geschlossen.");
	DBG_ASSERT(!bOpen,"SdrDownCompat::OpenSubRecord(): Record ist bereits geoeffnet.");
	
	// Fileposition des Records merken
	nSubRecPos = rStream.Tell(); 

	if(nMode == STREAM_READ) 
	{
		// Subrecordgroesse auslesen
		Read();         
	} 
	else if(nMode == STREAM_WRITE) 
	{
		// Platz fuer Groessenangabe schaffen
		Write();            
	} 
	else 
		DBG_ERROR("SdrDownCompat::OpenSubRecord(): Falscher StreamMode angegeben.");

	bOpen = TRUE;
}

void SdrDownCompat::CloseSubRecord()
{
	if(rStream.GetError()) 
		return;

	DBG_ASSERT(!bClosed,"SdrDownCompat::CloseSubRecord(): Record ist bereits geschlossen.");
	DBG_ASSERT(bOpen || bClosed,"SdrDownCompat::CloseSubRecord(): Record ist noch nicht geoeffnet.");
	
	UINT32 nAktPos(rStream.Tell());
	
	if(nMode == STREAM_READ) 
	{
		UINT32 nReadAnz(nAktPos - nSubRecPos);

#ifdef DBG_UTIL
		if(nReadAnz > nSubRecSiz) 
		{
			ByteString aErrMsg("SdrDownCompat::CloseSubRecord(), ");
			
			aErrMsg += "RedordID";

			if(!pRecId) 
				aErrMsg += " unbekannt";
			else 
			{
				aErrMsg += '=';
				aErrMsg += pRecId;
			}

			aErrMsg += ":\nAus dem Record wurde";

			UINT32 nToMuch(nReadAnz - nSubRecSiz);
			
			if(nToMuch == 1) 
				aErrMsg += " 1 Byte";
			else 
			{
				aErrMsg += "n ";
				aErrMsg += ByteString::CreateFromInt32( nToMuch );
				aErrMsg += " Bytes";
			}

			aErrMsg += " zuviel gelesen, FilePos korregiert.";

			DBG_ERROR(aErrMsg.GetBuffer());
		}
#endif

		if(nReadAnz != nSubRecSiz) 
		{
			// den Rest ueberspringen
			rStream.Seek(nSubRecPos + nSubRecSiz); 
		}
	} 
	else if(nMode == STREAM_WRITE) 
	{
		// Groesse dieses SubRecords (inkl. der Groessenangabe selbst)
		nSubRecSiz = nAktPos - nSubRecPos; 

		// an den Anfang des Records
		rStream.Seek(nSubRecPos);      
		// rausschreiben.
		Write();                    
		// und die FilePos restaurieren.
		rStream.Seek(nAktPos);         
	} 
	else 
		DBG_ERROR("SdrDownCompat::CloseSubRecord(): Falscher StreamMode angegeben.");
	
	bOpen = FALSE;
	bClosed = TRUE;
}

UINT32 SdrDownCompat::GetBytesLeft() const
{
	if(nMode == STREAM_READ) 
	{
		UINT32 nAktPos(rStream.Tell());
		UINT32 nReadAnz(nAktPos - nSubRecPos);
		
		if(nReadAnz <= nSubRecSiz) 
			return nSubRecSiz - nReadAnz;
		else 
		// Fehler, zuviel gelesen!
			return 0; 
	} 
	else 
		return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

SdrNamedSubRecord::SdrNamedSubRecord(SvStream& rNewStream, UINT16 nNewMode,
	UINT32 nNewInventor, UINT16 nNewIdentifier,
	BOOL bAutoOpen)
:	SdrDownCompat(rNewStream, nNewMode, FALSE),
	nInventor(nNewInventor),
	nIdentifier(nNewIdentifier)
{
	DBG_ASSERT(nNewMode==STREAM_READ || (nNewInventor!=0xFFFF && nNewInventor!=0xFFFF),
		"SdrNamedSubRecord: bei Write muss Inventor und Identifier angegeben werden");
	
	if(bAutoOpen) 
		OpenSubRecord();
}

void SdrNamedSubRecord::Read()
{
	SdrDownCompat::Read();

	rStream.Read((char*)&nInventor, 4);
	rStream.Read((char*)&nIdentifier, 2);

#ifdef __BIGENDIAN
	nIdentifier = SWAPSHORT(nIdentifier);
	nInventor = SWAPLONG(nInventor);
#endif
}

void SdrNamedSubRecord::Write()
{
	SdrDownCompat::Write();

#ifdef __BIGENDIAN
	nIdentifier = SWAPSHORT(nIdentifier);
	nInventor = SWAPLONG(nInventor);
#endif

	rStream.Write((char*)&nInventor, 4);
	rStream.Write((char*)&nIdentifier, 2);

#ifdef __BIGENDIAN
	nIdentifier = SWAPSHORT(nIdentifier);
	nInventor = SWAPLONG(nInventor);
#endif
}

////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL SdrIsModel(SvStream& rIn)
{
	if(!rIn.GetError() && !rIn.IsEof()) 
	{
		SdrIOHeaderLookAhead aHead(rIn);
		
		if(!rIn.GetError() && aHead.IsMagic() && aHead.IsID(SdrIOModlID)) 
			return TRUE;
	}

	return FALSE;
}

BOOL SdrIsView(SvStream& rIn)
{
	if(!rIn.GetError() && !rIn.IsEof()) 
	{
		SdrIOHeaderLookAhead aHead(rIn);
	
		if(!rIn.GetError() && aHead.IsMagic() && aHead.IsID(SdrIOViewID)) 
			return TRUE;
	}

	return FALSE;
}

