/*************************************************************************
 *
 *  $RCSfile: wizmulti.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 16:03:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#include "swtypes.hxx"
#include "wizmulti.hxx"
#include "wizdoku.hxx"
#include "wizard.hrc"
#include "fldmgr.hxx"		// SwFldMgr zum Fuellen der DateListbox
#include "fldbas.hxx"



////////////////////////////////////////////////////////////////////////////////
// MultiOne
////////////////////////////////////////////////////////////////////////////////

MultiOne::MultiOne()
{
	ElemAnz = 0;
	nHelpId = 0;

	// Feste Anzahl wegen schwer findbarem Bug (GPF)
	ElemList = new WinMerkRec[ MAX_WIN_PER_STEP ];
	memset( ElemList, 0, sizeof( WinMerkRec ) * MAX_WIN_PER_STEP );

	ArrSize = MAX_WIN_PER_STEP;
}

MultiOne::~MultiOne()
{
    delete[] ElemList;
}

void MultiOne::Show()
{
	register WinMerkRec* pList = ElemList;
	for( USHORT i = ElemAnz; i; --i, ++pList )
		if( pList->bIsVisible && pList->bIsGroup )
			pList->pWin->Show();

	BOOL bFocusSet = FALSE;
	pList = ElemList;
	for( i = ElemAnz; i; --i, ++pList )
		if( pList->bIsVisible && !pList->bIsGroup )
		{
			pList->pWin->Show();
			if( !bFocusSet && pList->bGetFocus && pList->pWin->IsEnabled() &&
				( WINDOW_RADIOBUTTON != pList->pWin->GetType() ||
				((RadioButton*)pList->pWin)-> IsChecked() ))
			{
				pList->pWin->GrabFocus();
				bFocusSet = TRUE;
			}
		}
}

void MultiOne::Hide()
{
	register WinMerkRec* pList = ElemList;
	for( USHORT i = ElemAnz; i; --i, ++pList )
	{
		pList->bIsVisible = pList->pWin->IsVisible();
		pList->pWin->Hide();
	}
}

void MultiOne::AddWin( Window* pWin, BOOL bGetFocus, BOOL bGroup )
{
	if( ElemAnz < ArrSize )
	{
		// Feste Anzahl wegen schwer findbarem Bug (GPF)
		register WinMerkRec& rTmp = ElemList[ ElemAnz++ ];
		rTmp.pWin = pWin;
		rTmp.bIsVisible = TRUE; //pWin->IsVisible();
		rTmp.bIsGroup = bGroup;
		rTmp.bGetFocus = bGetFocus;
	}
}

BOOL MultiOne::SetWinShowHide( Window* pWin, BOOL bFlag )
{
	for( USHORT i = 0; i < ElemAnz; ++i )
		if( pWin == ElemList[i].pWin )
		{
			ElemList[i].bIsVisible = bFlag;
			return TRUE;
		}
	return FALSE;
}

BOOL MultiOne::FindWin(Window* pWin)
{
	if( pWin )
		for( USHORT i = 0; i < ElemAnz; ++i  )
			if( pWin == ElemList[i].pWin )
				return TRUE;

	return FALSE;
}

////////////////////////////////////////////////////////////////////////////////
// MultiDialog
////////////////////////////////////////////////////////////////////////////////

MultiDialog::MultiDialog(Window* pParent, const ResId& rResId, USHORT nAnz)
	: ModalDialog(pParent,rResId)
{
	AktStep=nAnz; // bedeutet: keiner ist aktiv;
	StepAnz=nAnz;
	WinList=NULL;
	PrevBtn=NULL;
	NextBtn=NULL;
}

MultiDialog::~MultiDialog()
{
	if( WinList )
		__DELETE( StepAnz ) WinList;
}

void MultiDialog::Init(Button* pPrev, Button* pNext)
{
	PrevBtn = pPrev;
	NextBtn = pNext;
	WinList = new MultiOne[ StepAnz ];

	for( USHORT i = 0; i < StepAnz; ++i )
		Fill( i, WinList[i] );
		//WinList[i].Hide();

	Link aLk = LINK(this,MultiDialog,MultiClickHdl);
	PrevBtn->SetClickHdl( aLk );
	NextBtn->SetClickHdl( aLk );
}

void MultiDialog::Fill(USHORT, MultiOne&) {}         	// abstract
BOOL MultiDialog::Possible(USHORT) { return FALSE; }	// abstract

BOOL MultiDialog::Step(short n, BOOL bOnlyCheck)
{
	short i=AktStep;
	if (AktStep>=StepAnz) { i=-1; n=1; } // Erster Step nach Ctor
	BOOL bPoss;
	BOOL bRange;
	BOOL bRet = FALSE;
	do {
		i += n;
		bRange = ( i >= 0 ) && ( i < short( StepAnz ) );
		bPoss = bRange && Possible(i);
	} while( !bPoss && bRange );

	if (bPoss)
	{
		bRet = TRUE;
		if( !bOnlyCheck )
			Switch(i);
	}
	return bRet;
}

IMPL_LINK_INLINE_START( MultiDialog, MultiClickHdl, Button *, pBut )
{
	if( pBut == NextBtn)
		Inc();
	else if( pBut == PrevBtn)
		Dec();
	return 0;
}
IMPL_LINK_INLINE_END( MultiDialog, MultiClickHdl, Button *, pBut )

void MultiDialog::Leave(USHORT StepNum) {} // Aufruf vor Hide
void MultiDialog::Enter(USHORT StepNum) {} // Aufruf nach Show

void MultiDialog::ShowHideWin( Window& rWin, BOOL bShow )
{
	for( USHORT i = 0; i < StepAnz; ++i )
		if( WinList[ i ].SetWinShowHide( &rWin, bShow ) )
		{
			if( i == AktStep )
			{
				if( bShow )
					rWin.Show();
				else
					rWin.Hide();
			}
			break;
		}
}


BOOL MultiDialog::FindWin(Window* pWin, USHORT& nStep)
{
	if( pWin )
		for( USHORT i = 0; i < StepAnz; ++i )
			if( WinList[i].FindWin( pWin ) )
			{
				nStep = i;
				return TRUE;
			}

	return FALSE;
}

void MultiDialog::Switch( USHORT nStepNum )
{
	if (nStepNum < StepAnz && Possible( nStepNum ) && nStepNum != AktStep)
	{
		if( AktStep < StepAnz )
		{
			Leave( AktStep );
			WinList[ AktStep ].Hide();
		}
		WinList[ nStepNum ].Show();
		Enter( nStepNum );
		AktStep = nStepNum;

		SetHelpId( WinList[ nStepNum ].GetHelpId() );

		NextBtn->Enable(!IsLast());
		PrevBtn->Enable(!IsFrst());
	}
}

////////////////////////////////////////////////////////////////////////////////
// WizardPreview
////////////////////////////////////////////////////////////////////////////////

WizardPreview::WizardPreview(Window* pParent, const ResId& rResId)
	: Window(pParent,rResId /*WB_BORDER*/)
{
	//SetPosSize(Point(6*2,6*2),Size(87*2,120*2));
	pAktPage=NULL;
	Show();
}

void WizardPreview::Paint(const Rectangle&)
{
	if (pAktPage!=NULL) pAktPage->Draw(*this);
}

void WizardPreview::SetPage(WizardPage* pPage)
{
	if (pPage!=pAktPage)
	{
		pAktPage=pPage;
		Invalidate();
	}
}

////////////////////////////////////////////////////////////////////////////////
// SwWizardDialog
////////////////////////////////////////////////////////////////////////////////

SwWizardDialog::SwWizardDialog(Window* pParent, const ResId& rResId, USHORT nAnz )
	: MultiDialog( pParent, rResId, nAnz ),
	aPrevWin( this, SW_RES(DLG_Wiz_Wind_Preview) )
{
	pTrenWin=new FixedLine   (this,SW_RES(DLG_Wiz_Wind_Trenner));
	// Ok ist damit auch der Default Button !
	pOkayBtn=new OKButton    (this,SW_RES(DLG_Wiz_OBtn_Okay   ));
	pHelpBtn=new HelpButton  (this,SW_RES(DLG_Wiz_CBtn_Help   ));
	pCnclBtn=new CancelButton(this,SW_RES(DLG_Wiz_CBtn_Cancel ));
	pPrevBtn=new PushButton  (this,SW_RES(DLG_Wiz_PBtn_Prev   ));
	pNextBtn=new PushButton  (this,SW_RES(DLG_Wiz_PBtn_Next   ));
	aMinSize=GetOutputSizePixel();
	aSize0=GetOutputSizePixel();
	pDoku = new WizardDokuDlg( this );
}

SwWizardDialog::~SwWizardDialog()
{
	delete pTrenWin;
	delete pHelpBtn;
	delete pCnclBtn;
	delete pPrevBtn;
	delete pNextBtn;
	delete pOkayBtn;

	delete pDoku;
}

void SwWizardDialog::Init()
{
	MultiDialog::Init(pPrevBtn,pNextBtn);
	Fill(0xFFFF,URElem);
}

void SwWizardDialog::FillDefElems(MultiOne& WinArr)
{
	WinArr.AddWin(&aPrevWin);
	WinArr.AddWin(pTrenWin);
	WinArr.AddWin(pHelpBtn);
	WinArr.AddWin(pCnclBtn);
	WinArr.AddWin(pPrevBtn);
	WinArr.AddWin(pNextBtn);
	WinArr.AddWin(pOkayBtn);
}

void SwWizardDialog::FillFldListBox( ListBox& rLstBox, USHORT nType )
{
	if (nType != TYP_FIXDATEFLD && nType != TYP_FIXTIMEFLD)
	{
		SwFldMgr aMgr;
		USHORT nSize = aMgr.GetFormatCount( nType, FALSE );
		rLstBox.Clear();
		for( USHORT i = 0; i < nSize; ++i )
		{
			USHORT nPos = rLstBox.InsertEntry(aMgr.GetFormatStr(nType, i));
			USHORT nFmtId = aMgr.GetFormatId( nType, i );
			rLstBox.SetEntryData( nPos, (void*)nFmtId );
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
// JBitmapButton
////////////////////////////////////////////////////////////////////////////////

JBitmapButton::JBitmapButton(Window* pParent, const ResId& rResId)
	: ImageButton(pParent,rResId)
{
}
// -----------------------------------------------------------------------------
void JBitmapButton::setBitmaps(const Bitmap& rBmp_h)
{
	SetModeImage( Image(rBmp_h) ,BMP_COLOR_HIGHCONTRAST);
	aEnabImg = GetModeImage(BMP_COLOR_NORMAL);
	aEnabImg_h = GetModeImage(BMP_COLOR_HIGHCONTRAST);
}
// -----------------------------------------------------------------------------
void JBitmapButton::Enable(BOOL bEnable)
{
	if( IsEnabled() != bEnable )
	{
		SetModeImage( bEnable ? aEnabImg : aDisbImg );
		SetModeImage( bEnable ? aEnabImg_h : aDisbImg_h ,BMP_COLOR_HIGHCONTRAST);
		ImageButton::Enable(bEnable);
	}
}

void JBitmapButton::ChangeDisbBitmap(const Bitmap& rBmp,const Bitmap& rBmp_h)
{
	aDisbImg = Image( rBmp );
	aDisbImg_h = Image( rBmp_h );
}

////////////////////////////////////////////////////////////////////////////////
// Abgekuerzte Dateinamen
////////////////////////////////////////////////////////////////////////////////

void FNam2FixedText(const String& rFNam, FixedText& rText)
{
	String aStr( rFNam );
	long nWdt = rText.GetOutputSize().Width();
	if( rText.GetTextWidth( aStr ) > nWdt)
	{
		String aStr2;
		do {
			aStr.Erase( 0, 1 );
			aStr2 = String::CreateFromAscii("...");
			aStr2 += aStr;
		} while( rText.GetTextWidth( aStr2 ) > nWdt );
		aStr = aStr2;
	}
	rText.SetText( aStr );
}


