/*************************************************************************
 *
 *  $RCSfile: dbmem.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef DBG_UTIL

#ifdef MAC
#include "mac_start.h"

#include <string.h>

#ifndef __MEMORY__
  #include <Memory.h>
#endif

#include "mac_end.h"
#endif

#include <debug.hxx>
#include <New.hxx>

// -----------------------------------------------------------------------

#if defined( WNT )
#include "memwnt.cxx"
#elif defined( WIN )
#include "memwin.cxx"
#elif defined( OS2 )
#include "memos2.cxx"
#elif defined( MAC )
#include "memmac.cxx"
#elif defined( UNX )
#include "memunx.cxx"
#endif

// -----------------------------------------------------------------------

#include <MemMgr.hxx>
#include <stdio.h>

// -----------------------------------------------------------------------

#define DBG_TEST_MEM_EXTRA  (DBG_TEST_MEM_OVERWRITE |                   \
                             DBG_TEST_MEM_OVERWRITEFREE |               \
                             DBG_TEST_MEM_POINTER |                     \
                             DBG_TEST_MEM_REPORT | DBG_TEST_MEM_TRACE)

// -----------------------------------------------------------------------

struct DbgMemBlock
{
    DbgMemBlock*    pNext;                  // Naechster TestBlock
    ULONG           nSize;                  // Groesse des Blocks
    ULONG           nSignature;             // Signature vor Block
};

// -----------------------------------------------------------------------

ULONG           nDbgCountAlloc = 0;
ULONG           nDbgCountFree = 0;
ULONG           nDbgAllAlloc = 0;
ULONG           nDbgAllFree = 0;
DbgMemBlock*    pFirstDbgBlock = NULL;

/*************************************************************************
|*
|*    DbgMemError()
|*
|*    Beschreibung      Gibt Memroy-Fehlermeldung aus
|*    Ersterstellung    TH 21.10.92
|*    Letzte Aenderung  TH 28.03.95
|*
*************************************************************************/

static void DbgMemError( int nError, void* p,
                         void* p2 = NULL, ULONG nSize = 0 )
{
    char aBuf[100];
    long n;

    switch ( nError )
    {
        case DBG_MEMERR_OVERWRITE_BEFOR:
            n =  ((long)p2) - ((long)p);
            sprintf( aBuf, "MemMgr - Write befor Block (Block: %p / Size: %lu / Offset: %ld)",
                     p, nSize, n );
            break;

        case DBG_MEMERR_OVERWRITE_BEHIND:
            n =  ((long)p2) - ((long)p);
            sprintf( aBuf, "MemMgr - Write behind Block (Block: %p / Size: %lu / Offset: %ld)",
                     p, nSize, n );
            break;

        case DBG_MEMERR_OVERWRITE_FREE:
            sprintf( aBuf, "MemMgr - Overwrite free memory: %p", p );
            break;

        case DBG_MEMERR_UNKNOWN_PTR:
            sprintf( aBuf, "MemMgr - Unknown Pointer: %p", p );
            break;
#ifdef MAC
        case DBG_MEMERR_ODD_PTR:
            sprintf( aBuf, "MemMgr - Odd Pointer: %p", p );
            break;
			
        case DBG_MEMERR_NOTINHEAP_PTR:
            sprintf( aBuf, "MemMgr - Pointer not in Heap: %p", p );
            break;
#endif
    }

    DbgError( aBuf );
}

/*************************************************************************
|*
|*    DbgImpCheckMemory()
|*
|*    Beschreibung      Testet auf Speicherueberschreiber
|*    Ersterstellung    TH 27.03.95
|*    Letzte Aenderung  TH 27.03.95
|*
*************************************************************************/

static void DbgImpCheckBound( DbgMemBlock* pBlock )
{
#ifdef WIN
    char huge*  pComp;
#else
    char*       pComp;
#endif
    char*       p;
    int         i;

    pComp = (char*)&(pBlock->nSignature);
    for ( i = 0; i < sizeof( ULONG ); i++ )
    {
        if ( *pComp != DBG_BOUND_SIGNATURE )
        {
            p = (((char*)pBlock)+sizeof( DbgMemBlock ));
            DbgMemError( DBG_MEMERR_OVERWRITE_BEFOR, p, pComp, pBlock->nSize );
            break;
        }
        pComp++;
    }

    pComp = (char*)pBlock;
    pComp += sizeof( DbgMemBlock ) + pBlock->nSize;
    for ( i = 0; i < sizeof( ULONG ); i++ )
    {
        if ( *pComp != DBG_BOUND_SIGNATURE )
        {
            p = (((char*)pBlock)+sizeof( DbgMemBlock ));
            DbgMemError( DBG_MEMERR_OVERWRITE_BEHIND, p, pComp, pBlock->nSize );
            break;
        }
        pComp++;
    }
}

/*************************************************************************
|*
|*    DbgImpCheckFreeMemory()
|*
|*    Beschreibung      Testet auf Speicherueberschreiber vom
|*                      freien Speicher
|*    Ersterstellung    TH 27.03.95
|*    Letzte Aenderung  TH 27.03.95
|*
*************************************************************************/

static void DbgImpCheckFreeMemory()
{
    FreeBlock* pBlock = GetMemData()->pFirstBlock;
    while ( pBlock )
    {
        if ( (pBlock->nSize > MEMBLOCK_SIZE) ||
             (pBlock->nSize < MEMBLOCK_MINSIZE) )
            DbgMemError( DBG_MEMERR_OVERWRITE_FREE, &(pBlock->nSize) );
        if ( pBlock->nPrev > MEMBLOCK_MAXSIZE )
            DbgMemError( DBG_MEMERR_OVERWRITE_FREE, &(pBlock->nPrev) );

        char*  p = (char*)pBlock;
        USHORT n = pBlock->nSize-sizeof(FreeBlock);
        p += sizeof( FreeBlock );
        while ( n )
        {
            // Freier Speicherblock ueberschrieben
            if ( *p != DBG_FREE_SIGNATURE )
                DbgMemError( DBG_MEMERR_OVERWRITE_FREE, p );

            p++;
            n--;
        }

        pBlock = pBlock->pNext;
    }
}

/*************************************************************************
|*
|*    DbgImpCheckMemory()
|*
|*    Beschreibung      Testet auf Speicherueberschreiber
|*    Ersterstellung    TH 27.03.95
|*    Letzte Aenderung  TH 27.03.95
|*
*************************************************************************/

void DbgImpCheckMemory( void* p = NULL )
{
    DbgData* pData = DbgGetData();

    if ( !pData )
        return;

    if ( (pData->nTestFlags & DBG_TEST_MEM_OVERWRITE) ||
         ((pData->nTestFlags & DBG_TEST_MEM_POINTER) && p) )
    {
        BOOL bFound = FALSE;
        DbgMemBlock* pBlock = (DbgMemBlock*)pFirstDbgBlock;
        while ( pBlock )
        {
            void* pTemp = (void*)(((char*)pBlock)+sizeof( DbgMemBlock ));
            if ( pTemp == p )
                bFound = TRUE;

            if ( pData->nTestFlags & DBG_TEST_MEM_OVERWRITE )
                DbgImpCheckBound( pBlock );

            pBlock = pBlock->pNext;
        }

        if ( !bFound && p )
        {
            if ( pData->nTestFlags & DBG_TEST_MEM_POINTER )
                DbgMemError( DBG_MEMERR_UNKNOWN_PTR, p );
        }
    }

    if ( pData->nTestFlags & DBG_TEST_MEM_OVERWRITEFREE )
        DbgImpCheckFreeMemory();
}

/*************************************************************************
|*
|*    DbgTraceSize()
|*
|*    Beschreibung      Zahl in String umwandeln an Buffer haengen
|*    Ersterstellung    TH 26.03.95
|*    Letzte Aenderung  TH 26.03.95
|*
*************************************************************************/

static void DbgTraceSize( char* pBuf, ULONG nSize )
{
    // Alloc-Size in String umwandeln und dranhaengen
    char   aSize[11];
    char*  pSize = &aSize[9];
    ULONG i;
    memset( aSize, 0, sizeof( aSize ) );
    do
    {
        i = nSize % 10;
        pSize--;
        *(pSize) = (char)i + 48;
        nSize /= 10;
    }
    while ( nSize );
    strcat( pBuf, pSize );
}

/*************************************************************************
|*
|*    Dbghmemset()
|*
|*    Beschreibung      Zahl in String umwandeln an Buffer haengen
|*    Ersterstellung    TH 26.03.95
|*    Letzte Aenderung  TH 26.03.95
|*
*************************************************************************/

static void Dbghmemset( void* p, BYTE n, ULONG nSize )
{
	if (!p)
		return;
		
#ifdef WIN
    char huge* pTemp = (char*)p;
    while ( nSize > 0xFFFF )
    {
        memset( pTemp, n, (size_t)0xFFFF );
        pTemp += 0xFFFF;
        nSize -= 0xFFFF;
    }
    memset( pTemp, n, (size_t)nSize );
#else
    memset( p, n, nSize );
#endif
}

/*************************************************************************
|*
|*    DbgMemAlloc()
|*
|*    Beschreibung      Speicher mit Debug-Test anfordern
|*    Ersterstellung    TH 26.03.95
|*    Letzte Aenderung  TH 26.03.95
|*
*************************************************************************/

void* DbgMemAlloc( ULONG nAlloc )
{
    DbgData*    pData = DbgGetData();
    void*       p;

    if ( pData )
    {
        if ( pData->nTestFlags & DBG_TEST_MEM_EXTRA )
        {
            if ( pData->nTestFlags & (DBG_TEST_MEM_NEWDEL | DBG_TEST_MEM_POINTER) )
                DbgImpCheckMemory();

            if ( pData->nTestFlags & DBG_TEST_MEM_TRACE )
            {
                char aDbgOutBuf[20];
                strcpy( aDbgOutBuf, "Alloc: " );
                DbgTraceSize( aDbgOutBuf, nAlloc );
                DbgTrace( aDbgOutBuf );
            }

            ULONG nSize = nAlloc + sizeof( DbgMemBlock ) + sizeof( ULONG );
            p = MemAlloc( nSize );

            if ( p )
            {
                nDbgCountAlloc++;
                nDbgAllAlloc += nAlloc;

                if ( pData->nTestFlags & DBG_TEST_MEM_INIT )
                    Dbghmemset( p, DBG_INIT_SIGNATURE, nSize );

                DbgMemBlock* pBlock = (DbgMemBlock*)p;
                p = (void*)(((char*)p)+sizeof( DbgMemBlock ));

                pBlock->pNext = pFirstDbgBlock;
                pFirstDbgBlock = pBlock;
                pBlock->nSize = nAlloc;
                memset( &(pBlock->nSignature), DBG_BOUND_SIGNATURE, sizeof( ULONG ) );
#ifdef WIN
                char huge* pTemp = (char*)p;
                pTemp += nAlloc;
                for ( int i = 0; i < sizeof( ULONG ); i++ )
                {
                    *pTemp = DBG_BOUND_SIGNATURE;
                    pTemp++;
                }
#else
                char* pTemp = (char*)p;
                pTemp += nAlloc;
                memset( pTemp, DBG_BOUND_SIGNATURE, sizeof( ULONG ) );
#endif
            }

            return p;
        }

        p = MemAlloc( nAlloc );

        if ( pData->nTestFlags & DBG_TEST_MEM_INIT )
            Dbghmemset( p, DBG_INIT_SIGNATURE, nAlloc );

        return p;
    }

    return MemAlloc( nAlloc );
}

/*************************************************************************
|*
|*    DbgMemFree()
|*
|*    Beschreibung      Speicher mit Debug-Test freigeben
|*    Ersterstellung    TH 26.03.95
|*    Letzte Aenderung  TH 26.03.95
|*
*************************************************************************/

void* DbgMemFree( void* p )
{
    DbgData* pData = DbgGetData();

    if ( pData )
    {
        if ( pData->nTestFlags & DBG_TEST_MEM_EXTRA )
        {
            if ( pData->nTestFlags & DBG_TEST_MEM_NEWDEL )
                DbgImpCheckMemory( p );

            DbgMemBlock* pPrev = NULL;
            DbgMemBlock* pTemp = pFirstDbgBlock;
            while ( pTemp )
            {
                void* pComp = (void*)(((char*)pTemp)+sizeof( DbgMemBlock ));
                if ( p == pComp )
                {
                    if ( !(pData->nTestFlags & DBG_TEST_MEM_NEWDEL) &&
                         (pData->nTestFlags & DBG_TEST_MEM_OVERWRITE) )
                        DbgImpCheckBound( pTemp );

                    if ( pPrev )
                        pPrev->pNext = pTemp->pNext;
                    else
                        pFirstDbgBlock = pTemp->pNext;
                    break;
                }

                pPrev = pTemp;
                pTemp = pTemp->pNext;
            }

            if ( !pTemp )
            {
                if ( pData->nTestFlags & DBG_TEST_MEM_POINTER )
                    DbgMemError( DBG_MEMERR_UNKNOWN_PTR, p );
                return NULL;
            }

            DbgMemBlock* pBlock = (DbgMemBlock*)(((char*)p)-sizeof( DbgMemBlock ));
            ULONG nSize = pBlock->nSize;
            nDbgCountFree++;
            nDbgAllFree += nSize;

            if ( pData->nTestFlags & DBG_TEST_MEM_TRACE )
            {
                char aDbgOutBuf[20];
                strcpy( aDbgOutBuf, "Free: " );
                DbgTraceSize( aDbgOutBuf, pBlock->nSize );
                DbgTrace( aDbgOutBuf );
            }

            if ( pData->nTestFlags & DBG_TEST_MEM_INIT )
            {
                Dbghmemset( pBlock, DBG_FREE_SIGNATURE,
                            nSize + sizeof( DbgMemBlock ) + sizeof( ULONG ) );
            }

            return pBlock;
        }
    }

    return p;
}

/*************************************************************************
|*
|*    DbgImpCheckMemoryDeInit()
|*
|*    Beschreibung      Gibt aus, welcher Speicher nicht geloescht wurde
|*    Ersterstellung    TH 27.03.95
|*    Letzte Aenderung  TH 27.03.95
|*
*************************************************************************/

void DbgImpCheckMemoryDeInit()
{
    DbgData* pData = DbgGetData();

    if ( pData )
    {
        if ( pData->nTestFlags & DBG_TEST_MEM_REPORT )
        {
            ULONG nAvg = nDbgAllAlloc / nDbgCountAlloc;
            DbgOutf( "------------------------------------------------------------------------------" );
            DbgOutf( "Memory Report" );
            DbgOutf( "------------------------------------------------------------------------------" );
            DbgOutf( "Alloc: %10lu     Bytes: %10lu     Avg.: %lu", nDbgCountAlloc, nDbgAllAlloc, nAvg );
            DbgOutf( "Free:  %10lu     Bytes: %10lu", nDbgCountFree, nDbgAllFree );
            DbgOutf( "------------------------------------------------------------------------------" );
            DbgOutf( "Leaks: %10lu     Bytes: %10lu", nDbgCountAlloc-nDbgCountFree, nDbgAllAlloc-nDbgAllFree );
            DbgOutf( "------------------------------------------------------------------------------" );
            if ( nDbgCountFree < nDbgCountAlloc )
            {
                // Nicht freigegebene Speicherbloecke ausgeben
                DbgMemBlock* pBlock = pFirstDbgBlock;
                while ( pBlock )
                {
                    DbgOutf( "%10lu", pBlock->nSize );
                    pBlock = pBlock->pNext;
                }

                DbgOutf( "------------------------------------------------------------------------------" );
            }
        }
    }
}

// -----------------------------------------------------------------------

#else

#define DBG_MEM_ALLOC( n )          MemAlloc( n )
#define DBG_MEM_FREE( p )
#define DBG_MEM_FREESET( p, n )

#endif
