/*************************************************************************
 *
 *  $RCSfile: machine.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2000/12/04 17:26:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCB_MAIN_MACHINE_HXX_
#define _UCB_MAIN_MACHINE_HXX_

#include <cstddef>
#include <hash_map>

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

namespace ucb_main {

class Machine;

//============================================================================
class MachineControl
{
public:
	inline MachineControl();

	void activate();

	void busy(Machine * pMachine);

	void idle(Machine * pMachine, bool bAwaitingEvent);

	void canStop(Machine * pMachine, bool bStop);

	void stopped(Machine * pMachine);

	void eventOccured();

private:
	enum State
	{
		STATE_INACTIVE,
		STATE_RUNNING,
		STATE_CALLING_TRY_STOP,
		STATE_STOPPING,
		STATE_CALLING_DO_STOP,
		STATE_STOPPED
	};

	struct MachineData
	{
		enum State
		{
			STATE_RUNNING,
			STATE_STOPPING,
			STATE_WAITING,
			STATE_STOPPED
		};

		enum Mode
		{
			MODE_BUSY,
			MODE_IDLE,
			MODE_IDLE_AWAITING_EVENT
		};

		State m_eState;
		Mode m_eMode;

		inline MachineData() {}

		inline MachineData(Mode eTheMode);
	};

	struct Hash
	{
		inline size_t operator ()(Machine const * p) const
		{ return reinterpret_cast< size_t >(p); }
	};

	typedef std::hash_map< Machine *, MachineData, Hash > Map;

	Map m_aMap;
	vos::OMutex m_aMutex;
	Map::size_type m_nTotal;
	Map::size_type m_nIdle;
	Map::size_type m_nIdleAwaitingEvent;
	Map::size_type m_nStopNo;
	Map::size_type m_nStopYes;
	State m_eState;
	bool m_bEventOccured;

	void checkTryStop();

	void checkDoStop();
};

inline MachineControl::MachineControl():
	m_nTotal(0),
	m_nIdle(0),
	m_nIdleAwaitingEvent(0),
	m_nStopNo(0),
	m_nStopYes(0),
	m_eState(STATE_INACTIVE),
	m_bEventOccured(false)
{}

//============================================================================
class Machine
{
public:
	Machine(MachineControl * pTheControl);

	virtual void tryStop() = 0;

	virtual void doStop(bool bStop) = 0;

protected:
	inline void busy() { m_pControl->busy(this); }

	inline void idle(bool bAwaitingEvent)
	{ m_pControl->idle(this, bAwaitingEvent); }

	inline void canStop(bool bStop) { m_pControl->canStop(this, bStop); }

	inline void stopped() { m_pControl->stopped(this); }

	inline void eventOccured() { m_pControl->eventOccured(); }

private:
	MachineControl * m_pControl;
};

}

#endif //  _UCB_MAIN_MACHINE_HXX_
