/*************************************************************************
 *
 *  $RCSfile: mainwrappedservicefactory.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: sb $ $Date: 2001/02/06 11:11:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_MAINWRAPPEDSERVICEFACTORY_HXX
#include "mainwrappedservicefactory.hxx"
#endif

#ifndef _UCPRMT_RMTPAID_HXX_
#include "rmtpaid.hxx"
#endif

#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XUNOTUNNEL_HPP_
#include <com/sun/star/lang/XUnoTunnel.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERACCEPTOR_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderAcceptor.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_XINTERFACE_HPP_
#include <com/sun/star/uno/XInterface.hpp>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _UCBHELPER_CONFIGURATIONKEYS_HXX_
#include <ucbhelper/configurationkeys.hxx>
#endif
#ifndef _UCBHELPER_CONTENTBROKER_HXX_
#include <ucbhelper/contentbroker.hxx>
#endif
#ifndef _VOS_DIAGNOSE_H_
#include <vos/diagnose.hxx>
#endif

using namespace com::sun;
using ucb_main::WrappedServiceFactory;

//============================================================================
//
//  WrappedServiceFactory
//
//============================================================================

star::uno::Reference< star::uno::XInterface >
WrappedServiceFactory::getUniversalContentBroker()
	throw (star::uno::RuntimeException)
{
	if (!m_xUniversalContentBroker.is())
	{
		star::uno::Sequence< star::uno::Any > aArguments(2);
		aArguments[0] <<= rtl::OUString::createFromAscii(
			                  m_bServer ? UCB_CONFIGURATION_KEY1_SERVER :
							              UCB_CONFIGURATION_KEY1_LOCAL);
		aArguments[1]
			<<= rtl::OUString::createFromAscii(
				    UCB_CONFIGURATION_KEY2_UNIVERSAL_CONTENT_BROKER);
		ucb::ContentBroker::initialize(m_xServiceFactory, aArguments);
		m_xUniversalContentBroker
			= ucb::ContentBroker::get()->getContentProviderManagerInterface();
		VOS_ASSERT(m_xUniversalContentBroker.is());
	}
	return m_xUniversalContentBroker;
}

//============================================================================
star::uno::Reference< star::uno::XInterface >
WrappedServiceFactory::getRemoteContentBroker(rtl::OUString const &
											      rServiceSpecifier)
	throw (star::uno::Exception)
{
	if (!m_xRemoteContentBroker.is())
	{
		star::uno::Sequence< star::uno::Any > aArguments(2);
		aArguments[0]
			<<= rtl::OUString::createFromAscii(UCB_CONFIGURATION_KEY1_SERVER);
		aArguments[1]
			<<= rtl::OUString::createFromAscii(
				    UCB_CONFIGURATION_KEY2_WEB_SERVER);
		m_xRemoteContentBroker
			= m_xServiceFactory->
			      createInstanceWithArguments(rServiceSpecifier, aArguments);
		VOS_ASSERT(m_xRemoteContentBroker.is());
	}
	return m_xRemoteContentBroker;
}

//============================================================================
star::uno::Reference< star::uno::XInterface >
WrappedServiceFactory::getRemoteContentProviderAcceptor(rtl::OUString const &
														    rServiceSpecifier)
	throw (star::uno::Exception)
{
	if (!m_xRemoteContentProviderAcceptor.is())
	{
		m_xRemoteContentProviderAcceptor
			= m_xServiceFactory->createInstance(rServiceSpecifier);
		VOS_ASSERT(m_xRemoteContentProviderAcceptor.is());
		if (m_bServer)
		{
			// The RemoteContentProviderAcceptor service (actually, it's
			// ucprmt::ProviderAcceptor implementation) must be configured so
			// that it registers the external UCBs at the RemoteContentBroker
			// service, not at the UniversalContentBroker service:
			ucprmt::SetExternalUcb * pSetExternalUcb = 0;
			star::uno::Reference< star::lang::XUnoTunnel >
				xTunnel(m_xRemoteContentProviderAcceptor,
						star::uno::UNO_QUERY);
			if (xTunnel.is())
			{
				sal_Int64 nSomething
					= xTunnel->
					      getSomething(
							  star::uno::Sequence< sal_Int8 >(
								  ucprmt::aProviderAcceptorImplementationId,
								  sizeof
							      ucprmt::aProviderAcceptorImplementationId));
				if (nSomething != 0)
					pSetExternalUcb
						= reinterpret_cast< ucprmt::SetExternalUcb * >(
							  nSomething);
			}
			VOS_ENSURE(pSetExternalUcb, "Can't call setExternalUcb()");
			if (pSetExternalUcb)
				pSetExternalUcb(
					star::uno::Reference<
					        star::ucb::XRemoteContentProviderAcceptor >(
						m_xRemoteContentProviderAcceptor,
						star::uno::UNO_QUERY),
					rtl::OUString(
						RTL_CONSTASCII_USTRINGPARAM(
							"com.sun.star.ucb.RemoteContentBroker")));
		}
	}
	return m_xRemoteContentProviderAcceptor;
}

//============================================================================
WrappedServiceFactory::WrappedServiceFactory(
	star::uno::Reference< star::lang::XMultiServiceFactory > const &
		rServiceFactory,
	bool bServer)
	throw (star::uno::RuntimeException):
	m_aListeners(m_aMutex),
	m_xServiceFactory(rServiceFactory),
	m_bServer(bServer)
{
	if (!m_xServiceFactory.is())
		throw star::uno::RuntimeException();
}

//============================================================================
// virtual
WrappedServiceFactory::~WrappedServiceFactory() throw ()
{}

//============================================================================
// virtual
star::uno::Reference< star::uno::XInterface > SAL_CALL
WrappedServiceFactory::createInstance(rtl::OUString const & rServiceSpecifier)
	throw (star::uno::Exception, star::uno::RuntimeException)
{
	star::uno::Reference< star::lang::XMultiServiceFactory > xTarget;
	{
		osl::MutexGuard aGuard(m_aMutex);
		if (!m_xServiceFactory.is())
			throw star::lang::DisposedException();
		if (rServiceSpecifier.
			    equalsAsciiL(
					RTL_CONSTASCII_STRINGPARAM(
						"com.sun.star.ucb.UniversalContentBroker")))
			return getUniversalContentBroker();

		// THIS CAN BE REMOVED ONCE THE WEBTOP SERVER HAS A UCB OF ITS OWN:
		if (rServiceSpecifier.
			    equalsAsciiL(
					RTL_CONSTASCII_STRINGPARAM(
						"com.sun.star.ucb.RemoteContentBroker")))
		{
			// The RemoteContentBroker will access the UniversalContentBroker
			// via the unwrapped service factory, so configure both here:
			getUniversalContentBroker();
			return getRemoteContentBroker(rServiceSpecifier);
		}
		else if (rServiceSpecifier.
				     equalsAsciiL(
						 RTL_CONSTASCII_STRINGPARAM(
						   "com.sun.star.ucb.RemoteContentProviderAcceptor")))
			return getRemoteContentProviderAcceptor(rServiceSpecifier);

		xTarget = m_xServiceFactory;
	}
	return xTarget->createInstance(rServiceSpecifier);
}

//============================================================================
// virtual
star::uno::Reference< star::uno::XInterface > SAL_CALL
WrappedServiceFactory::createInstanceWithArguments(
	rtl::OUString const & rServiceSpecifier,
	star::uno::Sequence< star::uno::Any > const & rArguments)
	throw (star::uno::Exception, star::uno::RuntimeException)
{
	star::uno::Reference< star::lang::XMultiServiceFactory > xTarget;
	{
		osl::MutexGuard aGuard(m_aMutex);
		if (!m_xServiceFactory.is())
			throw star::lang::DisposedException();
		if (rServiceSpecifier.
			    equalsAsciiL(
					RTL_CONSTASCII_STRINGPARAM(
						"com.sun.star.ucb.UniversalContentBroker")))
			return getUniversalContentBroker();

		// THIS CAN BE REMOVED ONCE THE WEBTOP SERVER HAS A UCB OF ITS OWN:
		if (rServiceSpecifier.
			    equalsAsciiL(
					RTL_CONSTASCII_STRINGPARAM(
						"com.sun.star.ucb.RemoteContentBroker")))
		{
			// The RemoteContentBroker will access the UniversalContentBroker
			// via the unwrapped service factory, so configure both here:
			getUniversalContentBroker();
			return getRemoteContentBroker(rServiceSpecifier);
		}
		else if (rServiceSpecifier.
				     equalsAsciiL(
						 RTL_CONSTASCII_STRINGPARAM(
						   "com.sun.star.ucb.RemoteContentProviderAcceptor")))
			return getRemoteContentProviderAcceptor(rServiceSpecifier);

		xTarget = m_xServiceFactory;
	}
	return xTarget->createInstanceWithArguments(rServiceSpecifier,
												rArguments);
}

//============================================================================
// virtual
star::uno::Sequence< rtl::OUString > SAL_CALL
WrappedServiceFactory::getAvailableServiceNames()
	throw (star::uno::RuntimeException)
{
	star::uno::Reference< star::lang::XMultiServiceFactory > xTarget;
	{
		osl::MutexGuard aGuard(m_aMutex);
		if (!m_xServiceFactory.is())
			throw star::lang::DisposedException();
		xTarget = m_xServiceFactory;
	}
	return xTarget->getAvailableServiceNames();
}

//============================================================================
// virtual
rtl::OUString SAL_CALL
WrappedServiceFactory::getImplementationName()
	throw (star::uno::RuntimeException)
{
	star::uno::Reference< star::lang::XServiceInfo > xTarget;
	{
		osl::MutexGuard aGuard(m_aMutex);
		if (!m_xServiceFactory.is())
			throw star::lang::DisposedException();
		xTarget = star::uno::Reference< star::lang::XServiceInfo >(
			          m_xServiceFactory, star::uno::UNO_QUERY);
	}
	if (!xTarget.is())
		throw star::uno::RuntimeException(
			      rtl::OUString(
					  RTL_CONSTASCII_USTRINGPARAM(
						  "ServiceManager service lacking interface")),
				  *this); //@@@
	return xTarget->getImplementationName();
}

//============================================================================
// virtual
sal_Bool SAL_CALL
WrappedServiceFactory::supportsService(rtl::OUString const & rServiceName)
	throw (star::uno::RuntimeException)
{
	star::uno::Reference< star::lang::XServiceInfo > xTarget;
	{
		osl::MutexGuard aGuard(m_aMutex);
		if (!m_xServiceFactory.is())
			throw star::lang::DisposedException();
		xTarget = star::uno::Reference< star::lang::XServiceInfo >(
			          m_xServiceFactory, star::uno::UNO_QUERY);
	}
	if (!xTarget.is())
		throw star::uno::RuntimeException(
			      rtl::OUString(
					  RTL_CONSTASCII_USTRINGPARAM(
						  "ServiceManager service lacking interface")),
				  *this); //@@@
	return xTarget->supportsService(rServiceName);
}

//============================================================================
// virtual
star::uno::Sequence< rtl::OUString > SAL_CALL
WrappedServiceFactory::getSupportedServiceNames()
	throw (star::uno::RuntimeException)
{
	star::uno::Reference< star::lang::XServiceInfo > xTarget;
	{
		osl::MutexGuard aGuard(m_aMutex);
		if (!m_xServiceFactory.is())
			throw star::lang::DisposedException();
		xTarget = star::uno::Reference< star::lang::XServiceInfo >(
			          m_xServiceFactory, star::uno::UNO_QUERY);
	}
	if (!xTarget.is())
		throw star::uno::RuntimeException(
			      rtl::OUString(
					  RTL_CONSTASCII_USTRINGPARAM(
						  "ServiceManager service lacking interface")),
				  *this); //@@@
	return xTarget->getSupportedServiceNames();
}

//============================================================================
// virtual
void SAL_CALL WrappedServiceFactory::dispose()
	throw (star::uno::RuntimeException)
{
	star::uno::Reference< star::lang::XMultiServiceFactory > xFactory;
	{
		osl::MutexGuard aGuard(m_aMutex);
		xFactory = m_xServiceFactory;
		m_xServiceFactory = 0;
	}
	if (xFactory.is())
	{
		m_aListeners.disposeAndClear(star::lang::EventObject(*this));
		m_xUniversalContentBroker = 0;
		m_xRemoteContentBroker = 0;
		m_xRemoteContentProviderAcceptor = 0;
		star::uno::Reference< star::lang::XComponent >
			xComponent(xFactory, star::uno::UNO_QUERY);
		VOS_ASSERT(xComponent.is());
		if (xComponent.is())
			xComponent->dispose();
	}
}

//============================================================================
// virtual
void SAL_CALL
WrappedServiceFactory::addEventListener(
	star::uno::Reference< star::lang::XEventListener > const & rListener)
	throw (star::uno::RuntimeException)
{
	m_aListeners.addInterface(rListener);
	bool bDisposed;
	{
		osl::MutexGuard aGuard(m_aMutex);
		bDisposed = !m_xServiceFactory.is();
	}
	if (bDisposed)
		m_aListeners.disposeAndClear(star::lang::EventObject(*this));
}

//============================================================================
// virtual
void SAL_CALL
WrappedServiceFactory::removeEventListener(
	star::uno::Reference< star::lang::XEventListener > const & rListener)
	throw (star::uno::RuntimeException)
{
	m_aListeners.removeInterface(rListener);
}

//============================================================================
// virtual
star::uno::Type SAL_CALL WrappedServiceFactory::getElementType()
	throw (star::uno::RuntimeException)
{
	star::uno::Reference< star::container::XSet > xTarget;
	{
		osl::MutexGuard aGuard(m_aMutex);
		if (!m_xServiceFactory.is())
			throw star::lang::DisposedException();
		xTarget = star::uno::Reference< star::container::XSet >(
			          m_xServiceFactory, star::uno::UNO_QUERY);
	}
	if (!xTarget.is())
		throw star::uno::RuntimeException(
			      rtl::OUString(
					  RTL_CONSTASCII_USTRINGPARAM(
						  "ServiceManager service lacking interface")),
				  *this); //@@@
	return xTarget->getElementType();
}

//============================================================================
// virtual
sal_Bool SAL_CALL WrappedServiceFactory::hasElements()
	throw (star::uno::RuntimeException)
{
	star::uno::Reference< star::container::XSet > xTarget;
	{
		osl::MutexGuard aGuard(m_aMutex);
		if (!m_xServiceFactory.is())
			throw star::lang::DisposedException();
		xTarget = star::uno::Reference< star::container::XSet >(
			          m_xServiceFactory, star::uno::UNO_QUERY);
	}
	if (!xTarget.is())
		throw star::uno::RuntimeException(
			      rtl::OUString(
					  RTL_CONSTASCII_USTRINGPARAM(
						  "ServiceManager service lacking interface")),
				  *this); //@@@
	return xTarget->hasElements();
}

//============================================================================
// virtual
star::uno::Reference< star::container::XEnumeration > SAL_CALL
WrappedServiceFactory::createEnumeration()
	throw (star::uno::RuntimeException)
{
	star::uno::Reference< star::container::XSet > xTarget;
	{
		osl::MutexGuard aGuard(m_aMutex);
		if (!m_xServiceFactory.is())
			throw star::lang::DisposedException();
		xTarget = star::uno::Reference< star::container::XSet >(
			          m_xServiceFactory, star::uno::UNO_QUERY);
	}
	if (!xTarget.is())
		throw star::uno::RuntimeException(
			      rtl::OUString(
					  RTL_CONSTASCII_USTRINGPARAM(
						  "ServiceManager service lacking interface")),
				  *this); //@@@
	return xTarget->createEnumeration();
}

//============================================================================
// virtual
sal_Bool SAL_CALL WrappedServiceFactory::has(star::uno::Any const & rElement)
	throw (star::uno::RuntimeException)
{
	star::uno::Reference< star::container::XSet > xTarget;
	{
		osl::MutexGuard aGuard(m_aMutex);
		if (!m_xServiceFactory.is())
			throw star::lang::DisposedException();
		xTarget = star::uno::Reference< star::container::XSet >(
			          m_xServiceFactory, star::uno::UNO_QUERY);
	}
	if (!xTarget.is())
		throw star::uno::RuntimeException(
			      rtl::OUString(
					  RTL_CONSTASCII_USTRINGPARAM(
						  "ServiceManager service lacking interface")),
				  *this); //@@@
	return xTarget->has(rElement);
}

//============================================================================
// virtual
void SAL_CALL WrappedServiceFactory::insert(star::uno::Any const & rElement)
	throw (star::lang::IllegalArgumentException,
		   star::container::ElementExistException,
		   star::uno::RuntimeException)
{
	star::uno::Reference< star::container::XSet > xTarget;
	{
		osl::MutexGuard aGuard(m_aMutex);
		if (!m_xServiceFactory.is())
			throw star::lang::DisposedException();
		xTarget = star::uno::Reference< star::container::XSet >(
			          m_xServiceFactory, star::uno::UNO_QUERY);
	}
	if (!xTarget.is())
		throw star::uno::RuntimeException(
			      rtl::OUString(
					  RTL_CONSTASCII_USTRINGPARAM(
						  "ServiceManager service lacking interface")),
				  *this); //@@@
	xTarget->insert(rElement);
}

//============================================================================
// virtual
void SAL_CALL WrappedServiceFactory::remove(star::uno::Any const & rElement)
	throw (star::lang::IllegalArgumentException,
		   star::container::NoSuchElementException,
		   star::uno::RuntimeException)
{
	star::uno::Reference< star::container::XSet > xTarget;
	{
		osl::MutexGuard aGuard(m_aMutex);
		if (!m_xServiceFactory.is())
			throw star::lang::DisposedException();
		xTarget = star::uno::Reference< star::container::XSet >(
			          m_xServiceFactory, star::uno::UNO_QUERY);
	}
	if (!xTarget.is())
		throw star::uno::RuntimeException(
			      rtl::OUString(
					  RTL_CONSTASCII_USTRINGPARAM(
						  "ServiceManager service lacking interface")),
				  *this); //@@@
	xTarget->remove(rElement);
}

//============================================================================
// virtual
star::uno::Reference< star::container::XEnumeration > SAL_CALL
WrappedServiceFactory::createContentEnumeration(rtl::OUString const &
												    rServiceName)
	throw (star::uno::RuntimeException)
{
	star::uno::Reference< star::container::XContentEnumerationAccess >
		xTarget;
	{
		osl::MutexGuard aGuard(m_aMutex);
		if (!m_xServiceFactory.is())
			throw star::lang::DisposedException();
		xTarget = star::uno::Reference<
			              star::container::XContentEnumerationAccess >(
					  m_xServiceFactory, star::uno::UNO_QUERY);
	}
	if (!xTarget.is())
		throw star::uno::RuntimeException(
			      rtl::OUString(
					  RTL_CONSTASCII_USTRINGPARAM(
						  "ServiceManager service lacking interface")),
				  *this); //@@@
	return xTarget->createContentEnumeration(rServiceName);
}
