/*************************************************************************
 *
 *  $RCSfile: i_real.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/05/14 08:29:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef UDM_I_REAL_HXX
#define UDM_I_REAL_HXX



// USED SERVICES
	// BASE CLASSES
#include <udm/real.hxx>
	// COMPONENTS
	// PARAMETERS
#include <udm/type_traits.hxx>

namespace udm
{

template <class SRC>
class TReal : public Real
{
  public:
    typedef SRC     source_type;

                        TReal();
    virtual             ~TReal();

    void                connect_to(
                            const source_type & i_rSrc );

  private:
    // Interface Data
    virtual void        do_Dispose();
    virtual void        do_BinWrite(
                            csv::bostream &     o_out ) const;

    // Interface StdStr
    virtual value_type  inq_Value() const;
    // DATA
    const source_type * pSrc;
};


template <class SRC>
inline void
TReal<SRC>::connect_to( const source_type & i_rSrc )
{
 	pSrc = &i_rSrc;
}

template <class SRC>
void
TReal<SRC>::do_Dispose()
{
 	delete this;
}

template <class SRC>
void
TReal<SRC>::do_BinWrite( csv::bostream & o_out ) const
{
    double c = value();
    o_out.write( &c, sizeof(double) );
}

template <class SRC>
Real::value_type
TReal<SRC>::inq_Value() const
{
    return convert_value_src_2_udm<source_type,value_type>(*pSrc);
}

}   // namespace udm


#endif


