/*************************************************************************
 *
 *  $RCSfile: menubtn.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 10:23:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_MENUBTN_HXX
#define _SV_MENUBTN_HXX

#ifndef _SV_SV_H
#include <sv.h>
#endif
#ifndef _SV_BUTTON_HXX
#include <button.hxx>
#endif

class Timer;
class PopupMenu;

// --------------------
// - MenuButton-Types -
// --------------------

#define MENUBUTTON_MENUMODE_TIMED		((USHORT)0x0001)

// --------------
// - MenuButton -
// --------------

class MenuButton : public PushButton
{
private:
	Rectangle		maFocusRect;
	void*			mpDummy;
	Timer*			mpMenuTimer;
	PopupMenu*		mpOwnMenu;
	PopupMenu*		mpMenu;
	USHORT			mnCurItemId;
	USHORT			mnMenuMode;
	Link			maActivateHdl;
	Link			maSelectHdl;

#ifdef _SV_MENUBTN_CXX
	void			ImplInitData();
	void			ImplExecuteMenu();
					DECL_LINK( ImplMenuTimeoutHdl, Timer* );
#endif

protected:
	void			ImplInit( Window* pParent, WinBits nStyle );
	void			ImplLoadRes( const ResId& rResId );

public:
					MenuButton( Window* pParent, WinBits nStyle = 0 );
					MenuButton( Window* pParent, const ResId& rResId );
					~MenuButton();

	virtual void	MouseButtonDown( const MouseEvent& rMEvt );
	virtual void	KeyInput( const KeyEvent& rKEvt );

	virtual void	Activate();
	virtual void	Select();

	void			SetMenuMode( USHORT nMode );
	USHORT			GetMenuMode() const { return mnMenuMode; }

	void			SetPopupMenu( PopupMenu* pNewMenu );
	PopupMenu*		GetPopupMenu() const { return mpMenu; }

	USHORT			GetCurItemId() const { return mnCurItemId; }

	void			SetActivateHdl( const Link& rLink ) { maActivateHdl = rLink; }
	const Link& 	GetActivateHdl() const				{ return maActivateHdl; }
	void			SetSelectHdl( const Link& rLink )	{ maSelectHdl = rLink; }
	const Link& 	GetSelectHdl() const				{ return maSelectHdl; }
};

#endif	// _SV_MENUBTN_HXX
