/*************************************************************************
 *
 *	$RCSfile: pdfwriter.hxx,v $
 *
 *	$Revision: 1.6 $
 *
 *	last change: $Author: vg $ $Date: 2003/05/28 12:29:54 $
 *
 *	The Contents of this file are made available subject to the terms of
 *	either of the following licenses
 *
 *		   - GNU Lesser General Public License Version 2.1
 *		   - Sun Industry Standards Source License Version 1.1
 *
 *	Sun Microsystems Inc., October, 2000
 *
 *	GNU Lesser General Public License Version 2.1
 *	=============================================
 *	Copyright 2000 by Sun Microsystems, Inc.
 *	901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License version 2.1, as published by the Free Software Foundation.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *	MA	02111-1307	USA
 *
 *
 *	Sun Industry Standards Source License Version 1.1
 *	=================================================
 *	The contents of this file are subject to the Sun Industry Standards
 *	Source License Version 1.1 (the "License"); You may not use this file
 *	except in compliance with the License. You may obtain a copy of the
 *	License at http://www.openoffice.org/license.html.
 *
 *	Software provided under this License is provided on an "AS IS" basis,
 *	WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *	WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *	MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *	See the License for the specific provisions governing your rights and
 *	obligations concerning the Software.
 *
 *	The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *	Copyright: 2000 by Sun Microsystems, Inc.
 *
 *	All Rights Reserved.
 *
 *	Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _VCL_PDFWRITER_HXX
#define _VCL_PDFWRITER_HXX

#ifndef _SAL_TYPES_H
#include <sal/types.h>
#endif
#ifndef _TL_GEN_HXX
#include <tools/gen.hxx>
#endif
#ifndef _VCL_VCLENUM_HXX
#include <vclenum.hxx>
#endif
#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _COLOR_HXX
#include <tools/color.hxx>
#endif

class Font;
class Point;
class OutputDevice;
class Region;
class MapMode;
class Polygon;
class LineInfo;
class PolyPolygon;
class Bitmap;
class BitmapEx;
class Image;
class Gradient;
class Hatch;
class Wallpaper;

namespace vcl
{

struct PDFDocInfo
{
    String			Title;			// document title
    String			Author;			// document author
    String			Subject;		// subject
    String			Keywords;		// keywords
    String			Creator;		// application that created the original document
    String			Producer;		// OpenOffice
};

class PDFWriter
{
    void* pImplementation;
public:
    enum Orientation { Portrait, Landscape, Seascape, Inherit };
    enum PDFVersion { PDF_1_2, PDF_1_3, PDF_1_4 };
    enum Compression { Screen, Print, Press };

	/* target must be a valid file url usable by osl */
    PDFWriter( const rtl::OUString& rTarget, PDFVersion eVersion = PDF_1_3, Compression eCompression = Screen );
    ~PDFWriter();

    /* returns an OutputDevice for formatting
     *  this Output device is guaranteed to use the same
     *  font metrics as the resulting PDF file.
     */
    OutputDevice* GetReferenceDevice();

    /* creates a new page to fill
     *  if width and height are not set the page size
     *  is inherited from the page tree
     *  returns the page number of the new page
     *  other effects:
     *  - resets the graphics state: MapMode, Font,
     *  Colors and other state information MUST
     *  be set again or are undefined.
     */
    sal_Int32 NewPage( sal_Int32 nPageWidth = 0, sal_Int32 nPageHeight = 0, Orientation eOrientation = Inherit );

    /*
     *  set document info; may be called anytime befor Emit()
     */
    void SetDocInfo( const PDFDocInfo& rInfo );

    /*
     *  get currently set document info
     */
    const PDFDocInfo& GetDocInfo() const;

    /* finishes the file */
    bool Emit();

    PDFVersion GetVersion() const;

    /* functions for graphics state */
    /* flag values: see vcl/outdev.hxx */
    void				Push( USHORT nFlags = 0xffff );
    void				Pop();

    void               SetClipRegion();
    void               SetClipRegion( const Region& rRegion );
    void               MoveClipRegion( long nHorzMove, long nVertMove );
    void               IntersectClipRegion( const Rectangle& rRect );
    void               IntersectClipRegion( const Region& rRegion );

    void               SetAntialiasing( USHORT nMode =  0 );

    void               SetLayoutMode( ULONG nMode );

    void               SetLineColor( const Color& rColor );
    void               SetLineColor() { SetLineColor( Color( COL_TRANSPARENT ) ); }

    void               SetFillColor( const Color& rColor );
    void               SetFillColor() { SetFillColor( Color( COL_TRANSPARENT ) ); }

    void               SetFont( const Font& rNewFont );
    void               SetTextColor( const Color& rColor );
    void               SetTextFillColor();
    void               SetTextFillColor( const Color& rColor );

    void               SetTextLineColor();
    void               SetTextLineColor( const Color& rColor );
    void               SetTextAlign( TextAlign eAlign );

    void               SetMapMode();
    void               SetMapMode( const MapMode& rNewMapMode );


    /* actual drawing functions */
    void				DrawText( const Point& rPos, const String& rText );

    void				DrawTextLine( const Point& rPos, long nWidth,
                                      FontStrikeout eStrikeout,
                                      FontUnderline eUnderline,
                                      BOOL bUnderlineAbove = FALSE );
    void				DrawTextArray( const Point& rStartPt, const XubString& rStr,
                                       const long* pDXAry = NULL,
                                       xub_StrLen nIndex = 0,
                                       xub_StrLen nLen = STRING_LEN );
    void				DrawStretchText( const Point& rStartPt, ULONG nWidth,
                                         const XubString& rStr,
                                         xub_StrLen nIndex = 0, xub_StrLen nLen = STRING_LEN );
    void				DrawText( const Rectangle& rRect,
                                  const XubString& rStr, USHORT nStyle = 0 );

    void				DrawPixel( const Point& rPt, const Color& rColor );
    void				DrawPixel( const Point& rPt )
    { DrawPixel( rPt, Color( COL_TRANSPARENT ) ); }
    void				DrawPixel( const Polygon& rPts, const Color* pColors = NULL );
    void				DrawPixel( const Polygon& rPts, const Color& rColor )
    { Push(); SetLineColor( rColor ); DrawPixel( rPts ); Pop(); }

    void				DrawLine( const Point& rStartPt, const Point& rEndPt );
    void				DrawLine( const Point& rStartPt, const Point& rEndPt,
                                  const LineInfo& rLineInfo );
    void				DrawPolyLine( const Polygon& rPoly );
    void				DrawPolyLine( const Polygon& rPoly,
                                      const LineInfo& rLineInfo );
    void				DrawPolygon( const Polygon& rPoly );
    void				DrawPolyPolygon( const PolyPolygon& rPolyPoly );
    void				DrawRect( const Rectangle& rRect );
    void				DrawRect( const Rectangle& rRect,
                                  ULONG nHorzRount, ULONG nVertRound );
    void				DrawEllipse( const Rectangle& rRect );
    void				DrawArc( const Rectangle& rRect,
                                 const Point& rStartPt, const Point& rEndPt );
    void				DrawPie( const Rectangle& rRect,
                                 const Point& rStartPt, const Point& rEndPt );
    void				DrawChord( const Rectangle& rRect,
                                   const Point& rStartPt, const Point& rEndPt );

    void				DrawBitmap( const Point& rDestPt,
                                    const Bitmap& rBitmap );
    void				DrawBitmap( const Point& rDestPt, const Size& rDestSize,
                                    const Bitmap& rBitmap );
    void				DrawBitmap( const Point& rDestPt, const Size& rDestSize,
                                    const Point& rSrcPtPixel, const Size& rSrcSizePixel,
                                    const Bitmap& rBitmap );

    void				DrawBitmapEx( const Point& rDestPt,
                                      const BitmapEx& rBitmapEx );
    void				DrawBitmapEx( const Point& rDestPt, const Size& rDestSize,
                                      const BitmapEx& rBitmapEx );
    void				DrawBitmapEx( const Point& rDestPt, const Size& rDestSize,
                                      const Point& rSrcPtPixel, const Size& rSrcSizePixel,
                                      const BitmapEx& rBitmapEx );

    void				DrawMask( const Point& rDestPt,
                                  const Bitmap& rBitmap, const Color& rMaskColor );
    void				DrawMask( const Point& rDestPt, const Size& rDestSize,
                                  const Bitmap& rBitmap, const Color& rMaskColor );
    void				DrawMask( const Point& rDestPt, const Size& rDestSize,
                                  const Point& rSrcPtPixel, const Size& rSrcSizePixel,
                                  const Bitmap& rBitmap, const Color& rMaskColor );

    void				DrawGradient( const Rectangle& rRect, const Gradient& rGradient );
    void				DrawGradient( const PolyPolygon& rPolyPoly, const Gradient& rGradient );

    void				DrawHatch( const PolyPolygon& rPolyPoly, const Hatch& rHatch );

    void				DrawWallpaper( const Rectangle& rRect, const Wallpaper& rWallpaper );
    void				DrawTransparent( const PolyPolygon& rPolyPoly,
                                         USHORT nTransparencePercent );
//     void                DrawTransparent( const GDIMetaFile& rMtf,
//                                          const Point& rPos, const Size& rSize,
//                                          const Gradient& rTransparenceGradient );

    // inserts a JPG encoded image (optionally with mask)
    // rJPGData:			a Stream containing the encoded image
    // rSrcSizePixel:		size in pixel of the image
    // rTargetArea:		where to put the image
    // rMask:				optional mask; if non empty it must have
	//						the same pixel size as the image and
    //						be either 1 bit black&white or 8 bit grey
    void				DrawJPGBitmap( SvStream& rJPGData, const Size& rSrcSizePixel, const Rectangle& rTargetArea, const Bitmap& rMask );
};

}

#endif // _VCL_PDFWRITER_HXX
