/*************************************************************************
 *
 *  $RCSfile: rmwindow.hxx,v $
 *
 *  $Revision: 1.16 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/24 16:29:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_RMWINDOW_HXX
#define _SV_RMWINDOW_HXX

#include <sal/types.h>
#include "wintypes.hxx"
#include "sndstyle.hxx"
#include "ptrstyle.hxx"
#include "rvp.hxx"
#include <tools/unqidx.hxx>
#include <tools/link.hxx>
#ifndef _SV_GEN_HXX
#include <gen.hxx>
#endif
#ifndef _SV_SALGEOM_HXX
#include <salgeom.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERNCE_HXX_
#include "com/sun/star/uno/Reference.hxx"
#endif

namespace com { namespace sun { namespace star { namespace portal {
    namespace client { class XRmFrameWindow; }
} } } }
namespace com { namespace sun { namespace star { namespace accessibility { class XAccessible; } } } }

// -----------------
// - RmFrameWindow -
// -----------------

DECLARE_UNIQUEINDEX( EventIDIndex, Link* );

class Window;
class XRmsEventHdl;
class Font;
class RmDragSource;

// forward declaration (see unotools/atom.hxx for declaration)
namespace utl {
	class AtomClient;
}

struct RmCursorData {
    // keeps track of last cursor rect sent to client
	Rectangle   mRect;
	long		mnCursorExtWidth;
    RmCursorData()  {
        mnCursorExtWidth = 0;
    }
};

class RmFrameWindow
{
	friend class XRmsEventHdl;
    friend class RmDragSource;

private:
	PointerStyle						mePtrStyle;
	PointerStyle						meDragPtrStyle;
	
	REF( NMSP_CLIENT::XRmFrameWindow )	mxFrameWindow;
	REF( NMSP_CLIENT::XRmOutputDevice )	mxOutputDevice; // performance:; dont query this
	REF( NMSP_CLIENT::XEventHdl )		mxEventHdl;
	XRmsEventHdl                       *mpEvtHdl;   // jbu (see implementation)

	EventIDIndex					    maEvents;
	::utl::AtomClient*					mpAtoms;
    BOOL                                mbInEvtHandler; // is currently in windowproc ?
    BOOL                                mbInDragMode;
    RmCursorData                        mRmCursorData;

    void                                EnableDragMode( BOOL bEnable );
    void								SetDragPointer( PointerStyle ePointerStyle );

public:
    RmFrameWindow(Window * pServerWindow, ::com::sun::star::uno::Reference< ::com::sun::star::portal::client::XRmFrameWindow > const & rClientWindow);
										~RmFrameWindow();
    SalFrameGeometry					maGeometry;

	BOOL								IsValid() const { return( mxFrameWindow.is() && mxEventHdl.is() ); }
	
	const REF( NMSP_CLIENT::XRmFrameWindow )&	GetFrameInterface() const { return mxFrameWindow; }
	const REF( NMSP_CLIENT::XRmOutputDevice )&	GetOutdevInterface() const { return mxOutputDevice; }
	const REF( NMSP_CLIENT::XEventHdl )&		GetEventHdlInterface() const { return mxEventHdl; }

    void                                IsInEvtHandler( BOOL bFlag ) { mbInEvtHandler = bFlag; }
    BOOL                                IsInEvtHandler( ) const { return mbInEvtHandler; }

public:

	ULONG								InsertUserEventLink( const Link& );
	
    void								Create( WinBits nWinBits, const REF( NMSP_CLIENT::XEventHdl )& xEventInterface, const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessibleContext > & rxAccessible, const ::com::sun::star::uno::Any& aSystemWorkWindowToken, const REF( NMSP_CLIENT::XRmFrameWindow )& xParent );
    void								SetParent( const REF( NMSP_CLIENT::XRmFrameWindow )& xParent );
    void								SetTitle( const OUSTRING& rTitle );
    void								Show( BOOL bVisible, BOOL bNoActivate = FALSE );
    void								SetClientSize( sal_Int16 nWidth, sal_Int16 nHeight );
    void								SetPosSize( sal_Int16 nX, sal_Int16 nY, sal_Int16 nWidth, sal_Int16 nHeight, USHORT nFlags );
    void								GetClientSize( sal_Int32 & rWidth, sal_Int32& rHeight );
    void								GetWorkArea( Rectangle& rRect );
    const SalFrameGeometry&				GetGeometry() const { return maGeometry; }
    String								GetWindowState();
    void								SetWindowState( const String& rState );
    void								GetFontResolution( long& nDPIX, long& nDPIY );
	NMSP_CLIENT::RmFrameResolutions		GetFrameResolutions();
    void								ToTop( sal_uInt16 nFlags );
    void								StartPresentation( BOOL bStart, sal_uInt16 nStartFlags );
    void								SetAlwaysOnTop( BOOL bOnTop );
    void								ShowFullScreen( BOOL bFullScreen );
    void								CaptureMouse( BOOL bMouse );
    void								SetPointer( PointerStyle ePointerStyle );
    void								SetPointerPos( sal_Int16 nX, sal_Int16 nY );
    void								Beep( SoundType eSoundType );
    void								GetKeyNames( NMSP_CLIENT::KeyNameSequence& rKeyNames );
	void								Enable( sal_Bool bEnable );
	void								SetIcon( sal_Int16 IconID );
	void								SetMinClientSize( sal_Int16 Width, sal_Int16 Height );
    void								MouseMoveProcessed();
    void								KeyInputProcessed();
    ULONG					            GetCurrentModButtons();

    void                                SetInputContext( const Font& rFont, ULONG rOptions);
    void                                EndExtTextInput( USHORT nFlags );
    void                                SetCursorRect( const Rectangle* pRect, long nExtTextInputWidth );
    void                                GetDragSourceDropTarget( ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDragSource >& xDragSource,
                                                                 ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDropTarget >& xDropTarget );
};

#endif	// _RMWINDOW_HXX
