/*************************************************************************
 *
 *  $RCSfile: indbmp.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _SV_INDBMP_CXX

#ifndef _SV_SALBTYPE_HXX
#undef private
#define private public
#include <salbtype.hxx>
#undef private
#define private private
#endif
#ifndef _RTL_ALLOC_H_
#include <rtl/alloc.h>
#endif
#ifndef _RTL_MEMORY_H_
#include <rtl/memory.h>
#endif
#ifndef _SV_INDBMP_HXX
#include <indbmp.hxx>
#endif

// ----------
// - Header -
// ----------

struct IndHeader
{
   ULONG	biSize; 
   long		biWidth; 
   long		biHeight; 
   USHORT	biPlanes; 
   USHORT	biBitCount;
   ULONG	biCompression; 
   ULONG	biSizeImage; 
   long		biXPelsPerMeter; 
   long		biYPelsPerMeter; 
   ULONG	biClrUsed; 
   ULONG	biClrImportant; 
};

// -----------
// - Defines -
// -----------

#define HEADERLEN( def_nBits ) ( sizeof( IndHeader ) + ( ( (def_nBits) <= 8 ) ? ( ( 1 << (def_nBits) ) << 2 ) : 0 ) )

// -------------
// - ImplServerBitmap -
// -------------

ImplServerBitmap::ImplServerBitmap() :
		mpBuffer	( NULL ),
		mnBitCount	( 0 )
{
	mpPalette = new BitmapPalette;
}

// ------------------------------------------------------------------

ImplServerBitmap::~ImplServerBitmap()
{
	Destroy();
	delete mpPalette;
}

// ------------------------------------------------------------------

BOOL ImplServerBitmap::Create( const Size& rSize, USHORT nBitCount, const BitmapPalette& rPal )
{	
	HPBYTE	pBuffer = (HPBYTE) rtl_allocateZeroMemory( HEADERLEN( nBitCount ) + 
													   AlignedWidth4Bytes( nBitCount * rSize.Width() ) * rSize.Height() );
	BOOL	bRet = FALSE;

	if( pBuffer )
	{
		const USHORT nColors = ( nBitCount <= 8 ) ? ( 1 << nBitCount ) : 0;

		maSize = rSize;
		mnBitCount = nBitCount;

		if( nColors )
		{
			const USHORT nMinCount = Min( nColors, rPal.GetEntryCount() );
			mpPalette->SetEntryCount( nColors );

			if( rPal.GetEntryCount() )
				rtl_copyMemory( mpPalette->ImplGetColorBuffer(), rPal.ImplGetColorBuffer(), nMinCount << 2 );
		}

		mpBuffer = pBuffer;
		bRet = TRUE;
	}

	return bRet;
}

// ------------------------------------------------------------------

BOOL ImplServerBitmap::Create( const ImplServerBitmap& rImplServerBitmap )
{
	BOOL bRet = FALSE;

	if( rImplServerBitmap.mpBuffer )
	{
		ULONG nSize = HEADERLEN( rImplServerBitmap.mnBitCount ) + 
					  AlignedWidth4Bytes( rImplServerBitmap.mnBitCount * rImplServerBitmap.maSize.Width() ) *
					  rImplServerBitmap.maSize.Height();
		
		if( ( mpBuffer = (HPBYTE) rtl_allocateZeroMemory( nSize ) ) != NULL )
		{
			maSize = rImplServerBitmap.maSize;
			mnBitCount = rImplServerBitmap.mnBitCount;
			*mpPalette = *rImplServerBitmap.mpPalette;
			rtl_copyMemory( mpBuffer, rImplServerBitmap.mpBuffer, nSize );
			bRet = TRUE;
		}
	}

	return bRet;
}

// ------------------------------------------------------------------

BOOL ImplServerBitmap::Create( const ImplServerBitmap& rSalBmp, SalGraphics* pGraphics )
{
	return Create( rSalBmp );
}

// ------------------------------------------------------------------

BOOL ImplServerBitmap::Create( const ImplServerBitmap& rSalBmp, USHORT nNewBitCount )
{
	return Create( rSalBmp );
}

// ------------------------------------------------------------------

void ImplServerBitmap::Destroy()
{
	maSize = Size();
	mnBitCount = 0;
	mpPalette->SetEntryCount( 0 );
	rtl_freeMemory( mpBuffer );
	mpBuffer = NULL;
}

// ------------------------------------------------------------------

BitmapBuffer* ImplServerBitmap::AcquireBuffer( BOOL bReadOnly )
{
	BitmapBuffer* pBuffer = NULL;

	if( mpBuffer )
	{
		pBuffer = new BitmapBuffer;
		pBuffer->mnFormat = BMP_FORMAT_BOTTOM_UP |
							( mnBitCount == 1 ? BMP_FORMAT_1BIT_MSB_PAL :
							  mnBitCount == 4 ? BMP_FORMAT_4BIT_MSN_PAL :
							  mnBitCount == 8 ? BMP_FORMAT_8BIT_PAL :
							  mnBitCount == 24 ? BMP_FORMAT_24BIT_TC_BGR : 0UL );

		if( BMP_SCANLINE_FORMAT( pBuffer->mnFormat ) )
		{
			pBuffer->mnWidth = maSize.Width();
			pBuffer->mnHeight = maSize.Height();
			pBuffer->mnBitCount = (USHORT) mnBitCount;
			pBuffer->mnScanlineSize = AlignedWidth4Bytes( pBuffer->mnWidth * mnBitCount );

			if( pBuffer->mnBitCount <= 8 )
				pBuffer->maPalette = *mpPalette;

			pBuffer->mpBits = mpBuffer + HEADERLEN( mnBitCount );
		}
		else
		{
			delete pBuffer;
			pBuffer = NULL;
		}
	}

	return pBuffer;
}

// ------------------------------------------------------------------

void ImplServerBitmap::ReleaseBuffer( BitmapBuffer* pBuffer, BOOL bReadOnly )
{
	if( pBuffer )
	{
		if( mpBuffer && !bReadOnly && !!pBuffer->maPalette )
			*mpPalette = pBuffer->maPalette;

		delete pBuffer;
	}
}

// ------------------------------------------------------------------

const BYTE*  ImplServerBitmap::GetRawData() const
{
	return( mpBuffer ? ( mpBuffer + HEADERLEN( mnBitCount ) ) : NULL );
}
