/*************************************************************************
 *
 *  $RCSfile: thrdsrv.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _VOS_THRDSRV_HXX_
#define _VOS_THRDSRV_HXX_


#ifndef _VOS_TYPES_HXX_
#	include <vos/types.hxx>
#endif
#ifndef _VOS_OBSERVER_HXX_
#	include <vos/observer.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#	include <vos/mutex.hxx>
#endif
#ifndef _VOS_RUNTHRD_HXX_
#	include <vos/runthrd.hxx>
#endif
#ifndef _VOS_EXECABL_HXX_
#	include <vos/execabl.hxx>
#endif
#ifndef _VOS_REF_HXX_
#	include <vos/ref.hxx>
#endif
#ifndef _VOS_QUEUE_HXX_
#	include <vos/queue.hxx>
#endif

#ifndef __VECTOR__
#	include <vector>
#endif

#ifdef _USE_NAMESPACE
namespace vos
{     
#endif



/** OThreadingServer

	Creates a thread for each IExecutable-Object added.
	So the IExecutables are executed completely asynchronously.
	If you need only cooperative multitasking, use
	OFiberServer instead.

	@author  Bernd Hofner
	@version 0.1
*/

class OThreadingServer : public NAMESPACE_VOS(OObserver),
						 public NAMESPACE_VOS(OObject)
{
	VOS_DECLARE_CLASSINFO(NAMESPACE_VOS(OThreadingServer));
public:

	/**
	*/
	OThreadingServer();

	/**
		By destroying the OThreadServer, you also terminate 
		and delete all its threads.
	*/
	virtual ~OThreadingServer();

	/** Create a thread for each IExecutable and add it to the
		server.
	*/
	void SAL_CALL add(const ORef<IExecutable>& ref);		

	/** Removes the IExecutable from the server and terminates
		its thread, if it is running.
	*/
	void SAL_CALL remove(const ORef<IExecutable>& ref);

	/** Wait till all threads have terminated.
	*/
	void SAL_CALL complete();

	/** Block until the next thread has finished.
		Then return the IExecutable that was executed
		by this thread.
	*/
	ORef<IExecutable> SAL_CALL getNextCompleted();

	/** Called by the threads when they have terminated.
	*/
	void SAL_CALL notify(sal_Int32 code, void* pData);

protected:

	// collection of running threads
	typedef NAMESPACE_STD(vector<OExecutableThread*>) TExecVector;
	TExecVector m_Pool;

	// queue of terminated threads (keep only their executables)
	typedef ORef<IExecutable> TRefExecutable;
	NAMESPACE_VOS(OQueue<TRefExecutable>) m_CompletedQueue;
	
	NAMESPACE_VOS(OMutex) m_Lock;
};


#ifdef _USE_NAMESPACE
}
#endif

#endif // _VOS_THRDSRV_HXX_

