/*************************************************************************
 *
 *  $RCSfile: bytestrm.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <vos/diagnose.hxx>
#include <vos/object.hxx>
#include <vos/macros.hxx>
#include <vos/bytestrm.hxx>

#ifdef _USE_NAMESPACE
using namespace vos;
#endif


/////////////////////////////////////////////////////////////////////////////
//
//  class ByteStream
//

OByteStream::OByteStream(OByteArray& s)
	: OStream((IPositionableStream&)*this), m_Buffer(s)
{
    m_Position = 0;
}

sal_Int32 OByteStream::read(void* poutput, sal_uInt32 n) const
{
    sal_Int32 ret = VOS_MAX(0, VOS_MIN(m_Buffer.getSize() - m_Position, n));
    if (ret > 0) 
	{
        m_Buffer.copyTo(poutput, ret, m_Position);
        ((OByteStream*)this)->m_Position += ret; // const cast away
    }

    return (ret);
}

sal_Int32 OByteStream::write(const void* buffer, sal_uInt32 n)
{
    sal_uInt32 size = m_Buffer.getSize();
    if (size - m_Position < n) 
	{
        sal_Int32 new_size = m_Position + n;
        if (! changeSize(new_size))
            return (sal_False);
    }
        
    if (n > 0) 
	{
        m_Buffer.copyFrom(buffer, n, m_Position);
        m_Position += n;
    }

    return (n >= 0);
}

///
sal_Int32 OByteStream::read(IPositionableStream::Offset offset, 
					      void* pbuffer, 
					      sal_uInt32 n) const
{
	return OStream::read(offset, pbuffer, n);
}

///
sal_Int32 OByteStream::write(IPositionableStream::Offset offset, 
						   const void* pbuffer, 
						   sal_uInt32 n)
{
	return OStream::write(offset, pbuffer, n);
}


#define DEFAULT_EXPANSION 64

// Change the current position. Returns sal_True on success.
sal_Bool OByteStream::seekTo(Offset position) const
{
    if (position < 0)
        return (sal_False);

    sal_uInt32 size = m_Buffer.getSize();
    
	if ((m_Position > size) && ! m_Buffer.changeSize (size + DEFAULT_EXPANSION))
        return (sal_False);
    ((OByteStream*) this)->m_Position = position; // const cast away
    
	return (sal_True);
}

sal_Bool OByteStream::seekToEnd () const
{
    ((OByteStream*)this)->m_Position = m_Buffer.getSize(); // Cast away const
    
	return (sal_True);
}

sal_Bool OByteStream::seekRelative(sal_Int32 change) const
{
    Offset new_pos = VOS_MAX(0, m_Position + change);
    
	((OByteStream*)this)->m_Position = new_pos; // Cast away const
    
	return sal_True;
}

sal_Bool OByteStream::changeSize(sal_uInt32 new_size)
{
    return (m_Buffer.changeSize(new_size));
}

inline sal_uInt32 OByteStream::getSize() const
{
    return (m_Buffer.getSize());
}

sal_Bool OByteStream::isEof() const
{
    return (m_Position >= m_Buffer.getSize());
}

IPositionableStream::Offset OByteStream::getOffset() const
{
    return (m_Position);
}

