/*************************************************************************
 *
 *  $RCSfile: cmdline.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: np $ $Date: 2002/08/08 16:07:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "cmdline.hxx"

#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <iostream>


char C_sUseText[] = "Use: xml2cmp.exe \n"
					"        [-func funcFile] \n"
					"        [-html htmlFile] \n"
					"        [-types typeFile] \n"
					"        [-idlpath idlPath] \n"
					"        Xml_FileName\n"
					" or: xml2cmp.exe \n"
					"        -ix \n"
					"        sourceDirectory \n"
					"        outputDirectory \n"
					"        [-idlpath idlPath] \n"
					"        tagname [tagname ...]";


char C_sCmdFunc[] 		= "-func";
char C_sCmdHtml[]       = "-html";
char C_sCmdType[]       = "-types";
char C_sCmdIndex[]      = "-ix";
char C_sCmdIdlPath[]    = "-idlpath";



bool GetParameter( Simstr & o_rMemory, int & io_nCountArg, int argc, char * argv[] );


CommandLine::CommandLine( int			argc,
						  char *		argv[] )
	:	bIsOk(true)
{
	bool bDisplayUse = false;

	/* Check command line: */
	if ( argc < 2 )
		bDisplayUse = true;
	else if ( argc == 2 && ! isalnum(argv[1][0]) )
		bDisplayUse = true;
	else if ( strcmp( argv[1], C_sCmdIndex ) == 0 && argc < 5 )
		bDisplayUse = true;

	if (bDisplayUse)
	{
		std::cout << C_sUseText << std::endl;
		bIsOk = false;
		exit(0);
	}

	if ( strcmp( argv[1], C_sCmdIndex ) == 0 )
	{
		ParseIndexCommand(argc,argv);
	}
	else
	{
		ParseSingleFileCommand(argc,argv);
	}

	if ( sXmlSourceFile.l() == 0
		 && sXmlSourceDirectory.l() == 0 )
	{
		bIsOk = false;
	}
	else if ( sXmlSourceFile.l() > 0
			  && sXmlSourceDirectory.l() > 0 )
	{
		bIsOk = false;
	}
	else if ( sIndexFile.l() > 0
			  && ( sXmlSourceDirectory.l() == 0
				   || aTagsInIndex.size() == 0
				 )
			)
	{
		bIsOk = false;
	}

}

CommandLine::~CommandLine()
{
}


const char *
CommandLine::ErrorText() const
{
	static char cOut[] = "Error:  Command line was incorrect. Probably there was a flag without\n"
						 "        the corresponding parameter. Or there was no XML-sourcefile specified.\n";
	return cOut;
}

bool
GetParameter( Simstr &      o_pMemory,
			  int & 	    io_pCountArg,
			  int           argc,
			  char *        argv[] )
{
	io_pCountArg++;
	if( io_pCountArg < argc )
	{
		o_pMemory = argv[io_pCountArg];
		return true;
	}
	return false;
}


void
CommandLine::ParseIndexCommand( int					argc,
								char *				argv[] )
{
	int nCountArg = 1;
	bIsOk = GetParameter(
				sXmlSourceDirectory,
				nCountArg,
				argc,
				argv  );
	if (bIsOk)
		bIsOk = GetParameter(
					sOutputDirectory,
					nCountArg,
					argc,
					argv  );
	if (bIsOk && strcmp( argv[nCountArg+1], C_sCmdIdlPath ) == 0 )
		bIsOk = GetParameter(
					sIdlRootPath,
					++nCountArg,
					argc,
					argv  );

	sIndexFile = sOutputDirectory;
#ifdef WNT
	sIndexFile+= "\\xmlindex.html";
#elif defined(UNX)
	sIndexFile+= "/xmlindex.html";
#endif

	for ( ++nCountArg; nCountArg < argc; ++nCountArg )
	{
		Simstr sElementName(argv[nCountArg]);
		aTagsInIndex.push_back( sElementName );
	}
}


void
CommandLine::ParseSingleFileCommand( int				argc,
									 char *				argv[] )
{
	for ( int nCountArg = 1; nCountArg < argc && bIsOk; ++nCountArg )
	{
		if ( strcmp( argv[nCountArg], C_sCmdFunc ) == 0 )
		{
			bIsOk = GetParameter(
								sFuncFile,
								nCountArg,
								argc,
								argv  );
		}
		else if ( strcmp( argv[nCountArg], C_sCmdHtml ) == 0 )
		{
			bIsOk = GetParameter(
								sHtmlFile,
								nCountArg,
								argc,
								argv  );
		}
		else if ( strcmp( argv[nCountArg], C_sCmdType ) == 0 )
		{
			bIsOk = GetParameter(
								sTypeInfoFile,
								nCountArg,
								argc,
								argv  );
		}
		else if ( strcmp( argv[nCountArg], C_sCmdIdlPath ) == 0 )
		{
			bIsOk = GetParameter(
								sIdlRootPath,
								nCountArg,
								argc,
								argv  );
		}
		else
		{
			sXmlSourceFile = argv[nCountArg];
		}
	}  	/* end for */
}
