/*************************************************************************
 *
 *  $RCSfile: IndexAccessor.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: abi $ $Date: 2001/06/19 13:36:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _XMLSEARCH_UTIL_INDEXACCESSOR_HXX_
#define _XMLSEARCH_UTIL_INDEXACCESSOR_HXX_


#ifndef _RTL_USTRING_HXX_
#include  <rtl/ustring.hxx>
#endif
#ifndef _XMLSEARCH_EXCEP_XMLSEARCHEXCEPTIONS_HXX_
#include <excep/XmlSearchExceptions.hxx>
#endif

namespace xmlsearch {
  
	namespace util {
    
		class RandomAccessStream;
    
		class IndexAccessor
		{
		public:
		
			enum ACCESSKIND { READ,
							  WRITE,
							  READWRITE };
      
      
			IndexAccessor( const rtl::OUString& dirName )
			{
				if( dirName.getLength() )
					if( dirName.getStr()[dirName.getLength()-1] != sal_Unicode( '/' ) )
						dirName_ = ( dirName + rtl::OUString::createFromAscii( "/" ) ) ;
					else
						dirName_ = dirName;
			}
			
      
			~IndexAccessor()
			{
			}
			
	
			IndexAccessor( const IndexAccessor& accessor )
			{
				dirName_ = accessor.dirName_;
			}
			
			
			RandomAccessStream* getStream( const rtl::OUString& fileName,
										   const rtl::OUString& how ) const;
      
			
			sal_Int32 readByteArray( sal_Int8*& data, const rtl::OUString& fileName )
				throw( xmlsearch::excep::IOException );
		
		private:
      
			rtl::OUString  dirName_;

		};
		
	}
}


#endif
