/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /usr/home/sean/mozdev/mozilla-1.0/mozilla/netwerk/base/public/nsIURIChecker.idl
 */

#ifndef __gen_nsIURIChecker_h__
#define __gen_nsIURIChecker_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIRequest_h__
#include "nsIRequest.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
/**
 * nsIRequest
 *
 * @status FROZEN
 */
class nsIRequest; /* forward declaration */

class nsIRequestObserver; /* forward declaration */

#include "nsAString.h"

/* starting interface:    nsIURIChecker */
#define NS_IURICHECKER_IID_STR "0ce148b2-1dd2-11b2-ba70-af918b44b323"

#define NS_IURICHECKER_IID \
  {0x0ce148b2, 0x1dd2, 0x11b2, \
    { 0xba, 0x70, 0xaf, 0x91, 0x8b, 0x44, 0xb3, 0x23 }}

class NS_NO_VTABLE nsIURIChecker : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IURICHECKER_IID)

  /**
   * Begin asynchronous check for validity.
   * Notification will be asynchronous through the callback.
   *
   * Our interpretations of the nsIRequestObserver errors:
   *   NS_BINDING_SUCCEEDED:   link is valid
   *   NS_BINDING_FAILED:      link is invalid (gave an error)
   *   NS_BINDING_ABORTED:     timed out, or cancelled
   *
   * @param aURI        The URI to be checked.
   * @param aObserver   The object to notify when the link is verified.
   *                    We will call aObserver.OnStartRequest followed
   *                    immediately by aObserver.OnStopRequest.
   *                    It is recommended that the caller use
   *                    OnStopRequest to act on the link's status.
   *                    The underlying request will not be cancelled
   *                    until after OnStopRequest has been called.
   * @param aCtxt       A closure that will be passed back to the
   *                    nsIRequestObserver methods
   * @param aLoadFlags  Load flags to set on the base request.
   */
  /* nsIRequest asyncCheckURI (in AUTF8String uri, in nsIRequestObserver aObserver, in nsISupports aCtxt, in nsLoadFlags aLoadFlags); */
  NS_IMETHOD AsyncCheckURI(const nsACString & uri, nsIRequestObserver *aObserver, nsISupports *aCtxt, nsLoadFlags aLoadFlags, nsIRequest **_retval) = 0;

  /* readonly attribute nsIRequest baseRequest; */
  NS_IMETHOD GetBaseRequest(nsIRequest * *aBaseRequest) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIURICHECKER \
  NS_IMETHOD AsyncCheckURI(const nsACString & uri, nsIRequestObserver *aObserver, nsISupports *aCtxt, nsLoadFlags aLoadFlags, nsIRequest **_retval); \
  NS_IMETHOD GetBaseRequest(nsIRequest * *aBaseRequest); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIURICHECKER(_to) \
  NS_IMETHOD AsyncCheckURI(const nsACString & uri, nsIRequestObserver *aObserver, nsISupports *aCtxt, nsLoadFlags aLoadFlags, nsIRequest **_retval) { return _to AsyncCheckURI(uri, aObserver, aCtxt, aLoadFlags, _retval); } \
  NS_IMETHOD GetBaseRequest(nsIRequest * *aBaseRequest) { return _to GetBaseRequest(aBaseRequest); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIURICHECKER(_to) \
  NS_IMETHOD AsyncCheckURI(const nsACString & uri, nsIRequestObserver *aObserver, nsISupports *aCtxt, nsLoadFlags aLoadFlags, nsIRequest **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->AsyncCheckURI(uri, aObserver, aCtxt, aLoadFlags, _retval); } \
  NS_IMETHOD GetBaseRequest(nsIRequest * *aBaseRequest) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetBaseRequest(aBaseRequest); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsURIChecker : public nsIURIChecker
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIURICHECKER

  nsURIChecker();
  virtual ~nsURIChecker();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsURIChecker, nsIURIChecker)

nsURIChecker::nsURIChecker()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsURIChecker::~nsURIChecker()
{
  /* destructor code */
}

/* nsIRequest asyncCheckURI (in AUTF8String uri, in nsIRequestObserver aObserver, in nsISupports aCtxt, in nsLoadFlags aLoadFlags); */
NS_IMETHODIMP nsURIChecker::AsyncCheckURI(const nsACString & uri, nsIRequestObserver *aObserver, nsISupports *aCtxt, nsLoadFlags aLoadFlags, nsIRequest **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIRequest baseRequest; */
NS_IMETHODIMP nsURIChecker::GetBaseRequest(nsIRequest * *aBaseRequest)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIURIChecker_h__ */
