/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

public class HorizontalNumberAxis3D
extends HorizontalNumberAxis {
    public static final double DEFAULT_EFFECT_3D = 10.0;
    private double effect3d = 10.0;

    public HorizontalNumberAxis3D() {
        this(null);
    }

    public HorizontalNumberAxis3D(String string) {
        this(string, AxisConstants.DEFAULT_AXIS_LABEL_FONT, 0.0, 1.0);
        this.setAutoRangeAttribute(true);
    }

    public HorizontalNumberAxis3D(String string, Font font, double d, double d2) {
        this(string, font, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, false, true, AxisConstants.DEFAULT_TICK_STROKE, AxisConstants.DEFAULT_TICK_PAINT, false, ValueAxis.DEFAULT_AUTO_RANGE_MINIMUM_SIZE, true, true, d, d2, false, true, NumberAxis.DEFAULT_TICK_UNIT, true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, 0.0, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT, 10.0);
    }

    public HorizontalNumberAxis3D(String string, Font font, Paint paint, Insets insets, boolean bl, Font font2, Paint paint2, Insets insets2, boolean bl2, boolean bl3, Stroke stroke, Paint paint3, boolean bl4, Number number, boolean bl5, boolean bl6, double d, double d2, boolean bl7, boolean bl8, NumberTickUnit numberTickUnit, boolean bl9, Stroke stroke2, Paint paint4, double d3, boolean bl10, double d4, Stroke stroke3, Paint paint5, double d5) {
        super(string, font, paint, insets, bl, font2, paint2, insets2, bl2, bl3, stroke, paint3, bl4, number, bl5, bl6, d, d2, bl7, bl8, numberTickUnit, bl9, stroke2, paint4, d3, bl10, d4, stroke3, paint5);
        this.effect3d = d5;
    }

    public double getEffect3d() {
        return this.effect3d;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        float f;
        Object object;
        Object object2;
        if (this.label != null) {
            graphics2D.setFont(this.labelFont);
            graphics2D.setPaint(this.labelPaint);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            object2 = this.labelFont.getStringBounds(this.label, fontRenderContext);
            object = this.labelFont.getLineMetrics(this.label, fontRenderContext);
            f = (float)(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0 - ((RectangularShape)object2).getWidth() / 2.0);
            float f2 = (float)(rectangle2D.getMaxY() - (double)this.labelInsets.bottom - (double)((LineMetrics)object).getDescent() - (double)((LineMetrics)object).getLeading());
            graphics2D.drawString(this.label, f, f2);
        }
        this.refreshTicks(graphics2D, rectangle2D, rectangle2D2);
        float f3 = (float)rectangle2D2.getMaxY();
        graphics2D.setFont(this.getTickLabelFont());
        object2 = this.ticks.iterator();
        while (object2.hasNext()) {
            object = (Tick)object2.next();
            f = (float)this.translateValueToJava2D(((Tick)object).getNumericalValue(), rectangle2D2);
            if (this.tickLabelsVisible) {
                graphics2D.setPaint(this.tickLabelPaint);
                if (this.getVerticalTickLabels()) {
                    RefineryUtilities.drawRotatedString((String)((Tick)object).getText(), (Graphics2D)graphics2D, (float)((Tick)object).getX(), (float)((Tick)object).getY(), (double)-1.5707963267948966);
                } else {
                    graphics2D.drawString(((Tick)object).getText(), ((Tick)object).getX(), ((Tick)object).getY());
                }
            }
            if (this.tickMarksVisible) {
                graphics2D.setStroke(this.getTickMarkStroke());
                graphics2D.setPaint(this.getTickMarkPaint());
                Line2D.Float float_ = new Line2D.Float(f, f3 - 2.0f, f, f3 + 2.0f);
                graphics2D.draw(float_);
            }
            if (!this.isGridLinesVisible()) continue;
            graphics2D.setStroke(this.getGridStroke());
            graphics2D.setPaint(this.getGridPaint());
            Line2D.Double double_ = new Line2D.Double((double)f + this.effect3d, rectangle2D2.getMaxY() - this.effect3d, (double)f + this.effect3d, rectangle2D2.getMinY() - this.effect3d);
            graphics2D.draw(double_);
            Line2D.Double double_2 = new Line2D.Double(f, rectangle2D2.getMaxY(), (double)f + this.effect3d, rectangle2D2.getMaxY() - this.effect3d);
            graphics2D.draw(double_2);
        }
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D) {
        double d = 0.0;
        if (this.label != null) {
            LineMetrics lineMetrics = this.labelFont.getLineMetrics(this.label, graphics2D.getFontRenderContext());
            d = (float)this.labelInsets.top + lineMetrics.getHeight() + (float)this.labelInsets.bottom;
        }
        double d2 = this.tickLabelInsets.top + this.tickLabelInsets.bottom;
        if (this.tickLabelsVisible) {
            graphics2D.setFont(this.tickLabelFont);
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D);
            d2 += this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.getVerticalTickLabels());
        }
        return d + d2;
    }

    public Rectangle2D reserveAxisArea(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, double d) {
        double d2 = 0.0;
        if (this.label != null) {
            LineMetrics lineMetrics = this.labelFont.getLineMetrics(this.label, graphics2D.getFontRenderContext());
            d2 = (float)this.labelInsets.top + lineMetrics.getHeight() + (float)this.labelInsets.bottom;
        }
        double d3 = this.tickLabelInsets.top + this.tickLabelInsets.bottom;
        if (this.tickLabelsVisible) {
            graphics2D.setFont(this.tickLabelFont);
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D);
            d3 += this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.getVerticalTickLabels());
        }
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getMaxY(), rectangle2D.getWidth() - d, d2 + d3);
    }

    private double getMaxTickLabelHeight(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = 0.0;
        if (bl) {
            Iterator iterator = this.ticks.iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D rectangle2D2 = font.getStringBounds(tick.getText(), fontRenderContext);
                if (!(rectangle2D2.getWidth() > d)) continue;
                d = rectangle2D2.getWidth();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("Sample", fontRenderContext);
            d = lineMetrics.getHeight();
        }
        return d;
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof HorizontalValuePlot;
    }
}

