/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.SeriesChangeEvent;
import com.jrefinery.data.SeriesChangeListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Series
implements Cloneable {
    private String name;
    private String description;
    private List listeners;
    private PropertyChangeSupport propertyChangeSupport;

    protected Series(String string) {
        this(string, null);
    }

    protected Series(String string, String string2) {
        this.name = string;
        this.description = string2;
        this.listeners = new ArrayList();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        this.propertyChangeSupport.firePropertyChange("Name", string2, string);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        this.propertyChangeSupport.firePropertyChange("Description", string2, string);
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Series.clone(): unexpected exception.");
        }
        Series series = (Series)object;
        series.listeners = new ArrayList();
        series.propertyChangeSupport = new PropertyChangeSupport(series);
        return series;
    }

    public void addChangeListener(SeriesChangeListener seriesChangeListener) {
        this.listeners.add(seriesChangeListener);
    }

    public void removeChangeListener(SeriesChangeListener seriesChangeListener) {
        this.listeners.remove(seriesChangeListener);
    }

    public void fireSeriesChanged() {
        this.notifyListeners(new SeriesChangeEvent(this));
    }

    protected void notifyListeners(SeriesChangeEvent seriesChangeEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            SeriesChangeListener seriesChangeListener = (SeriesChangeListener)iterator.next();
            seriesChangeListener.seriesChanged(seriesChangeEvent);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }
}

