/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.EditorKit;
import org.netbeans.modules.jarpackager.ArchiveDescriptor;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ManifestTab
extends JPanel
implements PropertyEditor {
    private JScrollPane jScrollPane1;
    private JEditorPane manifestPane;
    private JPanel featuresPanel;
    private JButton loadButton;
    private JPanel generationPanel;
    private JComboBox generationComboBox;
    private JButton generateButton;
    private static File lastManifestFolder = null;
    private Manifest manifest;
    private PropertyChangeSupport support;
    private boolean editorKitInitialized;
    private DefaultComboBoxModel model;
    BasicAttributesGenerator baGen;
    private static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$JarPackagerModule == null ? (class$org$netbeans$modules$jarpackager$JarPackagerModule = ManifestTab.class$("org.netbeans.modules.jarpackager.JarPackagerModule")) : class$org$netbeans$modules$jarpackager$JarPackagerModule));
    public static final String SPECIFIED_BY = new String("Specified-By");
    private boolean isValid = true;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$ManifestTab;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarPackagerModule;

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.manifestPane = new JEditorPane();
        this.featuresPanel = new JPanel();
        this.loadButton = new JButton();
        this.generationPanel = new JPanel();
        this.generationComboBox = new JComboBox();
        this.generateButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(418, 200));
        this.jScrollPane1.setMinimumSize(new Dimension(418, 200));
        this.manifestPane.setPreferredSize(new Dimension(400, 200));
        this.manifestPane.setMinimumSize(new Dimension(400, 200));
        this.manifestPane.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ManifestTab.this.manifestPaneFocusLost(focusEvent);
            }
        });
        this.manifestPane.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ManifestTab.this.manifestPaneKeyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                ManifestTab.this.manifestPaneKeyReleased(keyEvent);
            }
        });
        this.manifestPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ManifestTab.this.manifestPanePropertyChange(propertyChangeEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.manifestPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.featuresPanel.setLayout(new GridBagLayout());
        this.loadButton.setToolTipText(bundle.getString("CTL_LoadManifestTip"));
        this.loadButton.setText(bundle.getString("CTL_LoadManifest"));
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManifestTab.this.loadButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.weightx = 1.0;
        this.featuresPanel.add((Component)this.loadButton, gridBagConstraints2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 2.0;
        this.add((Component)this.featuresPanel, gridBagConstraints);
        this.generationPanel.setLayout(new GridBagLayout());
        this.generationPanel.setBorder(new CompoundBorder(new TitledBorder("Content Generation"), new EmptyBorder(new Insets(0, 5, 4, 5))));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 8);
        gridBagConstraints3.weightx = 1.0;
        this.generationPanel.add((Component)this.generationComboBox, gridBagConstraints3);
        this.generateButton.setToolTipText(bundle.getString("CTL_GenerationButtonTip"));
        this.generateButton.setText(bundle.getString("CTL_GenerationButton"));
        this.generateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManifestTab.this.generateButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        this.generationPanel.add((Component)this.generateButton, gridBagConstraints3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.generationPanel, gridBagConstraints);
    }

    private void manifestPanePropertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private void manifestPaneFocusLost(FocusEvent focusEvent) {
        try {
            this.updateValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void manifestPaneKeyPressed(KeyEvent keyEvent) {
    }

    private void manifestPaneKeyReleased(KeyEvent keyEvent) {
        this.checkValid();
    }

    private void generateButtonActionPerformed(ActionEvent actionEvent) {
        Generator generator = (Generator)this.generationComboBox.getSelectedItem();
        if (generator == null) {
            return;
        }
        generator.generate(this.manifest);
        this.setValue(this.manifest);
        this.checkValid();
    }

    private void loadButtonActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new MfFileFilter());
        if (lastManifestFolder != null) {
            jFileChooser.setCurrentDirectory(lastManifestFolder);
        }
        jFileChooser.setDialogTitle(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("CTL_LoadManifestTitle"));
        if (jFileChooser.showDialog(TopManager.getDefault().getWindowManager().getMainWindow(), NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("CTL_BrowseOk")) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            lastManifestFolder = jFileChooser.getCurrentDirectory();
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                try {
                    this.setValue(new Manifest(bufferedInputStream));
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    bufferedInputStream.close();
                    this.checkValid();
                    throw throwable;
                }
                bufferedInputStream.close();
                this.checkValid();
                {
                }
            }
            catch (IOException iOException) {
                ErrorManager errorManager = TopManager.getDefault().getErrorManager();
                errorManager.notify(65536, errorManager.annotate((Throwable)iOException, NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("MSG_LoadManifestError")));
            }
        }
    }

    public ManifestTab() {
        this.initComponents();
        this.additionalInitialization();
        HelpCtx.setHelpIDString((JComponent)this, (String)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab).getName());
    }

    public void setJarContentFile(String string) {
        if (this.baGen != null) {
            this.baGen.setJarContentFile(string);
        }
    }

    private void additionalInitialization() {
        this.generationPanel.setBorder(new CompoundBorder(new TitledBorder(NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("CTL_GenerationBorder")), new EmptyBorder(new Insets(0, 5, 4, 5))));
        this.model = new DefaultComboBoxModel();
        this.baGen = new BasicAttributesGenerator();
        this.model.addElement(this.baGen);
        this.generationComboBox.setModel(this.model);
        this.initContentType();
    }

    public void readSettings(ArchiveDescriptor archiveDescriptor) throws IOException {
        this.doSetValue(archiveDescriptor.getManifest());
        this.updateGui(this.manifest);
    }

    public void storeSettings(ArchiveDescriptor archiveDescriptor) throws IOException {
        this.updateValue();
        archiveDescriptor.setManifest(this.manifest);
        this.support().firePropertyChange("", null, null);
    }

    public Component getComponent() {
        return this;
    }

    public String getName() {
        return "manifestTab";
    }

    public String getDisplayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("CTL_ManifestTab");
    }

    public String getShortDescription() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("HINT_ManifestTab");
    }

    public String getJavaInitializationString() {
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String[] getTags() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support().addPropertyChangeListener(propertyChangeListener);
    }

    public void setValue(Object object) {
        try {
            this.doSetValue(object);
            this.updateGui(object);
        }
        catch (IOException iOException) {
            ErrorManager errorManager = TopManager.getDefault().getErrorManager();
            errorManager.notify(16, errorManager.annotate((Throwable)iOException, NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("MSG_CanNotReadManifest")));
        }
    }

    public Object getValue() {
        return this.manifest;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public String getAsText() {
        Integer n = new Integer(this.manifest.getMainAttributes().size());
        Integer n2 = new Integer(this.manifest.getEntries().size());
        return MessageFormat.format(bundle.getString("FMT_ManifestSize"), n, n2);
    }

    private PropertyChangeSupport support() {
        if (this.support == null) {
            this.support = new PropertyChangeSupport(this);
        }
        return this.support;
    }

    void updateValue() throws IOException {
        this.doSetValue(this.makeManifest());
    }

    public boolean isValid() {
        return this.isValid;
    }

    private boolean checkValid() {
        boolean bl = true;
        try {
            this.makeManifest();
        }
        catch (IOException iOException) {
            bl = false;
        }
        if (this.isValid != bl) {
            this.isValid = bl;
            this.support().firePropertyChange("propertyValueValid", !this.isValid, this.isValid);
        }
        return this.isValid;
    }

    private Manifest makeManifest() throws IOException {
        byte[] byArray = this.manifestPane.getText().getBytes();
        TerminateLineInputStream terminateLineInputStream = new TerminateLineInputStream(new ByteArrayInputStream(byArray));
        return new Manifest(terminateLineInputStream);
    }

    void doSetValue(Object object) {
        if (!(object instanceof Manifest)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.manifest = (Manifest)object;
        this.support().firePropertyChange("", null, null);
    }

    void updateGui(Object object) throws IOException {
        Manifest manifest = (Manifest)object;
        this.manifestPane.setText("");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            manifest.write(byteArrayOutputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            byteArrayOutputStream.close();
            throw throwable;
        }
        byteArrayOutputStream.close();
        this.manifestPane.setText(byteArrayOutputStream.toString().trim());
        this.manifestPane.requestFocus();
    }

    String readManifestFile(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string).append("\n");
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    void initContentType() {
        EditorKit editorKit = this.manifestPane.getEditorKitForContentType("text/plain");
        if (editorKit != null) {
            String string = this.manifestPane.getText();
            this.manifestPane.setContentType("text/plain");
            this.manifestPane.setEditorKit(editorKit);
            this.manifestPane.setText(string);
        }
    }

    static void completeMainAttributes(Attributes attributes, String string) {
        Attributes.Name name;
        Attributes.Name name2;
        if (attributes.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        if (attributes.getValue(name2 = new Attributes.Name("Created-By")) == null) {
            attributes.put(name2, NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = ManifestTab.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("CTL_IDEName"));
        }
        if (string != null && attributes.getValue(name = new Attributes.Name(SPECIFIED_BY)) == null) {
            attributes.put(name, string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class TerminateLineInputStream
    extends FilterInputStream {
        byte last = 0;
        boolean terminated = true;

        TerminateLineInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public int read() throws IOException {
            int n = this.in.read();
            if (n < 0) {
                if (this.last == 10 || this.terminated) {
                    return n;
                }
                this.terminated = true;
                return 10;
            }
            this.terminated = false;
            this.last = (byte)n;
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 < 0) {
                if (this.last == 10 || this.terminated) {
                    return n3;
                }
                byArray[n] = 10;
                this.terminated = true;
                return 1;
            }
            if (n3 > 0) {
                this.terminated = false;
                this.last = byArray[n + n3 - 1];
            }
            return n3;
        }
    }

    static final class BasicAttributesGenerator
    implements Generator {
        private String jarContentFile;
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$ManifestTab;

        BasicAttributesGenerator() {
        }

        public void setJarContentFile(String string) {
            this.jarContentFile = string;
        }

        public void generate(Manifest manifest) {
            ManifestTab.completeMainAttributes(manifest.getMainAttributes(), this.jarContentFile);
        }

        public String getDisplayName() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = BasicAttributesGenerator.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("CTL_BasicAttributes");
        }

        public String getShortDescription() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = BasicAttributesGenerator.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("CTL_BasicAttributesTip");
        }

        public String toString() {
            return this.getDisplayName();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static interface Generator {
        public void generate(Manifest var1);

        public String getDisplayName();

        public String getShortDescription();
    }

    static final class MfFileFilter
    extends FileFilter {
        static /* synthetic */ Class class$org$netbeans$modules$jarpackager$ManifestTab;

        MfFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".mf") || file.getName().endsWith(".txt") || file.getName().endsWith(".MF");
        }

        public String getDescription() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$jarpackager$ManifestTab == null ? (class$org$netbeans$modules$jarpackager$ManifestTab = MfFileFilter.class$("org.netbeans.modules.jarpackager.ManifestTab")) : class$org$netbeans$modules$jarpackager$ManifestTab)).getString("CTL_MfFiles");
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

