/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotUndoException;
import org.openide.ErrorManager;
import org.openide.actions.ActionConstants;
import org.openide.actions.RedoAction;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListener;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class UndoAction
extends CallableSystemAction {
    static final long serialVersionUID = -2762036372802427913L;
    private static Listener listener;
    private static UndoRedo last;
    private static UndoAction undoAction;
    private static RedoAction redoAction;
    static /* synthetic */ Class class$org$openide$actions$UndoAction;
    static /* synthetic */ Class class$org$openide$actions$RedoAction;

    public boolean isEnabled() {
        UndoAction.initializeUndoRedo();
        return super.isEnabled();
    }

    static synchronized void initializeUndoRedo() {
        if (listener != null) {
            return;
        }
        listener = new Listener();
        TopComponent.Registry registry = WindowManager.getDefault().getRegistry();
        registry.addPropertyChangeListener(WeakListener.propertyChange(listener, registry));
        last = UndoAction.getUndoRedo();
        last.addChangeListener(listener);
        UndoAction.updateStatus();
    }

    static synchronized void updateStatus() {
        if (undoAction == null) {
            undoAction = (UndoAction)SharedClassObject.findObject(class$org$openide$actions$UndoAction == null ? (class$org$openide$actions$UndoAction = UndoAction.class$("org.openide.actions.UndoAction")) : class$org$openide$actions$UndoAction, false);
        }
        if (redoAction == null) {
            redoAction = (RedoAction)SharedClassObject.findObject(class$org$openide$actions$RedoAction == null ? (class$org$openide$actions$RedoAction = UndoAction.class$("org.openide.actions.RedoAction")) : class$org$openide$actions$RedoAction, false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UndoRedo undoRedo = UndoAction.getUndoRedo();
                if (undoAction != null) {
                    undoAction.setEnabled(undoRedo.canUndo());
                }
                if (redoAction != null) {
                    redoAction.setEnabled(undoRedo.canRedo());
                }
            }
        });
    }

    static UndoRedo getUndoRedo() {
        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
        return topComponent == null ? UndoRedo.NONE : topComponent.getUndoRedo();
    }

    public String getName() {
        MessageFormat messageFormat = new MessageFormat(ActionConstants.BUNDLE.getString("Undo"));
        return messageFormat.format(new String[]{UndoAction.getUndoRedo().getUndoPresentationName()});
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$UndoAction == null ? (class$org$openide$actions$UndoAction = UndoAction.class$("org.openide.actions.UndoAction")) : class$org$openide$actions$UndoAction);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/undo.gif";
    }

    public void performAction() {
        try {
            UndoRedo undoRedo = UndoAction.getUndoRedo();
            if (undoRedo.canUndo()) {
                undoRedo.undo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
            ErrorManager.getDefault().notify(cannotUndoException);
        }
        UndoAction.updateStatus();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        last = UndoRedo.NONE;
        undoAction = null;
        redoAction = null;
    }

    private static final class Listener
    implements PropertyChangeListener,
    ChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            UndoAction.updateStatus();
            last.removeChangeListener(this);
            last = UndoAction.getUndoRedo();
            last.addChangeListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            UndoAction.updateStatus();
        }
    }
}

