.\" $NCDId: @(#)AuSRecTB.man,v 1.2 1995/05/23 23:53:05 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id: AuSRecTB.man,v 1.1.1.1 1999/05/08 18:47:27 jon Exp $
.TH AuSoundRecordToBucket 3 "1.2" "soundlib"
.SH \fBName\fP
\fBAuSoundRecordToBucket\fP \- create a flow to record to a bucket.
.SH \fBSynopsis\fP
#include <audio/audiolib.h>
.br
#include <audio/soundlib.h>
.sp 1
\fBAuEventHandlerRec\fP *\fBAuSoundRecordToBucket\fP(\fIserver\fP, \fIdestination\fP, \fIsource\fP, \fIgain\fP, \fIcallback\fP, \fIcallback_data\fP, \fImode\fP, \fIflow\fP, \fIvolume_mult_elem\fP, \fIstatus\fP)
.br
    \fBAuServer\fP *\fIserver\fP;
.br
    \fBAuBucketID\fP \fIdestination\fP;
.br
    \fBAuDeviceID\fP \fIsource\fP;
.br
    \fBAuFixedPoint\fP \fIgain\fP;
.br
    void (*\fIcallback\fP) (\fBAuServer\fP *, \fBAuEventHandlerRec\fP *, \fBAuEvent\fP *, \fBAuPointer\fP);
.br
    \fBAuPointer\fP \fIcallback_data\fP;
.br
    int \fImode\fP;
.br
    \fBAuFlowID\fP *\fIflow\fP; /* \fBRETURN\fP */
.br
    int *\fIvolume_mult_elem\fP; /* \fBRETURN\fP */
.br
    \fBAuStatus\fP *\fIstatus\fP; /* \fBRETURN\fP */
.SH \fBArguments\fP
.IP \fIserver\fP 1i
Specifies the connection to the audio server.
.IP \fIdestination\fP 1i
Specifies the bucket to record to.
.IP \fIsource\fP 1i
Specifies the input device to record from.
.IP \fIgain\fP 1i
Specifies the gain for the input device.
.IP \fIcallback\fP 1i
Specifies the procedure to be called for additional event processing.
.IP \fIcallback_data\fP 1i
Specifies any additional arguments to be passed to the callback.
.IP \fImode\fP 1i
Specifies the line mode for the input device.
Currently the following line modes are defined: \fBAuDeviceInputModeNone\fP, \fBAuDeviceInputModeLineIn\fP, \fBAuDeviceInputModeMicrophone\fP.
.IP \fIflow\fP 1i
If non-NULL, returns the flow ID.
.IP \fIvolume_mult_elem\fP 1i
According to the comment in the source, not implemented.
.IP \fIstatus\fP 1i
If non-NULL, flush the output buffer and return the status from the server.
.SH \fBDescription\fP
\fBAuSoundRecordToBucket\fP creates a flow to record from \fIsource\fP into \fIdestination\fP and returns a pointer to the event handler created or NULL if there was an error.
.SH \fBErrors\fP
\fBAuBadBucket\fP,
\fBAuBadDevice\fP.
.SH \fBSee Also\fP
\fBAuSoundRecord\fP,
\fBAuSoundRecordToData\fP,
\fBAuSoundRecordToFile\fP,
\fBAuSoundRecordToFileN\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
