/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Rotation.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 13:29:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_chart2.hxx"

#include "Rotation.hxx"

#ifndef INCLUDED_RTL_MATH_HXX
#include <rtl/math.hxx>
#endif

//.............................................................................
namespace chart
{
//.............................................................................
using namespace ::com::sun::star;

Matrix4D Rotation::getRotationMatrixFromAxisAngleRepresentation( const drawing::Direction3D& rAxis, double fAngleDegree )
{
    double fAnglePi = fAngleDegree*(F_PI/180.0);
    double x=rAxis.DirectionX;
    double y=rAxis.DirectionY;
    double z=rAxis.DirectionZ;
    double c =rtl::math::cos(fAnglePi);
    double s =rtl::math::sin(fAnglePi);
    double t =1 - c;

    Matrix4D aR;
    aR[0][0]=t*x*x + c;
    aR[1][0]=t*x*y - z*s;
    aR[2][0]=t*x*z + y*s;
    aR[3][0]=0.0;

    aR[0][1]=t*x*y + z*s;
    aR[1][1]=t*y*y + c;
    aR[2][1]=t*y*z - x*s;
    aR[3][1]=0.0;

    aR[0][2]=t*x*z - y*s;
    aR[1][2]=t*y*z + x*s;
    aR[2][2]=t*z*z + c;
    aR[3][2]=0.0;

    aR[0][3]=aR[1][3]=aR[2][3]=0.0;
    aR[3][3]=1.0;

    return aR;
}

void Rotation::getRotationAxisAngleFromMatrixRepresentation( drawing::Direction3D& rAxis, double& fAngleDegree, const Matrix4D& rMatrix )
{
    fAngleDegree = acos((rMatrix[0][0] + rMatrix[1][1] + rMatrix[2][2] - 1.0)/2.0) * (180.0/F_PI);

    double d0= rMatrix[1][2]-rMatrix[2][1];
    double d1= rMatrix[2][0]-rMatrix[0][2];
    double d2= rMatrix[0][1]-rMatrix[1][0];
    double fDenominator= ::sqrt( (d0*d0+d1*d1+d2*d2) );

    if(fDenominator!=0.0)
    {
        rAxis.DirectionX = (rMatrix[1][2] - rMatrix[2][1])/ fDenominator;
        rAxis.DirectionY = (rMatrix[2][0] - rMatrix[0][2])/ fDenominator;
        rAxis.DirectionZ = (rMatrix[0][1] - rMatrix[1][0])/ fDenominator;
    }
    else
    {
        rAxis = drawing::Direction3D(0.0,1.0,0.0);
    }
}

void Rotation::getEulerFromAxisAngleRepresentation( const drawing::Direction3D& rAxis, double fAngleDegree
                        , double& fXAngle, double& fYAngle, double& fZAngle )
{
    double fAnglePi = fAngleDegree*(F_PI/180.0);
    double x=rAxis.DirectionZ;
    double y=rAxis.DirectionY;
    double z=rAxis.DirectionX;
    double c =rtl::math::cos(fAnglePi);
    double s =rtl::math::sin(fAnglePi);
    double t =1 - c;

    fXAngle = -(180.0/F_PI) * atan( (x * y * t + z * s) / (1 - (y*y + z*z) * t) );
    fZAngle = -(180.0/F_PI) * atan( (y * z * t + x * s) / (1 - (x*x + y*z) * t) );
    fYAngle = -(180.0/F_PI) * asin(-(x * z * t - y * s) );
}

void Rotation::getAxisAngleFromEulerRepresentation( drawing::Direction3D& rAxis, double& fAngleDegree
                        , double fXAngle, double fYAngle, double fZAngle )
{
    double c1 = cos(-(F_PI/180.0)*fZAngle/2);
    double c2 = cos(-(F_PI/180.0)*fYAngle/2);
    double c3 = cos(-(F_PI/180.0)*fXAngle/2);
    double s1 = sin(-(F_PI/180.0)*fZAngle/2);
    double s2 = sin(-(F_PI/180.0)*fYAngle/2);
    double s3 = sin(-(F_PI/180.0)*fXAngle/2);

    fAngleDegree = (180.0/F_PI)*2*acos(c1*c2*c3 + s1*s2*s3);
    rAxis.DirectionX = c1*c2*s3 - s1*s2*c3;
    rAxis.DirectionY = c1*s2*c3 + s1*c2*s3;
    rAxis.DirectionZ = s1*c2*c3 - c1*s2*s3;

    double fDenominator= ::sqrt( rAxis.DirectionX*rAxis.DirectionX
                       + rAxis.DirectionY*rAxis.DirectionY
                       + rAxis.DirectionZ*rAxis.DirectionZ );

    if(fDenominator!=0.0)
    {
        rAxis.DirectionX /= fDenominator;
        rAxis.DirectionY /= fDenominator;
        rAxis.DirectionZ /= fDenominator;
    }
    else
    {
        rAxis = drawing::Direction3D(0.0,1.0,0.0);
    }
}

//.............................................................................
} //namespace chart
//.............................................................................
