/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: types.cxx,v $
 *
 *  $Revision: 1.4.12.1 $
 *
 *  last change: $Author: rt $ $Date: 2006/11/03 11:34:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_configmgr.hxx"

#include "types.hxx"

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

#ifndef INCLUDED_STRING_H
#include <string.h>
#define INCLUDED_STRING_H
#endif

namespace configmgr
{
//-----------------------------------------------------------------------------	
    namespace sharable
    {
//-----------------------------------------------------------------------------	
//-----------------------------------------------------------------------------	
// for now, Name == String
//-----------------------------------------------------------------------------	

Name allocName(rtl::OUString const & _sString)
{
	rtl_uString_acquire(_sString.pData);
	return _sString.pData;
}
//-----------------------------------------------------------------------------	
// Name copyName(Allocator const& _anAllocator, Name _aName);
//-----------------------------------------------------------------------------	

void freeName(Name _aName)
{
	rtl_uString_release(_aName);
}

//-----------------------------------------------------------------------------	

::rtl::OUString readName(Name _aName)
{
	return rtl::OUString(_aName);
}

//-----------------------------------------------------------------------------	
//-----------------------------------------------------------------------------	

String allocString(rtl::OUString const & _sString)
{
	return allocName(_sString);
}

//-----------------------------------------------------------------------------	

void freeString(String _aString)
{
	return freeName(_aString);
}
//-----------------------------------------------------------------------------	

::rtl::OUString readString(String _aString)
{
	return readName(_aString);
}
//-----------------------------------------------------------------------------	
    }
//-----------------------------------------------------------------------------	
} // namespace
 
