/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: protchk.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 13:01:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_extensions.hxx"

#include <stdio.h>

#ifdef WNT
#include <regtools.hxx>
#endif

#include <vcl/svapp.hxx>
#include <vcl/wrkwin.hxx>
#include <tools/fsys.hxx>
#include <tools/resmgr.hxx>
#include <tools/string.hxx>

#ifndef _COM_SUN_STAR_INSTALLATION_XPROTOCOLHANDLERCHECK_HPP_
#include <com/sun/star/installation/XProtocolHandlerCheck.hpp>
#endif
#ifndef _COM_SUN_STAR_INSTALLATION_PROTOCOLS_HPP_
#include <com/sun/star/installation/protocols.hpp>
#endif
#ifndef _COM_SUN_STAR_INSTALLATION_PROTDLGRES_HPP_
#include <com/sun/star/installation/ProtDlgRes.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif

#ifndef _UNO_MAPPING_HXX_
#include <uno/mapping.hxx>
#endif

#ifndef _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif

#ifndef _CPPU_WEAK_HXX_
#include<cppuhelper/weak.hxx>
#endif

#include <vcl/svapp.hxx>

#ifdef OS2
#include <tools/svpm.h>
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

#include <rtl/string.hxx>
#include <rtl/ustring.hxx>

#include "protdlg.hxx"

#define PROTCHK_SERVICE_NAME "com.sun.star.installation.ProtCheck"
#define PROTCHK_IMPLEMENTATION_NAME "com.sun.star.installation.ProtCheck.V10"

using namespace ::osl;
using namespace ::rtl;
using namespace ::cppu;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::registry;
using namespace ::com::sun::star::installation;

class ProtocolHandlerCheck_Impl : public XProtocolHandlerCheck,
    public OWeakObject
{
private:
    OString appName;
#ifdef OS2
    char *appDir;
#endif
    ProtocolsSelectionDialog *dlg;
#ifdef WNT
    char regEntry[256], iconEntry[256];
#endif
    int notSetMask;
    sal_Bool setProt(char *name);
    sal_Bool checkProt(char *name);
public:
// --- XInterface ------------------------------------------------------------
    virtual Any SAL_CALL queryInterface(const Type& aType)
        throw(RuntimeException);
    virtual void SAL_CALL acquire() throw(RuntimeException)
      { OWeakObject::acquire(); }
    virtual void SAL_CALL release() throw(RuntimeException)
      { OWeakObject::release(); }
// --- XProtocolHandlerCheck -------------------------------------------------
    ProtocolHandlerCheck_Impl::ProtocolHandlerCheck_Impl(
      const Reference<XMultiServiceFactory> &xServiceMgr);
    ProtocolHandlerCheck_Impl::~ProtocolHandlerCheck_Impl();
    virtual sal_Bool SAL_CALL isSingleSettingAvailable(void)
        throw(RuntimeException);
    virtual sal_Bool SAL_CALL isProtocolHandler(sal_Int16 nWhich)
        throw(RuntimeException);
    virtual sal_Bool SAL_CALL setProtocolHandler(sal_Int16 nWhich)
        throw(RuntimeException);
    virtual ProtDlgRes SAL_CALL checkProtocolHandler(sal_Int16 nWhich)
        throw(RuntimeException);
};

// ###########################################################################
// ### implementation ########################################################
// ###########################################################################

// --- XInterface ------------------------------------------------------------
Any SAL_CALL ProtocolHandlerCheck_Impl::queryInterface(const Type& aType)
  throw(RuntimeException)
{
    Any aRet = ::cppu::queryInterface(aType,
      static_cast<XProtocolHandlerCheck *> (this));
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface(aType);
}

// --- XProtocolHandlerCheck -------------------------------------------------
ProtocolHandlerCheck_Impl::ProtocolHandlerCheck_Impl(
  const Reference<XMultiServiceFactory> &xServiceMgr)
{
    appName = OUStringToOString(Application::GetAppFileName(), osl_getThreadTextEncoding());
#ifdef OS2
    int i = strlen(appName.getStr()) - 1;
    while ((i > 0) && (appName.getStr()[i] != '\\')) i--;
    if (i > 0)
    {
        appDir = new char[i + 1];
        strncpy(appDir, appName.getStr(), i);
        appDir[i] = 0;
    }
    else
    {
        appDir = new char[1];
        appDir[0] = 0;
    }
#endif
#ifdef WNT
    sprintf(regEntry, "\"%s\" \"%%1\"", appName.getStr());
    sprintf(iconEntry, "%s, 0", appName.getStr());
#endif
}

ProtocolHandlerCheck_Impl::~ProtocolHandlerCheck_Impl()
{
}

sal_Bool ProtocolHandlerCheck_Impl::isSingleSettingAvailable(void)
{
#ifdef WNT
    return sal_True;
#endif
#ifdef OS2
    return sal_False;
#endif
}


sal_Bool ProtocolHandlerCheck_Impl::checkProt(char *name)
{
#ifdef WNT
    sal_Bool result = sal_False;
    OString pName(name);
    pName += "\\shell\\open\\command";
    HKEY command;
    
    if (getRegKey(HKEY_CLASSES_ROOT, pName, command))
    {
        OString cmdDefault;
        if (getRegSTRING(command, "", cmdDefault))
        {
            if (stricmp(regEntry, cmdDefault.getStr()) == 0)
            {
                HKEY ddeExec;
                OString ddeName(name);
                ddeName += "\\shell\\open\\ddeexec";
                if (getRegKey(HKEY_CLASSES_ROOT, ddeName, ddeExec))
                    RegCloseKey(ddeExec);
                else result = sal_True;
            }
        }
        RegCloseKey(command);
    }
    return result;
#endif
#ifdef OS2
    char szBuffer[256];
    sal_uInt32 ulBytes = PrfQueryProfileString(HINI_PROFILE,
      "WPURLDEFAULTSETTINGS", "DefaultBrowserExe", NULL, szBuffer, 256);
    if (ulBytes) return (stricmp(szBuffer, appName) == 0);
    return sal_False;
#endif
}

sal_Bool ProtocolHandlerCheck_Impl::isProtocolHandler(sal_Int16 nWhich)
  throw(RuntimeException)
{
    switch (nWhich)
    {
    case protocols::ALL:
        {
            sal_Bool isStd = sal_True;
            for (sal_Int16 i = protocols::HTTP; (i <= protocols::NEWS)
                 && isStd; i++) if (!isProtocolHandler(i)) isStd = sal_False;
            return isStd;
        }
    case protocols::HTTP:
        {
            return checkProt("http");
        }
    case protocols::FTP:
        {
            return checkProt("ftp");
        }
    case protocols::HTTPS:
        {
            return true; // #66403# Zeile neu
//            return checkProt("https");
        }
    case protocols::MAIL:
        {
            return checkProt("mailto");
        }
    case protocols::NEWS:
        {
            return checkProt("news");
        }
    };
    return sal_False;
}

sal_Bool ProtocolHandlerCheck_Impl::setProt(char *name)
{
#ifdef WNT
    char open[256]; sprintf(open, "%s\\shell\\open", name);
    char cmd[256];  sprintf(cmd,  "%s\\command", open);
    char icon[256]; sprintf(icon, "%s\\DefaultIcon", name);
    char leer[1]; leer[0] = 0;
    DWORD editFlags = 2;
    OString prot = "URL:";
    prot += name;
    prot = prot.toAsciiUpperCase();
    prot += " Protocol";

    sal_Bool result = sal_False;
    if (!createRegKey(HKEY_CLASSES_ROOT, open, "command")) goto error;
    if (!setRegValue(HKEY_CLASSES_ROOT, cmd, leer, regEntry)) goto error;
    if (!delRegKey(HKEY_CLASSES_ROOT, open, "ddeexec")) goto error;


    setRegValue(HKEY_CLASSES_ROOT, name, leer, prot.getStr());
    setRegValue(HKEY_CLASSES_ROOT, name, "URL Protocol", "");
    setRegBINARY(HKEY_CLASSES_ROOT, name, "EditFlags", &editFlags,
                 sizeof(editFlags));

    createRegKey(HKEY_CLASSES_ROOT, name, "DefaultIcon");
    setRegValue(HKEY_CLASSES_ROOT, icon, leer, iconEntry);
    SHChangeNotify(SHCNE_ASSOCCHANGED, SHCNF_IDLIST, 0, 0);
    result = sal_True;
error:
    return result;
#endif
#ifdef OS2
    CHAR szBuffer[2048];
    sal_Bool rc;
    HOBJECT hObject;

    sprintf(szBuffer,
            "DEFAULTBROWSER=%s;DEFAULTPARAMETERS=;DEFAULTWORKINGDIR=%s",
            appName, appDir);

    hObject = WinCreateObject("WPUrl", "", szBuffer, "<WP_NOWHERE>", 0);

    if(hObject)
        WinDestroyObject(hObject);

    rc = hObject;
    rc &= PrfWriteProfileString(HINI_PROFILE, "WPURLDEFAULTSETTINGS",
                                "DefaultBrowserExe", appName);
    rc &= PrfWriteProfileString(HINI_PROFILE, "WPURLDEFAULTSETTINGS",
                                "DefaultParameters", "");
    rc &= PrfWriteProfileString(HINI_PROFILE, "WPURLDEFAULTSETTINGS",
                                "DefaultWorkingDir", appDir);
    return rc;
#endif
}

sal_Bool ProtocolHandlerCheck_Impl::setProtocolHandler(sal_Int16 nWhich)
  throw(RuntimeException)
{
    switch (nWhich)
    {
    case protocols::ALL:
        {
            sal_Bool setStd = sal_True;
            for (sal_Int16 i = protocols::HTTP; i <= protocols::NEWS; i++)
                if (!setProtocolHandler(i)) setStd = sal_False;
            return setStd;
        }
    case protocols::HTTP:
        {
            return setProt("http");
        }
    case protocols::FTP:
        {
            return setProt("ftp");
        }
    case protocols::HTTPS:
        {
            // #66403# eigentlich return setProt("https");
            return true;
        }
    case protocols::MAIL:
        {
            return setProt("mailto");
        }
    case protocols::NEWS:
        {
            return setProt("news");
        }
    default:
        {
            return sal_False;
        }
    };
    return sal_False;
}

ProtDlgRes ProtocolHandlerCheck_Impl::checkProtocolHandler(sal_Int16 nWhich)
  throw(RuntimeException)
{
    switch (nWhich)
    {
    case protocols::ALL:
        {
            int solve[protCount], j = 0, i;
            notSetMask = 0;
            sal_Bool b = sal_True;
            for (i = protocols::HTTP; i <= protocols::NEWS; i++)
            {
                if (!isProtocolHandler(i))
                    if (i != protocols::HTTPS) // #66403# Zeile neu
                {
                    notSetMask |= (1 << (i - protocols::HTTP));
                    b = sal_False;
                }
            }
            if (b) return ProtDlgRes_NOCHANGE;

            OString aResFileName("opc");
            aResFileName += MAKE_NUMSTR(SUPD);
            ResMgr* pResMgr = ResMgr::CreateResMgr(aResFileName.getStr());
            ProtocolsSelectionDialog dlg(NULL, pResMgr);

            OUString strs[protCount];
            strs[0] = dlg.maHttp; strs[1] = dlg.maFtp;  strs[2] = dlg.maHttps;
            strs[3] = dlg.maMail; strs[4] = dlg.maNews;
            dlg.maSelection.Clear();

            for (i = 0; i < protCount; i++)
            {
                if ((notSetMask & (1 << i)) != 0)
                {
                    dlg.maSelection.InsertEntry(strs[solve[j] = i]);
                    dlg.maSelection.CheckEntryPos(j);
                    j++;
                }
            }

            if (!dlg.Execute()) return ProtDlgRes_NOCHANGE;
            if (dlg.maStar.IsChecked())
            {
                int res = 0;
                for (i = 0; i < j; i++)
                {
                    if (dlg.maSelection.IsChecked(i)) res |= (1 << solve[i]);
                }

                for (sal_Int16 i = protocols::HTTP; i <= protocols::NEWS; i++)
                {
                    if ((res & (1 << (i - protocols::HTTP))) != 0)
                    {
                        setProtocolHandler(i);
                    }
                }
            }
            if (!dlg.maPerform.IsChecked()) return ProtDlgRes_CHECK;
            return ProtDlgRes_UNCHECK;
        }
    case protocols::HTTP:
    case protocols::FTP:
    case protocols::HTTPS:
    case protocols::MAIL:
    case protocols::NEWS:
        {
            if (nWhich == protocols::HTTPS)
                return ProtDlgRes_NOCHANGE; // #66403# Zeile neu
            if (isProtocolHandler(nWhich)) return ProtDlgRes_NOCHANGE;

            OString aResFileName("opc");
            aResFileName += MAKE_NUMSTR(SUPD);
            ResMgr* pResMgr = ResMgr::CreateResMgr(aResFileName.getStr());
            ProtocolsSelectionDialog dlg(NULL, pResMgr);

            if (!dlg.Execute()) return ProtDlgRes_NOCHANGE;
            setProtocolHandler(nWhich);
            if (dlg.maPerform.IsChecked()) return ProtDlgRes_CHECK;
            return ProtDlgRes_UNCHECK;
        }
    default:
        {
            return ProtDlgRes_NOCHANGE;
        }
    };
}

// --- statics ---------------------------------------------------------------
static OUString Protchk_getImplementationName()
{
	return OUString::createFromAscii(PROTCHK_IMPLEMENTATION_NAME);
}

static Sequence<OUString> Protchk_getSupportedServiceNames()
{
	OUString aName(OUString::createFromAscii(PROTCHK_SERVICE_NAME));
	Sequence<OUString> aSeq(&aName, 1);
	return aSeq;
}

static Reference<XInterface> SAL_CALL Protchk_createInstance(
	const Reference<XMultiServiceFactory> &rxManager)
{
	Reference<XInterface> xInst(
      SAL_STATIC_CAST(::cppu::OWeakObject *,
      new ProtocolHandlerCheck_Impl(rxManager)));
	return xInst;
}

static Reference<XSingleServiceFactory> Protchk_createServiceFactory(
	const Reference<XMultiServiceFactory> &rxManager)
{
	Reference<XSingleServiceFactory> xFactory
    (
		cppu::createSingleFactory
        (
			rxManager,
			Protchk_getImplementationName(),
			Protchk_createInstance,
            Protchk_getSupportedServiceNames()
        )
    );
	return xFactory;
}

//-----------------------------------------------------------------------
// registration
//-----------------------------------------------------------------------

extern "C"
{
	//-------------------------------------------------------------------
	// component_getImplementationEnvironment
	//-------------------------------------------------------------------

	void SAL_CALL component_getImplementationEnvironment( 
		const sal_Char** ppEnvTypeName, uno_Environment** ppEnv )
	{
		*ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
	}

	//-------------------------------------------------------------------
	// component_writeInfo
	//-------------------------------------------------------------------

	sal_Bool SAL_CALL component_writeInfo( void* pServiceManager, void* pRegistryKey )
	{
		sal_Bool bRet = sal_False;

		if ( pRegistryKey )
		{
			try
			{
				Reference< XRegistryKey > xNewRegKey( 
					reinterpret_cast< XRegistryKey* >( pRegistryKey )->createKey( 
					OUString::createFromAscii( "/" PROTCHK_IMPLEMENTATION_NAME "/UNO/SERVICES" ) ) );

				Sequence< OUString >& rSNL = Protchk_getSupportedServiceNames( );
				const OUString* pArray = rSNL.getConstArray( );
				for ( sal_Int32 i = rSNL.getLength( ); i--; /* empty */ )
					xNewRegKey->createKey( pArray[i] );

				bRet = sal_True;

			}
			catch( InvalidRegistryException& )
			{
				OSL_ENSURE( sal_False, "### InvalidRegistryException!" ); 
			}
		}

		return bRet;
	}	

	//-------------------------------------------------------------------
	// component_getFactory
	//-------------------------------------------------------------------

	void* SAL_CALL component_getFactory( 
		const sal_Char* pImplName, void* pServiceManager, void* pRegistryKey )
	{
		void* pRet = 0;

		if ( 0 == rtl_str_compare( pImplName, PROTCHK_IMPLEMENTATION_NAME ) )
		{
			Reference< XSingleServiceFactory > xFactory( createOneInstanceFactory(
				reinterpret_cast< XMultiServiceFactory* >( pServiceManager ), 
				OUString::createFromAscii( pImplName ),
				Protchk_createInstance, 
				Protchk_getSupportedServiceNames( ) ) );

			if ( xFactory.is( ) )
			{
				xFactory->acquire( );
				pRet = xFactory.get( );
			}
		}

		return pRet;
	}
	
} // extern "C"

