/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: filtercache.cxx,v $
 *
 *  $Revision: 1.52 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 13:46:05 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_framework.hxx"

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

// If you wish to enable this memory measure macros ... you need "windows.h"
// But it's not agood idea to include it in your header!!! Because it's not compatible to VCL header .-(
// So you must include it here ... in cxx, where you whish to use it.
#ifdef ENABLE_MEMORYMEASURE
    #define VCL_NEED_BASETSD
    #include <tools/presys.h>
    #include <windows.h>
    #include <tools/postsys.h>
    #undef  VCL_NEED_BASETSD
#endif

#ifndef __FRAMEWORK_MACROS_DEBUG_MEMORYMEASURE_HXX_
#include <macros/debug/memorymeasure.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_FILTERCACHE_HXX_
#include <classes/filtercache.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_WILDCARD_HXX_
#include <classes/wildcard.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_GENERIC_HXX_
#include <macros/generic.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_TRANSACTIONGUARD_HXX_
#include <threadhelp/transactionguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_WRITEGUARD_HXX_
#include <threadhelp/writeguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_READGUARD_HXX_
#include <threadhelp/readguard.hxx>
#endif

#ifndef __FRAMEWORK_FILTERFLAGS_H_
#include <filterflags.h>
#endif

#ifndef __FRAMEWORK_QUERIES_H_
#include <queries.h>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HPP_
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_XMULTIPROPERTYSET_HPP_
#include <com/sun/star/beans/XMultiPropertySet.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XCHANGESBATCH_HPP_
#include <com/sun/star/util/XChangesBatch.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XHIERARCHICALNAMEACCESS_HPP_
#include <com/sun/star/container/XHierarchicalNameAccess.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
#include <com/sun/star/container/XNameAccess.hpp>
#endif

//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#ifndef _UNOTOOLS_PROCESSFACTORY_HXX_
#include <unotools/processfactory.hxx>
#endif

#ifndef _UTL_CONFIGMGR_HXX_
#include <unotools/configmgr.hxx>
#endif

#ifndef _UTL_CONFIGPATHES_HXX_
#include <unotools/configpathes.hxx>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#include <algorithm>

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

using namespace ::utl						;
using namespace ::osl						;
using namespace ::rtl						;
using namespace ::std						;
using namespace ::comphelper				;
using namespace ::com::sun::star::uno		;
using namespace ::com::sun::star::registry	;
using namespace ::com::sun::star::lang		;
using namespace ::com::sun::star::beans		;
using namespace ::com::sun::star::container	;
using namespace ::com::sun::star::util		;

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported definitions
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

// initialize static member with default values!
sal_Int32           FilterCache::m_nRefCount            = 0                             ;
DataContainer*      FilterCache::m_pData                = NULL                          ;
sal_Int32           FilterCache::m_nVersion             = DEFAULT_FILTERCACHE_VERSION   ;
sal_Int16           FilterCache::m_nMode                = DEFAULT_FILTERCACHE_MODE      ;

/*-****************************************************************************************************//**
    @short      standard constructor
    @descr      This will initialize the cache automaticly ... but at first call only!
                These class use a refcount mechanism to share cache between different ownern.

    @attention  We must use a global lock instead of a normal one ... because we work on static member!

    @seealso    -

    @param      "nVersion"
    @return     -

    @onerror    An assertion is thrown and the cache will be empty!
                Method isValid() returns false then.
*//*-*****************************************************************************************************/

FilterCache::FilterCache( sal_Int32 nVersion ,
                          sal_Int16 nMode    )
	// initialize base classes first
    :   ThreadHelpBase  ()
    ,   TransactionBase ()
	// initialize member then
{
    // ------------------------------------------------------------------------------------------------------------
    // Global access, must be guarded (multithreading!).
	// We must protect our static member creation!
	// But we use a ref count mechanism too ...
    // This ctor can be called more then ones at same time!
    // What can we do?

    // We should set a write lock first (is an exclusiv lock!).
    // Nobody can disturb us then! Next we must look for current
    // working mode of our transaction manager (available by baseclass TransactionBase).
    // a)   If we detect an E_INIT we know => this is the first call.
    //      It's neccessary to fill our cache then an set working mode to E_WORK.
    //      The write lock blocks all further instances of this class due to
    //      we finished this fill-operation.
    // b)   If current working mode different from E_INIT, e.g. it's E_WORK ...
    //      then we must increase our ref count only. Cache was already initialized.
    // c)   Mode should never be E_BEFORECLOSE ... because this state is set by calling
    //      of our dtor. Of course - it could be that a new instance should be created during
    //      release of last instance ... but our dtor must set a write lock too!
    //      I think => it's enough to protect us against sharing of ctor/dtor ...
    // d)   But we can detect E_CLOSE as current working mode. This says: Last instance
    //      was gone sometimes before ... this is a new one ... we must fill our cache again.
    //      It's not a good idea to fill this cache more then ones during life time of our office
    //      ... but it could be :-( That's live! We should avoid this case by clever using of this class.

    WriteGuard aWriteLock( LockHelper::getGlobalLock() );

    // ------------------------------------------------------------------------------------------------------------
    // d)   We must change working mode to E_INIT if we detect E_CLOSE
    //      before we check for E_INIT ... because both modes must fill
    //      our cache. But it's not clever to write same code twice!
    if( TransactionManager::getGlobalTransactionManager().getWorkingMode() == E_CLOSE )
    {
        // Please make shure that no current transaction is active in THIS ctor metod!
        // Otherwise call of setWorkingMode() will block for waiting of that transaction ...
        TransactionManager::getGlobalTransactionManager().setWorkingMode( E_INIT );
    }

    // ------------------------------------------------------------------------------------------------------------
    // a,d) Don't combine it with scope before by using "else"!
    if( TransactionManager::getGlobalTransactionManager().getWorkingMode() == E_INIT )
    {
        RTL_LOGFILE_CONTEXT( aLog, "framework (as96863) ::FilterCache::FilterCache" );

        m_nVersion = nVersion         ;
        m_nMode    = nMode            ;
        m_pData    = new DataContainer;

        RTL_LOGFILE_CONTEXT_TRACE2( aLog, "{ creation ConfigItem [file=standard, version=%d, mode=%d]", m_nVersion, m_nMode );
            FilterCFGAccess aAccess( PACKAGENAME_TYPEDETECTION_STANDARD, m_nVersion, m_nMode );
        RTL_LOGFILE_CONTEXT_TRACE( aLog, "} creation ConfigItem" );

        RTL_LOGFILE_CONTEXT_TRACE( aLog, "{ reading TypeDetection.xml" );
            aAccess.read( *m_pData, DataContainer::E_ALL );
        RTL_LOGFILE_CONTEXT_TRACE( aLog, "} reading TypeDetection.xml" );

            m_pData->startListener();

        // Register this instance.
        ++m_nRefCount;

        // Don't forget to open object for further calls!
        TransactionManager::getGlobalTransactionManager().setWorkingMode( E_WORK );

        #ifdef ENABLE_COMPONENT_SELF_CHECK
        impldbg_dumpCache();
        #endif
    }
    else
    // ------------------------------------------------------------------------------------------------------------
    // b)
    if( TransactionManager::getGlobalTransactionManager().getWorkingMode() == E_WORK )
    {
        ++m_nRefCount;
    }
}

/*-****************************************************************************************************//**
    @short      debug function to print out the current content of this filter cache
    @descr      -
*//*-*****************************************************************************************************/
#ifdef ENABLE_COMPONENT_SELF_CHECK

void FilterCache::impldbg_dumpCache()
{
    ::rtl::OUStringBuffer sBuffer(10000);

    sBuffer.appendAscii("-------------------------------------------------------\n");
    sBuffer.appendAscii("content of preferred type hash\n");
    sBuffer.appendAscii("-------------------------------------------------------\n");

    for( PreferredHash::const_iterator pIt  = m_pData->m_aPreferredTypesCache.begin() ;
                                pIt != m_pData->m_aPreferredTypesCache.end()   ;
                              ++pIt                                            )
    {
        sBuffer.appendAscii("[\""       );
        sBuffer.append     (pIt->first  );
        sBuffer.appendAscii("\"]\t=\t\"");
        sBuffer.append     (pIt->second );
        sBuffer.appendAscii("\"\n"      );
    }

    WRITE_LOGFILE("dump_filtercache.log",U2B(sBuffer.makeStringAndClear()))
}

#endif // ENABLE_COMPONENT_SELF_CHECK

/*-****************************************************************************************************//**
    @short      standard destructor to delete instance
    @descr      This will clear the cache if last owner release it.

    @seealso    -

    @param      -
    @return     -

    @onerror    -
*//*-*****************************************************************************************************/
FilterCache::~FilterCache()
{
    // ------------------------------------------------------------------------------------------------------------
    // Global access, must be guarded (multithreading!).
    // We must protect our static member deletion!
	// But we use a ref count mechanism too ...
    // This dtor can be called more then ones at same time!
    // What can we do?

    // We should set a write lock first (is an exclusiv lock!).
    // Nobody can disturb us then! Next we must look for current
    // working mode of our transaction manager (available by baseclass TransactionBase).
    // a)   E_INIT          :   This case never should occure! We set it in ctor and change it to E_WORK too!
    // b)   E_WORK          :   We must decrease our ref count. If it will be 0 ...
    //                          we must change working mode to E_BEFORECLOSE; release internal data and change mode to E_CLOSE.
    // c)   E_BEFORECLOSE   :
    //      E_CLOSE         :   This cases never should occure too! b) must be a complete transaction!

    WriteGuard aWriteLock( LockHelper::getGlobalLock() );

    --m_nRefCount;
    if( m_nRefCount == 0 )
    {
        // Attention: This call blocks till all current transactions are gone!
        TransactionManager::getGlobalTransactionManager().setWorkingMode( E_BEFORECLOSE );

/*TODO: It's to late to save my values ... because used config manager is already dead!
        I can't write my values ... user must have called flush before ...
*/
        LOG_ASSERT2( m_pData->isModified(), "FilterCache::dtor()", "Who forgot to flush my data? I can't do it now - ConfigManager already dead ... uno dead ... I have no fun to live anylonger .-)!" )

        m_pData->free();
        delete m_pData;
        m_pData = NULL;

        TransactionManager::getGlobalTransactionManager().setWorkingMode( E_CLOSE );
	}
}

/*-------------------------------------------------------------------------------------------------
    07.03.2003 08:18
-------------------------------------------------------------------------------------------------*/
void FilterCache::flush( DataContainer::ECFGType eType )
{
    // UNSAFE AREA ---------------------------------------------------------------------------------------------
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

    // SAFE AREA -----------------------------------------------------------------------------------------------
    // Safe complete flushing with a exclusiv writelock!
    // Use global lock ... it's static member ...
    WriteGuard aWriteLock( LockHelper::getGlobalLock() );

    RTL_LOGFILE_CONTEXT( aLog, "framework (as96863) ::FilterCache::flush" );

    RTL_LOGFILE_CONTEXT_TRACE2( aLog, "{ creation ConfigItem [file=standard, version=%d, mode=%d ]", m_nVersion, m_nMode );
        FilterCFGAccess aAccess( PACKAGENAME_TYPEDETECTION_STANDARD, m_nVersion, m_nMode );
    RTL_LOGFILE_CONTEXT_TRACE ( aLog, "} creation ConfigItem" );
    RTL_LOGFILE_CONTEXT_TRACE1( aLog, "{ flush config set %d of TypeDetetcion", eType );
        aAccess.write(*m_pData, eType);
    RTL_LOGFILE_CONTEXT_TRACE1( aLog, "} flush config set %d of TypeDetetcion", eType );
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::isValidOrRepairable() const
{
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );
    ReadGuard aReadLock( LockHelper::getGlobalLock() );
    return m_pData && m_pData->isValidOrRepairable();
}

//*****************************************************************************************************************
//  interface method
//*****************************************************************************************************************
sal_Bool FilterCache::validateAndRepairTypes()
{
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );
    WriteGuard aWriteLock( LockHelper::getGlobalLock() );
    return (m_pData && m_pData->validateAndRepairTypes());
}

sal_Bool FilterCache::validateAndRepairFilter()
{
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );
    WriteGuard aWriteLock( LockHelper::getGlobalLock() );
    return (m_pData && m_pData->validateAndRepairFilter());
}

sal_Bool FilterCache::validateAndRepairDetectors()
{
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );
    WriteGuard aWriteLock( LockHelper::getGlobalLock() );
    return (m_pData && m_pData->validateAndRepairDetectors());
}

sal_Bool FilterCache::validateAndRepairLoader()
{
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );
    WriteGuard aWriteLock( LockHelper::getGlobalLock() );
    return (m_pData && m_pData->validateAndRepairLoader());
}

sal_Bool FilterCache::validateAndRepairHandler()
{
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );
    WriteGuard aWriteLock( LockHelper::getGlobalLock() );
    return (m_pData && m_pData->validateAndRepairHandler());
}

sal_Bool FilterCache::validateAndRepair()
{
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );
    WriteGuard aWriteLock( LockHelper::getGlobalLock() );
    return (m_pData && m_pData->validateAndRepair());
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::hasTypes() const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    return( m_pData->m_aTypeCache.size() > 0 );
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::hasFilters() const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    return( m_pData->m_aFilterCache.size() > 0 );
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::hasDetectors() const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // If we have a registered default detector (normaly must exist!)
    // we can return true ... otherwise we should check our cache for
    // other registered detect services.
    return  ( m_pData->m_aDetectorCache.size()                > 0 );
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::hasLoaders() const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // If we have a registered default loader (normaly must exist!)
    // we can return true ... otherwise we should check our cache for
    // other registered loader services.
    return  (
                ( m_pData->m_aLoaderCache.size()              >   0   )   &&
                ( m_pData->m_aGenericLoader.sName.getLength() >   0   )
            );
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::hasContentHandlers() const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    return( m_pData->m_aContentHandlerCache.size() > 0 );
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::searchType(	const	OUString&				sURL				,
                                    const   OUString&               sMediaType          ,
                                    const   OUString&               sClipboardFormat    ,
								   			CheckedTypeIterator&	aStartEntry			,
											OUString&				sResult				) const
{
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // Set defaults if search failed.
             sResult = OUString();
    sal_Bool bFound  = sal_False ;

    // Parse URL and extract extensions.
    // Extract main URL part without optional arguments and jumpmarks too.
    // Otherwise pattern matching couldn't work correctly.
    INetURLObject   aParser     ( sURL );
    OUString        sExtension  = aParser.getExtension( INetURLObject::LAST_SEGMENT        ,
                                                        sal_True                           ,
                                                        INetURLObject::DECODE_WITH_CHARSET );
                    sExtension  = sExtension.toAsciiLowerCase();
    OUString        sArguments  = aParser.GetParam    ( INetURLObject::NO_DECODE           );
                                  aParser.SetParam    ( OUString()                         );
    OUString        sMainURL    = aParser.GetMainURL  ( INetURLObject::NO_DECODE           );

    sal_Bool bMainURL         = (sMainURL.getLength()         > 0);
    sal_Bool bExtension       = (sExtension.getLength()       > 0);
    sal_Bool bMediaType       = (sMediaType.getLength()       > 0);
    sal_Bool bClipboardFormat = (sClipboardFormat.getLength() > 0);

    // Check for start of new search first!
    if (aStartEntry.isUninitialized())
    {
        // Initialize "step"-parameter then!
        aStartEntry.initialize( m_pData->m_aTypeCache );

        // If user give URL only - we will have some problems.
        // Sometimes exist more types registered for the same extension.
        // Then we must look for preferred entries.
        // Please do that at first call only!
        // Attention: If no extension exist ... "find()" will find anything!
        // Filter this case!
        if (bExtension && !bMediaType && !bClipboardFormat)
        {
            // Search a preferred type and set return value if some one was found.
            PreferredHash::const_iterator  pPreferredType  = m_pData->m_aPreferredTypesCache.find(sExtension);
            if( pPreferredType != m_pData->m_aPreferredTypesCache.end() )
            {
                sResult = pPreferredType->second;
                bFound  = sal_True              ;
            }
        }
    }

    /* NO "ELSE" HERE! */

    // If no preferred type match given parameter start normal search.
    while (!aStartEntry.isEnd() && !bFound)
    {
        FileTypeHash::const_iterator pTypeIterator = aStartEntry.getEntry();

        //---------------------------------------------------------------------------------------------------------
        // 1)   If media type was given (no NULL pointer!) ...
        //      ... and no result exist yet ...
        if (bMediaType)
        {
            //  ... and given value match current list item ...
            //  Save these state - the return value is later set!
            bFound = (sMediaType.equals(pTypeIterator->second.sMediaType));
        }

        //---------------------------------------------------------------------------------------------------------
        // 2)   If clipboard formt was given (no NULL pointer!) ...
        //      ... and no result exist yet ...
        if (!bFound && bClipboardFormat)
        {
            //  ... and given value match current list item ...
            //  Save these state - the return value is later set!
            bFound = (sClipboardFormat.equals(pTypeIterator->second.sClipboardFormat));
        }

        //---------------------------------------------------------------------------------------------------------
        // 3)   If URL was given ...
        //      ... and no result exist yet ...
        //      use lists of URLPattern
        if (!bFound && bMainURL)
        {
            for( OUStringList::const_iterator pPatternIterator =pTypeIterator->second.lURLPattern.begin() ;
                                              pPatternIterator!=pTypeIterator->second.lURLPattern.end()   ;
                                            ++pPatternIterator                                            )
            {
                bFound = Wildcard::match(sMainURL, *pPatternIterator);
                if (bFound)
                    break;
            }
        }

        //-----------------------------------------------------------------------------------------------------
        // 4)  If no pattern match given URL, use extension list.
        if (!bFound && bExtension)
        {
            for( OUStringList::const_iterator pExtensionIterator =pTypeIterator->second.lExtensions.begin() ;
                                              pExtensionIterator!=pTypeIterator->second.lExtensions.end()   ;
                                            ++pExtensionIterator                                            )
            {
                // An extension must match without wildcards!
                bFound = sExtension.equals(*pExtensionIterator);
                if (bFound)
                    break;
            }
        }

        // If given parameter match an existing element in our type list
        // we can set right return values.
        if (bFound)
        {
            sResult = pTypeIterator->first;   // Set return value.
            ++aStartEntry                 ;   // Set start point of next search to NEXT element after these found one!
        }
        else
        {
            // Otherwise ...
            // Step to next item in type list.
            ++aStartEntry;
        }
    }

	// Return result of search.
	return bFound;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::searchFilterForType(	const	OUString&					sInternalTypeName	,
													CheckedStringListIterator&	aStartEntry			,
													OUString&					sResult				) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Check wrong parameter.
    LOG_ASSERT2( implcp_searchFilterForType( sInternalTypeName, aStartEntry, sResult ), "FilterCache::searchFilterForType()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // Set defaults if search failed.
    sal_Bool bFound  = sal_False ;
             sResult = OUString();

    // I)   This is the first call of this method.
    //      ... because "StartEntry" isn't right initialized.
    //      Do it now.
    if( aStartEntry.isUninitialized() == sal_True )
    {
        // I.I) Search list of registered filter for given type.
        //      If you found some one set it on "StartEntry"
        //      for further searches!
        //      Return value is set at later time!
        PerformanceHash::const_iterator pFilter = m_pData->m_aFastFilterCache.find( sInternalTypeName );
        if( pFilter != m_pData->m_aFastFilterCache.end() )
        {
            aStartEntry.initialize( pFilter->second );
        }
        else
        // I.II)    We couldn't find any registered filter for given type name.
        //          We must break all further searches by disable "StartEntry"!
        //          Use method "setAfterEnd()" to do that ...
        {
            aStartEntry.setAfterEnd();
        }
    }

    /* NO "ELSE" HERE! */

    // II)  This isn't the first call (or we have initialized aStartEntry in I)!).
    //      "StartEntry" is already initialized. Look for end of list and
    //      set current element for return.
    if( aStartEntry.isEnd() == sal_False )
    {
        sResult = *(aStartEntry.getEntry()) ;
        bFound  = sal_True                  ;
        ++aStartEntry;
    }

	return bFound;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::searchDetectorForType(	const	OUString&					sInternalTypeName	,
										   				CheckedStringListIterator&	aStartEntry			,
														OUString&					sResult				) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_searchDetectorForType( sInternalTypeName, aStartEntry, sResult ), "FilterCache::searchDetectorForType()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // Set defaults if search failed.
             sResult = OUString();
    sal_Bool bFound  = sal_False ;

    // I)   This is the first call of this method ... because given "StartEntry" isn't right initialized!
    //      Do it now ...
    if( aStartEntry.isUninitialized() == sal_True )
    {
        // I.I)     Search for type to get list of registered detect services.
        //          If you found someone initialize "StartEntry".
        //          At next calls of this method you don't must search in "m_pData->m_aFastDetectorCache" anymore ...
        //          because you set and hold list of registered services in "StartEntry".
        //          User should not change that!
        PerformanceHash::const_iterator pDetector = m_pData->m_aFastDetectorCache.find( sInternalTypeName );
        if( pDetector != m_pData->m_aFastDetectorCache.end() )
        {
            aStartEntry.initialize( pDetector->second );
        }
        else
        // I.II)    We couldn't find any registered detect service for given type name.
        //          We must break all further searches by disable "StartEntry"!
        //          Use method "setEnd()" to do that ...
        //          NOT "setAfterEnd()" !!! ... because we must return our default detector first
        //          before we stop all further searches! see III)
        {
            aStartEntry.setEnd();
        }
    }

    /* NO "ELSE" HERE! */

    //  II) This must be the second, third ... call of this search method! (or first call after successful initalizing of aStartEntry!)
    //      And we haven't reached the end of set list of registered services.
    //      Set next elemenet for return and step to the next one.
    if( aStartEntry.isEnd() == sal_False )
    {
        sResult = *(aStartEntry.getEntry()) ;
        bFound  = sal_True                  ;
        ++aStartEntry;
    }

	// Return result of operation.
	return bFound;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::searchLoaderForType(	const	OUString&					sInternalTypeName	,
										  			CheckedStringListIterator&	aStartEntry			,
													OUString&					sResult				) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_searchLoaderForType( sInternalTypeName, aStartEntry, sResult ), "FilterCache::searchLoaderForType()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // Set defaults if search failed.
             sResult = OUString();
    sal_Bool bFound  = sal_False ;

    // I)   This is the first call of this method ... because given "StartEntry" isn't right initialized!
    //      Do it now ...
    if( aStartEntry.isUninitialized() == sal_True )
    {
        // I.I)     Search for type to get list of registered loader services.
        //          If you found someone initialize "StartEntry".
        //          At next calls of this method you don't must search in "m_pData->m_aFastLoaderCache" anymore ...
        //          because you set and hold list of registered services in "StartEntry".
        //          User should not change that!
        PerformanceHash::const_iterator pLoader = m_pData->m_aFastLoaderCache.find( sInternalTypeName );
        if( pLoader != m_pData->m_aFastLoaderCache.end() )
        {
            aStartEntry.initialize( pLoader->second );
        }
        else
        // I.II)    We couldn't find any registered loader service for given type name.
        //          We must break all further searches by disable "StartEntry"!
        //          Use method "setEnd()" to do that ...
        //          NOT "setAfterEnd()" !!! ... because we must return our generic loader first
        //          before we stop all further searches! see III)
        {
            aStartEntry.setEnd();
        }
    }

    /* NO "ELSE" HERE! */

    //  II)     This must be the second, third ... call of this search method! (or first call after successful initalizing of aStartEntry!)
    //          And we haven't reached the end of set list of registered services.
    //          Set next elemenet for return and step to the next one.
    if( aStartEntry.isEnd() == sal_False )
    {
        sResult = *(aStartEntry.getEntry()) ;
        bFound  = sal_True                  ;
        ++aStartEntry;
    }
    else
    //  III)    Last registered service was returned at last call.
    //          We reached the end of set list ...
    //          (II=true => isEnd() is reached!)
    //          ... but we have a default loader service.
    //          Set it for return and break further searches! Disable
    //          "StartEntry" by calling "setAfterEnd()".
    if( aStartEntry.isAfterEnd() == sal_False )
    {
        aStartEntry.setAfterEnd();
        sResult = m_pData->m_aGenericLoader.sName ;
        bFound  = sal_True                        ;
    }

	// Return result of operation.
	return bFound;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::searchContentHandlerForType(  const   OUString&                   sInternalTypeName   ,
                                                            CheckedStringListIterator&  aStartEntry         ,
                                                            OUString&                   sResult             ) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    LOG_ASSERT2( implcp_searchContentHandlerForType( sInternalTypeName, aStartEntry, sResult ), "FilterCache::searchContentHandlerForType()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // Set defaults if search failed.
             sResult = OUString();
    sal_Bool bFound  = sal_False ;

    // I)   This is the first call of this method ... because given "StartEntry" isn't right initialized!
    //      Do it now ...
    if( aStartEntry.isUninitialized() == sal_True )
    {
        // I.I)     Search for type to get list of registered handler services.
        //          If you found someone initialize "StartEntry".
        //          At next calls of this method you don't must search in "m_pData->m_aFastHandlerCache" anymore ...
        //          because you set and hold list of registered services in "StartEntry".
        //          User should not change that!
        PerformanceHash::const_iterator pHandler = m_pData->m_aFastContentHandlerCache.find( sInternalTypeName );
        if( pHandler != m_pData->m_aFastContentHandlerCache.end() )
        {
            aStartEntry.initialize( pHandler->second );
        }
        else
        // I.II)    We couldn't find any registered handler service for given type name.
        //          We must break all further searches by disable "StartEntry"!
        //          Use method "setAfterEnd()" to do that ...
        {
            aStartEntry.setAfterEnd();
        }
    }

    /* NO "ELSE" HERE! */

    //  II)     This must be the second, third ... call of this search method! (or first call after successful initalizing of aStartEntry!)
    //          And we haven't reached the end of set list of registered services.
    //          Set next elemenet for return and step to the next one.
    if( aStartEntry.isEnd() == sal_False )
    {
        sResult = *(aStartEntry.getEntry()) ;
        bFound  = sal_True                  ;
        ++aStartEntry;
    }

	// Return result of operation.
	return bFound;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
Sequence< OUString > FilterCache::getAllTypeNames() const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // Algorithm:
    //      a) initialize return sequence with right size.
    //      b) copy all values from hash to temp. vector! (neccessary to return list in alphabetic order)
    //      c) sort list
    //      d) convert vector to return sequence

    /*TODO
        May be - we can make it better!
        We could create a static pointer to a return list at first call of this method.
        All other requests works on this created result set ... till something was changed
        in our m_pData->m_aTypeCache! Then we must delete this static list and create a new one.
     */

    // a)
    sal_uInt32           nCount     = (sal_uInt32)(m_pData->m_aTypeCache.size());
    Sequence< OUString > lReturnList( nCount )                                  ;
    sal_uInt32           nItem      = 0                                         ;
    OUStringList         lTempList                                              ;

    // b)
    for( FileTypeHash::const_iterator pHashIterator=m_pData->m_aTypeCache.begin(); pHashIterator!=m_pData->m_aTypeCache.end(); ++pHashIterator )
    {
        lTempList.push_back( pHashIterator->first );
    }

    // c)
    ::std::stable_sort( lTempList.begin(), lTempList.end() );

    // d)
    for( OUStringList::const_iterator pListIterator=lTempList.begin(); pListIterator!=lTempList.end(); ++pListIterator )
    {
        lReturnList[nItem] = *pListIterator;
        ++nItem;
    }

    return lReturnList;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
Sequence< OUString > FilterCache::getAllFilterNames() const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    RTL_LOGFILE_CONTEXT( aMeasure, "framework (as96863) ::FilterCache::getAllFilterNames" );

    // Algorithm:
    //      a) initialize return sequence with right size.
    //      b) copy all values from hash to temp. vector! (neccessary to return list in alphabetic order)
    //      c) sort list
    //      d) convert vector to return sequence

    /*TODO
        May be - we can make it better!
        We could create a static pointer to a return list at first call of this method.
        All other requests works on this created result set ... till something was changed
        in our m_pData->m_aTypeCache! Then we must delete this static list and create a new one.
     */

    // a)
    OUStringList lTempList;

    // b)
    for( FilterHash::const_iterator pHashIterator=m_pData->m_aFilterCache.begin(); pHashIterator!=m_pData->m_aFilterCache.end(); ++pHashIterator )
    {
        lTempList.push_back( pHashIterator->first );
    }

    // c)
    ::std::stable_sort( lTempList.begin(), lTempList.end() );

    // d)
    return Converter::convert_OUStringList2seqOUString(lTempList);
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
Sequence< OUString > FilterCache::getAllDetectorNames() const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // a) Initialize return sequence with right size.
    // b) Step over all cache items and copy names to return list.
    // Attention: Don't return our default detector! Do that in right method getAllDetectorNamesWithDefault() ...
    Sequence< OUString > lNames ( m_pData->m_aDetectorCache.size() );
    sal_uInt32           nItem  = 0;
    for( DetectorHash::const_iterator aIterator=m_pData->m_aDetectorCache.begin(); aIterator!=m_pData->m_aDetectorCache.end(); ++aIterator )
    {
        lNames[nItem] = aIterator->first;
        ++nItem;
    }
	return lNames;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
Sequence< OUString > FilterCache::getAllLoaderNames() const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // a) Initialize return sequence with right size.
    // b) Step over all cache items and copy names to return list.
    // Attention: Don't return our default loader! Do that in right method getAllLoaderNamesWithDefault() ...
    Sequence< OUString > lNames ( m_pData->m_aLoaderCache.size() );
    sal_uInt32           nItem  = 0;
    for( LoaderHash::const_iterator aIterator=m_pData->m_aLoaderCache.begin(); aIterator!=m_pData->m_aLoaderCache.end(); ++aIterator )
    {
        lNames[nItem] = aIterator->first;
        ++nItem;
    }
	return lNames;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
Sequence< OUString > FilterCache::getAllContentHandlerNames() const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // a) Initialize return sequence with right size.
    // b) Step over all cache items and copy names to return list.
    Sequence< OUString > lNames ( m_pData->m_aContentHandlerCache.size() );
    sal_uInt32           nItem  = 0;
    for( ContentHandlerHash::const_iterator aIterator=m_pData->m_aContentHandlerCache.begin(); aIterator!=m_pData->m_aContentHandlerCache.end(); ++aIterator )
    {
        lNames[nItem] = aIterator->first;
        ++nItem;
    }
	return lNames;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
Sequence< OUString > FilterCache::getAllDetectorNamesWithDefault() const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // a) Initialize return sequence with right size.
    // b) Step over all cache items and copy names to return list.
    // Attention: Don't forget our default detector ... => +1 ...!
    Sequence< OUString > lNames ( m_pData->m_aDetectorCache.size() );
    sal_uInt32           nItem  = 0;
    for( DetectorHash::const_iterator aIterator=m_pData->m_aDetectorCache.begin(); aIterator!=m_pData->m_aDetectorCache.end(); ++aIterator )
    {
        lNames[nItem] = aIterator->first;
        ++nItem;
    }
	return lNames;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
Sequence< OUString > FilterCache::getAllLoaderNamesWithDefault() const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // a) Initialize return sequence with right size.
    // b) Step over all cache items and copy names to return list.
    // Attention: Don't forget our default loader ... => +1 ...!
    Sequence< OUString > lNames ( m_pData->m_aLoaderCache.size()+1 );
    sal_uInt32           nItem  = 0;
    for( LoaderHash::const_iterator aIterator=m_pData->m_aLoaderCache.begin(); aIterator!=m_pData->m_aLoaderCache.end(); ++aIterator )
    {
        lNames[nItem] = aIterator->first;
        ++nItem;
    }
    lNames[nItem] = m_pData->m_aGenericLoader.sName;
	return lNames;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
::rtl::OUString FilterCache::getDefaultLoader() const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    return m_pData->m_aGenericLoader.sName;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
Sequence< PropertyValue > FilterCache::getTypeProperties( const OUString& sName ) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_getTypeProperties( sName ), "FilterCache::getTypeProperties()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // Search for element. If it could be found - pack his properties for return.
    Sequence< PropertyValue >    lProperties                                      ;
    FileTypeHash::const_iterator pItem       = m_pData->m_aTypeCache.find( sName );
    if( pItem != m_pData->m_aTypeCache.end() )
    {
        DataContainer::convertFileTypeToPropertySequence( pItem->second, lProperties, m_pData->m_sLocale );
    }
	return lProperties;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
Sequence< PropertyValue > FilterCache::getFilterProperties( const OUString& sName ) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_getFilterProperties( sName ), "FilterCache::getFilterProperties()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // Search for element. If it could be found - pack his properties for return.
    Sequence< PropertyValue >   lProperties                                         ;
    FilterHash::const_iterator  pItem       = m_pData->m_aFilterCache.find( sName ) ;
    if( pItem != m_pData->m_aFilterCache.end() )
    {
        DataContainer::convertFilterToPropertySequence( pItem->second, lProperties, m_pData->m_sLocale );
    }
	return lProperties;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
Sequence< PropertyValue > FilterCache::getDetectorProperties( const OUString& sName ) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_getDetectorProperties( sName ), "FilterCache::getDetectorProperties()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // Search for element. If it could be found - pack his properties for return.
    Sequence< PropertyValue >    lProperties                                          ;
    DetectorHash::const_iterator pItem       = m_pData->m_aDetectorCache.find( sName );
    if( pItem != m_pData->m_aDetectorCache.end() )
    {
        DataContainer::convertDetectorToPropertySequence( pItem->second, lProperties );
    }
	return lProperties;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
Sequence< PropertyValue > FilterCache::getLoaderProperties( const OUString& sName ) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_getLoaderProperties( sName ), "FilterCache::getLoaderProperties()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // Search for element. If it could be found - pack his properties for return.
    Sequence< PropertyValue >   lProperties                                        ;
    LoaderHash::const_iterator  pItem       = m_pData->m_aLoaderCache.find( sName );
    if( pItem != m_pData->m_aLoaderCache.end() )
    {
        DataContainer::convertLoaderToPropertySequence( pItem->second, lProperties, m_pData->m_sLocale );
    }
	return lProperties;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
Sequence< PropertyValue > FilterCache::getContentHandlerProperties( const OUString& sName ) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    LOG_ASSERT2( implcp_getContentHandlerProperties( sName ), "FilterCache::getContentHandlerProperties()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // Search for element. If it could be found - pack his properties for return.
    Sequence< PropertyValue >           lProperties                                                ;
    ContentHandlerHash::const_iterator  pItem       = m_pData->m_aContentHandlerCache.find( sName );
    if( pItem != m_pData->m_aContentHandlerCache.end() )
    {
        DataContainer::convertContentHandlerToPropertySequence( pItem->second, lProperties );
    }
	return lProperties;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
FileType FilterCache::getType( const OUString& sName ) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_getType( sName ), "FilterCache::getType()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // Search for element and return his properties.
    FileType                     aType                                       ;
    FileTypeHash::const_iterator pItem = m_pData->m_aTypeCache.find( sName ) ;
    if( pItem != m_pData->m_aTypeCache.end() )
    {
        aType = pItem->second;
    }
	return aType;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
Filter FilterCache::getFilter( const OUString& sName ) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_getFilter( sName ), "FilterCache::getFilter()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // Search for element and return his properties.
    Filter                     aFilter                                        ;
    FilterHash::const_iterator pItem   = m_pData->m_aFilterCache.find( sName );
    if( pItem != m_pData->m_aFilterCache.end() )
    {
        aFilter = pItem->second;
    }
	return aFilter;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
Detector FilterCache::getDetector( const OUString& sName ) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_getDetector( sName ), "FilterCache::getDetector()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // Search for element and return his properties.
    Detector                     aDetector                                          ;
    DetectorHash::const_iterator pItem     = m_pData->m_aDetectorCache.find( sName );
    if( pItem != m_pData->m_aDetectorCache.end() )
    {
        aDetector = pItem->second;
    }
	return aDetector;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
Loader FilterCache::getLoader( const OUString& sName ) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_getLoader( sName ), "FilterCache::getLoader()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // Search for element and return his properties.
    Loader                     aLoader                                        ;
    LoaderHash::const_iterator pItem   = m_pData->m_aLoaderCache.find( sName );
    if( pItem != m_pData->m_aLoaderCache.end() )
    {
        aLoader = pItem->second;
    }
	return aLoader;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
ContentHandler FilterCache::getContentHandler( const OUString& sName ) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    LOG_ASSERT2( implcp_getContentHandler( sName ), "FilterCache::getContentHandler()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // Search for element and return his properties.
    ContentHandler                     aHandler                                               ;
    ContentHandlerHash::const_iterator pItem   = m_pData->m_aContentHandlerCache.find( sName );
    if( pItem != m_pData->m_aContentHandlerCache.end() )
    {
        aHandler = pItem->second;
    }
    return aHandler;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::existsType( const OUString& sName ) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_existsType( sName ), "FilterCache::existsType()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    return m_pData->existsType(sName);
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::existsFilter( const OUString& sName ) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_existsFilter( sName ), "FilterCache::existsFilter()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    return m_pData->existsFilter(sName);
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::existsDetector( const OUString& sName ) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_existsDetector( sName ), "FilterCache::existsDetector()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    return m_pData->existsDetector(sName);
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::existsLoader( const OUString& sName ) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_existsLoader( sName ), "FilterCache::existsLoader()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    return m_pData->existsLoader(sName);
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::existsContentHandler( const OUString& sName ) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    LOG_ASSERT2( implcp_existsContentHandler( sName ), "FilterCache::existsContentHandler()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    return m_pData->existsContentHandler(sName);
}

//*****************************************************************************************************************
// Objects of these class type are called by ::std::stable_sort() calls inside next functions.
// The should compare two given list entries and return information about her order in result
// of sortation.
//      a) compareByOrder       ...     sort two filter entries by her "Order" property
//      b) selectByOrder        ...     indicates, if given filter entry has a valid order information
//                                      These information is used to split list in items WITH valid "Order" and items WITHOUT it!
//      c) sortByUIName         ...     sort two filters by his "UIName" property
//      d) sortByInternalName   ...     sort two filters by his "Name" property
//*****************************************************************************************************************

//*****************************************************************************************************************
class compareByOrder
{
    public:
        //---------------------------------------------------------------------------------------------------------
        compareByOrder( sal_Bool bDescending )
            : m_bDescending( bDescending )
        {
        }

        //---------------------------------------------------------------------------------------------------------
        int operator() ( const FilterHash::const_iterator& p1 ,
                         const FilterHash::const_iterator& p2 ) const
        {
            #ifdef ENABLE_WARNINGS
            const Filter* pF1 = &(p1->second);
            const Filter* pF2 = &(p2->second);
            #endif

            int nDecision = 0;

            if( m_bDescending == sal_True )
            {
                if( p2->second.nOrder < p1->second.nOrder )
                {
                    nDecision = 1;
                }
            }
            else
            {
                if( p1->second.nOrder < p2->second.nOrder )
                {
                    nDecision = 1;
                }
            }

            // MUST be in [0,1] ... because it's a difference between
            // insert-positions of given filters in sorted list!
            return nDecision;
        }

    private:
        sal_Bool m_bDescending;
};

//*****************************************************************************************************************
class selectByOrder
{
    public:
        bool operator() ( const FilterHash::const_iterator& pFilter ) const
        {
            #ifdef ENABLE_WARNINGS
            const Filter* pF = &(pFilter->second);
            #endif

            return( pFilter->second.nOrder != 0 );
        }
};

//*****************************************************************************************************************
class selectDefault
{
    public:
        bool operator() ( const FilterHash::const_iterator& pFilter ) const
        {
            #ifdef ENABLE_WARNINGS
            const Filter* pF = &(pFilter->second);
            #endif

            return FlagCheck::isMaskSet(pFilter->second.nFlags, FILTERFLAG_DEFAULT);
        }
};

//*****************************************************************************************************************
class sortByProp
{
    public:
        //---------------------------------------------------------------------------------------------------------
        sortByProp( const ::rtl::OUString&          sLocale        ,
                          QueryAnalyzer::ESortProp  eProp          ,
                          sal_Bool                  bDescending    ,
                          sal_Bool                  bCaseSensitive )
            : m_sLocale       ( sLocale        )
            , m_eProp         ( eProp          )
            , m_bDescending   ( bDescending    )
            , m_bCaseSensitive( bCaseSensitive )
        {
        }

        //---------------------------------------------------------------------------------------------------------
        int operator() ( const FilterHash::const_iterator& p1 ,
                         const FilterHash::const_iterator& p2 ) const
        {
            #ifdef ENABLE_WARNINGS
            const Filter* pF1 = &(p1->second);
            const Filter* pF2 = &(p2->second);
            #endif

            ::rtl::OUString sCMP1;
            ::rtl::OUString sCMP2;
            switch( m_eProp )
            {
                case QueryAnalyzer::E_NAME  :   {
                                                    sCMP1 = p1->first;
                                                    sCMP2 = p2->first;
                                                }
                                                break;
                case QueryAnalyzer::E_UINAME:   {
                                                    sCMP1 = DataContainer::getLocalelizedString( p1->second.lUINames, m_sLocale );
                                                    sCMP2 = DataContainer::getLocalelizedString( p2->second.lUINames, m_sLocale );
                                                }
                                                break;
            }

            if( m_bCaseSensitive == sal_False )
            {
                sCMP1 = sCMP1.toAsciiLowerCase();
                sCMP2 = sCMP2.toAsciiLowerCase();
            }

            int nDecision = 0;

            if( m_bDescending == sal_True )
            {
                if( sCMP1.compareTo( sCMP2 ) >= 0 )
                {
                    nDecision = 1;
                }
            }
            else
            {
                if( sCMP2.compareTo( sCMP1 ) >= 0 )
                {
                    nDecision = 1;
                }
            }

            // MUST be in [0,1] ... because it's a difference between
            // insert-positions of given filters in sorted list!
            return nDecision;
        }

    private:
        const ::rtl::OUString       m_sLocale        ;
        QueryAnalyzer::ESortProp    m_eProp          ;
        sal_Bool                    m_bDescending    ;
        sal_Bool                    m_bCaseSensitive ;
};

//*****************************************************************************************************************
class isDefault
{
    public:
        int operator() ( const FilterHash::const_iterator& p1 ,
                         const FilterHash::const_iterator& p2 ) const
        {
            #ifdef ENABLE_WARNINGS
            const Filter* pF1 = &(p1->second);
            const Filter* pF2 = &(p2->second);
            #endif

            int nDecision = 0;

            if( m_bDescending == sal_True )
            {
                if( p1->first.compareTo( p2->first ) >= 0 )
                {
                    nDecision = 1;
                }
            }
            else
            {
                if( p2->first.compareTo( p1->first ) >= 0 )
                {
                    nDecision = 1;
                }
            }

            // MUST be in [0,1] ... because it's a difference between
            // insert-positions of given filters in sorted list!
            return nDecision;
        }

    private:
        sal_Bool m_bDescending ;
};

//*****************************************************************************************************************
class matchFlags
{
    public:
        //---------------------------------------------------------------------------------------------------------
        matchFlags( sal_uInt32 nMask   ,
                    sal_Bool   bNegate )
            : m_nMask  ( nMask   )
            , m_bNegate( bNegate )
        {
        }

        //---------------------------------------------------------------------------------------------------------
        bool operator() ( const FilterHash::const_iterator& pItem ) const
        {
            #ifdef ENABLE_WARNINGS
            const Filter* pFilter = &(pItem->second);
            #endif
            bool bMatch = ((pItem->second.nFlags & m_nMask)==m_nMask);
            if( m_bNegate == sal_True )
            {
                bMatch = !bMatch;
            }
            return bMatch;
        }

    private:
        sal_uInt32 m_nMask   ;
        sal_Bool   m_bNegate ;
};

//*****************************************************************************************************************
class notMatchDocumentService
{
    public:
        //---------------------------------------------------------------------------------------------------------
        notMatchDocumentService( const ::rtl::OUString& sService )
            : m_sService( sService )
        {
        }

        //---------------------------------------------------------------------------------------------------------
        bool operator() ( const FilterHash::const_iterator& pItem ) const
        {
            #ifdef ENABLE_WARNINGS
            const Filter* pFilter = &(pItem->second);
            #endif
            return !(pItem->second.sDocumentService.equals(m_sService));
        }

    private:
        ::rtl::OUString m_sService ;
};

//*****************************************************************************************************************
class notMatchFirstUserData
{
    public:
        //---------------------------------------------------------------------------------------------------------
        notMatchFirstUserData( const ::rtl::OUString& sData )
            : m_sData( sData )
        {
        }

        //---------------------------------------------------------------------------------------------------------
        bool operator() ( const FilterHash::const_iterator& pItem ) const
        {
            return(
                    ( pItem->second.lUserData.size()     < 1        )   ||
                    ( *(pItem->second.lUserData.begin()) != m_sData )
                  );
        }

    private:
        ::rtl::OUString m_sData;
};

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
Any FilterCache::queryFilters( const OUString& sQuery ) const
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_queryFilters( sQuery ), "FilterCache::queryFilters()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

    css::uno::Any aResult;

    // Analyze given query by using helper to split into base and optional params/values.
    QueryAnalyzer         aAnalyzer( sQuery );
    QueryAnalyzer::EQuery eQuery   = aAnalyzer.getQueryType();

    /* SAFE AREA ------------------------------------------------------------------------------------------- */
    // Hold this lock alive till all steps of query are finished ...
    // Because; lResult points into m_aFilterCache member and we must guarantee
    // valid informations there ...
    ReadGuard aReadLock( LockHelper::getGlobalLock() );

    // Build list of all available filters as possible query result!
    // We use list of iterator-pointer, which points into right filter list.
    // So we have all informations of a filter available during different steps
    // in follow lines ... without copying of all these data ...
    FilterQuery lResult;
    for( FilterHash::const_iterator pFilter =m_pData->m_aFilterCache.begin();
                                pFilter!=m_pData->m_aFilterCache.end()  ;
                                ++pFilter                               )
    {
        lResult.push_back( pFilter );
    }

    // Step over these list and delete non matching filters!
    // Attention: ::std::remove_if() don't remove member realy ...
    // But he sort non removed elements on top of list and returns iterator to end
    // of these partition. All elements betwenn these pointer and "end()" are superflous
    // and can be deleted.
    FilterQuery::iterator pRemoveEnd = lResult.end();
    switch( aAnalyzer.getQueryType() )
    {
        //case QueryAnalyzer::E_ALL     :  Nothing to do here ... because lResult already includes ALL filters!!!
        //                                 see for-construct before!
        case QueryAnalyzer::E_WRITER    :  pRemoveEnd = ::std::remove_if( lResult.begin(), lResult.end(), notMatchDocumentService(DECLARE_ASCII("com.sun.star.text.TextDocument")) );
                                            break;
        case QueryAnalyzer::E_WEB       :  pRemoveEnd = ::std::remove_if( lResult.begin(), lResult.end(), notMatchDocumentService(DECLARE_ASCII("com.sun.star.text.WebDocument")) );
                                            break;
        case QueryAnalyzer::E_GLOBAL    :  pRemoveEnd = ::std::remove_if( lResult.begin(), lResult.end(), notMatchDocumentService(DECLARE_ASCII("com.sun.star.text.GlobalDocument")) );
                                            break;
        case QueryAnalyzer::E_CHART     :  pRemoveEnd = ::std::remove_if( lResult.begin(), lResult.end(), notMatchDocumentService(DECLARE_ASCII("com.sun.star.chart.ChartDocument")) );
                                            break;
        case QueryAnalyzer::E_CALC      :  pRemoveEnd = ::std::remove_if( lResult.begin(), lResult.end(), notMatchDocumentService(DECLARE_ASCII("com.sun.star.sheet.SpreadsheetDocument")) );
                                            break;
        case QueryAnalyzer::E_IMPRESS   :  pRemoveEnd = ::std::remove_if( lResult.begin(), lResult.end(), notMatchDocumentService(DECLARE_ASCII("com.sun.star.presentation.PresentationDocument")) );
                                            break;
        case QueryAnalyzer::E_DRAW      :  pRemoveEnd = ::std::remove_if( lResult.begin(), lResult.end(), notMatchDocumentService(DECLARE_ASCII("com.sun.star.drawing.DrawingDocument")) );
                                            break;
        case QueryAnalyzer::E_MATH      :  pRemoveEnd = ::std::remove_if( lResult.begin(), lResult.end(), notMatchDocumentService(DECLARE_ASCII("com.sun.star.formula.FormulaProperties")) );
                                            break;
        case QueryAnalyzer::E_GRAPHICS  :  pRemoveEnd = ::std::remove_if( lResult.begin(), lResult.end(), notMatchFirstUserData(DECLARE_ASCII("OO")) );
                                            break;
    }
    lResult.erase( pRemoveEnd, lResult.end() );

    // If user has flag mask set - delete filters, which doesnt match these
    sal_uInt32 nIFlags = aAnalyzer.getIFlags();
    sal_uInt32 nEFlags = aAnalyzer.getEFlags();
    if( nIFlags > 0 )
    {
        pRemoveEnd = ::std::remove_if( lResult.begin(), lResult.end(), matchFlags(nIFlags, sal_True) );
        lResult.erase( pRemoveEnd, lResult.end() );
    }
    if( nEFlags > 0 )
    {
        pRemoveEnd = ::std::remove_if( lResult.begin(), lResult.end(), matchFlags(nEFlags, sal_False) );
        lResult.erase( pRemoveEnd, lResult.end() );
    }

    // Sort result list by using different sort criterions
    // pOrderEnd points to last item in list, which has "nOrder>0"!
    // So we can split list into filters, which has an order or not.
    // It makes it possible to sort these parts separate!
    // If no entry use "nOrder" ... pOrderEnd points to first element in list ...
    // Then we sort alphabeticly only.
    FilterQuery::iterator pOrderEnd = lResult.begin();
    if( aAnalyzer.getUseOrder() == sal_True )
    {
        // split list on "filter with order | filters without order"
        pOrderEnd = ::std::stable_partition( lResult.begin(), lResult.end(), selectByOrder() );
        if( pOrderEnd != lResult.begin() )
        {
            // sort part "filter with order" by using order property
            ::std::stable_sort( lResult.begin(), pOrderEnd, compareByOrder(aAnalyzer.getDescending()) );
        }
    }

    // We can sort by using UIName property or using the internal name of every filter.
    // Look for right start end end points by using "pOrderEnd" too!
    ::std::stable_sort( pOrderEnd, lResult.end(), sortByProp( m_pData->m_sLocale           ,
                                                              aAnalyzer.getSortProp()      ,
                                                              aAnalyzer.getDescending()    ,
                                                              aAnalyzer.getCaseSensitive() ) );

    // Sortation and order can be irgnored ...
    // if user whish default filter on top of list!
    if( aAnalyzer.getDefaultFirst() == sal_True )
    {
        ::std::stable_partition( lResult.begin(), lResult.end(), selectDefault() );
    }

    // Query is complete now ... but we must convert it from internal to return presentation.
    css::uno::Sequence< ::rtl::OUString > lNames( (sal_Int32)lResult.size() );
    sal_Int32                             nStep = 0;
    for( FilterQuery::iterator pResult =lResult.begin();
                               pResult!=lResult.end()  ;
                               ++pResult               )
    {
        lNames[nStep] = (*pResult)->first;
        ++nStep;
    }
    // Access to filter configuration isn't neccessary any longer :-)
    aReadLock.unlock();
    /* UNSAFE AREA ----------------------------------------------------------------------------------------- */
    aResult <<= lNames;

    return aResult;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::addFilter( const ::rtl::OUString&                                 sName       ,
                                 const css::uno::Sequence< css::beans::PropertyValue >& lProperties ,
                                       sal_Bool                                         bException  )
    throw(css::container::ElementExistException  ,
          css::registry::InvalidRegistryException)
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_addFilter( sName, lProperties ), "FilterCache::addFilter()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    WriteGuard aWriteLock( LockHelper::getGlobalLock() );

    // We throw an exception if element already exist!
    // Why? Because user can't write threadsafe code by using "existsFilter()" AND "addFilter()" realy ...
    // It's better we throw this exception for him automaticly ...
    // These cache implementation is used by services which must throw an exception in this case!!!
    // If you don't whish that ... write another add-method ...
    if( m_pData->m_aFilterCache.find( sName ) != m_pData->m_aFilterCache.end() )
    {
        if (bException)
        {
            OUStringBuffer sMessage( 256 );
            sMessage.appendAscii( "FilterCache::addFilter()\nFilter \"" );
            sMessage.append     ( sName                                 );
            sMessage.appendAscii( "\" already exist!"                   );
            throw ElementExistException( sMessage.makeStringAndClear(), Reference< XInterface >() );
        }
        return sal_False;
    }

    // Add new filter to internal structures only!
    // User must call "flush()" or release this cache to write data to disk.
    Filter aFilter;
    DataContainer::convertPropertySequenceToFilter( lProperties, aFilter, m_pData->m_sLocale );
    aFilter.sName = sName;
    m_pData->addFilter( aFilter, sal_True );

    return sal_True;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::replaceFilter( const ::rtl::OUString&                                 sName       ,
                                     const css::uno::Sequence< css::beans::PropertyValue >& lProperties ,
                                           sal_Bool                                         bException  )
    throw(css::container::NoSuchElementException ,
          css::registry::InvalidRegistryException)
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_replaceFilter( sName, lProperties ), "FilterCache::replaceFilter()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ----------------------------------------------------------------------------------------------- */
    WriteGuard aWriteLock( LockHelper::getGlobalLock() );

    // We throw an exception if element not exist!
    // Why? Because user can't write threadsafe code by using "existsFilter()" AND "replaceFilter()" realy ...
    // It's better we throw this exception for him automaticly ...
    // These cache implementation is used by services which must throw an exception in this case!!!
    // If you don't whish that ... write another replace-method ...
    if( m_pData->m_aFilterCache.find( sName ) == m_pData->m_aFilterCache.end() )
    {
        if (bException)
        {
            OUStringBuffer sMessage( 256 );
            sMessage.appendAscii( "FilterCache::replaceFilter()\nFilter \"" );
            sMessage.append     ( sName                                     );
            sMessage.appendAscii( "\" not exist!"                           );
            throw NoSuchElementException( sMessage.makeStringAndClear(), Reference< XInterface >() );
        }
        return sal_False;
    }

    // Change filter data at internal structures only!
    // User must call "flush()" or release this cache to write data to disk.
    Filter aFilter;
    DataContainer::convertPropertySequenceToFilter( lProperties, aFilter, m_pData->m_sLocale );
    aFilter.sName = sName;
    m_pData->replaceFilter( aFilter, sal_True );

    return sal_True;
}

//*****************************************************************************************************************
//	interface method
//*****************************************************************************************************************
sal_Bool FilterCache::removeFilter( const ::rtl::OUString& sName      ,
                                          sal_Bool         bException )
    throw(css::container::NoSuchElementException ,
          css::registry::InvalidRegistryException)
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	LOG_ASSERT2( implcp_removeFilter( sName ), "FilterCache::removeFilter()", "Invalid parameter detected!" )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

	/* SAFE AREA ------------------------------------------------------------------------------------------- */
    WriteGuard aWriteLock( LockHelper::getGlobalLock() );

    // We throw an exception if element not exist!
    // Why? Because user can't write threadsafe code by using "existsFilter()" AND "removeFilter()" realy ...
    // It's better we throw this exception for him automaticly ...
    // These cache implementation is used by services which must throw an exception in this case!!!
    // If you don't whish that ... write another remove-method ...
    if( m_pData->m_aFilterCache.find( sName ) == m_pData->m_aFilterCache.end() )
    {
        if (bException)
        {
            OUStringBuffer sMessage( 256 );
            sMessage.appendAscii( "FilterCache::removeFilter()\nFilter \""  );
            sMessage.append     ( sName                                     );
            sMessage.appendAscii( "\" not exist!"                           );
            throw NoSuchElementException( sMessage.makeStringAndClear(), Reference< XInterface >() );
        }
        return sal_False;
    }

    // Remove filter from internal structures only!
    // User must call "flush()" or release this cache to write data to disk.
    m_pData->removeFilter( sName, sal_True );

    return sal_True;
}

//*****************************************************************************************************************
//  interface method
//*****************************************************************************************************************
sal_Bool FilterCache::addType( const ::rtl::OUString&                                 sName       ,
                               const css::uno::Sequence< css::beans::PropertyValue >& lProperties ,
                                     sal_Bool                                         bException  )
    throw(css::container::ElementExistException  ,
          css::registry::InvalidRegistryException)
{
    /* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

    /* SAFE AREA ----------------------------------------------------------------------------------------------- */
    WriteGuard aWriteLock( LockHelper::getGlobalLock() );

    // We throw an exception if element already exist!
    // Why? Because user can't write threadsafe code by using "existsType()" AND "addType()" realy ...
    // It's better we throw this exception for him automaticly ...
    // These cache implementation is used by services which must throw an exception in this case!!!
    // If you don't whish that ... write another add-method ...
    if( m_pData->m_aTypeCache.find( sName ) != m_pData->m_aTypeCache.end() )
    {
        if (bException)
        {
            OUStringBuffer sMessage( 256 );
            sMessage.appendAscii( "FilterCache::addType()\nType \"" );
            sMessage.append     ( sName                             );
            sMessage.appendAscii( "\" already exist!"               );
            throw ElementExistException( sMessage.makeStringAndClear(), Reference< XInterface >() );
        }
        return sal_False;
    }

    // Add new type to internal structures only!
    // User must call "flush()" or release this cache to write data to disk.
    FileType aType;
    DataContainer::convertPropertySequenceToFileType( lProperties, aType, m_pData->m_sLocale );
    aType.sName = sName;
    m_pData->addType( aType, sal_True );

    return sal_True;
}

//*****************************************************************************************************************
//  interface method
//*****************************************************************************************************************
sal_Bool FilterCache::replaceType( const ::rtl::OUString&                                 sName       ,
                                   const css::uno::Sequence< css::beans::PropertyValue >& lProperties ,
                                         sal_Bool                                         bException  )
    throw(css::container::NoSuchElementException ,
          css::registry::InvalidRegistryException)
{
    /* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

    /* SAFE AREA ----------------------------------------------------------------------------------------------- */
    WriteGuard aWriteLock( LockHelper::getGlobalLock() );

    // We throw an exception if element not exist!
    // Why? Because user can't write threadsafe code by using "existsType()" AND "replaceType()" realy ...
    // It's better we throw this exception for him automaticly ...
    // These cache implementation is used by services which must throw an exception in this case!!!
    // If you don't whish that ... write another replace-method ...
    if( m_pData->m_aTypeCache.find( sName ) == m_pData->m_aTypeCache.end() )
    {
        if (bException)
        {
            OUStringBuffer sMessage( 256 );
            sMessage.appendAscii( "FilterCache::replaceType()\nType \"" );
            sMessage.append     ( sName                                 );
            sMessage.appendAscii( "\" not exist!"                       );
            throw NoSuchElementException( sMessage.makeStringAndClear(), Reference< XInterface >() );
        }
        return sal_False;
    }

    // Change type data at internal structures only!
    // User must call "flush()" or release this cache to write data to disk.
    FileType aType;
    DataContainer::convertPropertySequenceToFileType( lProperties, aType, m_pData->m_sLocale );
    aType.sName = sName;
    m_pData->replaceType( aType, sal_True );

    return sal_True;
}

//*****************************************************************************************************************
//  interface method
//*****************************************************************************************************************
sal_Bool FilterCache::removeType( const ::rtl::OUString& sName      ,
                                        sal_Bool         bException )
    throw(css::container::NoSuchElementException ,
          css::registry::InvalidRegistryException)
{
    /* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

    /* SAFE AREA ------------------------------------------------------------------------------------------- */
    WriteGuard aWriteLock( LockHelper::getGlobalLock() );

    // We throw an exception if element not exist!
    // Why? Because user can't write threadsafe code by using "existsType()" AND "removeType()" realy ...
    // It's better we throw this exception for him automaticly ...
    // These cache implementation is used by services which must throw an exception in this case!!!
    // If you don't whish that ... write another remove-method ...
    if( m_pData->m_aTypeCache.find( sName ) == m_pData->m_aTypeCache.end() )
    {
        if (bException)
        {
            OUStringBuffer sMessage( 256 );
            sMessage.appendAscii( "FilterCache::removeType()\nType \""  );
            sMessage.append     ( sName                                 );
            sMessage.appendAscii( "\" not exist!"                       );
            throw NoSuchElementException( sMessage.makeStringAndClear(), Reference< XInterface >() );
        }
        return sal_False;
    }

    // Remove type from internal structures only!
    // User must call "flush()" or release this cache to write data to disk.
    m_pData->removeType( sName, sal_True );

    return sal_True;
}

//*****************************************************************************************************************
//  interface method
//*****************************************************************************************************************
sal_Bool FilterCache::addDetector( const ::rtl::OUString&                                 sName       ,
                                 const css::uno::Sequence< css::beans::PropertyValue >& lProperties ,
                                       sal_Bool                                         bException  )
    throw(css::container::ElementExistException  ,
          css::registry::InvalidRegistryException)
{
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

    /* SAFE AREA ----------------------------------------------------------------------------------------------- */
    WriteGuard aWriteLock( LockHelper::getGlobalLock() );

    // We throw an exception if element already exist!
    // Why? Because user can't write threadsafe code by using "existsDetector()" AND "addDetector()" realy ...
    // It's better we throw this exception for him automaticly ...
    // These cache implementation is used by services which must throw an exception in this case!!!
    // If you don't whish that ... write another add-method ...
    if( m_pData->m_aDetectorCache.find( sName ) != m_pData->m_aDetectorCache.end() )
    {
        if (bException)
        {
            OUStringBuffer sMessage( 256 );
            sMessage.appendAscii( "FilterCache::addDetector()\nDetector \"" );
            sMessage.append     ( sName                                 );
            sMessage.appendAscii( "\" already exist!"                   );
            throw ElementExistException( sMessage.makeStringAndClear(), Reference< XInterface >() );
        }
        return sal_False;
    }

    // Add new detector to internal structures only!
    // User must call "flush()" or release this cache to write data to disk.
    Detector aDetector;
    DataContainer::convertPropertySequenceToDetector(lProperties, aDetector);
    aDetector.sName = sName;
    m_pData->addDetector( aDetector, sal_True );

    return sal_True;
}

//*****************************************************************************************************************
//  interface method
//*****************************************************************************************************************
sal_Bool FilterCache::replaceDetector( const ::rtl::OUString&                                 sName       ,
                                     const css::uno::Sequence< css::beans::PropertyValue >& lProperties ,
                                           sal_Bool                                         bException  )
    throw(css::container::NoSuchElementException ,
          css::registry::InvalidRegistryException)
{
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

    /* SAFE AREA ----------------------------------------------------------------------------------------------- */
    WriteGuard aWriteLock( LockHelper::getGlobalLock() );

    // We throw an exception if element not exist!
    // Why? Because user can't write threadsafe code by using "existsDetector()" AND "replaceDetector()" realy ...
    // It's better we throw this exception for him automaticly ...
    // These cache implementation is used by services which must throw an exception in this case!!!
    // If you don't whish that ... write another replace-method ...
    if( m_pData->m_aDetectorCache.find( sName ) == m_pData->m_aDetectorCache.end() )
    {
        if (bException)
        {
            OUStringBuffer sMessage( 256 );
            sMessage.appendAscii( "FilterCache::replaceDetector()\nDetector \"" );
            sMessage.append     ( sName                                     );
            sMessage.appendAscii( "\" not exist!"                           );
            throw NoSuchElementException( sMessage.makeStringAndClear(), Reference< XInterface >() );
        }
        return sal_False;
    }

    // Change detector data at internal structures only!
    // User must call "flush()" or release this cache to write data to disk.
    Detector aDetector;
    DataContainer::convertPropertySequenceToDetector(lProperties, aDetector);
    aDetector.sName = sName;
    m_pData->replaceDetector( aDetector, sal_True );

    return sal_True;
}

//*****************************************************************************************************************
//  interface method
//*****************************************************************************************************************
sal_Bool FilterCache::removeDetector( const ::rtl::OUString& sName      ,
                                          sal_Bool         bException )
    throw(css::container::NoSuchElementException ,
          css::registry::InvalidRegistryException)
{
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( TransactionManager::getGlobalTransactionManager(), E_HARDEXCEPTIONS );

    /* SAFE AREA ------------------------------------------------------------------------------------------- */
    WriteGuard aWriteLock( LockHelper::getGlobalLock() );

    // We throw an exception if element not exist!
    // Why? Because user can't write threadsafe code by using "existsDetector()" AND "removeDetector()" realy ...
    // It's better we throw this exception for him automaticly ...
    // These cache implementation is used by services which must throw an exception in this case!!!
    // If you don't whish that ... write another remove-method ...
    if( m_pData->m_aDetectorCache.find( sName ) == m_pData->m_aDetectorCache.end() )
    {
        if (bException)
        {
            OUStringBuffer sMessage( 256 );
            sMessage.appendAscii( "FilterCache::removeDetector()\nDetector \""  );
            sMessage.append     ( sName                                     );
            sMessage.appendAscii( "\" not exist!"                           );
            throw NoSuchElementException( sMessage.makeStringAndClear(), Reference< XInterface >() );
        }
        return sal_False;
    }

    // Remove detector from internal structures only!
    // User must call "flush()" or release this cache to write data to disk.
    m_pData->removeDetector( sName, sal_True );

    return sal_True;
}

//_________________________________________________________________________________________________________________
//	debug methods
//_________________________________________________________________________________________________________________

/*-----------------------------------------------------------------------------------------------------------------
	The follow methods checks the parameter for other functions. If a parameter or his value is non valid,
	we return "sal_False". (else sal_True) This mechanism is used to throw an ASSERT!

	ATTENTION

		If you miss a test for one of this parameters, contact the autor or add it himself !(?)
		But ... look for right testing! See using of this methods!
-----------------------------------------------------------------------------------------------------------------*/

#ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
// Given pointer mark optional parameter. But a call without search parameter is superflous!
// One of them must valid - I think.
// The start entry parameter must be valid!
sal_Bool FilterCache::implcp_searchType(	const	OUString&	  			sURL				,
								   			const	OUString*	  			pMediaType			,
								   			const	OUString*	  			pClipboardFormat	,
								   			const	CheckedTypeIterator&	aStartEntry			,
											const	OUString&				sResult				)
{
	return	(
				( &aStartEntry	==	NULL	)						||
 				( &sURL			==	NULL	)						||
				( &sResult		==	NULL	)						||
				(
					( pMediaType					!=	NULL	)	&&
					( pMediaType->getLength()		<	1		)
				)													||
				(
					( pClipboardFormat				!=	NULL	)	&&
					( pClipboardFormat->getLength()	<	1		)
				)
			);
}

//*****************************************************************************************************************
// We don't accept NULL pointer!
sal_Bool FilterCache::implcp_searchFilterForType(	const	OUString&					sInternalTypeName	,
								   					const	CheckedStringListIterator&	aStartEntry			,
													const	OUString&					sResult				)
{
	return	(
				( &sInternalTypeName			==	NULL	)	||
				( sInternalTypeName.getLength()	<	1		)	||
				( &aStartEntry					==	NULL	)	||
				( &sResult						==	NULL	)
			);
}

//*****************************************************************************************************************
// We don't accept NULL pointer!
sal_Bool FilterCache::implcp_searchDetectorForType(	const	OUString&					sInternalTypeName	,
								   					const	CheckedStringListIterator&	aStartEntry			,
													const	OUString&					sResult				)
{
	return	(
				( &sInternalTypeName			==	NULL	)	||
				( sInternalTypeName.getLength()	<	1		)	||
				( &aStartEntry					==	NULL	)	||
				( &sResult						==	NULL	)
			);
}

//*****************************************************************************************************************
// We don't accept NULL pointer!
sal_Bool FilterCache::implcp_searchLoaderForType(	const	OUString&					sInternalTypeName	,
								   					const	CheckedStringListIterator&	aStartEntry			,
													const	OUString&					sResult				)
{
	return	(
				( &sInternalTypeName			==	NULL	)	||
				( sInternalTypeName.getLength()	<	1		)	||
				( &aStartEntry					==	NULL	)	||
				( &sResult						==	NULL	)
			);
}

//*****************************************************************************************************************
// We don't accept NULL pointer and can't search for empty entries in hash maps!
sal_Bool FilterCache::implcp_getTypeProperties( const OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
// We don't accept NULL pointer and can't search for empty entries in hash maps!
sal_Bool FilterCache::implcp_getFilterProperties( const OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
// We don't accept NULL pointer and can't search for empty entries in hash maps!
sal_Bool FilterCache::implcp_getDetectorProperties( const OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
// We don't accept NULL pointer and can't search for empty entries in hash maps!
sal_Bool FilterCache::implcp_getLoaderProperties( const OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
// We don't accept NULL pointer and can't search for empty entries in hash maps!
sal_Bool FilterCache::implcp_getType( const OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
// We don't accept NULL pointer and can't search for empty entries in hash maps!
sal_Bool FilterCache::implcp_getFilter( const OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
// We don't accept NULL pointer and can't search for empty entries in hash maps!
sal_Bool FilterCache::implcp_getDetector( const OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
// We don't accept NULL pointer and can't search for empty entries in hash maps!
sal_Bool FilterCache::implcp_getLoader( const OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
// We don't accept NULL pointer and can't search for empty entries in hash maps!
sal_Bool FilterCache::implcp_existsType( const OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
// We don't accept NULL pointer and can't search for empty entries in hash maps!
sal_Bool FilterCache::implcp_existsFilter( const OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
// We don't accept NULL pointer and can't search for empty entries in hash maps!
sal_Bool FilterCache::implcp_existsDetector( const OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
// We don't accept NULL pointer and can't search for empty entries in hash maps!
sal_Bool FilterCache::implcp_existsLoader( const OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
sal_Bool FilterCache::implcp_addFilter(	const	OUString&					sName		,
								   		const	Sequence< PropertyValue >&	lProperties	)
{
	return	(
				( &sName	  				==	NULL				)	||
				( &lProperties				==	NULL				)	||
				( sName.getLength()			<	1					)
			);
}

//*****************************************************************************************************************
sal_Bool FilterCache::implcp_replaceFilter(	const	OUString&					sName		,
								   			const	Sequence< PropertyValue >&	lProperties	)
{
	return	(
				( &sName	  				==	NULL				)	||
				( &lProperties				==	NULL				)	||
				( sName.getLength()			<	1					)
			);
}

//*****************************************************************************************************************
sal_Bool FilterCache::implcp_removeFilter( const OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
sal_Bool FilterCache::implcp_queryFilters( const OUString& sQuery )
{
	return	(
				( &sQuery				==	NULL	)	||
				( sQuery.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
sal_Bool FilterCache::implcp_searchContentHandlerForType( const ::rtl::OUString&           sInternalTypeName,
                                                          const CheckedStringListIterator& aStartEntry      ,
                                                          const ::rtl::OUString&           sResult          )
{
	return	(
				( &sInternalTypeName			==	NULL	)	||
				( sInternalTypeName.getLength()	<	1		)	||
				( &aStartEntry					==	NULL	)	||
				( &sResult						==	NULL	)
			);
}

//*****************************************************************************************************************
sal_Bool FilterCache::implcp_getContentHandlerProperties( const ::rtl::OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
sal_Bool FilterCache::implcp_getContentHandler( const ::rtl::OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

//*****************************************************************************************************************
sal_Bool FilterCache::implcp_existsContentHandler( const ::rtl::OUString& sName )
{
	return	(
				( &sName			==	NULL	)	||
				( sName.getLength()	<	1		)
			);
}

#endif  //  #ifdef ENABLE_ASSERTIONS

}		//	namespace framework
