
package org.netbeans.modules.openoffice;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;

import org.openide.compiler.*;
import org.openide.compiler.Compiler;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.NbProcessDescriptor;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;

/**
 *
 * @author  Michael Bohn
 *
 */

public class OOIDLCompilerType extends ExternalCompilerType {

    /* No special error expressions for now, probably not needed.
    static final ExternalCompiler.ErrorExpression[] ERROR_EXPRS = {
      new ExternalCompiler.ErrorExpression (NbBundle.getBundle (OOIDLCompilerType.class).getString ("LBL_error_exp_1"),
                                            "(some|reg|exp|here)",
                                            1, 2, 3, 4),
};
    */

    /** Default process template.
     */
    private static final NbProcessDescriptor DEFAULT = new NbProcessDescriptor (
                // WRAPPER NAME:
//                "/work/cvs/grande/sdk/source/OOSupport/org/netbeans/modules/openoffice/util/invoke",
                // PROCESS NAME:
                "{" + OOIDLCompilerGroup.Format.TAG_UDKINSTALL_DIRECTORY + "}" 
                + System.getProperty( "file.separator" ) + "bin" 
                + System.getProperty( "file.separator" ) +  "idlc",
                // LIST OF ARGUMENTS INCLUDING OPTIONS:
                "-I{" + OOIDLCompilerGroup.Format.TAG_IDL_INCLUDE_DIRECTORY 
                + "} " + "-I{" 
                + OOIDLCompilerGroup.Format.TAG_ADDITIONALY_IDL_INCLUDE_DIRECTORY 
                + "} " +
                "-O{" + OOIDLCompilerGroup.Format.TAG_OUTPUT_DIRECTORY + "} " +
                " {" + OOIDLCompilerGroup.Format.TAG_OUTPUT_DIRECTORY + "}" 
                + System.getProperty( "file.separator" ) + "{" 
                + OOIDLCompilerGroup.Format.TAG_IDL_FILE + "}",
                // DESCRIPTION FOR USER OF HOW TO MODIFY THE ARGUMENTS:
                NbBundle.getBundle( OOIDLCompilerType.class ).getString(
                "MSG_format_hint_MCT" )
            );

    /** Create a new compiler type.
     */
    public OOIDLCompilerType () {
        setExternalCompiler (DEFAULT);
        // setErrorExpression (ERROR_EXPRS[0]);
    }

    /** Get the display name.
     * Workaround for 1.0 core bug; not needed in 1.1 core.
     * @return the name
     */
    protected String displayName () {
        try {
            return java.beans.Introspector.getBeanInfo (getClass ()).getBeanDescriptor ().getDisplayName ();
        } catch (Exception e) {
            if (Boolean.getBoolean ("netbeans.debug.exceptions"))
                e.printStackTrace ();
            return getClass ().getName ();
        }
    }


    /** Get the help context.
     * @return help for the compiler
     */
    public HelpCtx getHelpCtx () {
        return HelpCtx.DEFAULT_HELP;
    }

    /** Add a proper compiler to the job.
     * @param job the job
     * @param type the style of compilation, controlling the target
     * @param obj the makefile
     */
   public void prepareJob (CompilerJob job, Class type, DataObject obj) {
        
        //I have choosen the prefix characters a,b,c regarding flow in which the 
       // compilers have to be called
        OOREGCompilerType bCompilerType = new OOREGCompilerType(); 
        OOURDCompilerType cCompilerType = new OOURDCompilerType();
        
        OOIDLCompiler aCompiler = new OOIDLCompiler (obj.getPrimaryFile (), getExternalCompiler (), getErrorExpression () );
      
        OOREGCompiler bCompiler = new OOREGCompiler (obj.getPrimaryFile().getPackageName('/') + ".urd",type,bCompilerType.getExternalCompiler() , bCompilerType.getErrorExpression ());
        bCompiler.dependsOn(aCompiler) ;     
//        TopManager.getDefault().notify(new NotifyDescriptor.Message(obj.getPrimaryFile().getPackageName('/') +  ".urd")); 
        OOURDCompiler cCompiler = new OOURDCompiler (obj.getPrimaryFile().getPackageName('/') +  ".urd" ,(Object) type, cCompilerType.getExternalCompiler() , cCompilerType.getErrorExpression ());
        cCompiler.dependsOn(bCompiler) ;     
        
        job.add (aCompiler);
        job.add (bCompiler);
        job.add (cCompiler);
                 
      
    }


}


 