

package org.netbeans.modules.openoffice.wizard.nodes;

import java.beans.FeatureDescriptor;
import java.util.StringTokenizer;
import org.netbeans.modules.openoffice.wizard.panels.idl.*;
import org.netbeans.modules.openoffice.wizard.keys.*;
import org.openide.nodes.AbstractNode;
import java.util.Vector;
import org.openide.nodes.Node;

public class AliasNode extends LeafNode
{

    public AliasNode(NameKey namedkey)
    {
        super(namedkey);
        setName(namedkey.getName());
        setIconBase("org/netbeans/modules/openoffice/wizard/ui/type");
    }

    public String generateSelf(int i)
    {
        String s = new String();
        for(int j = 0; j < i; j++)
            s = s + "    ";

        AliasKey aliaskey = (AliasKey)key;
        s = s + "typedef " + aliaskey.getType() + " ";
        s = s + getName() + " ";
        s = s.substring(0, s.length() - 1) + ";\n";
        return s;
    }

    public BasePanel getEditPanel()
    {
        AliasPanel aliaspanel = new AliasPanel();
        String s1 = ((AliasKey)key).getType();
        aliaspanel.setName(getName());
        aliaspanel.setType(s1);
        return aliaspanel;
    }

    public void reInit(BasePanel expanel)
    {
        if(expanel instanceof AliasPanel)
        {
            String s = ((AliasPanel)expanel).getName();
            if(!s.equals(getName()))
            {
                setName(s);
                ((AliasKey)key).setName(s);
            }
            String s1 = ((AliasPanel)expanel).getType();
            if(!s1.equals(((AliasKey)key).getType()))
                ((AliasKey)key).setType(s1);
        
        }
    }

    public void generateImports(Vector Imports1)
    {  
        Node anode[] = getChildren().getNodes();
        for(int l = 0; l < anode.length; l++)
        {
            ((BaseNode)anode[l]).generateImports(Imports1);
            
        }  
    }        
 
    private static final String ICON_BASE = "org/netbeans/modules/openoffice/wizard/ui/type";
}
