/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: chartdoc.cxx,v $
 *
 *  $Revision: 1.31 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 19:49:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"


#include <svx/eeitem.hxx>

#ifndef _CTRLTOOL_HXX //autogen
#include <svtools/ctrltool.hxx>
#endif
#ifndef _SFX_OBJSH_HXX //autogen
#include <sfx2/objsh.hxx>
#endif
#ifndef _EEITEM_HXX //autogen
#include <svx/eeitem.hxx>
#endif
#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _SV_MENU_HXX //autogen
#include <vcl/menu.hxx>
#endif
#ifndef _CTRLTOOL_HXX //autogen
#include <svtools/ctrltool.hxx>
#endif

#ifndef _ZFORLIST_HXX
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif


#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif

#ifndef _SFX_PRINTER_HXX //autogen
#include <sfx2/printer.hxx>
#endif

#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif
#ifndef _SVX_CHRTITEM_HXX //autogen
#define ITEMID_DOUBLE	        0
#define ITEMID_CHARTDATADESCR   SCHATTR_DATADESCR_DESCR
#include <svx/chrtitem.hxx>
#endif
#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#ifndef _SCH_STLPOOL_HXX
#include "stlpool.hxx"
#endif
#ifndef _SCH_SCHIOCMP_HXX
#include "schiocmp.hxx"
#endif
#ifndef _SCH_SCHRESID_HXX
#include "schresid.hxx"
#endif
#ifndef _SCH_DOCSHELL_HXX
#include "docshell.hxx"
#endif
#define ITEMID_FONT        EE_CHAR_FONTINFO
#define ITEMID_COLOR       EE_CHAR_COLOR
#define ITEMID_FONTHEIGHT  EE_CHAR_FONTHEIGHT

#include "glob.hrc"
#include "chtmodel.hxx"
#include "globfunc.hxx"

#include <svx/fontitem.hxx>
#include <svx/fhgtitem.hxx>

#ifndef _SVX_COLRITEM_HXX //autogen
#include <svx/colritem.hxx>
#endif
#ifndef _SVDLAYER_HXX //autogen
#include <svx/svdlayer.hxx>
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif

#include "pairs.hxx"
#include "chaxis.hxx"

#include "memchrt.hxx"

/*************************************************************************
|*
|* Diese Methode erzeugt ein neues Dokument (ChartModel) und gibt einen
|* Zeiger darauf zurueck. Die Drawing Engine benutzt diese Methode um das
|* Dokument oder Teile davon ins Clipboard/DragServer stellen zu koennen.
|*
|* this method works like a copy constructor. So make sure to copy all
|* members inside this method !!!
|*
\************************************************************************/
SdrModel* ChartModel::AllocModel() const
{
#ifdef DBG_UTIL
	ByteString aBStr( aMainTitle, RTL_TEXTENCODING_ASCII_US );
	CHART_TRACE1( "ChartModel::AllocModel (%s)", aBStr.GetBuffer() );
#endif

	ChartModel *pNewModel = new ChartModel( SvtPathOptions().GetPalettePath(), NULL );
	pNewModel->SetChartData (*pChartData, TRUE);

	pNewModel->TextScalability ()      = bTextScalable;
	pNewModel->IsCopied ()             = bIsCopied;
	pNewModel->ShowAverage ()          = bShowAverage;
	pNewModel->ChartKindError ()       = eErrorKind;
	pNewModel->ChartIndicate ()        = eIndicate;
	pNewModel->ChartRegress ()         = eRegression;

	pNewModel->IndicatePercent ()      = fIndicatePercent;
	pNewModel->IndicateBigError ()     = fIndicateBigError;
	pNewModel->IndicatePlus ()         = fIndicatePlus;
	pNewModel->IndicateMinus ()        = fIndicateMinus;
	pNewModel->nSplineDepth             = nSplineDepth;
	pNewModel->Granularity ()          = nGranularity;

	pNewModel->InitialSize ()          = aInitialSize;
	pNewModel->LightVec ()             = *aLightVec;
	pNewModel->SetAmbientIntensity (fAmbientIntensity);
	pNewModel->SetAmbientColor(aAmbientColor);
	pNewModel->SpotIntensity ()        = fSpotIntensity;
	pNewModel->SetSpotColor(aSpotColor);
	pNewModel->ChartStyle ()           = eChartStyle;
	pNewModel->OldChartStyle ()        = eOldChartStyle;
	pNewModel->PieHeight ()            = nPieHeight;
	pNewModel->PieSegCount ()          = nPieSegCount;
	pNewModel->ShowMainTitle ()        = bShowMainTitle;
	pNewModel->ShowSubTitle ()         = bShowSubTitle;
	pNewModel->ShowXAxisTitle ()       = bShowXAxisTitle;
	pNewModel->ShowYAxisTitle ()       = bShowYAxisTitle;
	pNewModel->ShowZAxisTitle ()       = bShowZAxisTitle;
//    pNewModel->ShowXAxis ()            = bShowXAxis;
//    pNewModel->ShowYAxis ()            = bShowYAxis;
//    pNewModel->ShowZAxis ()            = bShowZAxis;
	pNewModel->ShowXGridMain ()        = bShowXGridMain;
	pNewModel->ShowYGridMain ()        = bShowYGridMain;
	pNewModel->ShowZGridMain ()        = bShowZGridMain;
	pNewModel->ShowXGridHelp ()        = bShowXGridHelp;
	pNewModel->ShowYGridHelp ()        = bShowYGridHelp;
	pNewModel->ShowZGridHelp()         = bShowZGridHelp;
//    pNewModel->ShowXDescr ()           = bShowXDescr;
//    pNewModel->ShowYDescr ()           = bShowYDescr;
//    pNewModel->ShowZDescr ()           = bShowZDescr;
	pNewModel->MainTitle ()            = aMainTitle;
	pNewModel->SubTitle ()             = aSubTitle;
	pNewModel->XAxisTitle ()           = aXAxisTitle;
	pNewModel->YAxisTitle ()           = aYAxisTitle;
	pNewModel->ZAxisTitle ()           = aZAxisTitle;

	pNewModel->ShowSym ()              = bShowSym;
	pNewModel->SetSwitchData(bSwitchData);

	pNewModel->aBarY1 = aBarY1;
    pNewModel->aBarY1.ChangeModel( pNewModel );
	pNewModel->aBarY2 = aBarY2;
    pNewModel->aBarY2.ChangeModel( pNewModel );

	pNewModel->ReadError ()            = bReadError;
	pNewModel->DataDescr  ()           = eDataDescr;

	pNewModel->CopyDefaultColors (pDefaultColors);
	pNewModel->SetShowLegend (bLegendVisible);
//    pNewModel->SetChartData (*pChartData, TRUE); #64058#
	pNewModel->SetAngles (nXAngle, nYAngle, nZAngle);

	pNewModel->AllocPieSegOfs (nPieSegCount);

	// #68527# BM: some attributes have been missing

	pNewModel->SetUseRelativePositions( bUseRelativePositionsForChartGroups );
	pNewModel->aDiagramRectangle				= aDiagramRectangle;
	pNewModel->aLastDiagramRectangle			= aDiagramRectangle;
	pNewModel->bDiagramHasBeenMovedOrResized	= bDiagramHasBeenMovedOrResized;
	pNewModel->aLegendTopLeft					= aLegendTopLeft;
	pNewModel->aTitleTopCenter					= aTitleTopCenter;
	pNewModel->aSubTitleTopCenter				= aSubTitleTopCenter;
	pNewModel->aTitleXAxisPosition				= aTitleXAxisPosition;
	pNewModel->aTitleYAxisPosition				= aTitleYAxisPosition;
	pNewModel->aTitleZAxisPosition				= aTitleZAxisPosition;
	pNewModel->bAdjustMarginsForLegend			= bAdjustMarginsForLegend;
	pNewModel->bAdjustMarginsForMainTitle		= bAdjustMarginsForMainTitle;
	pNewModel->bAdjustMarginsForSubTitle		= bAdjustMarginsForSubTitle;
	pNewModel->bAdjustMarginsForXAxisTitle		= bAdjustMarginsForXAxisTitle;
	pNewModel->bAdjustMarginsForYAxisTitle		= bAdjustMarginsForYAxisTitle;
	pNewModel->bAdjustMarginsForZAxisTitle		= bAdjustMarginsForZAxisTitle;
	pNewModel->bDiagramHasBeenMovedOrResized	= bDiagramHasBeenMovedOrResized;
	pNewModel->bMainTitleHasBeenMoved			= bMainTitleHasBeenMoved;
	pNewModel->bSubTitleHasBeenMoved			= bSubTitleHasBeenMoved;
	pNewModel->bLegendHasBeenMoved				= bLegendHasBeenMoved;
	pNewModel->bXAxisTitleHasBeenMoved			= bXAxisTitleHasBeenMoved;
	pNewModel->bYAxisTitleHasBeenMoved			= bYAxisTitleHasBeenMoved;
	pNewModel->bZAxisTitleHasBeenMoved			= bZAxisTitleHasBeenMoved;
	pNewModel->bSwitch3DColRow					= bSwitch3DColRow;
	pNewModel->nMarkLen							= nMarkLen;
	pNewModel->bCanRebuild						= bCanRebuild;
	pNewModel->bShowDataDescr					= bShowDataDescr;
	pNewModel->eAdjustXAxesTitle				= eAdjustXAxesTitle;
	pNewModel->eAdjustYAxesTitle				= eAdjustYAxesTitle;
	pNewModel->eAdjustZAxesTitle				= eAdjustZAxesTitle;
	pNewModel->nBarPercentWidth					= nBarPercentWidth;
	pNewModel->nNumLinesInColChart				= nNumLinesInColChart;
	pNewModel->aChartRect						= aChartRect;
	pNewModel->aInitialSize						= aInitialSize;
	pNewModel->nChartStatus						= nChartStatus;
	pNewModel->bAttrAutoStorage					= bAttrAutoStorage;

	// #68527# BM: End

	pNewModel->PutTitleAttr(	 *pTitleAttr     ,FALSE);
	pNewModel->PutMainTitleAttr( *pMainTitleAttr ,FALSE);
	pNewModel->PutSubTitleAttr(  *pSubTitleAttr  ,FALSE);
	pNewModel->PutXAxisTitleAttr(*pXAxisTitleAttr,FALSE);
	pNewModel->PutYAxisTitleAttr(*pYAxisTitleAttr,FALSE);
	pNewModel->PutZAxisTitleAttr(*pZAxisTitleAttr,FALSE);

	// merge numberformatters
	if( pNewModel->pOwnNumFormatter && pNumFormatter )
	{
		SvNumberFormatterIndexTable* pTransTable =
			pNewModel->pOwnNumFormatter->MergeFormatter( *pNumFormatter );

		if( pTransTable && pTransTable->Count() )
		{
			// we have to merge some formats
			DBG_ERROR1( "Unexpected situation: %d number format(s) have to be merged.", pTransTable->Count() );
		}
	}

	pNewModel->PutAxisAttr (*pAxisAttr,FALSE);

	pNewModel->CopyAxisMembers(this);
	pNewModel->CopyAxisAttributes(this,FALSE);

	pNewModel->PutGridAttr (*pGridAttr,FALSE);
	pNewModel->PutXGridMainAttr(*pXGridMainAttr,FALSE);
	pNewModel->PutYGridMainAttr(*pYGridMainAttr,FALSE);
	pNewModel->PutZGridMainAttr(*pZGridMainAttr,FALSE);
	pNewModel->PutXGridHelpAttr(*pXGridHelpAttr,FALSE);
	pNewModel->PutYGridHelpAttr(*pYGridHelpAttr,FALSE);
	pNewModel->PutZGridHelpAttr(*pZGridHelpAttr,FALSE);

	pNewModel->PutDiagramAreaAttr(*pDiagramAreaAttr,FALSE);
	pNewModel->PutDiagramWallAttr(*pDiagramWallAttr,FALSE);
	pNewModel->PutDiagramFloorAttr(*pDiagramFloorAttr,FALSE);

	pNewModel->PutLegendAttr (*pLegendAttr,FALSE);
	pNewModel->SetItemSetLists(*this);
	pNewModel->PutChartAttr(*pChartAttr,FALSE);

	pNewModel->SetAttributes(CHOBJID_DIAGRAM_STOCKLINE_GROUP,*pStockLineAttr,FALSE);
	pNewModel->SetAttributes(CHOBJID_DIAGRAM_STOCKLOSS_GROUP,*pStockLossAttr,FALSE);
	pNewModel->SetAttributes(CHOBJID_DIAGRAM_STOCKPLUS_GROUP,*pStockPlusAttr,FALSE);

	DBG_ITEMS((SfxItemSet&)pNewModel->GetDataRowAttr(0),pNewModel);
	DBG_ITEMS((SfxItemSet&)GetDataRowAttr(0),(ChartModel*)this);

	return pNewModel;
}

/*************************************************************************
|*
|* Diese Methode erzeugt eine neue Seite (SchPage) und gibt einen Zeiger
|* darauf zurueck. Die Drawing Engine benutzt diese Methode beim Laden
|* zur Erzeugung von Seiten (deren Typ sie ja nicht kennt, da es ABLEITUNGEN
|* der SdrPage sind).
|*
\************************************************************************/

SdrPage* ChartModel::AllocPage(FASTBOOL bMasterPage)
{
	return new SdrPage(*this, bMasterPage);
}
/*************************************************************************
|*
|* Inserter fuer SvStream zum Speichern
|*
\************************************************************************/
//BFS03SvStream& operator << (SvStream& rOut, const ChartModel& rDoc)
//BFS03{
//BFS03	// die daemlichen blockklammern muessen erhalten bleiben, damit
//BFS03	// im destruktor ~SchIOCompat dei korrekte blockgroesse geschrieben
//BFS03	// wird. ansonsten gibt es beim einlesen mit der 304 jede menge
//BFS03	// aerger
//BFS03	{
//BFS03		SchIOCompat aIO(rOut, STREAM_WRITE, 1);
//BFS03
//BFS03		// AF: Don't write VCItemPool any longer (01/2001)
//BFS03		rOut << (ULONG)0L;
//BFS03
//BFS03		/**************************************************************************
//BFS03		* Frueher (StarChart Version 3.0, File-Format Version 1) wurde hier das
//BFS03		* JobSetup geschrieben, nun der Printer (binaer-kompatibel, daher wurde
//BFS03		* die Version des File-Formats nicht geaendert)
//BFS03		**************************************************************************/
//BFS03		if (rDoc.pDocShell)
//BFS03		{
//BFS03			SfxPrinter* pPrinter =
//BFS03				 ((SchChartDocShell*)rDoc.pDocShell)->GetPrinter();
//BFS03
//BFS03
//BFS03			if (pPrinter)
//BFS03			{
//BFS03				pPrinter->Store(rOut);
//BFS03			}
//BFS03			else
//BFS03			{
//BFS03				// Es ist kein Printer vorhanden -> muss erzeugt werden
//BFS03				SfxBoolItem aItem(SID_PRINTER_NOTFOUND_WARN, TRUE);
//BFS03				SfxItemSet* pSet = new SfxItemSet(((ChartModel&) rDoc).GetPool(),
//BFS03								SID_PRINTER_NOTFOUND_WARN,
//BFS03								SID_PRINTER_NOTFOUND_WARN, 0);
//BFS03				pSet->Put(aItem);
//BFS03				SfxPrinter* pPrinter = new SfxPrinter(pSet);
//BFS03
//BFS03				MapMode aMapMode = pPrinter->GetMapMode();
//BFS03				aMapMode.SetMapUnit(MAP_100TH_MM);
//BFS03				pPrinter->SetMapMode(aMapMode);
//BFS03
//BFS03				pPrinter->Store(rOut);
//BFS03				delete pPrinter;
//BFS03				//delete pSet; bloss nicht! Killt der Printer gleich mit!
//BFS03			}
//BFS03		}
//BFS03		else
//BFS03		{
//BFS03			// Keine DocShell, daher wird ein JobSetup geschrieben
//BFS03			JobSetup aJobSetup;
//BFS03			rOut << aJobSetup;
//BFS03		}
//BFS03	}
//BFS03
//BFS03
//BFS03	rOut << (SdrModel&) rDoc;
//BFS03
//BFS03	SchIOCompat aIO(rOut, STREAM_WRITE, 0);
//BFS03
//BFS03	rDoc.StoreAttributes(rOut);
//BFS03	//<- ehemals Basisklasse
//BFS03
//BFS03
//BFS03
//BFS03	return rOut;
//BFS03}

/*************************************************************************
|*
|* Extractor fuer SvStream zum Laden
|*
\************************************************************************/

//BFS03SvStream& operator >> (SvStream& rIn, ChartModel& rDoc)
//BFS03{
//BFS03	// auch hier muessen die blockklammern erhalten bleiben,
//BFS03	// um 304-er dokumente sauber lesen zu koennen.
//BFS03	{
//BFS03		SchIOCompat aIO(rIn, STREAM_READ);
//BFS03
//BFS03		ULONG n;
//BFS03		rIn >> n;
//BFS03		// must be 0 or 1. Otherwise we have an error
//BFS03		// most probably a wrong password
//BFS03		if( n == 1L )
//BFS03		{
//BFS03			// AF: Skip VCItemPool.
//BFS03			rIn.SeekRel (74);
//BFS03		}
//BFS03		else if( n != 0L )
//BFS03		{
//BFS03			rIn.SetError( ERRCODE_IO_GENERAL );
//BFS03			return rIn;
//BFS03		}
//BFS03
//BFS03		if (aIO.GetVersion() >= 1)
//BFS03		{
//BFS03
//BFS03			/******************************************************************
//BFS03			* Frueher (StarChart Version 3.0, File-Format Version 1) wurde hier
//BFS03			* das JobSetup eingelesen, nun wird der Printer erzeugt
//BFS03			* (binaer-kompatibel)
//BFS03			*******************************************************************/
//BFS03			// ItemSet mit speziellem Poolbereich anlegen
//BFS03			SfxItemSet* pSet =
//BFS03				new SfxItemSet(rDoc.GetPool(),
//BFS03							   SID_PRINTER_NOTFOUND_WARN,
//BFS03							   SID_PRINTER_NOTFOUND_WARN, 0);
//BFS03			pSet->Put(SfxBoolItem(SID_PRINTER_NOTFOUND_WARN, TRUE));
//BFS03
//BFS03			SfxPrinter* pPrinter = SfxPrinter::Create(rIn, pSet);
//BFS03
//BFS03			MapMode aMM(pPrinter->GetMapMode());
//BFS03			aMM.SetMapUnit(MAP_100TH_MM);
//BFS03			pPrinter->SetMapMode(aMM);
//BFS03
//BFS03			if (rDoc.pDocShell->GetCreateMode() != SFX_CREATE_MODE_EMBEDDED)
//BFS03			{
//BFS03				((SchChartDocShell*)rDoc.pDocShell)->SetPrinter( pPrinter, TRUE );	// will be deleted by DocShell
//BFS03			}
//BFS03			else
//BFS03			{
//BFS03				delete pPrinter;
//BFS03			}
//BFS03		}
//BFS03	}
//BFS03
//BFS03	// statt Basisklassenaufruf [    rIn >> (ChartModel&)rDoc;] direkt:
//BFS03	rIn >> (SdrModel&)rDoc;
//BFS03
//BFS03	if (rIn.GetError() != SVSTREAM_FILEFORMAT_ERROR)
//BFS03	{
//BFS03		SchIOCompat aIO(rIn, STREAM_READ);
//BFS03
//BFS03		rDoc.LoadAttributes(rIn);
//BFS03	}
//BFS03	// <- Basisaufruf
//BFS03
//BFS03	rDoc.GetItemPool().LoadCompleted();
//BFS03
//BFS03	rDoc.ReadError () = FALSE;
//BFS03
//BFS03	// alle 3D-Objekte werden bei einem Paint erstmailg sortiert, damit wird auch
//BFS03	// das Dokument als geaendert gekennzeichnet. Diese Variable wird in der
//BFS03	// CHVIEWSH-Paint-Methode abgefragt und bei Bedarf wird der Modified-Status
//BFS03	// des Dokuments zurueckgesetzt.
//BFS03
//BFS03	// no longer needed
//BFS03//-  	rDoc.FreshLoaded () = TRUE;
//BFS03
//BFS03	return rIn;
//BFS03}

/*************************************************************************
|*
|* SetChanged(), das Model wurde geaendert
|*
\************************************************************************/

void ChartModel::SetChanged(sal_Bool bFlag)
{
    if( m_bChangeNotificationsEnabled &&
        ! bNoBuildChart )
    {
        if( pDocShell )
        {
            SdrModel::SetChanged( bFlag );

            if( bNewOrLoadCompleted )
            {
                pDocShell->SetModified( bFlag );
            }
        }
        else
        {
            SdrModel::SetChanged( bFlag );
        }
    }
}

/*************************************************************************
|*
|* NewOrLoadCompleted
|*
|* Wird gerufen, wenn das Dokument geladen wurde bzw. feststeht, dass es
|* nicht mehr geladen wird.
|*
\************************************************************************/

void ChartModel::NewOrLoadCompleted(USHORT eMode)
{
	if (eMode == NEW_DOC)
	{
		// StyleSheets generieren
		Font aFont( OutputDevice::GetDefaultFont( DEFAULTFONT_SANS, GetLanguage( EE_CHAR_LANGUAGE ), DEFAULTFONT_FLAGS_ONLYONE ) );
		SvxFontItem aFontItem( aFont.GetFamily(), aFont.GetName(), aFont.GetStyleName(), aFont.GetPitch(),
			                   aFont.GetCharSet(), EE_CHAR_FONTINFO );

		SfxStyleSheetBase* pSheet =
			&pStyleSheetPool->Make(String(SchResId(STR_STLSHEET_TITLE_MAIN)),
										  SFX_STYLE_FAMILY_PARA);
		pSheet->GetItemSet().Put(aFontItem);
		pSheet->GetItemSet().Put(SvxColorItem( Color( COL_AUTO ) ));
		pSheet->GetItemSet().Put(SvxFontHeightItem(493));

		pSheet = &pStyleSheetPool->
					Make(String(SchResId(STR_STLSHEET_TITLE_SUB)),
						 SFX_STYLE_FAMILY_PARA);
		pSheet->GetItemSet().Put(aFontItem);
		pSheet->GetItemSet().Put(SvxColorItem( Color( COL_AUTO ) ));
		pSheet->GetItemSet().Put(SvxFontHeightItem(423));

		pSheet = &pStyleSheetPool->
					Make(String(SchResId(STR_STLSHEET_TITLE_X_AXIS)),
						 SFX_STYLE_FAMILY_PARA);
		pSheet->GetItemSet().Put(aFontItem);
		pSheet->GetItemSet().Put(SvxColorItem( Color( COL_AUTO ) ));
		pSheet->GetItemSet().Put(SvxFontHeightItem(352));

		pSheet = &pStyleSheetPool->
					Make(String(SchResId(STR_STLSHEET_TITLE_Y_AXIS)),
						 SFX_STYLE_FAMILY_PARA);
		pSheet->GetItemSet().Put(aFontItem);
		pSheet->GetItemSet().Put(SvxColorItem( Color( COL_AUTO ) ));
		pSheet->GetItemSet().Put(SvxFontHeightItem(352));

		pSheet = &pStyleSheetPool->
					Make(String(SchResId(STR_STLSHEET_TITLE_Z_AXIS)),
						 SFX_STYLE_FAMILY_PARA);
		pSheet->GetItemSet().Put(aFontItem);
		pSheet->GetItemSet().Put(SvxColorItem( Color( COL_AUTO ) ));
		pSheet->GetItemSet().Put(SvxFontHeightItem(352));

		pSheet = &pStyleSheetPool->
					Make(String(SchResId(STR_STLSHEET_DATAROWS)),
						 SFX_STYLE_FAMILY_PARA);
		pSheet->GetItemSet().Put(aFontItem);
		pSheet->GetItemSet().Put(SvxColorItem( Color( COL_AUTO ) ));
		pSheet->GetItemSet().Put(SvxFontHeightItem(282));

		pSheet = &pStyleSheetPool->
					Make(String(SchResId(STR_STLSHEET_DATACOLS)),
						 SFX_STYLE_FAMILY_PARA);
		pSheet->GetItemSet().Put(aFontItem);
		pSheet->GetItemSet().Put(SvxColorItem( Color( COL_AUTO ) ));
		pSheet->GetItemSet().Put(SvxFontHeightItem(282));

		pSheet = &pStyleSheetPool->
					Make(String(SchResId(STR_STLSHEET_DATAVALUES)),
						 SFX_STYLE_FAMILY_PARA);
		pSheet->GetItemSet().Put(aFontItem);
		pSheet->GetItemSet().Put(SvxColorItem( Color( COL_AUTO ) ));
		pSheet->GetItemSet().Put(SvxFontHeightItem(282));

		pSheet = &pStyleSheetPool->
					Make(String(SchResId(STR_STLSHEET_DATADESCR)),
						 SFX_STYLE_FAMILY_PARA);
		pSheet->GetItemSet().Put(aFontItem);
		pSheet->GetItemSet().Put(SvxColorItem( Color( COL_AUTO ) ));
		pSheet->GetItemSet().Put(SvxFontHeightItem(282));

		pSheet = &pStyleSheetPool->
					Make(String(SchResId(STR_STLSHEET_LEGEND)),
						 SFX_STYLE_FAMILY_PARA);
		pSheet->GetItemSet().Put(aFontItem);
		pSheet->GetItemSet().Put(SvxColorItem( Color( COL_AUTO )));
		pSheet->GetItemSet().Put(SvxFontHeightItem(282));

        pAxisAttr->ClearItem( SCHATTR_AXIS_SHOWDESCR );
	}
	else if (eMode == DOC_LOADED)
	{
        // set intersection of all axis attributes used as axis
        // 'style' (that is an itemset for the 'all axes' dialog)
        GetFullAxisAttr( NULL, true ).ClearInvalidItems();
        pAxisAttr->ClearItem( SCHATTR_AXIS_SHOWDESCR );

        // set 'all axis' attributes on all axes that are currently
        // disabled
        if( ! HasAxis( CHOBJID_DIAGRAM_X_AXIS ))
            pChartXAxis->SetAttributes( pAxisAttr );
        if( ! HasAxis( CHOBJID_DIAGRAM_Y_AXIS ))
            pChartYAxis->SetAttributes( pAxisAttr );
        if( ! HasAxis( CHOBJID_DIAGRAM_Z_AXIS ))
            pChartZAxis->SetAttributes( pAxisAttr );
        if( ! HasAxis( CHOBJID_DIAGRAM_A_AXIS ))
            pChartAAxis->SetAttributes( pAxisAttr );
        if( ! HasAxis( CHOBJID_DIAGRAM_B_AXIS ))
            pChartBAxis->SetAttributes( pAxisAttr );
        // #99528# change auto-font color according to diagram area
        PageColorChanged( *pDiagramAreaAttr );

        // #101591# set precision of own number-formatter to 2 if we reside in a
        // calc or writer, which is assumed by checking the cell-range in the
        // MemChart.
        OSL_ASSERT( pChartData );
        if( pChartData )
        {
            const SchChartRange & rRange = pChartData->GetChartRange();
            if( rRange.maRanges.size() > 0 )
            {
                pOwnNumFormatter->ChangeStandardPrec( 2 );
            }
        }
	}

	bNewOrLoadCompleted = TRUE;
#ifdef DBG_UTIL
	if(pChartData && GetRowCount() && GetColCount())
	{
		CHART_TRACE1( "ChartModel::NewOrLoadCompleted debugging ChartItems Model %s ",
					  (eMode==DOC_LOADED)? "was loaded": ((eMode==NEW_DOC)? "is new" : "don't know") );
		DBG_ITEMS((SfxItemSet&)GetDataRowAttr(0),this);
		DBG_ITEMS((SfxItemSet&)GetDataPointAttr(0,0),this);
	}
#endif
}

/*************************************************************************
|*
|* Setze den Modified-Status zurueck, wenn ein Dokument mit
|* 3D-Objekten geladen und ausgegeben wurde
|*
\************************************************************************/

//  void ChartModel::ResetFreshLoaded ()
//  {
//  	bFreshLoaded = FALSE;
//  	SetChanged (FALSE);
//  }


