/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fusel.cxx,v $
 *
 *  $Revision: 1.19 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:14:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"


#include <sfx2/docfile.hxx>

#ifndef _SVDORECT_HXX //autogen
#include <svx/svdorect.hxx>
#endif

#ifndef _SVDPAGV_HXX //autogen
#include <svx/svdpagv.hxx>
#endif
// header for SdrCircObj
#ifndef _SVDOCIRC_HXX
#include <svx/svdocirc.hxx>
#endif

#include <sfx2/viewfrm.hxx>

#include "app.hrc"
#include "fudraw.hxx"
#include "fusel.hxx"
#include "viewshel.hxx"
#include "schview.hxx"
#include <svx/scene3d.hxx>
#include <svx/polysc3d.hxx>
#include "chwindow.hxx"
#include "objid.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#ifndef _SCH_DATAPOIN_HXX
#include "datapoin.hxx"
#endif
#ifndef _SCH_DATAROW_HXX
#include "datarow.hxx"
#endif
#include "schgroup.hxx"
#include "chtscene.hxx"

// header for SchCalculationHelper
#include "calculat.hxx"
// header for SchDragConstrainedToVector
#include "schdrgmt.hxx"
#include "undmovsize.hxx"
#include "undmovpieseg.hxx"
#include "strings.hrc"

TYPEINIT1(SchFuSelection, SchFuDraw);


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuSelection::SchFuSelection(SchViewShell* pViewSh, SchWindow* pWin,
							   SchView* pView, ChartModel* pDoc,
							   SfxRequest& rReq) :
		SchFuDraw(pViewSh, pWin, pView, pDoc, rReq),
		bVCAction(FALSE),
		pDragMethod(NULL)
{
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchFuSelection::~SchFuSelection()
{
	if( pView->GetDragMode() != SDRDRAG_MOVE )
		pView->SetDragMode(SDRDRAG_MOVE);
}

/*************************************************************************
|*
|* Wege durch die MouseUp/Down Events:
|*
|* Weg A:  markierte Gesamtflaeche -> markierte Diagramflaeche (DIAGRAM_AREA -> DIAGRAM)
|*         (durch Klick in freie Flaeche, z.B. neben einem Datenpunkt)
|* Weg B:  markierte Gesamtflaeche -> markierte Datenreihe
\*************************************************************************/

/*************************************************************************
|*
|* MouseButtonDown-event
|*
\************************************************************************/

BOOL SchFuSelection::MouseButtonDown(const MouseEvent& rMEvt)
{
    // guard object to suspend sending broadcasts
    SuspendSelectionChangeBroadcasting aSelectionSuspender( pViewShell );

    BOOL bReturn = SchFuDraw::MouseButtonDown(rMEvt);

    bMBDown = TRUE;

    if( pView->IsAction() )
    {
		if( rMEvt.IsRight() )
			pView->BckAction();
		return TRUE;
    }

    bWasSelected = FALSE;

    if( rMEvt.IsLeft() )
    {
		pWindow->CaptureMouse();

		SdrHdl* pHdl = NULL;
		SdrObject* pObj = NULL;
		SdrPageView* pPV = NULL;
		SchObjectId* pObjId = NULL;

		pViewShell->SetMousePos( aMDPos );

		USHORT nDrgLog = (USHORT)pWindow->PixelToLogic(Size(DRGPIX,0)).Width();
		USHORT nHitLog = (USHORT)pWindow->PixelToLogic(Size(HITPIX,0)).Width();

		if( pView->GetPageViewPvNum(0)->GetEnteredLevel() == 0 )
			pHdl = pView->PickHandle( aMDPos, *pWindow );

		const SdrMarkList& rMarkList = pView->GetMarkedObjectList();
		SchChartDocShell* pDocSh = (SchChartDocShell*) pChDoc->GetObjectShell();

		if(!pDocSh)
		{
			DBG_ERROR("pDocSh lost!");
			return FALSE;
		}

		// click on marked object
		// ----------------------
		if( (pView->IsMarkedHit(aMDPos, nHitLog) &&
			 !rMEvt.IsShift() && !rMEvt.IsMod2() || pHdl)
			&& rMarkList.GetMark(0)) //#57196#
		{
			pObj   = rMarkList.GetMark(0)->GetMarkedSdrObj();
			pObjId = GetObjectId(*pObj);

			bWasSelected = TRUE;

			SdrObject *pOldObj = NULL;
			
			if( pObjId )
			{
				DBG_TRACE2( "SchFuSelection::MouseButtonDown Step 1, ObjId=%ld (%s)", pObjId->GetObjId(), GetCHOBJIDName( pObjId->GetObjId()));
				switch( pObjId->GetObjId() )
				{
					case CHOBJID_DIAGRAM_TITLE_X_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
					case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
						
					case CHOBJID_TITLE_MAIN:
					case CHOBJID_TITLE_SUB:
						{
							pHdl = NULL;
							pView->SetFrameDragSingles(TRUE);
							
							if( !pDocSh->IsReadOnly() )
							{
								pView->BegDragObj(aMDPos, NULL, pHdl, nDrgLog);
							}
						}
						break;

					case CHOBJID_DIAGRAM_AREA:									// path A,B #1
						{
							SdrPage *pPage = pChDoc->GetPage(0);

							if( pPage )
							{
								SdrObject *pDiagramObj = GetObjWithId( CHOBJID_DIAGRAM, *pPage, 0, IM_DEEPWITHGROUPS );
								SchObjectId* pDiagramId = NULL;

								if( pDiagramObj )
								{
									SdrPageView* pPV = pView->GetPageViewPvNum( 0 );

									pView->UnmarkAll();                       // path A,B #2
									pView->SetMarkHdlHidden(TRUE);
									pView->SetFrameDragSingles(FALSE);
									pView->PickObj( aMDPos, 50, pDiagramObj, pPV );		// pDiagramObj <- next level object in group

									SchObjectId* pDiaObjId = NULL;
									if( pDiagramObj ) // might be set to NULL in PickObj
									{
										pDiaObjId = GetObjectId( *pDiagramObj );

										if( pDiaObjId )
										{
											switch(pDiaObjId->GetObjId())
											{
												case CHOBJID_LEGEND:
												case CHOBJID_LEGEND_BACK:
												case CHOBJID_TITLE_MAIN:
												case CHOBJID_TITLE_SUB:
												case CHOBJID_DIAGRAM_TITLE_X_AXIS:
												case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
												case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
												case CHOBJID_DIAGRAM_AREA:
													pView->SetFrameDragSingles(TRUE);
													pView->MarkObj( pDiagramObj, pPV );
													break;

												default:
													pView->MarkObj( pDiagramObj, pPV );
													pView->EnterMarkedGroup();
													break;
											}
										}
									}

									if( pView->PickObj( aMDPos, nHitLog, pDiagramObj, pPV ))		// pDiagramObj <- next level object in group
										pView->MarkObj( aMDPos, nHitLog );      // path A,B #3

									pView->SetMarkHdlHidden(FALSE);

									//TVM: Wenn DonutChart, dann darf nicht versucht werden, eine
									//     Datenreihe zu markieren, die gibt es dort nicht als
									//     Gruppenobjekt!
									if(pObj==pDiagramObj || pChDoc->IsDonutChart())
									{
										pDiagramObj = GetObjWithId( CHOBJID_DIAGRAM, *pPage, 0, IM_DEEPWITHGROUPS );
										if(pDiagramObj)
										{
											if(pDiagramObj->GetLogicRect().IsInside(aMDPos))
											{
												pView->LeaveOneGroup();       // path A #4
												pView->UnmarkAll();
												pView->MarkObj(pDiagramObj,pPV);
												pView->SetFrameDragSingles(TRUE);
											}
										}
									}
									else
									{
										if(pDiagramObj)
										{
											pDiagramId = GetObjectId(*pDiagramObj);
											if(pDiagramId)
											{
												short nId = pDiagramId->GetObjId();  // path B #4
												switch(nId)
												{
													case CHOBJID_DIAGRAM_ROWGROUP:
                                                        if( pChDoc->IsFlat3DChart() )
                                                            Select3DGroupMembers(pObj,pPV);
														break;
													case CHOBJID_LEGEND:
														pView->LeaveOneGroup();
														pView->UnmarkAll();
														pView->MarkObj(pDiagramObj,pPV);
														pView->SetFrameDragSingles(TRUE);
														break;
												}
											}
											else
											{
												//DBG_TRACE("new selection in Chart::Fusel.cxx");
												// ohne diesen Block ist es moeglich, 3D-Achsenbeschr. zu selektieren
												pDiagramObj = GetObjWithId( CHOBJID_DIAGRAM, *pPage, 0, IM_DEEPWITHGROUPS );
												if(pDiagramObj)
												{
													pView->LeaveOneGroup();
													pView->UnmarkAll();
													pView->MarkObj(pDiagramObj,pPV);
													pView->SetFrameDragSingles( FALSE ); // TRUE
												}
											}
										}
									}
								}
							}
						}
						break;

					case CHOBJID_DIAGRAM:
						{
							if( !pDocSh->IsReadOnly() )
							{
								pView->BegDragObj(aMDPos, NULL, pHdl, nDrgLog); // ReSize
							}
						}
						break;

					case CHOBJID_DIAGRAM_DATA :
						// drag pie segments
						if( pChDoc->IsPieChart()
							&& !pDocSh->IsReadOnly() )
						{
							CreatePieDragMethod( SAL_STATIC_CAST( SdrCircObj*, pObj ) );
							pView->BegDragObj( aMDPos, NULL, pHdl, nDrgLog, pDragMethod );
						}
						if( !pView->IsLogicalGroupMarked() )
							break;
						// else continue with following block

					case CHOBJID_DIAGRAM_STACKEDGROUP:
					case CHOBJID_DIAGRAM_SPECIAL_GROUP:
					case CHOBJID_LEGEND:
						{
							pView->SetMarkHdlHidden(TRUE);

							if(CHOBJID_LEGEND!=pObjId->GetObjId())
								pView->SetFrameDragSingles(FALSE);
							else
								pView->SetFrameDragSingles(TRUE);

							pView->MarkObj(aMDPos, nHitLog);
							pView->EnterMarkedGroup();

							if( pView->PickObj(aMDPos, nHitLog, pObj, pPV) )
								pView->MarkObj(aMDPos, nHitLog);

							pView->SetMarkHdlHidden(FALSE);

							if(pObj)
							{
								SchObjectId* pSubObjId = GetObjectId(*pObj);
								if(pSubObjId)
								{
									long nId=pSubObjId->GetObjId();
									DBG_TRACE2( "SchFuSelection::MouseButtonDown Step 2, ObjId=%ld (%s)", nId, GetCHOBJIDName( nId ));

									if(nId<10)				 // meaning simple object (line, area, text, any)
									{
										pOldObj = GetObjWithId( CHOBJID_LEGEND, *pChDoc->GetPage(0), 0, IM_DEEPWITHGROUPS );
										if(pOldObj->GetLogicRect().IsInside(aMDPos))
										{
											pView->LeaveOneGroup();
											pView->UnmarkAll();
											pView->MarkObj(pOldObj,pPV);
											pView->SetFrameDragSingles(TRUE);

											if( !pDocSh->IsReadOnly() )
											{
												pView->BegDragObj( aMDPos, NULL, pHdl, nDrgLog );
											}
										}
									}
								}
							}
						}
						break;

					case CHOBJID_DIAGRAM_ROWGROUP:
//					case CHOBJID_3D_PIE_TOP:
						{
							switch( pChDoc->ChartStyle() )
							{
								case CHSTYLE_2D_AREA :
								case CHSTYLE_2D_STACKEDAREA :
								case CHSTYLE_2D_PERCENTAREA :
								case CHSTYLE_3D_STRIPE :
								case CHSTYLE_3D_AREA :
								case CHSTYLE_3D_STACKEDAREA :
								case CHSTYLE_3D_PERCENTAREA :
								case CHSTYLE_3D_SURFACE :
								case CHSTYLE_2D_LINE :
								case CHSTYLE_2D_STACKEDLINE :
								case CHSTYLE_2D_PERCENTLINE :
								case CHSTYLE_2D_CUBIC_SPLINE :
								case CHSTYLE_2D_B_SPLINE :
								case CHSTYLE_2D_NET :
								case CHSTYLE_2D_NET_STACK :
								case CHSTYLE_2D_NET_PERCENT :
								// #72910# xy types
								case CHSTYLE_2D_XY_LINE :		// lines only
								case CHSTYLE_2D_CUBIC_SPLINE_XY :
								case CHSTYLE_2D_B_SPLINE_XY :
									break;

								case CHSTYLE_2D_XY :			// lines + symbols
								case CHSTYLE_2D_CUBIC_SPLINE_SYMBOL_XY :
								case CHSTYLE_2D_B_SPLINE_SYMBOL_XY :
									pView->SetMarkHdlHidden(TRUE);
									pView->EnterMarkedGroup();
									pView->MarkObj(aMDPos, nHitLog);

									// if marked object is not a data point,
									// go up one level again
									if( rMarkList.GetMarkCount() )
									{
										SdrObject* pSubObj = rMarkList.GetMark( 0 )->GetMarkedSdrObj();
										if( pSubObj )
										{
											SchObjectId* pSubObjId = GetObjectId( *pSubObj );
											if( pSubObjId )
											{
												if( pSubObjId->GetObjId() != CHOBJID_DIAGRAM_DATA )
													pView->LeaveOneGroup();
											}
											else
												pView->SetFrameDragSingles(FALSE);
										}
									}

									pView->SetMarkHdlHidden(FALSE);									
									break;

								default:
									if( rMEvt.GetClicks() == 1 )
									{
										pView->SetMarkHdlHidden(TRUE);
                                        BOOL bDragSingles = !pChDoc->Is3DChart();
										pView->SetFrameDragSingles(bDragSingles);
										pView->EnterMarkedGroup();
										pView->MarkObj(aMDPos, nHitLog);
										pView->SetMarkHdlHidden(FALSE);
									}
							}
						}
						break;
				}

				bReturn = TRUE;
			}
			else		// object without CHOBJID hit
			{
				if(!pDocSh->IsReadOnly())
				{
					aDragTimer.Start();
				}

				pView->BegDragObj(aMDPos, NULL, NULL, nDrgLog);
			}
		}
		// unmarked object hit or click with modifying key
		// -----------------------------------------------
		else
		{
			pView->UnmarkAll();
			pView->SetFrameDragSingles(TRUE);

			while( pView->GetPageViewPvNum(0)->GetEnteredLevel() )
			{
				// anderes Objekt in gleicher oder uebergeordneter Gruppe
				// selektieren

				if( pView->PickObj(aMDPos, nHitLog, pObj, pPV) )
				{
					pObjId = GetObjectId(*pObj);

					if( pObjId )
					{
						BOOL bBreak;

						pView->SetMarkHdlHidden(TRUE);
						SchObjectId *pNewObjectId=NULL;

						DBG_TRACE2( "SchFuSelection::MouseButtonDown Step 3, ObjId=%ld (%s)", pObjId->GetObjId(), GetCHOBJIDName( pObjId->GetObjId() ));
						long nId;

                        BOOL bDragSingles = FALSE;

                        switch( pObjId->GetObjId() )
						{
							case CHOBJID_LEGEND_SYMBOL_ROW:
							case CHOBJID_LEGEND_SYMBOL_COL:
                            case CHOBJID_DIAGRAM_DATA:
                                bDragSingles = TRUE;
                                if( pObjId->GetObjId() == CHOBJID_DIAGRAM_DATA && pChDoc->Is3DChart() )
                                {
                                    bDragSingles = FALSE;
                                }
                                // Warning: Fall-Through intended!
                            case CHOBJID_DIAGRAM_ROWGROUP:
                                if( pObjId->GetObjId() == CHOBJID_DIAGRAM_ROWGROUP )
                                {
                                    bDragSingles = pChDoc->Is3DChart();
                                }
                                // Warning: Fall-Through intended!
							case CHOBJID_DIAGRAM_ROWS:
							case CHOBJID_DIAGRAM_ROWSLINE:
							case CHOBJID_DIAGRAM_STOCKLINE_GROUP:
							case CHOBJID_DIAGRAM_STOCKLOSS_GROUP:
							case CHOBJID_DIAGRAM_STOCKPLUS_GROUP:
							case CHOBJID_DIAGRAM_SPECIAL_GROUP:
							case CHOBJID_DIAGRAM_X_AXIS:
							case CHOBJID_DIAGRAM_Y_AXIS:
							case CHOBJID_DIAGRAM_Z_AXIS:
							case CHOBJID_DIAGRAM_A_AXIS:
							case CHOBJID_DIAGRAM_B_AXIS:
							case CHOBJID_DIAGRAM_C_AXIS:
								pView->UnmarkAll();
                                pView->SetFrameDragSingles( bDragSingles );
								pView->MarkObj(aMDPos, nHitLog);
								pView->MarkLogicalGroup();

								bBreak = TRUE;

								if(pObj)//TVMNEW
								{
									pNewObjectId=GetObjectId(*pObj);
									if(pNewObjectId)
									{
										nId=pNewObjectId->GetObjId();
										if(nId==CHOBJID_DIAGRAM_ROWGROUP &&
                                           pChDoc->IsFlat3DChart() )
										{
											pView->LeaveOneGroup();
											pView->PickObj(aMDPos,nHitLog,pObj,pPV);
											Select3DGroupMembers(pObj,pPV);
										}
									}
								}
								if( pChDoc->IsPieChart() && pObjId->GetObjId() == CHOBJID_DIAGRAM_DATA )
								{
									// drag pie segments
									if( !pDocSh->IsReadOnly() )
									{
										CreatePieDragMethod( SAL_STATIC_CAST( SdrCircObj*, pObj ) );
										pView->BegDragObj( aMDPos, NULL, pHdl, nDrgLog, pDragMethod );
									}
								}
								break;

							default:
								bBreak = FALSE;
								break;
						}
						pView->SetMarkHdlHidden(FALSE);

						if( bBreak )
							break;
					}
				}
				pView->LeaveOneGroup();
			}
			

			pPV = NULL;
			pObj = NULL;

			if(!pView->AreObjectsMarked() &&
			   pView->PickObj(aMDPos, nHitLog, pObj, pPV))
			{
				// Falls kein anderes Gruppenobjekt selektiert wurde,
				// ggf. auf oberster Ebene Objekt markieren und draggen

				pView->SetFrameDragSingles(TRUE);
				pObjId = GetObjectId(*pObj);

				if( pObjId )
				{

					SdrObject *pDiagramObj = GetObjWithId( CHOBJID_DIAGRAM,*pChDoc->GetPage(0),
														   0, IM_DEEPWITHGROUPS);
					DBG_ASSERT(pDiagramObj,"Diagramm nicht gefunden");

					DBG_TRACE2( "SchFuSelection::MouseButtonDown Step 4, ObjId=%ld (%s)", pObjId->GetObjId(), GetCHOBJIDName( pObjId->GetObjId() ));

					switch( pObjId->GetObjId() )
					{
						case CHOBJID_DIAGRAM_AREA:
							if( pDiagramObj &&
								pDiagramObj->GetLogicRect().IsInside(aMDPos) )
							{
								pView->MarkObj(pDiagramObj,pPV);
								if(!pDocSh->IsReadOnly())
								{
									pView->BegDragObj(aMDPos, NULL, NULL, nDrgLog);
								}
							}
							else
							{
								pView->MarkObj(pObj, pPV);
								if(!pDocSh->IsReadOnly())
								{
									pView->BegDragObj(aMDPos, NULL, NULL, nDrgLog);
								}
							}
							break;

						case CHOBJID_DIAGRAM:
						case CHOBJID_TITLE_MAIN:
						case CHOBJID_TITLE_SUB:
						case CHOBJID_LEGEND:
						case CHOBJID_DIAGRAM_TITLE_X_AXIS:
						case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
						case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
							{
								pView->MarkObj(pObj, pPV);

								pView->SetDragMode(SDRDRAG_MOVE);		// if scene was selected #53954#

								if(!pDocSh->IsReadOnly())
								{
									pView->BegDragObj(aMDPos, NULL, NULL, nDrgLog);
								}
							}
							break;
					}
				}
				else
				{
#ifdef OS2
					bFirstMouseMove = TRUE;
#endif
					if(!pDocSh->IsReadOnly())
					{
						aDragTimer.Start();
					}

					pView->MarkObj(pObj, pPV);
					pView->BegDragObj(aMDPos, NULL, NULL, nDrgLog);
				}

				bReturn = TRUE;
			}
		}
    }

    if(!bIsInDragMode)
		ForcePointer(&rMEvt);

    return bReturn;
}

/*************************************************************************
|*
|* MouseMove-event
|*
\************************************************************************/

BOOL SchFuSelection::MouseMove(const MouseEvent& rMEvt)
{
	BOOL bReturn = SchFuDraw::MouseMove(rMEvt);

	if(aDragTimer.IsActive())
	{
#ifdef OS2
		if(bFirstMouseMove)
			bFirstMouseMove = FALSE;
		else
#endif
		{
			aDragTimer.Stop();
			bIsInDragMode = FALSE;
		}
	}

	if(pView->IsAction())
		pView->MovAction( pWindow->PixelToLogic( rMEvt.GetPosPixel() ) );

	ForcePointer(&rMEvt);

	return bReturn;
}


/*************************************************************************
|*
|* MouseButtonUp-event
|*
\************************************************************************/

BOOL SchFuSelection::MouseButtonUp(const MouseEvent& rMEvt)
{
    // guard object to suspend sending broadcasts
    SuspendSelectionChangeBroadcasting aSelectionSuspender( pViewShell );

	if(aDragTimer.IsActive())
	{
		aDragTimer.Stop();
		bIsInDragMode = FALSE;
	}


	SchFuDraw::MouseButtonUp(rMEvt);

	Point aPnt(pWindow->PixelToLogic(rMEvt.GetPosPixel()));
	USHORT nDrgLog = USHORT( pWindow->PixelToLogic(Size(DRGPIX,0)).Width() );
	USHORT nHitLog = USHORT( pWindow->PixelToLogic(Size(HITPIX,0)).Width() );

	if( rMEvt.IsLeft() )
	{
		if(pView->IsDragObj())
		{
			//-- prepare undo
			UINT16 nUndoObjId(CHOBJID_ANY);
			Rectangle aOldUndoRect(0,0,0,0);// | if only a position point is relevant/available (e.g. objects that cannot be resized)
			Rectangle aNewUndoRect(0,0,0,0);// | this point will be storede in the top left corner of aOldUndoRect
			Point aUndoDataPointColRow(0,0);//x == column y == row
			Point aUndoPieSegOffOldNew(0,0);//x == old y == new
			Matrix4D aUndoOldSceneMatrix;
			Matrix4D aUndoNewSceneMatrix;
			//-- prepare undo (collect old state)
			{
				const SdrMarkList& rMarkList = pView->GetMarkedObjectList();
				if(rMarkList.GetMarkCount())
				{
					SdrObject* pObj = rMarkList.GetMark(0)->GetMarkedSdrObj();
					if(pObj)
					{
						aOldUndoRect = Rectangle(pObj->GetLogicRect().TopLeft(), Size(0,0));
						switch(GetObjectIdNum(*pObj))
						{
							case CHOBJID_DIAGRAM:
								aOldUndoRect = pChDoc->GetDiagramRectangle();
								if(pObj->ISA(ChartScene))
								{
									aUndoOldSceneMatrix = ((ChartScene*)pObj)->GetTransform();
								}
								break;
							case CHOBJID_DIAGRAM_DATA:
								if( pObj->ISA(SdrCircObj) && pChDoc->IsPieChart() )
								{
									SchDataPoint* pDataPoint = GetDataPoint( *pObj );
									if(pDataPoint)
										aUndoPieSegOffOldNew.X() =
											pChDoc->PieSegOfs( pDataPoint->GetCol() );
								}
								break;
						}
					}
				}
			}//-- end prepare undo (collect old state)

            // #i11980# copying objects with Ctrl-Key is not supported.  It
            // wasn't even a real drag&drop.
			if( pView->EndDragObj()) //rMEvt.IsMod1()))
			{
//				pView->SetDragWithCopy( rMEvt.IsMod1());

				const SdrMarkList& rMarkList = pView->GetMarkedObjectList();
				SdrObject* pObj = rMarkList.GetMark(0)->GetMarkedSdrObj();
				pChDoc->SetUseRelativePositions(TRUE);
				if(pObj->ISA(SchObjGroup))
				{
					((SchObjGroup*) pObj)->SetGroupMoved(TRUE);
					if(((SchObjGroup*) pObj)->GetGroupType() == SchObjGroup::DIAGRAM)
					{
						//-- prepare undo (collect new state)
						nUndoObjId = CHOBJID_DIAGRAM;
						aNewUndoRect = pChDoc->GetDiagramRectangle();
						//--
						pChDoc->BuildChart(FALSE);
					}
					else if(((SchObjGroup*) pObj)->GetGroupType() == SchObjGroup::LEGEND)
					{
						//-- prepare undo (collect new state)
						nUndoObjId = CHOBJID_LEGEND;
						aNewUndoRect = Rectangle(pObj->GetLogicRect().TopLeft(), Size(0,0));
						//--
					}
				}
				else if(pObj->ISA(SdrTextObj))
				{
					SchObjectId* pId = GetObjectId(*pObj);
					if (pId)switch(pId->GetObjId())
					{
						case CHOBJID_TITLE_MAIN:
						case CHOBJID_TITLE_SUB:
						case CHOBJID_DIAGRAM_TITLE_X_AXIS:
						case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
						case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
							pChDoc->SetHasBeenMoved(pId->GetObjId(),TRUE);
							//-- prepare undo (collect new state)
							nUndoObjId = pId->GetObjId();
							aNewUndoRect = Rectangle(pObj->GetLogicRect().TopLeft(), Size(0,0));
							//--
						break;
					}

					if( pObj->ISA(SdrCircObj) && pChDoc->IsPieChart() )
					{
						long nCol = -1, nRow = -1;
						SchDataPoint* pDataPoint = GetDataPoint( *pObj );
						if( pDataPoint )
						{
							nCol = pDataPoint->GetCol();
							nRow = pDataPoint->GetRow();

							//-- prepare undo (collect new state)
							nUndoObjId = GetObjectIdNum(*pObj);
							aUndoDataPointColRow = Point(nCol,nRow);
							aUndoPieSegOffOldNew.Y() = pChDoc->PieSegOfs( pDataPoint->GetCol() );
							//--
						}

						if( pChDoc->ChartStyle() == CHSTYLE_2D_PIE_SEGOFALL ||
							pChDoc->ChartStyle() == CHSTYLE_2D_PIE_SEGOF1 )
						{
							pChDoc->ChartStyle() = CHSTYLE_2D_PIE;
						}
						pChDoc->BuildChart( FALSE );

						SdrPageView* pPV = pView->GetPageViewPvNum( 0 );

						if( pPV && nCol >= 0 && nRow >= 0 )
						{
							pView->MarkObj( GetObjWithId( CHOBJID_DIAGRAM, *pChDoc->GetPage(0), 0, IM_DEEPWITHGROUPS ), pPV );
							pView->EnterMarkedGroup();
							pView->MarkObj( pChDoc->GetDataPointObj( nCol, nRow ), pPV );
						}
					}
				}
				else if(pObj->ISA(ChartScene))
				{
					Rectangle aRectangle;
					aRectangle = pObj->GetSnapRect();
					((ChartScene *)pObj)->SetAskForLogicRect(FALSE);
					pChDoc->SetDiagramRectangle(aRectangle);
					pChDoc->SetDiagramHasBeenMovedOrResized(TRUE);

					//-- prepare undo (collect new state)
					if( GetObjectIdNum(*pObj) == CHOBJID_DIAGRAM )
					{
						nUndoObjId = CHOBJID_DIAGRAM;
						aNewUndoRect = pChDoc->GetDiagramRectangle();
						aUndoNewSceneMatrix = ((ChartScene*)pObj)->GetTransform();
					}
					//--

					// BM: don't rescale text if object was rotated
					if( pView->GetDragMode() == SDRDRAG_ROTATE &&
						pChDoc->TextScalability() )
					{
						BOOL& bScalable = pChDoc->TextScalability();
						bScalable = FALSE;
						pChDoc->BuildChart(FALSE);
						bScalable = TRUE;
					}
					else
					{
						pChDoc->BuildChart(FALSE);
					}

					SdrObject* pDiagramObj = GetObjWithId( CHOBJID_DIAGRAM, *pChDoc->GetPage(0), 0, IM_DEEPWITHGROUPS );
					if( pDiagramObj )
					{
						pView->LeaveOneGroup();
						pView->UnmarkAll();
						pView->MarkObj(pDiagramObj, pView->GetPageViewPvNum(0));
					}
				}
				//create undo action
				if(nUndoObjId != CHOBJID_ANY)
				{
					SfxUndoAction* pUndo=NULL;
					if(nUndoObjId==CHOBJID_DIAGRAM_DATA)
					{
						if(aUndoDataPointColRow.Y()==0)
						{
							pUndo = new SchUndoMovePieSeg(	*pChDoc, aUndoDataPointColRow.X()
								, aUndoPieSegOffOldNew.X(), aUndoPieSegOffOldNew.Y() );
						}
					}
					else
					{
						pUndo = new SchUndoMoveOrResize( *pChDoc, nUndoObjId
								, aOldUndoRect, aNewUndoRect
								, aUndoOldSceneMatrix, aUndoNewSceneMatrix );

						USHORT nResId(STR_UNDO_MOVE);
						if(pView->GetDragMode()==SDRDRAG_ROTATE)
							nResId = STR_UNDO_ROTATE;
						else if(aOldUndoRect.GetWidth()!=aNewUndoRect.GetWidth()
							 || aOldUndoRect.GetHeight()!=aNewUndoRect.GetHeight())
							 nResId = STR_UNDO_RESIZE;
						reinterpret_cast<SchUndoMoveOrResize*>(pUndo)->SetCommentTemplate(nResId);
					}
					if(pUndo)
						pViewShell->GetViewFrame()->GetObjectShell()->
							GetUndoManager()->AddUndoAction(pUndo);
				}
			}
			else if( bWasSelected )
			{
				// Kein Drag, dann Gruppe betreten, falls diese schon
				// selektiert war

				const SdrMarkList& rMarkList = pView->GetMarkedObjectList();
				SdrObject* pObj = rMarkList.GetMark(0)->GetMarkedSdrObj();

				if(pObj->ISA(SdrObjGroup) || pObj->ISA(E3dScene) || pObj->ISA(E3dPolyScene))
				{
					BOOL bLeave      = TRUE;
					BOOL bDontShow   = FALSE;
					SdrPageView* pPV = NULL;

					pView->SetMarkHdlHidden(TRUE);
					pView->SetDragMode(SDRDRAG_MOVE);
					pView->SetFrameDragSingles(FALSE);
					pView->EnterMarkedGroup();

					if(pView->PickObj(aMDPos, nHitLog, pObj, pPV,SDRSEARCH_TESTMARKABLE))
					{
						SchObjectId* pObjId=NULL;//#51458#
						pObjId = GetObjectId(*pObj);

						if(pObjId)
						{
							// nur bestimmte Objekte zulassen
							DBG_TRACE2( "SchFuSelection::MouseButtonDown Step 5, ObjId=%ld (%s)", pObjId->GetObjId(), GetCHOBJIDName( pObjId->GetObjId() ));

							if( !pObj->ISA(E3dScene) )					// do not rotate non-scene objects
								pView->SetDragMode( SDRDRAG_MOVE );

							switch( pObjId->GetObjId() )
							{
								case CHOBJID_DIAGRAM_ROWGROUP:
								case CHOBJID_DIAGRAM_STATISTICS_GROUP:
								case CHOBJID_DIAGRAM_STOCKLINE_GROUP:
								case CHOBJID_DIAGRAM_STOCKLOSS_GROUP:
								case CHOBJID_DIAGRAM_STOCKPLUS_GROUP:
								case CHOBJID_DIAGRAM_ROWS:
								case CHOBJID_DIAGRAM_ROWSLINE:
								case CHOBJID_DIAGRAM_DATA:
								case CHOBJID_DIAGRAM_X_AXIS:
								case CHOBJID_DIAGRAM_Y_AXIS:
								case CHOBJID_DIAGRAM_Z_AXIS:
								case CHOBJID_DIAGRAM_A_AXIS:
								case CHOBJID_DIAGRAM_B_AXIS:
								case CHOBJID_DIAGRAM_C_AXIS:
								case CHOBJID_LEGEND_SYMBOL_ROW:
								case CHOBJID_LEGEND_SYMBOL_COL:
								case CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP :
								case CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP :
								case CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP :
								case CHOBJID_DIAGRAM_X_GRID_HELP_GROUP :
								case CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP :
								case CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP :
								case CHOBJID_DIAGRAM_AVERAGEVALUE :
								case CHOBJID_DIAGRAM_REGRESSION :
								case CHOBJID_DIAGRAM_ERROR :
								case CHOBJID_DIAGRAM_FLOOR:
//                                case CHOBJID_3D_PIE_TOP :
                                    if( pObjId->GetObjId() == CHOBJID_DIAGRAM_ROWGROUP &&
                                        pChDoc->IsFlat3DChart() )
                                    {
                                        pView->SetFrameDragSingles( FALSE );
                                        Select3DGroupMembers(pObj,pPV);
//                                         bDontShow = TRUE;
                                    }
//                                     else
                                    bLeave = FALSE;
									break;
							}
						}
					}

					if(bLeave)
						pView->LeaveOneGroup();
					if(!bDontShow)
					{
						pView->MarkObj(aMDPos, nHitLog);
						pView->MarkLogicalGroup();

						if( pView->GetPageViewPvNum(0)->GetEnteredLevel() == 0 ||
							rMarkList.GetMarkCount() &&
							rMarkList.GetMark(0)->GetMarkedSdrObj()->ISA(SdrRectObj))
							pView->SetFrameDragSingles(TRUE);

					}

					pView->SetMarkHdlHidden(FALSE);
				}
			}
		}

		if( pView->IsAction() )
			pView->EndAction();

		if(!rMEvt.IsShift() && !rMEvt.IsMod1() && !rMEvt.IsMod2() &&
		   Abs(aPnt.X() - aMDPos.X()) < nDrgLog &&
		   Abs(aPnt.Y() - aMDPos.Y()) < nDrgLog)
		{
			/**************************************************************
			 * Toggle zw. Selektion und Rotation
			 **************************************************************/
			SdrObject* pSingleObj = NULL;
			ULONG nMarkCount = pView->GetMarkedObjectList().GetMarkCount();

			if( nMarkCount == 1 )
			{
				pSingleObj = pView->GetMarkedObjectList().GetMark(0)->GetMarkedSdrObj();
			}

			SdrDragMode eDragMode = pView->GetDragMode();

			if (pSingleObj && pSingleObj->ISA( E3dScene ))
			{
				SchObjectId* pId = GetObjectId(*pSingleObj);
				if ( pId &&
					 (pId->GetObjId() == CHOBJID_DIAGRAM))
					if (eDragMode == SDRDRAG_MOVE )
						pView->SetDragMode(SDRDRAG_ROTATE);
					else if( eDragMode == SDRDRAG_ROTATE )
						pView->SetDragMode(SDRDRAG_MOVE);
			}
/*	AF: That's the way it was done before.
			if( pSingleObj && pSingleObj->ISA(E3dScene) && //bWasSelected &&
				eDragMode == SDRDRAG_MOVE )
			{
				pView->SetDragMode(SDRDRAG_ROTATE);
			}
			else if( eDragMode == SDRDRAG_ROTATE )
			{
				pView->SetDragMode(SDRDRAG_MOVE);
			}
*/		}
	}

	USHORT nClicks = rMEvt.GetClicks();
	SchChartDocShell* pDocSh = (SchChartDocShell*) pChDoc->GetObjectShell();
	if(!pDocSh)
	{
		DBG_ERROR("pDocSh lost!");
		return FALSE;
	}

	if(nClicks == 2 && rMEvt.IsLeft() && bMBDown &&
	   !rMEvt.IsMod1() && !rMEvt.IsMod2() && !rMEvt.IsShift() &&
	   !pDocSh->IsReadOnly())
	{
		DoubleClick();
	}

	bMBDown = FALSE;

	ForcePointer(&rMEvt);
	pWindow->ReleaseMouse();

	return FALSE;   //path A: nichts wesentliches passiert
}

/*************************************************************************
|*
|* Command-event
|*
\************************************************************************/

BOOL SchFuSelection::Command(const CommandEvent& rCEvt)
{
	return FALSE;
}

/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

void SchFuSelection::Activate()
{
	pView->SetEditMode(TRUE);

	SchFuDraw::Activate();
}

/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

void SchFuSelection::Deactivate()
{
	if(pView->GetDragMode() != SDRDRAG_MOVE)
		pView->SetDragMode(SDRDRAG_MOVE);

	pView->SetEditMode(FALSE);

	SchFuDraw::Deactivate();
}

void SchFuSelection::CreatePieDragMethod( SdrCircObj* pPie )
{
	// 100th degrees in 90deg rotated system -> rad
	long nStartAngle = pPie->GetStartWink(),
		nEndAngle = pPie->GetEndWink();
	if( nStartAngle > nEndAngle )
		nEndAngle += 36000;
	long nAngle = (nStartAngle + nEndAngle) / 2 + 9000;
	double fAngle = (double)nAngle * F_PI / 18000.0;

	double fRadius = (double)pChDoc->GetPieRadius();	 // maximum shift is 100% of radius
	Vector2D aVec( fRadius * sin( fAngle ), fRadius * cos( fAngle ) );

	SchDataPoint* pPoint = GetDataPoint( *pPie );
	DBG_ASSERT( pPoint, "CreatePieDragMethod: Pie has no data point user data" );

	if( pPoint )
	{
		double fOldShift = (double)pChDoc->PieSegOfs( pPoint->GetCol() );
		pDragMethod = new SchDragConstrainedToVector( *pView, aVec, fOldShift );
	}
}



