/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: futitle.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:14:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif
#define ITEMID_CHARTTEXTORIENT	SCHATTR_TEXT_ORIENT

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif

#include <svx/svxids.hrc>

#include "chtmodel.hxx"
#include "attrib.hrc"
#include "../inc/attrib.hxx"
#include "app.hrc"
#include "schresid.hxx"
#include "strings.hrc"
#include "viewshel.hxx"
#include "schview.hxx"
#include "chwindow.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "objid.hxx"
#include "untitle.hxx"
#include "futitle.hxx"

#include <svx/eeitem.hxx>

#ifndef _SVX_CHRTITEM_HXX //autogen
#define ITEMID_DOUBLE	        0
#define ITEMID_CHARTTEXTORDER   SCHATTR_TEXT_ORDER
#define ITEMID_CHARTDATADESCR	SCHATTR_DATADESCR_DESCR
#include <svx/chrtitem.hxx>
#endif
#include "globfunc.hxx"

TYPEINIT1(SchFuTitle, SchFuPoor);


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuTitle::SchFuTitle(SchViewShell* pViewSh, SchWindow* pWin,
					   SchView* pView, ChartModel* pDoc,
					   SfxRequest& rReq, Point &rMDPos)
	: SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	aMDPos = rMDPos;

	UINT16           nTitleId   = 0;
	SdrTextObj       *pTitleObj = NULL;
	const SfxItemSet *pArgs     = rReq.GetArgs();

	SdrPage* pPage = pDoc->GetPage(0);

	if (!pPage) return;
	else
	{
		switch (rReq.GetSlot ())
		{
			case SID_DIAGRAM_TITLE_MAIN :
				nTitleId  = CHOBJID_TITLE_MAIN;
				pTitleObj = (SdrTextObj*) GetObjWithId(nTitleId, *pPage);
				break;

			case SID_DIAGRAM_TITLE_SUB :
				nTitleId  = CHOBJID_TITLE_SUB;
				pTitleObj = (SdrTextObj*) GetObjWithId(nTitleId, *pPage);
				break;

			case SID_DIAGRAM_TITLE_X :
				nTitleId  = CHOBJID_DIAGRAM_TITLE_X_AXIS;                //TVMNEW: DEEP is unoetig
				pTitleObj = (SdrTextObj*) GetObjWithId(nTitleId, *pPage);//, 0, IM_DEEPWITHGROUPS);
				break;

			case SID_DIAGRAM_TITLE_Y :
				nTitleId  = CHOBJID_DIAGRAM_TITLE_Y_AXIS;
				pTitleObj = (SdrTextObj*) GetObjWithId(nTitleId, *pPage);//, 0, IM_DEEPWITHGROUPS);
				break;

			case SID_DIAGRAM_TITLE_Z :
				nTitleId  = CHOBJID_DIAGRAM_TITLE_Z_AXIS;
				pTitleObj = (SdrTextObj*) GetObjWithId(nTitleId, *pPage);//, 0, IM_DEEPWITHGROUPS);
				break;

			default :
				;
		}
	}

	if( !pArgs )
	{
		SfxItemSet      aAttr = pDoc->GetFullTitleAttr(pTitleObj);
		
		//	If the text orientation is set to automatic, then calculate the
		//	corresponding rotation angle.
		SvxChartTextOrient eOrientation = ((const SvxChartTextOrientItem&)aAttr.Get(
			SCHATTR_TEXT_ORIENT)).GetValue();
		if (eOrientation == CHTXTORIENT_AUTOMATIC)
		{
			switch (nTitleId)
			{
				case	CHOBJID_DIAGRAM_TITLE_X_AXIS:
					if (pDoc->IsXVertikal())
						eOrientation = CHTXTORIENT_BOTTOMTOP;
					else
						eOrientation = CHTXTORIENT_STANDARD;
					break;
					
				case	CHOBJID_DIAGRAM_TITLE_Y_AXIS:
					if (pDoc->IsXVertikal())
						eOrientation = CHTXTORIENT_STANDARD;
					else
						eOrientation = CHTXTORIENT_BOTTOMTOP;
					break;
					
				default:
					eOrientation = CHTXTORIENT_STANDARD;
					break;
			}
			long nAngle = GetTextRotation (aAttr, eOrientation);
			aAttr.Put (SfxInt32Item (SCHATTR_TEXT_DEGREES, nAngle));
		}

//      FG: Mit dieser Zeile erhaelt man keinen modalen Dialog => Absturz falls ein Resize im Chart
//      stattfindet waehrend dieser Dialog geoeffnet ist.
//        SchAttribTabDlg *pDlg =	new SchAttribTabDlg(&pViewSh->GetViewFrame()->GetWindow(), ATTR_TITLE,
//                                                    &aAttr,	pDoc->GetObjectShell(), pDoc, nTitleId,
//                                                    pDoc->ChartStyle());
		SchAttribTabDlg *pDlg =	new SchAttribTabDlg(NULL, ATTR_TITLE,
													&aAttr,	pDoc->GetObjectShell(), pDoc, nTitleId,
													pDoc->ChartStyle());

		if( pDlg->Execute() == RET_OK )
		{
			rReq.Done(*pDlg->GetOutputItemSet());
			pArgs = rReq.GetArgs();
		}
		else
		{
			delete pDlg;
			return;
		}
		delete pDlg;
		eOrientation = ((const SvxChartTextOrientItem&)aAttr.Get(
			SCHATTR_TEXT_ORIENT)).GetValue();

		pChDoc->CanRebuild (TRUE);

	}
	else pChDoc->CanRebuild (FALSE);

	SfxItemSet aOldAttr			= pDoc->GetTitleAttr(pTitleObj);
	SfxItemSet aOldMainAttr		= pDoc->GetMainTitleAttr();
	SfxItemSet aOldSubAttr		= pDoc->GetSubTitleAttr();
	SfxItemSet aOldXAxisAttr	= pDoc->GetXAxisTitleAttr();
	SfxItemSet aOldYAxisAttr	= pDoc->GetYAxisTitleAttr();
	SfxItemSet aOldZAxisAttr	= pDoc->GetZAxisTitleAttr();

	pViewSh->GetViewFrame()->GetDispatcher()->Execute(
		SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON );
	// pTitleObj wuerde danach auf eine Leiche zeigen, da ueber Execute
	// ein ::BuildChart aufgerufen wird, in welchem die Textobjekte vernichtet
	// werden -> also neuholen.

	switch (rReq.GetSlot ())
	{
		case SID_DIAGRAM_TITLE_MAIN :
			pTitleObj = (SdrTextObj*) GetObjWithId(CHOBJID_TITLE_MAIN, *pPage);
			break;

		case SID_DIAGRAM_TITLE_SUB :
			pTitleObj = (SdrTextObj*) GetObjWithId(CHOBJID_TITLE_SUB, *pPage);
			break;

		case SID_DIAGRAM_TITLE_X :
			pTitleObj = (SdrTextObj*) GetObjWithId(CHOBJID_DIAGRAM_TITLE_X_AXIS, *pPage);//, 0, IM_DEEPWITHGROUPS);
			break;

		case SID_DIAGRAM_TITLE_Y :
			pTitleObj = (SdrTextObj*) GetObjWithId(CHOBJID_DIAGRAM_TITLE_Y_AXIS, *pPage);//, 0, IM_DEEPWITHGROUPS);
			break;

		case SID_DIAGRAM_TITLE_Z :
			pTitleObj = (SdrTextObj*) GetObjWithId(CHOBJID_DIAGRAM_TITLE_Z_AXIS, *pPage);//, 0, IM_DEEPWITHGROUPS);
			break;

		default :
			pTitleObj = 0;
	}

	if (pDoc->ChangeTitleAttr(*pArgs, pTitleObj))
	{
		SchUndoTitle* pUndo = new SchUndoTitle(*pDoc, nTitleId, aOldMainAttr, aOldSubAttr,
											   aOldXAxisAttr, aOldYAxisAttr, aOldZAxisAttr,
											   aOldAttr, *pArgs);
		pUndo->SetComment(String(SchResId(STR_UNDO_TITLE)));

		pViewSh->GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
	}

	RemarkObject ();
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuTitle::Activate()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuTitle::Deactivate()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuTitle::RemarkObject()
{
	if (nMarkedID)
	{
		/*if (pChDoc->Is3DChart ()) aehnlich zu #48352#
		{
			((SchViewShell *) pViewShell)->SetRepaintPossible (FALSE);
			pView->CompleteRedraw (pWindow, Region (Rectangle (pWindow->GetViewOrigin (),
														   pWindow->GetViewSize ())));
		}*/

		SdrPage *pPage = pChDoc->GetPage(0);

		if (pPage)
		{
			SdrObject *pObj = GetObjWithId (nMarkedID, *pPage, 0, IM_DEEPWITHGROUPS);

			if (pObj)
			{
				SdrPageView* pPV = pView->GetPageViewPvNum (0);

				pView->UnmarkAll ();
				pView->LeaveAllGroup ();
				pView->SetMarkHdlHidden(TRUE);
				pView->PickObj (aMDPos, 50, pObj, pPV);
				pView->MarkObj (pObj, pPV);

				// TVMNEW: TITEL: hier hat sichs mitterweile ausge-entered,
				// Titelobjekte sind ALLE gleichwertig!
				/*
				if ((nMarkedID == CHOBJID_DIAGRAM_TITLE_X_AXIS) ||
					(nMarkedID == CHOBJID_DIAGRAM_TITLE_Y_AXIS) ||
					(nMarkedID == CHOBJID_DIAGRAM_TITLE_Z_AXIS))
				{
					pView->EnterMarkedGroup();
					pView->PickObj (aMDPos, 50, pObj, pPV);
					pView->MarkObj (pObj, pPV);
					pView->MarkLogicalGroup();
				}
				*/

				pView->SetMarkHdlHidden(FALSE);
			}
		}
	}
}



