/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: futransform.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:14:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"
#include "futransform.hxx"

// headers from chart
#include "schview.hxx"
#include "schresid.hxx"
#include "strings.hrc"
#include "chtmodel.hxx"
#include "schgroup.hxx"
//CHINA001 #include "transform.hxx"

// headers from other dlls
#ifndef _E3D_POLYSC3D_HXX
#include <svx/polysc3d.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#include "undmovsize.hxx"
#include "viewshel.hxx"
#include "chtscene.hxx"
#include <sfx2/viewfrm.hxx>

#include <svx/svxdlg.hxx> //CHINA001
#include <svx/dialogs.hrc> //CHINA001

TYPEINIT1( SchFuTransform, SchFuPoor );

SchFuTransform::SchFuTransform(
    SchViewShell* pViewShell, SchWindow* pWindow, SchView* pView,
    ChartModel* pModel, SfxRequest& rRequest ) :
        SchFuPoor( pViewShell, pWindow, pView, pModel, rRequest )
{
    if( pView->AreObjectsMarked() )
    {
		const SfxItemSet* pArgs = rRequest.GetArgs();

		if( NULL == pArgs )
		{
			// item set for size and position
			SfxItemSet aSet( pView->GetGeoAttrFromMarked() );
            aSet.DisableItem( SID_ATTR_TRANSFORM_PROTECT_POS );
            aSet.DisableItem( SID_ATTR_TRANSFORM_PROTECT_SIZE );

			const SdrMarkList& rMarkList = pView->GetMarkedObjectList();
			SdrObject* pObj = rMarkList.GetMark(0)->GetMarkedSdrObj();

            bool bSizable = false;
            bool bRotatable = false;

			Matrix4D	aUndoOldSceneMatrix;
			SfxItemSet	aUndoItemSet(aSet);

            DBG_ASSERT( pObj, "Have Marked Object, but Object is NULL!" );

            UINT16 nObjId = CHOBJID_ANY;
            SchObjectId * pObjId = GetObjectId( *pObj );
            if( pObjId )
                nObjId = pObjId->GetObjId();

            if( CHOBJID_DIAGRAM == nObjId )
            {
                bSizable = true;
                bRotatable = ( TRUE == pChDoc->Is3DChart() );
				if(pObj&&pObj->ISA(ChartScene))
					aUndoOldSceneMatrix = ((ChartScene*)pObj)->GetTransform();
            }


			//CHINA001 SchTransformTabDialog aDlg = SchTransformTabDialog( NULL, &aSet, pView, bSizable, bRotatable );
			SfxAbstractTabDialog* aDlg=NULL ;
			if( ! bRotatable ) //add CHINA001
			{
				SvxAbstractDialogFactory* pFact = SvxAbstractDialogFactory::Create();
				DBG_ASSERT(pFact, "Dialogdiet fail!");//CHINA001
				aDlg = pFact->CreateSchTransformTabDialog( NULL, &aSet, pView,ResId(RID_SCH_TransformTabDLG_SVXPAGE_ANGLE),bSizable );
				DBG_ASSERT(aDlg, "Dialogdiet fail!");//CHINA001
			}
			else
			{
				SvxAbstractDialogFactory* pFact = SvxAbstractDialogFactory::Create();
				DBG_ASSERT(pFact, "Dialogdiet fail!");//CHINA001
				aDlg = pFact->CreateSchTransformTabDialog( NULL, &aSet, pView,ResId(RID_SCH_TransformTabDLG_SVXPAGE_SLANT),bSizable );
				DBG_ASSERT(aDlg, "Dialogdiet fail!");//CHINA001
			}
			//CHINA001 if( aDlg.Execute() != RET_OK )
            //CHINA001  return;
           if( aDlg->Execute() != RET_OK ) //CHINA001 if( aDlg.Execute() != RET_OK )
		   {
			   delete aDlg;				//Add CHINA001
			   return;
		   }

            rRequest.Done( *( aDlg->GetOutputItemSet() ) );//CHINA001 rRequest.Done( *( aDlg.GetOutputItemSet() ) );
            pArgs = rRequest.GetArgs();

			delete aDlg; //add CHINA001

            // apply changed attributes only for ChartScene via DrawingLayer
            // necessary to get the new adjusted attributes
            if(pObj&&pObj->ISA(ChartScene))
            {
                pView->SetGeoAttrToMarked( *pArgs );
                pView->SetAttributes( *pArgs );
            }

			//create undo action and use undo-action to perform the action itself
			{
				Rectangle aOldPosSize(0,0,0,0);
				Rectangle aNewPosSize(0,0,0,0);
				Rectangle aRotateDummy(0,0,0,0);
				Matrix4D  aUndoNewSceneMatrix;

				SchUndoMoveOrResize::GetGeoAttribFromItemSet(aUndoItemSet,aOldPosSize,aRotateDummy);
				aUndoItemSet.Put(*pArgs);//overwrite old items with changed ones
				SchUndoMoveOrResize::GetGeoAttribFromItemSet(aUndoItemSet,aNewPosSize,aRotateDummy);

				if(pObj&&pObj->ISA(ChartScene))
				{
					aUndoNewSceneMatrix = ((ChartScene*)pObj)->GetTransform();
					aNewPosSize = pObj->GetSnapRect();
				}
                else if(pObj&&pObj->ISA(SchObjGroup)&&nObjId==CHOBJID_DIAGRAM)
                {
                    aOldPosSize = pChDoc->GetChartRect();
                    aNewPosSize = CreateNewDiagrammRectangle(aNewPosSize, pObj->GetSnapRect(), pChDoc->GetChartRect());
                }


				SchUndoMoveOrResize* pUndo = new SchUndoMoveOrResize( *pChDoc, nObjId
					, aOldPosSize, aNewPosSize
					, aUndoOldSceneMatrix, aUndoNewSceneMatrix );

                //perform the action itself:
                pUndo->Redo();


				pViewShell->GetViewFrame()->GetObjectShell()->
					GetUndoManager()->AddUndoAction(pUndo);
			}
        }
    }
}

SchFuTransform::~SchFuTransform()
{}


/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

void SchFuTransform::Activate()
{
	SchFuPoor::Activate();
}

/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

void SchFuTransform::Deactivate()
{
	SchFuPoor::Deactivate();
}


/*************************************************************************
|*
|* Function ResizeObject
|*
\************************************************************************/

Point SchFuTransform::GetPoint( Rectangle aRect, RECT_POINT eRP )
{
    switch( eRP )
	{
		case RP_LT: return Point( aRect.Left(), aRect.Top() );
		case RP_MT: return Point( aRect.Center().X(), aRect.Top() );
		case RP_RT: return Point( aRect.Right(), aRect.Top() );
		case RP_LM: return Point( aRect.Left(), aRect.Center().Y() );
		case RP_MM: return Point( aRect.Center().X(), aRect.Center().Y() );
		case RP_RM: return Point( aRect.Right(), aRect.Center().Y() );
		case RP_LB: return Point( aRect.Left(), aRect.Bottom() );
		case RP_MB: return Point( aRect.Center().X(), aRect.Bottom() );
		case RP_RB: return Point( aRect.Right(), aRect.Bottom() );
	}
    return Point( 0, 0 );
}

Rectangle SchFuTransform::CreateNewDiagrammRectangle(const Rectangle& rNew, const Rectangle& rOld, const Rectangle& rOldChartRect)
{
    //rNew is the new bound or snap rect
    //rOld is the old bound or snap rect (bound and snap rect should be ever identical for 2D Diagramms)
	
    //remind differences between old ChartRect and old BoundRect:
	Point aDifferenceLeftBottom = rOldChartRect.BottomLeft() - rOld.BottomLeft();
	Point aDifferenceTopRight = rOldChartRect.TopRight() - rOld.TopRight();

    //take the new BoundRect
    Rectangle aRect(rNew);
    //add old differences to new BoundRect to receive the new ChartRect
	aRect.Left() += aDifferenceLeftBottom.X();
	aRect.Bottom() += aDifferenceLeftBottom.Y();
	aRect.Right() += aDifferenceTopRight.X();
	aRect.Top() += aDifferenceTopRight.Y();
    return aRect;
}

