/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: viewshe3.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 20:28:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sch.hxx"

#define ITEMID_COLOR			SID_ATTR_3D_LIGHTCOLOR

#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif

#include "undswap.hxx"

//svdraw.hxx
#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SI_NOSBXCONTROLS
#define _SI_NOOTHERFORMS
#define _SI_NOCONTROL
#define _SI_NOSBXCONTROLS



#define ITEMID_LRSPACE			EE_PARA_LRSPACE
#define ITEMID_ULSPACE			EE_PARA_ULSPACE

#define ITEMID_SIZE 0
#include <svx/sizeitem.hxx>
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif


#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif


#ifndef _SFX_HRC
#include <sfx2/sfx.hrc>
#endif

#include "schattr.hxx"

#define ITEMID_CHARTLEGENDPOS	SCHATTR_LEGEND_POS
#ifndef _SVX_CHRTITEM_HXX //autogen
#include <svx/chrtitem.hxx>
#endif
#ifndef	_SCH_PERSISTENT_OBJECT_POINTER
# include	"SchPersistentObjectPointer.hxx"
#endif

#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "glob.hrc"

#include "viewshel.hxx"
#include "schview.hxx"
#include "fuinstit.hxx"
#include "fuinsleg.hxx"
#include "fuinsdes.hxx"
#include "fuinsaxi.hxx"
#include "fudgraut.hxx"
#include "fudgrtyp.hxx"
#include "futitle.hxx"
#include "fulegend.hxx"
#include "fuinssts.hxx"
#include "fudatrow.hxx"
#include "fudgraxi.hxx"
#include "fudgrgri.hxx"
#include "fudgrare.hxx"
#include "fudgrwal.hxx"
#include "fufloor.hxx"
#include "unscale.hxx"
#include "schresid.hxx"
#include "futransform.hxx"

#include "fubyid.hxx"


void SchViewShell::FuTemp2(SfxRequest &rReq)
{
	ChartModel* pChDoc = &pChView->GetDoc();

	USHORT nSId = rReq.GetSlot();
	switch( nSId )
	{

		case SID_DIAGRAM_TITLE_MAIN :
		case SID_DIAGRAM_TITLE_SUB :
		case SID_DIAGRAM_TITLE_X :
		case SID_DIAGRAM_TITLE_Y :
		case SID_DIAGRAM_TITLE_Z :
		case SID_DIAGRAM_TITLE_ALL :
			pFuActual = new SchFuTitle(this, GetWindow(), pChView,
									   pChDoc, rReq, aMDPos);
			Invalidate();
			Cancel();
			break;

		case SID_LEGEND:
			pFuActual = new SchFuLegend(this, GetWindow(), pChView,
										pChDoc, rReq, aMDPos);
			Invalidate();
			Cancel();
			break;

		case SID_INSERT_TITLE:
			pFuActual = new SchFuInsertTitle(this, GetWindow(), pChView,
											 pChDoc, rReq);
			Invalidate();
			Cancel();
			break;

		case SID_INSERT_CHART_LEGEND:
			pFuActual = new SchFuInsertLegend(this, GetWindow(), pChView,
											  pChDoc, rReq);
			Invalidate();
			Cancel();
			break;

		case SID_INSERT_DESCRIPTION:
			pFuActual = new SchFuInsertDataDescr(this, GetWindow(), pChView,
												 pChDoc, rReq);
			Invalidate();
			Cancel();
			break;

		case SID_INSERT_AXIS:
			pFuActual = new SchFuInsertAxis( this, GetWindow(), pChView, pChDoc, rReq);
			Invalidate();
			Cancel();
			break;

		case SID_INSERT_GRIDS:
			pFuActual = new SchFuInsertGrid( this, GetWindow(), pChView, pChDoc, rReq);
			Invalidate();
			Cancel();
			break;

		case SID_INSERT_STATISTICS:
			pFuActual = new SchFuInsertStatistics(this, GetWindow(), pChView,
												  pChDoc, rReq);
			Invalidate();
			Cancel();
			break;

		case SID_DIAGRAM_AXIS_X:
		case SID_DIAGRAM_AXIS_Y:
		case SID_DIAGRAM_AXIS_Z:
		case SID_DIAGRAM_AXIS_A:
		case SID_DIAGRAM_AXIS_B:
		case SID_DIAGRAM_AXIS_C:
		case SID_DIAGRAM_AXIS_ALL:
			pFuActual = new SchFuDiagramAxis(this, GetWindow(), pChView,
											 pChDoc, rReq, aMDPos);
			Invalidate();
			Cancel();
			break;

		case SID_DIAGRAM_GRID_X_MAIN:
		case SID_DIAGRAM_GRID_Y_MAIN:
		case SID_DIAGRAM_GRID_Z_MAIN:
		case SID_DIAGRAM_GRID_X_HELP:
		case SID_DIAGRAM_GRID_Y_HELP:
		case SID_DIAGRAM_GRID_Z_HELP:
		case SID_DIAGRAM_GRID_ALL:
			pFuActual = new SchFuDiagramGrid(this, GetWindow(), pChView,
											 pChDoc, rReq, aMDPos);
			Invalidate();
			Cancel();
			break;

		case SID_DIAGRAM_WALL:
			pFuActual = new SchFuDiagramWall(this, GetWindow(), pChView,
											 pChDoc, rReq, aMDPos);
			Invalidate();
			Cancel();
			break;

		case SID_DIAGRAM_FLOOR:
			pFuActual = new SchFuDiagramFloor(this, GetWindow(), pChView,
											  pChDoc, rReq);
			Invalidate();
			Cancel();
			break;

		case SID_DIAGRAM_AREA:
			pFuActual = new SchFuDiagramArea(this, GetWindow(), pChView,
											 pChDoc, rReq, aMDPos);
			Invalidate();
			Cancel();
			break;

		case SID_DIAGRAM_TYPE:
			pFuActual = new SchFuDiagramType(this, GetWindow(), pChView,
											 pChDoc, rReq);
			Invalidate();
			Cancel();
			break;

		case SID_AUTOFORMAT:
			pFuActual = new SchFuDiagramAutoPilot(this, GetWindow(), pChView,
												  pChDoc, rReq);
			Invalidate();
			Cancel();
			break;

		case SID_SCALE_TEXT:
		{
			GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

			BOOL bOldScale = pChDoc->TextScalability ();
			BOOL bNewScale = bOldScale;

			SFX_REQUEST_ARG( rReq, pScaleItem, SfxBoolItem, SID_SCALE_TEXT, FALSE );

			if( pScaleItem ) bNewScale = pScaleItem->GetValue();
			else bNewScale = !bOldScale;

			pChDoc->TextScalability () = bNewScale;

			SchUndoScale* pUndo = new SchUndoScale(*pChDoc, bOldScale, bNewScale);
			pUndo->SetComment(String(SchResId(STR_UNDO_SCALE)));
			GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);

			if( pScaleItem ) rReq.AppendItem( SfxBoolItem( SID_SCALE_TEXT, bNewScale ) );
			rReq.Done();
			Invalidate();
			break;
		}
		break;
		case SID_ROW_MOREFRONT:
			{
				long nRow=pChView->GetSelectedRow();
				if(nRow!=-1)
				{
				 if(pChDoc->MoveRow(nRow,TRUE))
				 {
					SchUndoSwapRow *pUndo = new SchUndoSwapRow(*pChDoc,nRow-1);
					pUndo->SetComment(String(SchResId(STR_UNDO_MOREFRONT)));
					GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
					pChDoc->BuildChart(FALSE);
				  
					//	Re-mark	the data row whose index is now nRow-1.
					pChView->MarkObj (pChView->GetDoc().GetDataRowGroup(nRow-1),
						pChView->GetPageViewPvNum (0));
				 }
				}
				else
					DBG_ERROR("Selection Lost:SID_ROW_MOREFRONT, Chart");
				Cancel();
			}
			break;
		case SID_ROW_MOREBACK:
			{
				long nRow=pChView->GetSelectedRow();
				if(nRow!=-1)
				{
				 if( pChDoc->MoveRow(nRow,FALSE))
				 {
					SchUndoSwapRow *pUndo = new SchUndoSwapRow(*pChDoc,nRow);
					pUndo->SetComment(String(SchResId(STR_UNDO_MOREBACK)));
					GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
					pChDoc->BuildChart(FALSE);
					
					//	Re-mark	the data row whose index is now nRow+1.
					pChView->MarkObj (pChView->GetDoc().GetDataRowGroup(nRow+1),
						pChView->GetPageViewPvNum (0));
				 }
				}
				else
					DBG_ERROR("Selection Lost:SID_ROW_MOREBACK, Chart");
				Cancel();
			}
			break;

		case SID_DIAGRAM_STOCK_LOSS:
			pFuActual = new SchFuById(this, GetWindow(), pChView,pChDoc, rReq,CHOBJID_DIAGRAM_STOCKLOSS_GROUP);
			Invalidate();
			Cancel();
			break;
		case SID_DIAGRAM_STOCK_PLUS:
			pFuActual = new SchFuById(this, GetWindow(), pChView,pChDoc, rReq,CHOBJID_DIAGRAM_STOCKPLUS_GROUP);
			Invalidate();
			Cancel();
			break;

        // transform dialog: set position/size/rotation
        case SID_ATTR_TRANSFORM:
			pFuActual = new SchFuTransform( this, GetWindow(), pChView, pChDoc, rReq );
			Invalidate();
			Cancel();
            break;
            
		default:
			break;
	}
}


