/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: graphpro.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 18:39:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"

#ifndef _SFX_PROGRESS_HXX
#include <sfx2/progress.hxx>
#endif

#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef _FILTER_HXX //autogen
#include <svtools/filter.hxx>
#endif

#include "strings.hrc"
#include "graphpro.hxx"
#include "sdresid.hxx"


/*************************************************************************
|*
|*	Ctor
|*
\************************************************************************/


FilterProgress::FilterProgress( GraphicFilter* _pFilter, SfxObjectShell* pShell ) :
				pFilter( _pFilter )
{
	String aPrgTitle( SdResId( STR_DRAW_FILTERPROGRESS ) );
	mpProgress = new SfxProgress( pShell, aPrgTitle, 100 );
	pFilter->SetUpdatePercentHdl( LINK( this, FilterProgress, Update ) );
}


/*************************************************************************
|*
|*	Dtor
|*
\************************************************************************/


FilterProgress::~FilterProgress()
{
	if ( pFilter )
		pFilter->SetUpdatePercentHdl( Link() );

	if ( mpProgress )
		delete mpProgress;
}

void FilterProgress::SetState( ULONG nVal, ULONG nNewRange /* = 0 */ )
{
	if( mpProgress )
		mpProgress->SetState( nVal, nNewRange );
}

/*************************************************************************
|*
|*	Setzen der Progressbar
|*
\************************************************************************/


IMPL_LINK_INLINE_START( FilterProgress, Update, GraphicFilter *, pGraphicFilter )
{
	if ( pGraphicFilter && mpProgress )
		mpProgress->SetState( pGraphicFilter->GetPercent() );

	return 0;
}
IMPL_LINK_INLINE_END( FilterProgress, Update, GraphicFilter *, pGraphicFilter )




