/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sdtreelb.cxx,v $
 *
 *  $Revision: 1.24 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 18:43:05 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"

#ifndef _SOT_FORMATS_HXX
#include <sot/formats.hxx>
#endif
#include <sot/storage.hxx>
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef SVTOOLS_URIHELPER_HXX
#include <svtools/urihelper.hxx>
#endif
#ifndef _SVDITER_HXX
#include <svx/svditer.hxx>
#endif
#ifndef _SFXDOCFILE_HXX
#include <sfx2/docfile.hxx>
#endif
#ifndef _SVDOOLE2_HXX
#include <svx/svdoole2.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SD_CUSSHOW_HXX
#include "cusshow.hxx"
#endif
#ifndef _SFX_CHILDWIN_HXX
#include <sfx2/childwin.hxx>
#endif

#include <sfx2/viewfrm.hxx>

#include "strmname.h"
#ifndef _SDTREELB_HXX
#include "sdtreelb.hxx"
#endif
#ifndef SD_DRAW_DOC_SHELL_HXX
#include "DrawDocShell.hxx"
#endif
#ifndef _DRAWDOC_HXX
#include "drawdoc.hxx"
#endif
#ifndef _SDPAGE_HXX
#include "sdpage.hxx"
#endif
#ifndef SD_RESID_HXX
#include "sdresid.hxx"
#endif
#ifndef SD_NAVIGATOR_HXX
#include "navigatr.hxx"
#endif
#ifndef _SD_CFGID_HXX
#include "strings.hrc"
#endif
#include "res_bmp.hrc"

using namespace com::sun::star;

BOOL SdPageObjsTLB::bIsInDrag = FALSE;

// -----------------------------------------
// - SdPageObjsTLB::SdPageObjsTransferable -
// -----------------------------------------

SdPageObjsTLB::SdPageObjsTransferable::~SdPageObjsTransferable()
{
}

// -----------------------------------------------------------------------------

void SdPageObjsTLB::SdPageObjsTransferable::AddSupportedFormats()
{
	AddFormat( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK );
}

// -----------------------------------------------------------------------------

sal_Bool SdPageObjsTLB::SdPageObjsTransferable::GetData( const ::com::sun::star::datatransfer::DataFlavor& rFlavor )
{
	SetINetBookmark( maBookmark, rFlavor );
	return sal_True;
}

// -----------------------------------------------------------------------------

void SdPageObjsTLB::SdPageObjsTransferable::DragFinished( sal_Int8 nDropAction )
{
	mrParent.DragFinished( nDropAction );
}

// -----------------------------------------------------------------------------

::sd::DrawDocShell& SdPageObjsTLB::SdPageObjsTransferable::GetDocShell() const
{
    return mrDocShell;
}

// -----------------------------------------------------------------------------

NavigatorDragType SdPageObjsTLB::SdPageObjsTransferable::GetDragType() const
{
    return meDragType;
}

// -----------------------------------------------------------------------------

sal_Int64 SAL_CALL SdPageObjsTLB::SdPageObjsTransferable::getSomething( const ::com::sun::star::uno::Sequence< sal_Int8 >& rId ) throw( ::com::sun::star::uno::RuntimeException )
{
    sal_Int64 nRet;

    if( ( rId.getLength() == 16 ) &&
        ( 0 == rtl_compareMemory( getUnoTunnelId().getConstArray(), rId.getConstArray(), 16 ) ) )
    {
        nRet = (sal_Int64) this;
    }
    else
        nRet = 0;

	return nRet;
}

// -----------------------------------------------------------------------------

const ::com::sun::star::uno::Sequence< sal_Int8 >& SdPageObjsTLB::SdPageObjsTransferable::getUnoTunnelId()
{
    static ::com::sun::star::uno::Sequence< sal_Int8 > aSeq;

	if( !aSeq.getLength() )
	{
		static osl::Mutex   aCreateMutex;
    	osl::MutexGuard     aGuard( aCreateMutex );

		aSeq.realloc( 16 );
    	rtl_createUuid( reinterpret_cast< sal_uInt8* >( aSeq.getArray() ), 0, sal_True );
	}

    return aSeq;
}

// -----------------------------------------------------------------------------

SdPageObjsTLB::SdPageObjsTransferable* SdPageObjsTLB::SdPageObjsTransferable::getImplementation( const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >& rxData )
    throw()
{
    try
    {
	    ::com::sun::star::uno::Reference< ::com::sun::star::lang::XUnoTunnel > xUnoTunnel( rxData, ::com::sun::star::uno::UNO_QUERY );

        return( xUnoTunnel.is() ?
                ( (SdPageObjsTLB::SdPageObjsTransferable*)(void*) xUnoTunnel->getSomething( SdPageObjsTLB::SdPageObjsTransferable::getUnoTunnelId() ) ) :
                NULL );
    }
    catch( const ::com::sun::star::uno::Exception& )
	{
        return NULL;
	}
}

/*************************************************************************
|*
|* Ctor1 SdPageObjsTLB
|*
\************************************************************************/

SdPageObjsTLB::SdPageObjsTLB( Window* pParentWin, const SdResId& rSdResId,
							  BOOL bEnableDrop ) :
	SvTreeListBox       ( pParentWin, rSdResId ),
	pParent 		    ( pParentWin ),
	pDoc			    ( NULL ),
	pBookmarkDoc	    ( NULL ),
	pMedium 	    	( NULL ),
	pOwnMedium		    ( NULL ),
	aTransparencyColor	( RGB_COLORDATA (0xff,0,0xff) ),
	aImgOle             ( Bitmap( SdResId( BMP_OLE ) ), aTransparencyColor ),
	aImgGraphic         ( Bitmap( SdResId( BMP_GRAPHIC ) ), aTransparencyColor ),
	aImgOleH            ( Bitmap( SdResId( BMP_OLE_H ) ), aTransparencyColor),
	aImgGraphicH        ( Bitmap( SdResId( BMP_GRAPHIC_H ) ), aTransparencyColor),
	pDropNavWin		    ( NULL ),
	bLinkableSelected   ( FALSE )
{
	// Tree-ListBox mit Linien versehen
	SetWindowBits( WinBits( WB_TABSTOP | WB_BORDER | WB_HASLINES |
							WB_HASBUTTONS | // WB_HASLINESATROOT |
							WB_HSCROLL | // #31562#
							WB_HASBUTTONSATROOT ) );
	SetNodeBitmaps( Bitmap( SdResId( BMP_EXPAND ) ),
					Bitmap( SdResId( BMP_COLLAPSE ) ) );

	SetNodeBitmaps( Bitmap( SdResId( BMP_EXPAND_H ) ),
					Bitmap( SdResId( BMP_COLLAPSE_H ) ),
					BMP_COLOR_HIGHCONTRAST );
}

/*************************************************************************
|*
|* Dtor SdPageObjsTLB
|*
\************************************************************************/

SdPageObjsTLB::~SdPageObjsTLB()
{
    if ( pBookmarkDoc )
        CloseBookmarkDoc();
    else
        // no document was created from pMedium, so this object is still the owner of it
        delete pMedium;
}

/*************************************************************************
|*
|* return name of object
|*
\************************************************************************/

String SdPageObjsTLB::GetObjectName( const SdrObject* pObj ) const
{
    String aRet;

    if( pObj )
    {
        aRet = pObj->GetName();

        if( !aRet.Len() && pObj->ISA( SdrOle2Obj ) )
            aRet = static_cast< const SdrOle2Obj* >( pObj )->GetPersistName();
    }

    return aRet;
}

/*************************************************************************
|*
|* In TreeLB Eintrag selektieren
|*
\************************************************************************/

BOOL SdPageObjsTLB::SelectEntry( const String& rName )
{
	BOOL bFound = FALSE;

	if( rName.Len() )
	{
		SvLBoxEntry* pEntry = NULL;
		String aTmp;

		for( pEntry = First(); pEntry && !bFound; pEntry = Next( pEntry ) )
		{
			aTmp = GetEntryText( pEntry );
			if( aTmp == rName )
			{
				bFound = TRUE;
				SetCurEntry( pEntry );
			}
		}
	}
	return( bFound );
}

/*************************************************************************
|*
|* Gibt zurueck, ob Childs des uebergebenen Strings selektiert sind
|*
\************************************************************************/

BOOL SdPageObjsTLB::HasSelectedChilds( const String& rName )
{
	BOOL bFound  = FALSE;
	BOOL bChilds = FALSE;

	if( rName.Len() )
	{
		SvLBoxEntry* pEntry = NULL;
		String aTmp;

		for( pEntry = First(); pEntry && !bFound; pEntry = Next( pEntry ) )
		{
			aTmp = GetEntryText( pEntry );
			if( aTmp == rName )
			{
				bFound = TRUE;
				BOOL bExpanded = IsExpanded( pEntry );
				long nCount = GetChildSelectionCount( pEntry );
#if SUPD < 335
				nCount++;
#endif
				if( bExpanded && nCount > 0 )
					bChilds = TRUE;
			}
		}
	}
	return( bChilds );
}

/*************************************************************************
|*
|* TreeLB mit Seiten und Objekten fuellen
|*
\************************************************************************/

void SdPageObjsTLB::Fill( const SdDrawDocument* pInDoc, BOOL bAllPages,
						  const String& rDocName)
{
	String aSelection;
	if( GetSelectionCount() > 0 )
	{
		aSelection = GetSelectEntry();
		Clear();
	}

	pDoc = pInDoc;
	aDocName = rDocName;

	SdrObject*	 pObj = NULL;
	SdPage* 	 pPage = NULL;
	SvLBoxEntry* pEntry = NULL;

	Bitmap aBmpPage( SdResId( BMP_PAGE ) );
	Image aImgPage( aBmpPage, aTransparencyColor );
	Bitmap aBmpPageExcl( SdResId( BMP_PAGE_EXCLUDED ) );
	Image aImgPageExcl( aBmpPageExcl, aTransparencyColor );
	Bitmap aBmpPageObjsExcl( SdResId( BMP_PAGEOBJS_EXCLUDED ) );
	Image aImgPageObjsExcl( aBmpPageObjsExcl, aTransparencyColor );
	Bitmap aBmpPageObjs( SdResId( BMP_PAGEOBJS ) );
	Image aImgPageObjs( aBmpPageObjs, aTransparencyColor );
	Bitmap aBmpObjects( SdResId( BMP_OBJECTS ) );
	Image aImgObjects( aBmpObjects, aTransparencyColor );

	Bitmap aBmpPageH( SdResId( BMP_PAGE_H ) );
	Image aImgPageH( aBmpPageH , aTransparencyColor );
	Bitmap aBmpPageExclH( SdResId( BMP_PAGE_EXCLUDED_H ) );
	Image aImgPageExclH( aBmpPageExclH, aTransparencyColor );
	Bitmap aBmpPageObjExclH( SdResId( BMP_PAGEOBJS_EXCLUDED_H ) );
	Image aImgPageObjsExclH( aBmpPageObjExclH, aTransparencyColor );
	Bitmap aBmpPageObjsH( SdResId( BMP_PAGEOBJS_H ) );
	Image aImgPageObjsH( aBmpPageObjsH, aTransparencyColor );
	Bitmap aBmpObjectsH( SdResId( BMP_OBJECTS_H ) );
	Image aImgObjectsH( aBmpObjectsH, aTransparencyColor );

	// Zuerst alle Pages incl. Objekte einfuegen
	USHORT nPage = 0;
	const USHORT nMaxPages = pDoc->GetPageCount();

	while( nPage < nMaxPages )
	{
		pPage = (SdPage*) pDoc->GetPage( nPage );
		if(  (bAllPages || pPage->GetPageKind() == PK_STANDARD)
		     && !(pPage->GetPageKind()==PK_HANDOUT)   ) //#94954# never list the normal handout page ( handout-masterpage is used instead )
		{
			BOOL bPageExluded = pPage->IsExcluded();

            bool bPageBelongsToShow = PageBelongsToCurrentShow (pPage);
            bPageExluded |= !bPageBelongsToShow;

			pEntry = InsertEntry( pPage->GetName(),
			                      bPageExluded ? aImgPageExcl : aImgPage,
								  bPageExluded ? aImgPageExcl : aImgPage,
								  0,
								  FALSE,
								  LIST_APPEND,
								  reinterpret_cast< void* >( 1 ) );

			SetExpandedEntryBmp( pEntry, bPageExluded ? aImgPageExclH : aImgPageH, BMP_COLOR_HIGHCONTRAST );
			SetCollapsedEntryBmp( pEntry, bPageExluded ? aImgPageExclH : aImgPageH, BMP_COLOR_HIGHCONTRAST );

			SdrObjListIter aIter( *pPage, IM_DEEPWITHGROUPS );

			while( aIter.IsMore() )
			{
				pObj = aIter.Next();
				String aStr( GetObjectName( pObj ) );
				if( aStr.Len() )
				{
					if( pObj->GetObjInventor() == SdrInventor && pObj->GetObjIdentifier() == OBJ_OLE2 )
					{
						SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgOle, aImgOle, pEntry );

						SetExpandedEntryBmp( pNewEntry, aImgOleH, BMP_COLOR_HIGHCONTRAST );
						SetCollapsedEntryBmp( pNewEntry, aImgOleH, BMP_COLOR_HIGHCONTRAST );
					}
					else if( pObj->GetObjInventor() == SdrInventor && pObj->GetObjIdentifier() == OBJ_GRAF )
					{
						SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgGraphic, aImgGraphic, pEntry );

						SetExpandedEntryBmp( pNewEntry, aImgGraphicH, BMP_COLOR_HIGHCONTRAST );
						SetCollapsedEntryBmp( pNewEntry, aImgGraphicH, BMP_COLOR_HIGHCONTRAST );
					}
					else
					{
					    SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgObjects, aImgObjects, pEntry );

						SetExpandedEntryBmp( pNewEntry, aImgObjectsH, BMP_COLOR_HIGHCONTRAST );
						SetCollapsedEntryBmp( pNewEntry, aImgObjectsH, BMP_COLOR_HIGHCONTRAST );
					}
				}
			}
			if( pEntry->HasChilds() )
			{
				SetExpandedEntryBmp( pEntry, bPageExluded ? aImgPageObjsExcl : aImgPageObjs );
				SetCollapsedEntryBmp( pEntry, bPageExluded ? aImgPageObjsExcl : aImgPageObjs );
				SetExpandedEntryBmp( pEntry, bPageExluded ? aImgPageObjsExclH : aImgPageObjsH, BMP_COLOR_HIGHCONTRAST );
				SetCollapsedEntryBmp( pEntry, bPageExluded ? aImgPageObjsExclH : aImgPageObjsH, BMP_COLOR_HIGHCONTRAST );
			}
		}
		nPage++;
	}

	// dann alle MasterPages incl. Objekte einfuegen
	if( bAllPages )
	{
		nPage = 0;
		const USHORT nMaxMasterPages = pDoc->GetMasterPageCount();

		while( nPage < nMaxMasterPages )
		{
			pPage = (SdPage*) pDoc->GetMasterPage( nPage );
			pEntry = InsertEntry( pPage->GetName(),
			                      aImgPage,
			                      aImgPage,
			                      0,
								  FALSE,
								  LIST_APPEND,
								  reinterpret_cast< void* >( 1 ) );

			SetExpandedEntryBmp( pEntry, aImgPageH, BMP_COLOR_HIGHCONTRAST );
			SetCollapsedEntryBmp( pEntry, aImgPageH, BMP_COLOR_HIGHCONTRAST );

			SdrObjListIter aIter( *pPage, IM_DEEPWITHGROUPS );

			while( aIter.IsMore() )
			{
				pObj = aIter.Next();
				String aStr( GetObjectName( pObj ) );
				if( aStr.Len() )
				{
					if( pObj->GetObjInventor() == SdrInventor && pObj->GetObjIdentifier() == OBJ_OLE2 )
					{
						SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgOle, aImgOle, pEntry ); // pEntry entspr. Parent

						SetExpandedEntryBmp( pNewEntry, aImgOleH, BMP_COLOR_HIGHCONTRAST );
						SetCollapsedEntryBmp( pNewEntry, aImgOleH, BMP_COLOR_HIGHCONTRAST );
					}
					else if( pObj->GetObjInventor() == SdrInventor && pObj->GetObjIdentifier() == OBJ_GRAF )
					{
						SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgGraphic, aImgGraphic, pEntry ); // pEntry entspr. Parent

						SetExpandedEntryBmp( pNewEntry, aImgGraphicH, BMP_COLOR_HIGHCONTRAST );
						SetCollapsedEntryBmp( pNewEntry, aImgGraphicH, BMP_COLOR_HIGHCONTRAST );
					}
					else
					{
						SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgObjects, aImgObjects, pEntry );

						SetExpandedEntryBmp( pNewEntry, aImgObjectsH, BMP_COLOR_HIGHCONTRAST );
						SetCollapsedEntryBmp( pNewEntry, aImgObjectsH, BMP_COLOR_HIGHCONTRAST );
					}
				}
			}
			if( pEntry->HasChilds() )
			{
				SetExpandedEntryBmp( pEntry, aImgPageObjs );
				SetCollapsedEntryBmp( pEntry, aImgPageObjs );
				SetExpandedEntryBmp( pEntry, aImgPageObjsH, BMP_COLOR_HIGHCONTRAST );
				SetCollapsedEntryBmp( pEntry, aImgPageObjsH, BMP_COLOR_HIGHCONTRAST );
			}
			nPage++;
		}
	}
	if( aSelection.Len() )
		SelectEntry( aSelection );
}

/*************************************************************************
|*
|* Es wird nur der erste Eintrag eingefuegt. Childs werden OnDemand erzeugt
|*
\************************************************************************/

void SdPageObjsTLB::Fill( const SdDrawDocument* pInDoc, SfxMedium* pInMedium,
						  const String& rDocName )
{
	pDoc = pInDoc;

    // this object now owns the Medium
	pMedium = pInMedium;
	aDocName = rDocName;

	SdrObject*	 pObj = NULL;
	SdPage* 	 pPage = NULL;
	SvLBoxEntry* pFileEntry = NULL;
	SvLBoxEntry* pPageEntry = NULL;

	Bitmap aBmpDocOpen( SdResId( BMP_DOC_OPEN ) );
	Image aImgDocOpen( aBmpDocOpen, aTransparencyColor );
	Bitmap aBmpDocClosed( SdResId( BMP_DOC_CLOSED ) );
	Image aImgDocClosed( aBmpDocClosed, aTransparencyColor );
	Bitmap aBmpDocOpenH( SdResId( BMP_DOC_OPEN_H ) );
	Image aImgDocOpenH( aBmpDocOpenH, aTransparencyColor );
	Bitmap aBmpDocClosedH( SdResId( BMP_DOC_CLOSED_H ) );
	Image aImgDocClosedH( aBmpDocClosedH, aTransparencyColor );

	// Dokumentnamen einfuegen
	pFileEntry = InsertEntry( aDocName,
	                          aImgDocOpen,
	                          aImgDocClosed,
	                          NULL,
	                          TRUE,
							  LIST_APPEND,
							  reinterpret_cast< void* >( 1 ) );

	SetExpandedEntryBmp( pFileEntry, aImgDocOpenH, BMP_COLOR_HIGHCONTRAST );
	SetCollapsedEntryBmp( pFileEntry, aImgDocClosedH, BMP_COLOR_HIGHCONTRAST );
}

/*************************************************************************
|*
|* Prueft, ob die Seiten (PK_STANDARD) und die darauf befindlichen Objekte
|* des Docs und der TreeLB identisch sind.
|* Wird ein Doc uebergeben, wird dieses zum aktuellem Doc (Wichtig bei
|* mehreren Documenten).
|*
\************************************************************************/

BOOL SdPageObjsTLB::IsEqualToDoc( const SdDrawDocument* pInDoc )
{
	if( pInDoc )
		pDoc = pInDoc;

	if( !pDoc )
		return( FALSE );

	SdrObject*	 pObj = NULL;
	SdPage* 	 pPage = NULL;
	SvLBoxEntry* pEntry = First();
	String		 aName;

	// Alle Pages incl. Objekte vergleichen
	USHORT nPage = 0;
	const USHORT nMaxPages = pDoc->GetPageCount();

	while( nPage < nMaxPages )
	{
		pPage = (SdPage*) pDoc->GetPage( nPage );
		if( pPage->GetPageKind() == PK_STANDARD )
		{
			if( !pEntry )
				return( FALSE );
			aName = GetEntryText( pEntry );

			if( pPage->GetName() != aName )
				return( FALSE );

			pEntry = Next( pEntry );

			SdrObjListIter aIter( *pPage, IM_DEEPWITHGROUPS );

			while( aIter.IsMore() )
			{
				pObj = aIter.Next();

                const String aObjectName( GetObjectName( pObj ) );

				if( aObjectName.Len() )
				{
					if( !pEntry )
						return( FALSE );

                	aName = GetEntryText( pEntry );

					if( aObjectName != aName )
						return( FALSE );

					pEntry = Next( pEntry );
				}
			}
		}
		nPage++;
	}
	// Wenn noch Eintraege in der Listbox vorhanden sind, wurden
	// Objekte (mit Namen) oder Seiten geloescht
	return( !pEntry );
}

/*************************************************************************
|*
|* Selectierten String zurueckgeben
|*
\************************************************************************/

String SdPageObjsTLB::GetSelectEntry()
{
	return( GetEntryText( GetCurEntry() ) );
}

/*************************************************************************
|*
|* Selektierte Eintrage zurueckgeben
|* nDepth == 0 -> Seiten
|* nDepth == 1 -> Objekte
|*
\************************************************************************/

List* SdPageObjsTLB::GetSelectEntryList( USHORT nDepth )
{
	List*		 pList	= NULL;
	SvLBoxEntry* pEntry = FirstSelected();

	while( pEntry )
	{
		USHORT nListDepth = GetModel()->GetDepth( pEntry );
		if( nListDepth == nDepth )
		{
			if( !pList )
				pList = new List();

			const String aEntryText( GetEntryText( pEntry ) );
			pList->Insert( new String( aEntryText ), LIST_APPEND );
		}
		pEntry = NextSelected( pEntry );
	}

	return( pList );
}

/*************************************************************************
|*
|* Alle Pages (und Objekte) des Docs zurueckgeben
|* nType == 0 -> Seiten
|* nType == 1 -> Objekte
|*
\************************************************************************/

List* SdPageObjsTLB::GetBookmarkList( USHORT nType )
{
	List* pList	= NULL;

	if( GetBookmarkDoc() )
	{
		SdPage* 	 pPage = NULL;
		String*		 pName = NULL;
		USHORT 		 nPage = 0;
		const USHORT nMaxPages = pBookmarkDoc->GetSdPageCount( PK_STANDARD );

		while( nPage < nMaxPages )
		{
			pPage = pBookmarkDoc->GetSdPage( nPage, PK_STANDARD );

			if( nType == 0 ) // Seitennamen einfuegen
			{
				if( !pList )
					pList = new List();

				pName = new String( pPage->GetRealName() );
				pList->Insert( pName, LIST_APPEND );
			}
			else // Objektnamen einfuegen
			{
				// Ueber Objekte der Seite iterieren
				SdrObjListIter aIter( *pPage, IM_DEEPWITHGROUPS );
				while( aIter.IsMore() )
				{
					SdrObject* pObj = aIter.Next();
					String aStr( GetObjectName( pObj ) );
					if( aStr.Len() )
					{
						if( !pList )
							pList = new List();

						pName = new String( aStr );
						pList->Insert( pName, LIST_APPEND );
					}
				}
			}
			nPage++;
		}
	}
	return( pList );
}

/*************************************************************************
|*
|* Eintraege werden erst auf Anforderung (Doppelklick) eingefuegt
|*
\************************************************************************/

void SdPageObjsTLB::RequestingChilds( SvLBoxEntry* pFileEntry )
{
	if( !pFileEntry->HasChilds() )
	{
		if( GetBookmarkDoc() )
		{
			SdrObject*	 pObj = NULL;
			SdPage* 	 pPage = NULL;
			SvLBoxEntry* pPageEntry = NULL;

			Bitmap aBmpPage( SdResId( BMP_PAGE ) );
			Image aImgPage( aBmpPage, aTransparencyColor );
			Bitmap aBmpPageObjs( SdResId( BMP_PAGEOBJS ) );
			Image aImgPageObjs( aBmpPageObjs, aTransparencyColor );
			Bitmap aBmpObjects( SdResId( BMP_OBJECTS ) );
			Image aImgObjects( aBmpObjects, aTransparencyColor );
			Bitmap aBmpPageH( SdResId( BMP_PAGE_H ) );
			Image aImgPageH( aBmpPageH, aTransparencyColor );
			Bitmap aBmpPageObjsH( SdResId( BMP_PAGEOBJS_H ) );
			Image aImgPageObjsH( aBmpPageObjsH, aTransparencyColor );
			Bitmap aBmpImgObjectsH( SdResId( BMP_OBJECTS_H ) );
			Image aImgObjectsH( aBmpImgObjectsH, aTransparencyColor );

			// Dokumentname ist schon eingefuegt

			// Nur alle "normalen" Pages mit Objekten einfuegen
			USHORT nPage = 0;
			const USHORT nMaxPages = pBookmarkDoc->GetPageCount();

			while( nPage < nMaxPages )
			{
				pPage = (SdPage*) pBookmarkDoc->GetPage( nPage );
				if( pPage->GetPageKind() == PK_STANDARD )
				{
					pPageEntry = InsertEntry( pPage->GetName(),
					                          aImgPage,
					                          aImgPage,
					                          pFileEntry,
							                  FALSE,
								              LIST_APPEND,
								              reinterpret_cast< void* >( 1 ) );

					SetExpandedEntryBmp( pPageEntry, aImgPageH, BMP_COLOR_HIGHCONTRAST );
					SetCollapsedEntryBmp( pPageEntry, aImgPageH, BMP_COLOR_HIGHCONTRAST );

					SdrObjListIter aIter( *pPage, IM_DEEPWITHGROUPS );

					while( aIter.IsMore() )
					{
						pObj = aIter.Next();
						String aStr( GetObjectName( pObj ) );
						if( aStr.Len() )
						{
							if( pObj->GetObjInventor() == SdrInventor && pObj->GetObjIdentifier() == OBJ_OLE2 )
							{
								SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgOle, aImgOle, pPageEntry );

								SetExpandedEntryBmp( pNewEntry, aImgOleH, BMP_COLOR_HIGHCONTRAST );
								SetCollapsedEntryBmp( pNewEntry, aImgOleH, BMP_COLOR_HIGHCONTRAST );
							}
							else if( pObj->GetObjInventor() == SdrInventor && pObj->GetObjIdentifier() == OBJ_GRAF )
							{
								SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgGraphic, aImgGraphic, pPageEntry ); // pEntry entspr. Parent

								SetExpandedEntryBmp( pNewEntry, aImgGraphicH, BMP_COLOR_HIGHCONTRAST );
								SetCollapsedEntryBmp( pNewEntry, aImgGraphicH, BMP_COLOR_HIGHCONTRAST );
							}
							else
							{
								SvLBoxEntry* pNewEntry = InsertEntry( aStr, aImgObjects, aImgObjects, pPageEntry );

								SetExpandedEntryBmp( pNewEntry, aImgObjectsH, BMP_COLOR_HIGHCONTRAST );
								SetCollapsedEntryBmp( pNewEntry, aImgObjectsH, BMP_COLOR_HIGHCONTRAST );
							}
						}
					}
					if( pPageEntry->HasChilds() )
					{
						SetExpandedEntryBmp( pPageEntry, aImgPageObjs );
						SetCollapsedEntryBmp( pPageEntry, aImgPageObjs );
						SetExpandedEntryBmp( pPageEntry, aImgPageObjsH, BMP_COLOR_HIGHCONTRAST );
						SetCollapsedEntryBmp( pPageEntry, aImgPageObjsH, BMP_COLOR_HIGHCONTRAST );
					}
				}
				nPage++;
			}
		}
	}
	else
		SvTreeListBox::RequestingChilds( pFileEntry );
}

/*************************************************************************
|*
|*	Prueft, ob es sich um eine Draw-Datei handelt und oeffnet anhand des
|*	uebergebenen Docs das BookmarkDoc
|*
\************************************************************************/

SdDrawDocument* SdPageObjsTLB::GetBookmarkDoc(SfxMedium* pMed)
{
	if (!pBookmarkDoc ||
		pMed && (!pOwnMedium || pOwnMedium->GetName() != pMed->GetName()))
	{
        // create a new BookmarkDoc if now one exists or if a new Medium is provided
        if (pOwnMedium != pMed)
		{
			CloseBookmarkDoc();
		}

		if (pMed)
		{
            // it looks that it is undefined if a Medium was set by Fill() allready
            DBG_ASSERT( !pMedium, "SfxMedium confusion!" );
            delete pMedium;
            pMedium = NULL;

            // take over this Medium (currently used only be Navigator)
			pOwnMedium = pMed;
        }

        DBG_ASSERT( pMedium || pMed, "No SfxMedium provided!" );

        if( pMed )
        {
            // in this mode the document is also owned and controlled by this instance
            xBookmarkDocShRef = new ::sd::DrawDocShell(SFX_CREATE_MODE_STANDARD, TRUE);
            if (xBookmarkDocShRef->DoLoad(pMed))
                pBookmarkDoc = xBookmarkDocShRef->GetDoc();
            else
                pBookmarkDoc = NULL;
        }
        else if ( pMedium )
            // in this mode the document is owned and controlled by the SdDrawDocument
            // it can be released by calling the corresponding CloseBookmarkDoc method
            // successfull creation of a document makes this the owner of the medium
            pBookmarkDoc = ((SdDrawDocument*) pDoc)->OpenBookmarkDoc(*pMedium);

        if ( !pBookmarkDoc )
		{
			ErrorBox aErrorBox( this, WB_OK, String( SdResId( STR_READ_DATA_ERROR ) ) );
			aErrorBox.Execute();
		}
	}

	return( pBookmarkDoc );
}

/*************************************************************************
|*
|* Bookmark-Dokument schlieen und loeschen
|*
\************************************************************************/

void SdPageObjsTLB::CloseBookmarkDoc()
{
	if (xBookmarkDocShRef.Is())
	{
		xBookmarkDocShRef->DoClose();
        xBookmarkDocShRef.Clear();

        // Medium is owned by document, so it's destroyed already
        pOwnMedium = 0;
	}
    else if ( pBookmarkDoc )
	{
        DBG_ASSERT( !pOwnMedium, "SfxMedium confusion!" );
        if ( pDoc )
        {
            // The document owns the Medium, so the Medium will be invalid after closing the document
			((SdDrawDocument*) pDoc)->CloseBookmarkDoc();
            pMedium = 0;
        }
	}
    else
    {
        // perhaps pOwnMedium provided, but no successfull creation of BookmarkDoc
        delete pOwnMedium;
        pOwnMedium = NULL;
    }

	pBookmarkDoc = NULL;
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SdPageObjsTLB::SelectHdl()
{
	SvLBoxEntry* pEntry = FirstSelected();

	bLinkableSelected = TRUE;

	while( pEntry && bLinkableSelected )
	{
	    if( NULL == pEntry->GetUserData() )
	        bLinkableSelected = FALSE;

		pEntry = NextSelected( pEntry );
	}

	SvTreeListBox::SelectHdl();
}

/*************************************************************************
|*
|* Ueberlaedt RETURN mit der Funktionsweise von DoubleClick
|*
\************************************************************************/

void SdPageObjsTLB::KeyInput( const KeyEvent& rKEvt )
{
	if( rKEvt.GetKeyCode().GetCode() == KEY_RETURN )
	{
		// Auskommentierter Code aus svtools/source/contnr/svimpbox.cxx
		SvLBoxEntry* pCursor = GetCurEntry();
		if( pCursor->HasChilds() || pCursor->HasChildsOnDemand() )
		{
			if( IsExpanded( pCursor ) )
				Collapse( pCursor );
			else
				Expand( pCursor );
		}

		DoubleClickHdl();
	}
	else
		SvTreeListBox::KeyInput( rKEvt );
}

/*************************************************************************
|*
|* StartDrag-Request
|*
\************************************************************************/

void SdPageObjsTLB::StartDrag( sal_Int8 nAction, const Point& rPosPixel )
{
	SdNavigatorWin* pNavWin = NULL;

	if( pFrame->HasChildWindow( SID_NAVIGATOR ) )
		pNavWin = (SdNavigatorWin*) ( pFrame->GetChildWindow( SID_NAVIGATOR )->GetContextWindow( SD_MOD() ) );

	if( pNavWin && pNavWin == pParent && pNavWin->GetNavigatorDragType() != NAVIGATOR_DRAGTYPE_NONE )
	{
		//  Aus dem ExecuteDrag heraus kann der Navigator geloescht werden
		//  (beim Umschalten auf einen anderen Dokument-Typ), das wuerde aber
		//  den StarView MouseMove-Handler, der Command() aufruft, umbringen.
		//  Deshalb Drag&Drop asynchron:
		Application::PostUserEvent( STATIC_LINK( this, SdPageObjsTLB, ExecDragHdl ) );
	}
}

/*************************************************************************
|*
|* Begin drag
|*
\************************************************************************/

void SdPageObjsTLB::DoDrag()
{
	pDropNavWin = ( pFrame->HasChildWindow( SID_NAVIGATOR ) ) ?
				  (SdNavigatorWin*)( pFrame->GetChildWindow( SID_NAVIGATOR )->GetContextWindow( SD_MOD() ) ) :
				  NULL;

	if( pDropNavWin )
	{
		::sd::DrawDocShell* pDocShell = pDoc->GetDocSh();
        String aURL = INetURLObject( pDocShell->GetMedium()->GetPhysicalName(), INET_PROT_FILE ).GetMainURL( INetURLObject::NO_DECODE );
		NavigatorDragType	eDragType = pDropNavWin->GetNavigatorDragType();

		aURL.Append( '#' );
		aURL.Append( GetSelectEntry() );

		INetBookmark	aBookmark( aURL, GetSelectEntry() );
		sal_Int8		nDNDActions = DND_ACTION_COPY;

		if( eDragType == NAVIGATOR_DRAGTYPE_LINK )
			nDNDActions = DND_ACTION_LINK;	// #93240# Either COPY *or* LINK, never both!

		SvTreeListBox::ReleaseMouse();

		bIsInDrag = TRUE;

		// object is destroyed by internal reference mechanism
		( new SdPageObjsTLB::SdPageObjsTransferable( *this, aBookmark, *pDocShell, eDragType ) )->StartDrag( this, nDNDActions );
	}
}

/*************************************************************************
|*
|* Drag finished
|*
\************************************************************************/

void SdPageObjsTLB::DragFinished( sal_uInt8 nDropAction )
{
	if( pFrame->HasChildWindow( SID_NAVIGATOR ) )
	{
		SdNavigatorWin* pNewNavWin = (SdNavigatorWin*) ( pFrame->GetChildWindow( SID_NAVIGATOR )->GetContextWindow( SD_MOD() ) );

		if( pDropNavWin == pNewNavWin)
		{
			MouseEvent aMEvt( pDropNavWin->GetPointerPosPixel() );
			SvTreeListBox::MouseButtonUp( aMEvt );
		}
	}

	pDropNavWin = NULL;
	bIsInDrag = FALSE;
}

/*************************************************************************
|*
|* AcceptDrop-Event
|*
\************************************************************************/

sal_Int8 SdPageObjsTLB::AcceptDrop( const AcceptDropEvent& rEvt )
{
	return( ( !bIsInDrag && IsDropFormatSupported( FORMAT_FILE ) ) ? rEvt.mnAction : DND_ACTION_NONE );
}

/*************************************************************************
|*
|* ExecuteDrop-Event
|*
\************************************************************************/

sal_Int8 SdPageObjsTLB::ExecuteDrop( const ExecuteDropEvent& rEvt )
{
	sal_Int8 nRet = DND_ACTION_NONE;

	if( !bIsInDrag )
	{
		SdNavigatorWin* pNavWin = NULL;
		USHORT			nId = SID_NAVIGATOR;

		if( pFrame->HasChildWindow( nId ) )
			pNavWin = (SdNavigatorWin*)( pFrame->GetChildWindow( nId )->GetContextWindow( SD_MOD() ) );

		if( pNavWin && ( pNavWin == pParent ) )
		{
			TransferableDataHelper	aDataHelper( rEvt.maDropEvent.Transferable );
			String					aFile;

			if( aDataHelper.GetString( FORMAT_FILE, aFile ) &&
				( (SdNavigatorWin*) pParent)->InsertFile( aFile ) )
			{
				nRet = rEvt.mnAction;
			}
		}
	}

	return nRet;
}

/*************************************************************************
|*
|* Handler fuers Dragging
|*
\************************************************************************/

IMPL_STATIC_LINK(SdPageObjsTLB, ExecDragHdl, void*, EMPTYARG)
{
	//	als Link, damit asynchron ohne ImpMouseMoveMsg auf dem Stack auch der
	//	Navigator geloescht werden darf
	pThis->DoDrag();
	return 0;
}


bool SdPageObjsTLB::PageBelongsToCurrentShow (const SdPage* pPage) const
{
    // Return <TRUE/> as default when there is no custom show or when none
    // is used.  The page does then belong to the standard show.
    bool bBelongsToShow = true;

    if (pDoc->getPresentationSettings().mbCustomShow)
    {
        // Get the current custom show.
        SdCustomShow* pCustomShow = NULL;
        List* pShowList = const_cast<SdDrawDocument*>(pDoc)->GetCustomShowList();
        if (pShowList != NULL)
        {
            ULONG nCurrentShowIndex = pShowList->GetCurPos();
            void* pObject = pShowList->GetObject(nCurrentShowIndex);
            pCustomShow = static_cast<SdCustomShow*>(pObject);
        }

        // Check whether the given page is part of that custom show.
        if (pCustomShow != NULL)
        {
            bBelongsToShow = false;
            ULONG nPageCount = pCustomShow->Count();
            for (USHORT i=0; i<nPageCount && !bBelongsToShow; i++)
                if (pPage == static_cast<SdPage*>(pCustomShow->GetObject (i)))
                    bBelongsToShow = true;
        }
    }

    return bBelongsToShow;
}
