/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fuslhide.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 18:55:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"


#include "fuslhide.hxx"

#include <svx/svxids.hrc>
#ifndef _SFX_BINDINGS_HXX //autogen
#include <sfx2/bindings.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX
#include <sfx2/viewfrm.hxx>
#endif

#include "sdpage.hxx"
#include "pres.hxx"
#include "drawdoc.hxx"
#ifndef SD_WINDOW_SHELL_HXX
#include "Window.hxx"
#endif
#ifndef SD_SLIDE_VIEW_HXX
#include "SlideView.hxx"
#endif
#ifndef SD_SLIDE_VIEW_SHELL_HXX
#include "SlideViewShell.hxx"
#endif

namespace sd {

TYPEINIT1( FuSlideHide, FuSlide );

/*************************************************************************
|*
|* Konstruktor
|*
|* Haben die selektierten Seiten keinen einheitlichen Status (anzeigen /
|* nicht anzeigen) werden sie auf "nicht anzeigen" geschaltet.
|* Haben alle selektierten Seiten den gleichen Status, so wird er an allen
|* Seiten geaendert.
|*
\************************************************************************/

FuSlideHide::FuSlideHide (
    ViewShell* pViewSh,
    ::sd::Window* pWin,
    ::sd::View* pView,
    SdDrawDocument* pDoc,
    SfxRequest& rReq)
    : FuSlide (
        static_cast<SlideViewShell*>(pViewSh), 
        pWin, 
        static_cast<SlideView*>(pView),
        pDoc, 
        rReq)
{
}

FunctionReference FuSlideHide::Create( SlideViewShell* pViewSh, ::sd::Window* pWin, SlideView* pView, SdDrawDocument* pDoc, SfxRequest& rReq )
{
	FunctionReference xFunc( new FuSlideHide( pViewSh, pWin, pView, pDoc, rReq ) );
	xFunc->DoExecute(rReq);
	return xFunc;
}

void FuSlideHide::DoExecute( SfxRequest& rReq )
{
	FuSlide::DoExecute( rReq );

	SdPage* pPage	   = NULL;
	USHORT	nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
	USHORT	nPage;
	short	nState = -1;				   // -1: unknown, 0: FALSE, 1: TRUE
	BOOL	bState;

	// Status der selektierten Seiten holen
	for (nPage = 0; nPage < nNoOfPages; nPage++)
	{
		pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
		if (pPage->IsSelected())
		{
			bState = pPage->IsExcluded();
			if (nState == -1)					  // noch nicht entschieden?
			{
				nState = (short)bState;
			}
			else								  // schon ein Status gefunden
			{
				if (nState != (short)bState)	  // anderer Status?
				{
					nState = -1;				  // nicht einheitlich
					break;
				}
				else
				{
					nState = (short)bState;
				}
			}
		}
	}

	// neuen Status setzen
	if (nState != -1)				 // einheitlich: Status toggeln
	{
		bState = !bState;
	}
	else							 // nicht einheitlich: alle "nicht zeigen"
	{
		bState = TRUE;
	}

	// Status an die Seiten schreiben
	for (nPage = 0; nPage < nNoOfPages; nPage++)
	{
		pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
		if (pPage->IsSelected())
		{
			pPage->SetExcluded(bState);

			Point aPos = pSlView->CalcPagePos(nPage);
			Size aSize = pPage->GetSize();
			aPos.Y() += aSize.Height();
			aSize.Height() = pSlView->GetPageGap();
			pWindow->Invalidate(Rectangle(aPos, aSize));

		}
	}

	SfxBindings& rBindings = pViewShell->GetViewFrame()->GetBindings();
	rBindings.Invalidate( SID_PRESENTATION );
	rBindings.Invalidate( SID_REHEARSE_TIMINGS );

	pDoc->SetChanged();
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

FuSlideHide::~FuSlideHide()
{
}



} // end of namespace sd
