/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: updatedlg.cxx,v $
 *
 *  $Revision: 1.7.10.1 $
 *
 *  last change: $Author: kz $ $Date: 2006/11/17 09:26:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sfx2.hxx"
 
#ifndef _COM_SUN_STAR_LANG_XMultiServiceFactory_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef  _COM_SUN_STAR_FRAME_XDESKTOP_HPP_
#include <com/sun/star/frame/XDesktop.hpp>
#endif

#ifndef  _COM_SUN_STAR_FRAME_XDISPATCHPROVIDER_HPP_
#include <com/sun/star/frame/XDispatchProvider.hpp>
#endif

#ifndef  _COM_SUN_STAR_FRAME_XNOTIFYINGDISPATCH_HPP_
#include <com/sun/star/frame/XNotifyingDispatch.hpp>
#endif

#ifndef _COM_SUN_STAR_TASK_XJOB_HPP_
#include <com/sun/star/task/XJob.hpp>
#endif

#include <cppuhelper/implbase1.hxx>

#include <rtl/ustrbuf.hxx>
#include <rtl/uri.hxx>
#include <vos/thread.hxx>
#include <vos/process.hxx>
#include <vos/mutex.hxx>
#include <comphelper/processfactory.hxx>
#include <vcl/msgbox.hxx>
#include <vcl/svapp.hxx>

#include "com/sun/star/beans/NamedValue.hpp"
#include "rtl/strbuf.hxx"
#include "app.hrc"
#include "sfxresid.hxx"
#include "updatedlg.hxx"

using namespace ::com::sun::star;
namespace css = ::com::sun::star;
namespace cssu = ::com::sun::star::uno;


class OCheckForUpdate;
class BaseMutex
{
    protected:
	    mutable ::osl::Mutex m_aMutex;
};

class CheckUpdateInfo : public BaseMutex
{
    friend class OCheckForUpdate;

    public:
        CheckUpdateInfo() :
          m_bInProgress( false )
          , m_bIsUpdateAvailable( false )
          , m_bErrorOccured( false )
          , m_nRefCount( 0 ) {}
        ~CheckUpdateInfo() {}
        
        void acquire();
	    void release();

        bool isCheckInProgress() const
        {
            osl::MutexGuard guard( m_aMutex );
            return m_bInProgress;
        }

        bool isUpdateAvailable() const
        {
            osl::MutexGuard guard( m_aMutex );
            return m_bIsUpdateAvailable;
        }

        bool hasErrorOccured() const
        {
            osl::MutexGuard guard( m_aMutex );
            return m_bErrorOccured;
        }
        
        const ::rtl::OUString& getURL() const
        {
            osl::MutexGuard guard( m_aMutex );
            return m_aURL;
        }

    private:
        void setInProgress( bool bInProgress )
        {
            osl::MutexGuard guard( m_aMutex );
            m_bInProgress = bInProgress;
        }

        void setUpdateAvailable( bool bUpdateAvailable )
        {
            osl::MutexGuard guard( m_aMutex );
            m_bIsUpdateAvailable = bUpdateAvailable;
        }
        
        void setErrorOccured( bool bErrorOccured )
        {
            osl::MutexGuard guard( m_aMutex );
            m_bErrorOccured = bErrorOccured;
        }
        
        void setUpdateURL( const ::rtl::OUString& aUpdateURL )
        {
            osl::MutexGuard guard( m_aMutex );
            m_aURL = aUpdateURL;
        }
        
        bool                m_bInProgress;
        bool                m_bIsUpdateAvailable;
        bool                m_bErrorOccured;
        ::rtl::OUString     m_aURL;
        oslInterlockedCount m_nRefCount;
};

void CheckUpdateInfo::acquire()
{
    osl_incrementInterlockedCount( &m_nRefCount );
}

void CheckUpdateInfo::release()
{
    if ( !osl_decrementInterlockedCount( &m_nRefCount ))
    {
		delete this;
    }
} 

// ------------------------------------------------------------------

// class OThread
class OCheckForUpdate : public ::vos::OThread
{
	public:
        OCheckForUpdate( const ::rtl::Reference< CheckUpdateInfo >& aUpdateInfo,
                         const uno::Reference< lang::XMultiServiceFactory >& rSrvMgr );
        virtual ~OCheckForUpdate();

		virtual void SAL_CALL run();
		virtual void SAL_CALL onTerminated();

	private:

        ::rtl::Reference< CheckUpdateInfo > m_aUpdateInfo;
        uno::Reference< lang::XMultiServiceFactory > m_xSrvMgr;
};

OCheckForUpdate::OCheckForUpdate( const ::rtl::Reference< CheckUpdateInfo >& aUpdateInfo,
                                 const uno::Reference< lang::XMultiServiceFactory >& rSrvMgr ) :
    m_aUpdateInfo( aUpdateInfo ),
    m_xSrvMgr( rSrvMgr )
{
    m_aUpdateInfo->setInProgress( true );
}

OCheckForUpdate::~OCheckForUpdate()
{
}



class ResultListener : public ::cppu::WeakImplHelper1< frame::XDispatchResultListener >
{
    rtl::OUString m_aResult;
    bool m_bErrorOccured;
    
public:

    ResultListener() { m_bErrorOccured = true; };
    inline rtl::OUString getResult() { return m_aResult; };
    inline bool gotErrors() { return m_bErrorOccured; } ;
    
    virtual void SAL_CALL disposing(const lang::EventObject&) throw (uno::RuntimeException)
        {};
    virtual void SAL_CALL dispatchFinished(const frame::DispatchResultEvent& rEvent) throw (uno::RuntimeException) 
        { m_bErrorOccured = ( sal_True != (rEvent.Result >>= m_aResult) ); };
    
};


void SAL_CALL OCheckForUpdate::run()
{
    uno::Reference < lang::XMultiServiceFactory > xFactory( ::comphelper::getProcessServiceFactory() );
 
    try
    {
        util::URL aURL;
        
        aURL.Complete = rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "vnd.sun.star.job:alias=UpdateCheck") );
        
        uno::Reference < frame::XDispatchProvider > xDispatchProvider(
            xFactory->createInstance( rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.frame.Desktop" ) ) ),
            uno::UNO_QUERY_THROW );
    
        uno::Reference< frame::XNotifyingDispatch > xDispatch(
            xDispatchProvider->queryDispatch(aURL, rtl::OUString(), 0), 
            uno::UNO_QUERY );
        
        if( xDispatch.is() )
        {
            rtl::Reference< ResultListener > xListener(new ResultListener());
            xDispatch->dispatchWithNotification(aURL, uno::Sequence< beans::PropertyValue > (), xListener.get());
            
            if( xListener->gotErrors() )
            {
                m_aUpdateInfo->setErrorOccured( true );
            }
            else
            {
                rtl::OUString aDownloadURL(xListener->getResult());
                if(aDownloadURL.getLength() > 0)
                {
                    m_aUpdateInfo->setUpdateURL( aDownloadURL );
                    m_aUpdateInfo->setUpdateAvailable( true );
                }
            }
        }
    }
    catch( const uno::Exception& )
    {
        m_aUpdateInfo->setErrorOccured( true );
    }
    
    m_aUpdateInfo->setInProgress( false );   
}

void SAL_CALL OCheckForUpdate::onTerminated()
{
	delete this;
}

// ------------------------------------------------------------------

SfxUpdateDialog::SfxUpdateDialog( Window* pParent ) :
    ModalDialog( pParent, SfxResId( DLG_CHECKFORONLINEUPDATE ) ),
    m_aCancelPB( this, ResId( RID_CHECKFORONLINEUPDATE_PB_CANCEL )),
    m_aMessageFT( this, ResId( RID_CHECKFORONLINEUPDATE_FT_MSG )),
    m_pProgress( 0 ),
    m_nProgress( 0 )
{
    FreeResource();

    m_pProgress = new StatusBar( this );

    Size aProgressSize;
    Size aWinSize = GetSizePixel();
    
    const long nHeight = 20;
    
    long nSpace = long(( aWinSize.Width() * 24 ) / 100 );
    long nXPos  = ( nSpace / 2 );
    long nYPos  = ::std::max( long( 0 ), ( aWinSize.Height() / 2 ) - ( nHeight / 2 ) + ( nHeight / 8 ));

    aProgressSize.Width()   = aWinSize.Width() - nSpace;
    aProgressSize.Height()  = nHeight;
    
    m_pProgress->SetPosSizePixel( Point( nXPos, nYPos ),
                                  aProgressSize );
    m_pProgress->StartProgressMode( String() );
    m_pProgress->Show();

	// Create CheckUpdateInfo instance
    CheckUpdateInfo* pCheckUpdateInfo = new CheckUpdateInfo();
    m_aUpdateInfo.set( pCheckUpdateInfo );

    // Create thread for blocking update check
    // Thread instance will destroy itself after leaving run() method
    // Communication will be done through the refcounted CheckUpdateInfo instance
    OCheckForUpdate* pCheckForUpdate = 
        new OCheckForUpdate( m_aUpdateInfo, 
                             ::comphelper::getProcessServiceFactory() );
    pCheckForUpdate->create();
    
    // Start progress timer
    m_aProgressTimer.SetTimeout( 250 );
	m_aProgressTimer.SetTimeoutHdl( LINK( this, SfxUpdateDialog, ProgressHdl_Impl ) );
    m_aProgressTimer.Start();
}

SfxUpdateDialog::~SfxUpdateDialog()
{
    delete m_pProgress;
}

IMPL_LINK( SfxUpdateDialog, CancelHdl_Impl, PushButton *, )
{
    m_aProgressTimer.Stop();
    m_pProgress->SetProgressValue( 100 );
    
    return 1;
}
	
IMPL_LINK( SfxUpdateDialog, ProgressHdl_Impl, Timer *, )
{
    m_nProgress += 5;
    m_pProgress->SetProgressValue( m_nProgress );
    
    if ( m_nProgress == 100 )
        m_nProgress = 0;

    if ( !m_aUpdateInfo->isCheckInProgress() )
    {
        m_pProgress->SetProgressValue( 100 );
        
        if ( m_aUpdateInfo->isUpdateAvailable() )
        {
            InfoBox aInfoBox( this, SfxResId( INFOBOX_NEW_UPDATE_AVAILABLE ));
            short nRet = aInfoBox.Execute();
            if ( nRet == RET_OK )
            {
                // open URL in system web brower
                ::rtl::OUString aURLString = m_aUpdateInfo->getURL();

                uno::Reference< ::com::sun::star::task::XJob > xJob( 
                    ::comphelper::getProcessServiceFactory()->createInstance(
                        ::rtl::OUString::createFromAscii( "com.sun.star.setup.UpdateCheck" )), 
                    uno::UNO_QUERY );
                if ( xJob.is() )
                {
                    try
                    {
                        // start browser
                        xJob->execute( uno::Sequence<beans::NamedValue>() );
                    }
                    catch ( uno::Exception& )
                    {
                        vos::OGuard aGuard( Application::GetSolarMutex() );
                        ErrorBox( this, SfxResId( MSG_ERR_NO_WEBBROWSER_FOUND )).Execute();
                    }
                }
            }
        }
        else if ( !m_aUpdateInfo->hasErrorOccured() )
        {
            InfoBox aInfoBox( this, SfxResId( INFOBOX_NO_NEW_UPDATE_AVAILABLE ));
            aInfoBox.Execute();
        }
        
        Close();
    }
    else
    {
        m_aProgressTimer.Start();
    }

    return 1;
}
