/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: newhdl.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: vg $ $Date: 2006/09/25 13:36:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sfx2.hxx"

#include <vos/mutex.hxx>
#ifndef GCC
#endif

#if defined _MSC_VER && _MSC_VER <= 1400
#include <new.h>
#else
#include <new>
#endif

#if defined( WIN ) || defined( WNT )
#include <tools/svwin.h>				// GetFreeSpace()
#endif

#include <vcl/msgbox.hxx>
#if defined( MAC )
#include <mac_start.h>
#include <Memory.h>						// FreeMem()
#include <mac_end.h>
#include <vcl/sysdep.hxx>				// Sysdepen::CallNewHandler()
#endif

#include "newhdl.hxx"
#include "sfxtypes.hxx"
#include "objsh.hxx"
#include "sfxresid.hxx"
#include "bastyp.hrc"
#include "topfrm.hxx"

using namespace vos;

// STATIC DATA -----------------------------------------------------------

#define WARN_MEM_SIZE       (200L*1024L)
#define EXCEPT_MEM_SIZE     (300L*1024L)
#define SAVE_MEM_SIZE       (1000L*1024L)

// Static member
SfxNewHdl* SfxNewHdl::pInstance = NULL;

// -----------------------------------------------------------------------
//	F"ur die vielen Plattformem ein _GetFreeMem()

#if defined( WIN ) || defined( WNT )
long    _GetFreeMem()	{ return GetFreeSpace(0); }
#endif
#if defined( MAC )
long    _GetFreeMem()   { return FreeMem(); }
#endif
#if defined( OS2 )
long    _GetFreeMem()   { DBG_ERRORFILE( "Kein _GetFreeMem()" ); return 0; }
#endif
#if defined( UNX )
long    _GetFreeMem()   { DBG_ERRORFILE( "Kein _GetFreeMem()" ); return 0; }
#endif

// -----------------------------------------------------------------------

void SfxNewHandler_Impl()

/*	[Beschreibung]

	der eigentliche new-Handler, der durch das System gerufen wird.
*/

{
	//fprintf ( stderr, "%s\n", "NewHandler" );

	SfxNewHdl* pThis = SfxNewHdl::pInstance;
	if ( pThis->FlushWarnMem() )
		pThis->MemoryWarning();
	else if ( pThis->FlushExceptMem() )
		pThis->MemoryError();
	else
		GetpApp()->Exception( EXC_SYSOBJNOTCREATED );
}

//--------------------------------------------------------------------

void SfxNewHdl::MemoryWarning()
{
	//fprintf ( stderr, "%s\n", "MemoryWarning" );

#if defined(MAC)
    MAC_SetCursor(&qd.arrow);
    short itemHit = Alert( 130, nil );
#else
    WarningBox aWarningBox( NULL, WinBits( WB_OK | WB_DEF_OK | WB_3DLOOK ), aMemWarningString );
    aWarningBox.Execute();
#endif
}

//--------------------------------------------------------------------
#include "docfile.hxx"

void SfxNewHdl::MemoryError()
{
	//fprintf ( stderr, "%s\n", "MemoryError" );

	SfxObjectShell *pIter, *pNext;
   	for(pIter = SfxObjectShell::GetFirst(); pIter; pIter = pNext)
   	{
	//	fprintf ( stderr, "%s\n", "Calling Handler" );

       	pNext = SfxObjectShell::GetNext(*pIter);
       	pIter->MemoryError();
   	}

	for ( SfxViewFrame *pFrame = SfxViewFrame::GetFirst( NULL, TYPE( SfxTopViewFrame ) ); pFrame; pFrame = SfxViewFrame::GetNext( *pFrame, NULL, TYPE( SfxTopViewFrame ) ) )
    {
//		fprintf ( stderr, "%s\n", "Found TopViewFrame" );

        if( pFrame != SfxViewFrame::Current() && !pFrame->GetObjectShell()->IsModified() && pFrame->GetFrame()->PrepareClose_Impl( FALSE ) )
		{
//			fprintf ( stderr, "%s\n", "Closing" );
//			fprintf ( stderr, "%s\n", pFrame->GetObjectShell()->GetName().GetBuffer() );
			pFrame->DoClose();
		}
    }

	// und Exception schmeissen
	GetpApp()->Exception( EXC_OUTOFMEMORY );
}

// -----------------------------------------------------------------------

SfxNewHdl::SfxNewHdl()

/*	[Beschreibung]

	Konstruktor der Klasse SfxNewHdl.
	Die beiden MemoryBuffer werden f"ur den Notfall alloziert und der
	new-Handler wird installiert..

*/
	: pWarnMem(0)
	, pExceptMem(0)
	, aMemWarningString( SfxResId(MSG_MEM_WARN) )
	, aMemExceptionString( SfxResId( STR_MEMEXCEPTION ) )
{
#if defined(_MSC_VER) && (_MSC_VER <= 1400)
    _set_new_handler( reinterpret_cast< _PNH >(SfxNewHandler_Impl) );
#else
    std::set_new_handler( SfxNewHandler_Impl );
#endif
}

// -----------------------------------------------------------------------

SfxNewHdl::~SfxNewHdl()

/*	[Beschreibung]

	Destruktor der Klasse SfxNewHdl.
	Die beiden MemoryBuffer werden freigegeben und der new-Handler
	wird deinstalliert.

*/
{
	FlushWarnMem();
	FlushExceptMem();
#if defined(_MSC_VER) && (_MSC_VER <= 1400)
    _set_new_handler( 0 );
#else
    std::set_new_handler( 0 );
#endif
}

SfxNewHdl* SfxNewHdl::Get()
{
	return pInstance;
}

SfxNewHdl* SfxNewHdl::GetOrCreate()
{
	vos::OGuard  aGuard( vos::OMutex::getGlobalMutex() );
	if ( !pInstance )
		pInstance = new SfxNewHdl;
	return pInstance;
}

void SfxNewHdl::Delete()
{
	vos::OGuard aGuard( vos::OMutex::getGlobalMutex() );
	DELETEZ( pInstance );
}

// -----------------------------------------------------------------------

BOOL SfxNewHdl::TryAllocBuffer()
/*	[Beschreibung]

	Gfs. wird versucht, den Buffer f"ur das WarningLevel zu reallozieren.

*/
{
//	fprintf (stderr, "%s\n", "TryAllocBuffer" );

	if(!pWarnMem)
	{
		const ULONG nFree = _GetFreeMem();
		if ( nFree >= WARN_MEM_SIZE + SAVE_MEM_SIZE )
#ifndef MAC
		{
//            fprintf (stderr, "%s\n", "Reallocating" );
			pWarnMem = new char[WARN_MEM_SIZE];
		}
#else
		{
			Sysdepen::CallNewHandler( FALSE );
			pWarnMem = (MAC_Ptr) NewHandleClear(WARN_MEM_SIZE);
			if ( pWarnMem )
			{
				MoveHHi((Handle) pWarnMem);
				HLock ((Handle) pWarnMem);
			}
			Sysdepen::CallNewHandler( TRUE );
		}
#endif
	}
	return pWarnMem ? TRUE : FALSE;
}

// -----------------------------------------------------------------------

BOOL SfxNewHdl::FlushWarnMem()

/*	[Beschreibung]

	Freigabe Buffer f"ur das WarningLevel
*/
{
//	fprintf (stderr, "%s\n", "FlushWarnmem" );
	if ( pWarnMem )
	{
#ifndef MAC
        delete [] pWarnMem;
        pWarnMem = NULL;
#else
	#ifdef DBG_UTIL
		// Ist unser Handle immer noch NULL ?
		if (memcmp(*((Handle) pWarnMem),
				   *((Handle) pWarnMem)+ WARN_MEM_SIZE / 2,
					 WARN_MEM_SIZE / 2) != 0)
			DebugStr("\ppWarnMem wurde ueberschrieben");
	#endif
		DisposeHandle((Handle) pWarnMem);
		pWarnMem = NULL;
#endif
		return TRUE;
	}
	return FALSE;
}

// -----------------------------------------------------------------------

BOOL SfxNewHdl::FlushExceptMem()

/*	[Beschreibung]

	Freigabe Buffer f"ur das ErrorLevel
*/
{
//	fprintf (stderr, "%s\n", "FlushExceptMem" );

	if ( pExceptMem )
	{
#ifndef MAC
        delete [] pExceptMem;
        pExceptMem = NULL;
#else
	#ifdef DBG_UTIL
		// Ist unser Handle immer noch NULL ?
		if (memcmp(*((Handle) pExceptMem),
				   *((Handle) pExceptMem)+EXCEPT_MEM_SIZE / 2,
					 EXCEPT_MEM_SIZE / 2) != 0)
			DebugStr("\ppExceptMem wurde ueberschrieben");
	#endif
		DisposeHandle((Handle) pExceptMem);
		pExceptMem = NULL;
#endif
		return TRUE;
	}
	return FALSE;
}

// -----------------------------------------------------------------------

IMPL_LINK( SfxNewHdl, InitMem_Impl, void *, pvoid )
{
    (void)pvoid; // unused variable
#ifndef MAC
	pWarnMem 	= new char [WARN_MEM_SIZE];
	pExceptMem 	= new char [EXCEPT_MEM_SIZE];
#else
	Sysdepen::CallNewHandler( FALSE );
	pExceptMem = (MAC_Ptr) NewHandleClear(EXCEPT_MEM_SIZE);
	if ( pExceptMem )
	{
		MoveHHi((Handle) pExceptMem);
		HLock ((Handle) pExceptMem);
	}
	pWarnMem = (MAC_Ptr) NewHandleClear(WARN_MEM_SIZE);
	if ( pWarnMem )
	{
		MoveHHi((Handle) pWarnMem);
		HLock ((Handle) pWarnMem);
	}
	Sysdepen::CallNewHandler( TRUE );
#endif
	return 0;
}

